/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.admin.business.GeneralAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.AdminCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AdminIndividualArrayConfirmAction
extends AdminCoreAction {
    static String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String uri = argReq.getRequestURI();
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("URI is " + uri));
        String crumb = uri.indexOf("shutdown") != -1 ? "admin.general.individualarray.shutdown" : (uri.indexOf("labels") != -1 ? "admin.general.individualarray.resetlabels" : "admin.general.individualarray.reset");
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("crumb is " + crumb));
        return crumb;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        Trace.methodBegin((Object)((Object)this), (String)"doAction");
        HttpSession session = argReq.getSession();
        String uri = argReq.getRequestURI();
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("URI is " + uri));
        ConfigContext configContext = this.getConfigContext(argReq);
        boolean isShutdown = false;
        boolean isReset = false;
        boolean isResetLabels = false;
        if (uri.indexOf("shutdown") != -1) {
            isShutdown = true;
        } else if (uri.indexOf("labels") != -1) {
            isResetLabels = true;
        } else {
            isReset = true;
        }
        String action = argAction;
        if ("show".equals(action)) {
            action = null;
        }
        if (action == null) {
            if (isShutdown) {
                action = "arrayshutdownconfirm";
            } else if (isReset) {
                action = "arrayresetconfirm";
            } else if (isResetLabels) {
                action = "arrayresetlabelsconfirm";
            }
        }
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("action=" + action));
        try {
            action = this.processInput(argForm, argReq, configContext, action);
        }
        catch (CoreUIBusException e) {
            this.handleSystemError(argReq, e);
        }
        catch (Exception e) {
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    private String processInput(ActionForm argForm, HttpServletRequest argReq, ConfigContext configContext, String action) throws CoreUIBusException, IllegalAccessException, InvocationTargetException {
        ArrayList selectedArrays = (ArrayList)argReq.getSession().getAttribute("SelectedIndividualArrays");
        if (selectedArrays == null) {
            Trace.verbose((Object)((Object)this), (String)"processInput", (String)"list of selected arrays not found! (SNH)");
            this.handleSystemError(argReq, null);
            return "cancelconfirm";
        }
        Trace.verbose((Object)((Object)this), (String)"processInput", (String)(selectedArrays.size() + " arrays selected for " + action));
        Admin adminBusObj = (Admin)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Admin");
        GeneralAdminInterface adminInterface = adminBusObj.getGeneralAdminInterface(configContext);
        if ("arrayshutdown".equals(action) || "arrayreset".equals(action) || "arrayresetlabels".equals(action)) {
            this.doArraysPowerAction(argReq, action, selectedArrays);
        } else if ("arrayshutdownconfirm".equals(action)) {
            String message = "admin.general.individualarray.shutdown.warning";
            this.prepareConfirm(argReq, message, selectedArrays, action);
        } else if ("arrayresetconfirm".equals(action)) {
            String message = "admin.general.individualarray.reset.warning";
            this.prepareConfirm(argReq, message, selectedArrays, action);
        } else if ("arrayresetlabelsconfirm".equals(action)) {
            String message = "admin.general.individualarray.resetlabels.mr3.bootr.warning";
            this.prepareConfirm(argReq, message, selectedArrays, action);
        } else if ("cancelconfirm".equals(action)) {
            argReq.getSession().removeAttribute("SelectedIndividualArrays");
        }
        return action;
    }

    protected void prepareConfirm(HttpServletRequest argReq, String message, ArrayList selectedArrays, String action) {
        Trace.methodBegin((Object)((Object)this), (String)"prepareConfirm");
        boolean showRarpEntries = false;
        ArrayList<String> arrays = new ArrayList<String>();
        T4Interface t4 = null;
        Iterator it = selectedArrays.iterator();
        while (it.hasNext()) {
            t4 = (T4Interface)it.next();
            arrays.add(t4.getName());
            if (showRarpEntries || !"arrayresetlabelsconfirm".equals(action) || t4.isFeatureSupported(6)) continue;
            showRarpEntries = true;
            message = "admin.general.individualarray.resetlabels.mr3.bootw.warning";
        }
        if ("arrayresetlabelsconfirm".equals(action)) {
            argReq.setAttribute("showRarpEntries", (Object)new Boolean(showRarpEntries));
        }
        UserMessages messages = new UserMessages();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, message));
        this.checkForActiveJobs(argReq, messages, arrays);
        if ("arrayresetlabelsconfirm".equals(action)) {
            if (showRarpEntries) {
                this.checkForRarpEntries(argReq, messages, selectedArrays);
            } else {
                argReq.getSession().removeAttribute("RarpEntryList");
            }
        }
        this.saveUserMessages(argReq, messages);
    }

    protected void doArraysPowerAction(HttpServletRequest argReq, String action, ArrayList arrays) {
        String methodName = "doArraysPowerAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String badList = new String();
        Iterator it = arrays.iterator();
        while (it.hasNext()) {
            T4Interface t4 = (T4Interface)it.next();
            if (this.singleArrayPower(t4, action)) continue;
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("failed for array " + t4.getName()));
            if (badList.length() > 0) {
                badList = badList.concat(", ");
            }
            badList = badList.concat(t4.getName());
        }
        UserMessages messages = new UserMessages();
        String key = "";
        if ("arrayshutdown".equals(action)) {
            key = "shutdown";
        } else if ("arrayreset".equals(action)) {
            key = "reset";
        } else if ("arrayresetlabels".equals(action)) {
            key = "resetlabels";
        }
        UserMessage msg = new UserMessage(2, "admin.general.individualarray." + key + ".done");
        if (badList.length() > 0) {
            msg = new UserMessage(0, "admin.general.individualarray." + key + ".failed", badList);
        }
        messages.add("org.apache.struts.action.GLOBAL_ERROR", msg);
        this.saveUserMessages(argReq, messages);
    }

    protected boolean singleArrayPower(T4Interface t4, String action) {
        String logKey = "ARRAY_SHUTDOWN_INITIATED";
        String t4Name = t4.getName();
        try {
            if ("arrayshutdown".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)"singleArrayPower", (String)("shutdown array " + t4Name));
                t4.shutdown();
            } else if ("arrayreset".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)"singleArrayPower", (String)("reboot array " + t4Name));
                t4.reboot();
                logKey = "ARRAY_REBOOT_INITIATED";
            } else if ("arrayresetlabels".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)"singleArrayPower", (String)("reset labels on array " + t4Name));
                t4.resetLabels(false);
                logKey = "ARRAY_RESET_LABELS_INITIATED";
            }
        }
        catch (ConfigMgmtException e) {
            Trace.verbose((Object)((Object)this), (String)"singleArrayPower", (Throwable)e);
            logKey = "ARRAY_SHUTDOWN_ERROR";
            if ("arrayreset".equals(action)) {
                logKey = "ARRAY_REBOOT_ERROR";
            } else if ("arrayresetlabels".equals(action)) {
                logKey = "ARRAY_RESET_LABELS_ERROR";
            }
            LogAPI.staticLog((String)logKey, (String[])new String[]{t4Name}, (String[])new String[0]);
            return false;
        }
        LogAPI.staticLog((String)logKey, (String[])new String[]{t4Name}, (String[])new String[0]);
        return true;
    }
}

