/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.admin.business.GeneralAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.AdminCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.AdminGeneralForm;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AdminGeneralAction
extends AdminCoreAction {
    static String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        return MenuData.ROOT_MENU + this.getMenuItemId() + this.getMenuSubItemId();
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        Trace.methodBegin((Object)((Object)this), (String)"doAction");
        HttpSession session = argReq.getSession();
        ConfigContext configContext = this.getConfigContext(argReq);
        String action = argAction == null ? "show" : argAction;
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("action=" + action));
        try {
            switch (Repository.getRepository().getConfigInteger()) {
                case 1: 
                case 2: {
                    action = "arrayselection";
                    return this.doForward(argReq, action, argMap);
                }
            }
            action = this.processInput(argForm, argReq, configContext, action);
        }
        catch (ConfigMgmtException e) {
            this.handleConfigMgmtExc(argReq, e);
        }
        catch (CoreUIBusException e) {
            this.handleSystemError(argReq, e);
        }
        catch (Exception e) {
            this.handleSystemError(argReq, e);
        }
        if ("show".equals(action)) {
            this.showPage(argForm, argReq, session, configContext);
        }
        return this.doForward(argReq, action, argMap);
    }

    private String processInput(ActionForm argForm, HttpServletRequest argReq, ConfigContext configContext, String action) throws CoreUIBusException, IllegalAccessException, InvocationTargetException, ConfigMgmtException {
        Admin adminBusObj = (Admin)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Admin");
        GeneralAdminInterface adminInterface = adminBusObj.getGeneralAdminInterface(configContext);
        if ("save".equals(action)) {
            action = this.doSave(argForm, argReq, adminInterface);
        } else if ("reboot".equals(action)) {
            action = this.doReboot(argReq, adminInterface);
        } else if (action.indexOf("array") != -1) {
            List selectedArrays = this.getSelectedArrays(argReq);
            if (selectedArrays.size() > 0) {
                Trace.verbose((Object)((Object)this), (String)"processInput", (String)(selectedArrays.size() + " arrays selected"));
                argReq.getSession().setAttribute("SelectedIndividualArrays", (Object)selectedArrays);
            } else {
                Trace.verbose((Object)((Object)this), (String)"processInput", (String)"no arrays selected");
                UserMessages messages = new UserMessages();
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.none.selected"));
                this.saveUserMessages(argReq, messages);
                action = "show";
            }
        }
        return action;
    }

    private void handleConfigMgmtExc(HttpServletRequest argReq, ConfigMgmtException e) {
        String exceptionKey = e.getExceptionKey();
        if ("POWER_SERVICE_FULL_SHUTDOWN_ERROR".equals(exceptionKey)) {
            LogAPI.staticLog((String)"POWER_SERVICE_FULL_SHUTDOWN_ERROR", (String[])new String[0], (String[])new String[0]);
        } else if ("POWER_SERVICE_PARTIAL_SHUTDOWN_ERROR".equals(exceptionKey)) {
            LogAPI.staticLog((String)"POWER_SERVICE_PARTIAL_SHUTDOWN_ERROR", (String[])new String[0], (String[])new String[0]);
        }
        this.handleSystemError(argReq, e);
    }

    protected String doSave(ActionForm argForm, HttpServletRequest argReq, GeneralAdminInterface adminInterface) throws IllegalAccessException, InvocationTargetException, ConfigMgmtException {
        String action = "show";
        UserMessages messages = new UserMessages();
        BeanUtils.copyProperties((Object)adminInterface, (Object)((Object)((AdminGeneralForm)argForm)));
        adminInterface.save();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.general.savesuccessful"));
        this.saveUserMessages(argReq, messages);
        return action;
    }

    protected void showPage(ActionForm argForm, HttpServletRequest argReq, HttpSession session, ConfigContext configContext) {
        try {
            Admin adminBusObj = (Admin)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Admin");
            GeneralAdminInterface adminInterface = adminBusObj.getGeneralAdminInterface(configContext);
            this.populateValues(argForm, session, adminInterface);
            Trace.verbose((Object)((Object)this), (String)"showPage", (String)("admin status is [" + adminInterface.getStatus() + "]"));
            if (adminInterface.getStatus() == 4) {
                UserMessages messages = new UserMessages();
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, "admin.general.powererror"));
                this.saveUserMessages(argReq, messages);
            }
            this.getArrayList(argReq, argForm);
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, e);
        }
    }

    protected void populateValues(ActionForm argForm, HttpSession session, GeneralAdminInterface adminInterface) {
        if (adminInterface != null) {
            AdminGeneralForm agf = (AdminGeneralForm)argForm;
            agf.setDescription(adminInterface.getDescription());
            agf.setMaseratiId(adminInterface.getMaseratiId().toString());
            agf.setModel(adminInterface.getModel());
            agf.setVendor(adminInterface.getVendor());
            session.setAttribute("POWER_STATUS", (Object)new Integer(adminInterface.getStatus()));
            session.setAttribute("PARTIAL_SHUTDOWN_AVAIL", (Object)new Boolean(adminInterface.isPartialShutdownAvailable()));
        }
    }

    protected String doReboot(HttpServletRequest argReq, GeneralAdminInterface adminInterface) throws ConfigMgmtException {
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)"Reboot");
        String action = "show";
        adminInterface.startUp();
        LogAPI.staticLog((String)"POWER_SERVICE_REBOOT_INITIATED", (String[])new String[0], (String[])new String[0]);
        UserMessages messages = new UserMessages();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.general.rebootinitiated"));
        this.saveUserMessages(argReq, messages);
        return action;
    }

    private void getArrayList(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getArrayList";
        HttpSession session = argReq.getSession();
        try {
            T4s t4s = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
            List t4List = t4s.list(this.getConfigContext(argReq), null);
            if (t4List != null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("array list size = " + t4List.size()));
                ArrayList healthList = new ArrayList();
                boolean allUnhealthy = t4s.areAllArraysUnhealthy(t4List, healthList);
                ((AdminGeneralForm)argForm).setAllArraysUnhealthy(allUnhealthy);
                session.setAttribute("HealthStatusList", healthList);
                session.setAttribute("T4List", (Object)t4List);
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Unable to get T4List, set to null");
            ConfigMgmtException cme = new ConfigMgmtException(ex);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.setListContext(argReq, "T4List", null);
        }
    }

    private List getSelectedArrays(HttpServletRequest argReq) {
        int[] selectedItems = Convert.stringArrayToIntArray((String[])argReq.getParameterValues("id"));
        List allArrays = (List)argReq.getSession().getAttribute("T4List");
        ArrayList selectedArrays = new ArrayList();
        if (selectedItems == null) {
            Trace.verbose((Object)((Object)this), (String)"getSelectedArrays", (String)"Empty array of indexes!!");
            return selectedArrays;
        }
        if (allArrays != null && allArrays.size() > 0) {
            for (int i = 0; i < selectedItems.length; ++i) {
                if (selectedItems[i] > allArrays.size()) {
                    Trace.verbose((Object)((Object)this), (String)"getSelectedArrays", (String)"Invalid checkbox index!!");
                    Trace.verbose((Object)((Object)this), (String)"getSelectedArrays", (String)("list size is " + allArrays.size() + " checkbox index is " + selectedItems[i]));
                    continue;
                }
                selectedArrays.add(allArrays.get(selectedItems[i]));
            }
        } else {
            Trace.verbose((Object)((Object)this), (String)"getSelectedArrays", (String)"all arrays list is null or empty");
        }
        return selectedArrays;
    }
}

