/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.AdminCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AdminArrayDetailsAction
extends AdminCoreAction {
    static String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        return "admin.general.arraydetails.breadcrumb";
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        Trace.methodBegin((Object)((Object)this), (String)"doAction");
        HttpSession session = argReq.getSession();
        ConfigContext configContext = this.getConfigContext(argReq);
        String action = argAction == null ? "show" : argAction;
        T4Interface t4 = null;
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("action=" + action));
        try {
            ArrayList t4s = (ArrayList)session.getAttribute("T4List");
            String arrayIndexStr = argReq.getParameter("arrayIndex");
            if (arrayIndexStr != null) {
                int t4index = Integer.parseInt(arrayIndexStr);
                t4 = (T4Interface)t4s.get(t4index);
                session.setAttribute("CurrentT4", (Object)t4);
            } else {
                t4 = this.getCurrentT4(argReq);
            }
        }
        catch (Exception e) {
            this.handleSystemError(argReq, e);
        }
        if ("show".equals(action)) {
            this.showPage(argForm, argReq, session, configContext, t4);
        }
        return this.doForward(argReq, action, argMap);
    }

    protected void showPage(ActionForm argForm, HttpServletRequest argReq, HttpSession session, ConfigContext configContext, T4Interface t4) {
        try {
            t4.reload();
            this.getTrayList(argForm, argReq, t4);
        }
        catch (Exception e) {
            this.handleSystemError(argReq, e);
        }
    }

    private void getTrayList(ActionForm argForm, HttpServletRequest argReq, T4Interface t4) {
        String methodName = "getTrayList";
        HttpSession session = argReq.getSession();
        try {
            List trays = t4.getTrays();
            this.checkPrerequisites(argReq, trays);
            if (trays != null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("tray list size = " + trays.size()));
                this.setListContext(argReq, "AllTraysInArray", trays);
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)methodName, (Throwable)ex);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Unable to get tray list, set to null");
            this.setListContext(argReq, "AllTraysInArray", null);
        }
    }

    private void checkPrerequisites(HttpServletRequest argReq, List trays) throws Exception {
        Trace.methodBegin((Object)((Object)this), (String)"checkPrerequisites");
        if (trays == null || trays.isEmpty()) {
            return;
        }
        boolean disableReconfiguration = false;
        boolean enableAddExpansion = true;
        boolean enableRemoveExpansion = true;
        Object messageKey = null;
        TrayInterface bottomController = null;
        TrayInterface topController = null;
        int numberOfTrays = trays.size();
        int numberOfControllers = 0;
        UserMessages messages = new UserMessages();
        for (int i = 0; i < trays.size(); ++i) {
            TrayInterface tray = (TrayInterface)trays.get(i);
            if (tray.getTrayType() != 17) continue;
            ++numberOfControllers;
            if (bottomController == null) {
                bottomController = tray;
                continue;
            }
            int bottomId = Integer.parseInt(bottomController.getId());
            int topId = Integer.parseInt(tray.getId());
            if (topId < bottomId) {
                topController = bottomController;
                bottomController = tray;
                continue;
            }
            topController = tray;
        }
        if (bottomController.getState() != 2) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, "admin.general.arraydetails.bottomctrldisabled.warning", bottomController.getId(), this.getStorADEString(argReq)));
            disableReconfiguration = true;
        } else if ("offline".equals(bottomController.getStatus())) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, "admin.general.arraydetails.bottomctrloffline.warning", bottomController.getId(), this.getStorADEString(argReq)));
            disableReconfiguration = true;
        } else if (topController != null && "booting".equals(topController.getStatus()) || "booting".equals(bottomController.getStatus())) {
            String trayId = bottomController.getId();
            if (topController != null && "booting".equals(topController.getStatus())) {
                trayId = topController.getId();
            }
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.general.arraydetails.ctrlbooting.info", trayId));
            disableReconfiguration = true;
        }
        if (numberOfControllers == 1 && numberOfTrays == 3 || numberOfControllers == 2 && numberOfTrays == 6) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.general.arraydetails.maxexptrays.info"));
            enableAddExpansion = false;
        } else if (numberOfControllers == 1 && numberOfTrays == 1 || numberOfControllers == 2 && numberOfTrays == 2) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.general.arraydetails.noexptrays.info"));
            enableRemoveExpansion = false;
        }
        boolean[] buttonRules = new boolean[]{!disableReconfiguration && enableAddExpansion, !disableReconfiguration && enableRemoveExpansion};
        argReq.getSession().setAttribute("EnableReconfiguration", (Object)buttonRules);
        if (!messages.empty()) {
            this.saveUserMessages(argReq, messages);
        }
    }

    private String getStorADEString(HttpServletRequest argReq) {
        Trace.methodBegin((Object)((Object)this), (String)"getStorADEString");
        if (Repository.getRepository().getConfigInteger() >= 3) {
            return "<a target=\"_blank\" href=\"" + argReq.getSession().getAttribute("SADE") + "\">StorADE</a>";
        }
        return "StorADE";
    }
}

