/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.actions.WizardContent;
import com.sun.netstorage.array.mgmt.cfg.ui.business.ArrayUnconfigurationThread;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Trays;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.AdminExpansionForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AddExpansionWizard
extends WizardContent {
    public ActionForward openWizard(int defaultPage, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "openWizard";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        this.clearWizard(argReq, argForm);
        argReq.getSession().setAttribute("is_add_expansion", (Object)"true");
        argReq.getSession().setAttribute("disableBackOnly", (Object)"true");
        this.setActiveJobs(argReq, argForm);
        this.checkControllersForSteps(argReq, argForm);
        return null;
    }

    protected void setActiveJobs(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "setActiveJobs";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        try {
            T4Interface currentT4 = this.getCurrentT4(argReq);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to handle expansion process for array = " + currentT4.getName()));
            ArrayList<String> arrays = new ArrayList<String>();
            arrays.add(currentT4.getName());
            Jobs jobsBusObj = (Jobs)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs");
            List activeJobs = jobsBusObj.getOutstandingJobsListForArrays(this.getConfigContext(argReq), arrays);
            if (activeJobs != null && activeJobs.size() > 0) {
                ((AdminExpansionForm)argForm).setActiveJobs(activeJobs);
            } else {
                ((AdminExpansionForm)argForm).setActiveJobs(null);
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to get list of active jobs", (Throwable)ex);
        }
    }

    protected void checkControllersForSteps(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "checkControllersForSteps";
        try {
            Trays traysBusObj = (Trays)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Trays");
            List allControllers = traysBusObj.getAllControllers(this.getCurrentT4(argReq));
            if (allControllers != null && allControllers.size() < 2) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("There are {" + allControllers.size() + ") controllers; should skip " + "disable and unconfiguration process"));
                ((AdminExpansionForm)argForm).setShouldSkipSteps(true);
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Exception trying to determine if steps should be skipped");
        }
    }

    protected void clearWizard(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "clearWizard";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ((AdminExpansionForm)argForm).doReset();
        HttpSession session = argReq.getSession();
        session.removeAttribute("unconfiguration_thread");
        session.removeAttribute("verification_thread_done");
        session.setAttribute("submitCount", (Object)new Integer(0));
        session.removeAttribute("needFinish");
        session.removeAttribute("needClose");
    }

    public ActionForward prepareDisplay(int pageNum, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "prepareDisplay";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Preparing display for page num = " + pageNum));
        switch (pageNum) {
            case 1: {
                this.saveSingleUserMessage(argReq, 1, "expansion.nocancel.warning");
                this.prepareActivesDisplay(argReq, argForm);
                break;
            }
            case 2: {
                this.prepareUnconfigurationDisplay(argReq, argForm);
                break;
            }
            case 3: {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Prepare page 3");
                this.saveSingleUserMessage(argReq, 1, "add.expansion.manual.warning");
                break;
            }
            case 4: {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Prepare page 4");
                ((AdminExpansionForm)argForm).setShouldOnline(true);
                this.handleArrayVerification(argReq, argMapping, argForm, pageNum);
            }
        }
        return null;
    }

    protected void prepareActivesDisplay(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "prepareActivesDisplay";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List activeJobs = ((AdminExpansionForm)argForm).getActiveJobs();
        if (activeJobs == null || activeJobs.size() == 0) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No active jobs detected on this array");
            this.setConfirmationMessage(argReq, "expansion.no.active.jobs.message");
        }
    }

    protected void prepareUnconfigurationDisplay(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "prepareUnconfigurationDisplay";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        boolean isUnconfigDone = false;
        ArrayUnconfigurationThread thread = (ArrayUnconfigurationThread)argReq.getSession().getAttribute("unconfiguration_thread");
        if (thread != null) {
            isUnconfigDone = thread.isThreadDone();
        }
        if (!((AdminExpansionForm)argForm).getHasErrors()) {
            if (isUnconfigDone) {
                this.setConfirmationMessage(argReq, "expansion.unconfigure.success");
            } else {
                this.saveSingleUserMessage(argReq, 1, "expansion.unconfigure.warning");
            }
        } else {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Form Has ERRORS");
            String messageKey = ((AdminExpansionForm)argForm).getErrorMessageKey();
            if (messageKey != null) {
                this.saveSingleUserMessage(argReq, 0, messageKey);
            }
        }
    }

    public ActionForward processInput(int pageNum, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "processInput";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Processing input for page = " + pageNum));
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Wizard action = " + this.getWizardAction(argReq)));
        switch (pageNum) {
            case 1: 
            case 2: {
                this.handleUnconfigurationProcess(argReq, argMapping, argForm, pageNum, true);
            }
        }
        return null;
    }

    protected ActionForward handleUnconfigurationProcess(HttpServletRequest argReq, ActionMapping argMapping, ActionForm argForm, int pageNum, boolean isAdd) {
        String methodName = "handleUnconfigurationProcess";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        UserMessages userMessages = new UserMessages();
        ActionForward actionForward = this.handleWizardErrors(argReq, argMapping, userMessages, pageNum);
        HttpSession session = argReq.getSession();
        if (!"nextPage".equals(this.getWizardAction(argReq))) {
            ArrayUnconfigurationThread uncfgThread = null;
            if (session.getAttribute("unconfiguration_thread") == null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Starting new unconfiguration process...");
                uncfgThread = new ArrayUnconfigurationThread(this, argForm, argReq, isAdd);
                session.setAttribute("unconfiguration_thread", (Object)uncfgThread);
                uncfgThread.start();
            } else {
                uncfgThread = (ArrayUnconfigurationThread)argReq.getSession().getAttribute("unconfiguration_thread");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ioe) {
                    // empty catch block
                }
                int stepInWizard = uncfgThread.getCurrentStep();
                int checkCount = 0;
                while (stepInWizard == uncfgThread.getCurrentStep() && !uncfgThread.isLastStepDone() && checkCount < 5) {
                    if (Trace.isTraceEnabled((Object)((Object)this))) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Last step is not done, step in wizard = thread current step,  waiting to check again...( " + checkCount + " )"));
                    }
                    ++checkCount;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ioe) {}
                }
                return actionForward;
            }
        }
        return null;
    }

    protected ActionForward handleArrayVerification(HttpServletRequest argReq, ActionMapping argMapping, ActionForm argForm, int pageNum) {
        String methodName = "handleArrayVerification";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        UserMessages userMessages = new UserMessages();
        ActionForward actionForward = this.handleWizardErrors(argReq, argMapping, userMessages, pageNum);
        try {
            T4Interface array = this.getCurrentT4(argReq);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Checking if array (" + array.getName() + ") is back from restart..."));
            T4s t4BusObj = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
            T4Interface arrayAfterRestart = t4BusObj.getArrayByName(this.getConfigContext(argReq), array.getName());
            if (arrayAfterRestart != null) {
                block11: {
                    argReq.getSession().setAttribute("CurrentT4", (Object)arrayAfterRestart);
                    String verifyStatus = (String)argReq.getSession().getAttribute("verification_thread_done");
                    if (verifyStatus == null) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"No verification status in session, put in session as false and show page");
                        argReq.getSession().setAttribute("verification_thread_done", (Object)"false");
                        this.saveSingleUserMessage(argReq, 1, "expansion.verify.arraynotready");
                        return actionForward;
                    }
                    int checkCount = 0;
                    while (arrayAfterRestart.getHealthStatus() != 2 && arrayAfterRestart.getHealthStatus() != 103 && checkCount < 10) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Array is not healty yet, keep waiting to check again (" + checkCount + ")"));
                        this.saveSingleUserMessage(argReq, 1, "expansion.verify.arraynotready");
                        try {
                            Thread.sleep(5000L);
                            t4BusObj.refreshArray(arrayAfterRestart);
                            ++checkCount;
                        }
                        catch (InterruptedException ioe) {
                        }
                        catch (Exception ioe) {
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Error trying to refresh cache; swallowing");
                        }
                    }
                    try {
                        if (arrayAfterRestart.getHealthStatus() == 103) {
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Array misconfigured detected");
                            argReq.getSession().setAttribute("verification_thread_done", (Object)"true");
                            this.removeAllUserMessages(argReq);
                            this.saveSingleUserMessage(argReq, 0, "expansion.verify.arraymissconfigured");
                            ((AdminExpansionForm)argForm).setShouldOnline(false);
                            ((AdminExpansionForm)argForm).setTrays(null);
                            return actionForward;
                        }
                        t4BusObj.checkArrayHealth(arrayAfterRestart);
                        this.removeAllUserMessages(argReq);
                        this.setConfirmationMessage(argReq, "expansion.verify.arrayready");
                        argReq.getSession().setAttribute("verification_thread_done", (Object)"true");
                        List trays = arrayAfterRestart.getTrays();
                        ((AdminExpansionForm)argForm).setTrays(trays);
                    }
                    catch (ConfigMgmtException cme) {
                        ((AdminExpansionForm)argForm).setTrays(null);
                        Integer submitCount = (Integer)argReq.getSession().getAttribute("submitCount");
                        if (submitCount == null) break block11;
                        int submitIntCount = submitCount;
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Array is not healthy; how many times have we submitted the page? " + submitIntCount));
                        argReq.getSession().setAttribute("submitCount", (Object)new Integer(++submitIntCount));
                        if (submitIntCount < 5) break block11;
                        argReq.getSession().setAttribute("verification_thread_done", (Object)"true");
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Array is still not healthy and check was performed more than max count");
                        this.removeAllUserMessages(argReq);
                        this.saveSingleUserMessage(argReq, 1, "expansion.timeout.warning.message");
                        this.saveSingleUserMessage(argReq, 1, "expansion.verify.maxcheck.arraynotready");
                        argReq.getSession().setAttribute("submitCount", (Object)new Integer(0));
                        ((AdminExpansionForm)argForm).setShouldOnline(false);
                    }
                }
                return actionForward;
            }
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Could not find array after restart");
            this.saveSingleUserMessage(argReq, 0, "expansion.error.arraycannotfind");
        }
        catch (Exception ex) {
            ConfigMgmtException cme = new ConfigMgmtException(ex);
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, ex);
        }
        return null;
    }

    public ActionForward finishWizard(int lastPage, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "finishWizard";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        UserMessages messages = new UserMessages();
        ActionForward actionForward = this.handleWizardErrors(argReq, argMapping, messages, lastPage);
        argReq.getSession().removeAttribute("needFinish");
        argReq.getSession().removeAttribute("needClose");
        if (!((AdminExpansionForm)argForm).getShouldOnline()) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Do NOT place pools online, finish wizard");
            return actionForward;
        }
        try {
            StoragePools poolsBusObj = (StoragePools)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Place all pools online...");
            List trays = this.getCurrentT4(argReq).getTrays();
            Iterator traysIterator = trays.iterator();
            while (traysIterator.hasNext()) {
                TrayInterface tray = (TrayInterface)traysIterator.next();
                List pools = tray.getRaidGroups();
                poolsBusObj.changeStatusToOnlineForGroup(pools);
            }
        }
        catch (Exception ex) {
            ConfigMgmtException cme = new ConfigMgmtException(ex);
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.saveSingleUserMessage(argReq, 0, "add.expansion.error.onlinepools");
        }
        return actionForward;
    }
}

