/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.props;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ListFormatter;
import com.sun.netstorage.array.mgmt.cfg.cli.props.VolumeBaseProps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class VolumePropsS1
extends VolumeBaseProps {
    private String name;
    private String WWN;
    private String description;
    private String creationDate;
    private String domain;
    private String pool;
    private String profile;
    private BigInteger size;
    private int state;
    private int mapState;
    private Set condition;
    private String type;
    private int snapPoolSize;
    private int snapPctFull;
    private String snapPool;
    private int snapPolicy;
    private int rollbackPercentage;
    private int snapCount;
    private int snapActivity;
    private ArrayList snaps;
    private ArrayList associations;
    private Set typeSummary;
    private boolean showDetails;

    public void setName(String newName) {
        this.name = newName;
    }

    public void setWWN(String newWWN) {
        this.WWN = newWWN;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public void setCreationDate(String newCreationDate) {
        this.creationDate = newCreationDate;
    }

    public void setDomain(String newDomain) {
        this.domain = newDomain;
    }

    public void setPool(String newPool) {
        this.pool = newPool;
    }

    public void setProfile(String newProfile) {
        this.profile = newProfile;
    }

    public void setSize(BigInteger newSize) {
        this.size = newSize;
    }

    public void setState(int newState) {
        this.state = newState;
    }

    public void setMapState(int newMapState) {
        this.mapState = newMapState;
    }

    public void setCondition(Set newCondition) {
        this.condition = newCondition;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public void setSnapPoolSize(int newSnapPoolSize) {
        this.snapPoolSize = newSnapPoolSize;
    }

    public void setSnapPctFull(int newSnapPctFull) {
        this.snapPctFull = newSnapPctFull;
    }

    public void setSnapPool(String newSnapPool) {
        this.snapPool = newSnapPool;
    }

    public void setSnapPolicy(int newSnapPolicy) {
        this.snapPolicy = newSnapPolicy;
    }

    public void setRollbackPercentage(int inInt) {
        this.rollbackPercentage = inInt;
    }

    public void setSnapCount(int newSnapCount) {
        this.snapCount = newSnapCount;
    }

    public void setSnapActivity(int newSnapActivity) {
        this.snapActivity = newSnapActivity;
    }

    public void setSnaps(ArrayList newSnaps) {
        this.snaps = newSnaps;
    }

    public void setAssociations(ArrayList newAssociations) {
        this.associations = newAssociations;
    }

    public void setTypeSummary(Set newTypeSummary) {
        this.typeSummary = newTypeSummary;
    }

    public void setShowDetails(boolean listDetails) {
        this.showDetails = listDetails;
    }

    private String volumeSummary() {
        StringBuffer sb = new StringBuffer();
        String[] arguments = new String[]{this.name, this.domain, this.typeSummaryString()};
        return this.getString("cli.volume.summary", arguments);
    }

    private String typeSummaryString() {
        StringBuffer sb = new StringBuffer();
        boolean bFirst = true;
        String delim = this.getString("cli.list.delimiter");
        if (null == this.typeSummary) {
            return this.getString("cli.volume.summary.typeSummary.unknown");
        }
        Iterator it = this.typeSummary.iterator();
        while (it.hasNext()) {
            Integer value = (Integer)it.next();
            if (!bFirst) {
                sb.append(delim);
            }
            sb.append(this.getString("cli.volume.summary.typeSummary", value));
            bFirst = false;
        }
        return sb.toString();
    }

    public String toString(Locale locale) {
        this.setLocale(locale);
        StringBuffer sb = new StringBuffer();
        if (!this.showDetails) {
            return this.volumeSummary();
        }
        ListFormatter lf = new ListFormatter();
        lf.addLine(this.getString("cli.volume.title"), this.name);
        lf.addLine(this.getString("cli.volume.description"), this.description);
        lf.addLine(this.getString("cli.volume.creationDate"), this.creationDate);
        lf.addLine(this.getString("cli.volume.WWN"), this.WWN);
        lf.addLine(this.getString("cli.volume.domain"), this.domain);
        lf.addLine(this.getString("cli.volume.pool"), this.pool);
        lf.addLine(this.getString("cli.volume.profile"), this.profile);
        lf.addLine(this.getString("cli.volume.size"), SizeConvert.bytesStringToDisplayValue((String)this.size.toString()).toString());
        lf.addLine(this.getString("cli.volume.state"), this.getString("cli.volume.state", this.state));
        lf.addLine(this.getString("cli.volume.condition"), this.cvtConditionToString(this.condition, true, this.rollbackPercentage));
        lf.addLine(this.getString("cli.volume.type"), this.type);
        if (!this.type.equalsIgnoreCase("SNAP")) {
            lf.addLine(this.getString("cli.volume.snapPolicy"), this.getString("cli.volume.snapPolicy", this.snapPolicy));
            lf.addLine(this.getString("cli.volume.snapPool"), this.snapPool);
            if (0 == this.snapCount) {
                lf.addLine(this.getString("cli.volume.snapCount"), this.getString("cli.volume.snapCount.noSnapshots"));
            } else {
                lf.addLine(this.getString("cli.volume.snapCount"), Integer.toString(this.snapCount) + this.getString("cli.volume.snapCount.snapshots"));
            }
            lf.addLine(this.getString("cli.volume.snapActivity"), this.getString("cli.volume.snapActivity", this.snapActivity));
            lf.addLine(this.getString("cli.volume.snapPoolSize"), Integer.toString(this.snapPoolSize));
            lf.addLine(this.getString("cli.volume.snapPctFull"), Integer.toString(this.snapPctFull));
        }
        sb.append(lf.getList());
        if (!this.type.equalsIgnoreCase("SNAP")) {
            sb.append(this.getString("cli.volume.snapHeader"));
            sb.append(this.cvtSnapshotListToString(this.snaps));
            sb.append("\n");
        }
        sb.append(this.getString("cli.volume.assocHeader"));
        sb.append(this.cvtInitiatorListToString(this.associations));
        return sb.toString();
    }
}

