/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.props;

import com.sun.netstorage.array.mgmt.cfg.cli.props.BaseProps;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ListFormatter;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Locale;

public class VdiskPropsS1
extends BaseProps {
    private String vdiskId;
    private String storageDomain;
    private String pool;
    private String profile;
    private boolean state;
    private int status;
    private String WWN;
    private BigInteger totalCapacity;
    private BigInteger configuredCapacity;
    private BigInteger availableCapacity;
    private ArrayList vdisks;
    private ArrayList volumes;
    private int nDisks;
    private int nUsedPartitions;
    private int nFreePartitions;
    private int nPartitions;
    private String trayId;
    private int management;
    boolean showDetails;

    public void setVdiskId(String newVdiskId) {
        this.vdiskId = newVdiskId;
    }

    public void setStorageDomain(String newStorageDomain) {
        this.storageDomain = newStorageDomain;
    }

    public void setPool(String newPool) {
        this.pool = newPool;
    }

    public void setProfile(String newProfile) {
        this.profile = newProfile;
    }

    public void setState(boolean newState) {
        this.state = newState;
    }

    public void setStatus(int newStatus) {
        this.status = newStatus;
    }

    public void setWWN(String newWWN) {
        this.WWN = newWWN;
    }

    public void setTotalCapacity(BigInteger newTotalCapacity) {
        this.totalCapacity = newTotalCapacity;
    }

    public void setConfiguredCapacity(BigInteger newConfiguredCapacity) {
        this.configuredCapacity = newConfiguredCapacity;
    }

    public void setAvailableCapacity(BigInteger newAvaliableCapacity) {
        this.availableCapacity = newAvaliableCapacity;
    }

    public void setVdisks(ArrayList newVdisks) {
        this.vdisks = newVdisks;
    }

    public void setVolumes(ArrayList newVolumes) {
        String METHOD_NAME = "setVolumes";
        Trace.methodBegin((Object)this, (String)"setVolumes");
        Trace.verbose((Object)this, (String)"setVolumes", (String)("setVolumes " + newVolumes));
        this.volumes = newVolumes;
    }

    public void setNDisks(int newNDisks) {
        this.nDisks = newNDisks;
    }

    public void setNUsedPartitions(int newNUsedPartitions) {
        this.nUsedPartitions = newNUsedPartitions;
    }

    public void setNFreePartitions(int newNFreePartitions) {
        this.nFreePartitions = newNFreePartitions;
    }

    public void setNPartitions(int newNPartitions) {
        this.nPartitions = newNPartitions;
    }

    public void setTrayId(String newTrayId) {
        this.trayId = newTrayId;
    }

    public void setManagement(int newManagement) {
        this.management = newManagement;
    }

    public void setShowDetails(boolean listDetails) {
        this.showDetails = listDetails;
    }

    private String vdiskVolumeListToString(ArrayList associatedVolumes) {
        StorageVolumeInterface svi = null;
        String[] arguments = new String[1];
        StringBuffer sb = new StringBuffer();
        String result = null;
        for (int i = 0; i < associatedVolumes.size(); ++i) {
            svi = (StorageVolumeInterface)associatedVolumes.get(i);
            arguments[0] = svi.getName();
            result = this.getString("cli.vdisk.volume", arguments);
            sb.append("\n").append(result);
        }
        return sb.toString();
    }

    private String listVdiskBrief() {
        String[] arguments = new String[]{this.vdiskId, this.storageDomain, this.pool, this.getString("cli.vdisk.management.label", this.management)};
        return this.getString("cli.vdisk.brief", arguments);
    }

    public String toString(Locale locale) {
        this.setLocale(locale);
        StringBuffer sb = new StringBuffer();
        if (!this.showDetails) {
            return this.listVdiskBrief();
        }
        ListFormatter lf = new ListFormatter();
        lf.addLine(this.getString("cli.vdisk.title"), this.vdiskId);
        lf.addLine(this.getString("cli.vdisk.domain"), this.storageDomain);
        lf.addLine(this.getString("cli.vdisk.pool"), this.pool);
        lf.addLine(this.getString("cli.vdisk.management"), this.getString("cli.vdisk.management.label", this.management));
        lf.addLine(this.getString("cli.vdisk.profile"), this.profile);
        lf.addLine(this.getString("cli.vdisk.trayId"), this.trayId);
        lf.addLine(this.getString("cli.vdisk.nDisks"), Integer.toString(this.nDisks));
        lf.addLine(this.getString("cli.vdisk.nPartitions"), Integer.toString(this.nPartitions));
        lf.addLine(this.getString("cli.vdisk.nUsedPartitions"), Integer.toString(this.nUsedPartitions));
        lf.addLine(this.getString("cli.vdisk.nFreePartitions"), Integer.toString(this.nFreePartitions));
        lf.addLine(this.getString("cli.vdisk.state"), this.state ? this.getString("cli.vdisk.stateInUse") : this.getString("cli.vdisk.stateNotInUse"));
        lf.addLine(this.getString("cli.vdisk.status"), this.getString("cli.6920.Vdisk.Value.Status", this.status));
        lf.addLine(this.getString("cli.vdisk.totalCapacity"), this.totalCapacity.toString());
        lf.addLine(this.getString("cli.vdisk.availableCapacity"), this.availableCapacity.toString());
        lf.addLine(this.getString("cli.vdisk.configuredCapacity"), this.configuredCapacity.toString());
        sb.append(lf.getList());
        sb.append(this.getString("cli.vdisk.volumes"));
        sb.append(this.vdiskVolumeListToString(this.volumes));
        return sb.toString();
    }
}

