/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.props;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.cli.props.BaseProps;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ListFormatter;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageArrayEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class StoragePoolPropsS1
extends BaseProps {
    private StoragePoolInterface storagePool;
    private String poolName;
    private String description;
    private String domain;
    private String profile;
    private BigInteger capacity;
    private BigInteger allocatedCapacity;
    private BigInteger unallocatedCapacity;
    private ArrayList vdisks;
    private ArrayList volumes;
    private List storageArrays;
    boolean showDetails = false;

    public void setName(String sPoolName) {
        this.poolName = sPoolName;
    }

    public void setDescription(String sDescription) {
        this.description = sDescription;
    }

    public void setDomain(String sDomain) {
        this.domain = sDomain;
    }

    public void setProfileName(String sProfileName) {
        this.profile = sProfileName;
    }

    public void setCapacity(BigInteger newCapacity) {
        this.capacity = newCapacity;
    }

    public void setAllocatedCapacity(BigInteger newAllocatedCapacity) {
        this.allocatedCapacity = newAllocatedCapacity;
    }

    public void setUnAllocatedCapacity(BigInteger newUnallocatedCapacity) {
        this.unallocatedCapacity = newUnallocatedCapacity;
    }

    public void setVdisks(ArrayList newVdisks) {
        this.vdisks = newVdisks;
    }

    public void setVolumes(ArrayList newVolumes) {
        this.volumes = newVolumes;
    }

    public void setStorageArrays(List theArraysList) {
        this.storageArrays = theArraysList;
    }

    public void setStoragePool(StoragePoolInterface theStoragePool) {
        this.storagePool = theStoragePool;
    }

    public void setShowDetails(boolean bValue) {
        this.showDetails = bValue;
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    private String poolBrief() {
        String[] arguments = new String[]{this.poolName, this.domain};
        return this.getString("cli.6920.StoragePool.Summary", arguments);
    }

    private String volumeListToString(ArrayList volumeList) {
        StringBuffer sb = new StringBuffer();
        String[] arguments = new String[2];
        Iterator e = volumeList.iterator();
        while (e.hasNext()) {
            StorageVolumeInterface svi = (StorageVolumeInterface)e.next();
            arguments[0] = svi.getName();
            sb.append("\n").append(this.getString("cli.6920.StoragePool.SubList.Volume", arguments));
        }
        return sb.toString();
    }

    private String vdiskListToString(ArrayList vdiskList) {
        StringBuffer sb = new StringBuffer();
        String[] arguments = new String[2];
        Iterator e = vdiskList.iterator();
        while (e.hasNext()) {
            VDiskEnt1Interface vdi = (VDiskEnt1Interface)e.next();
            arguments[0] = vdi.getName();
            arguments[1] = this.getString("cli.6920.Vdisk.Value.Status", vdi.getStatus());
            sb.append("\n").append(this.getString("cli.6920.StoragePool.SubList.VdiskStatus", arguments));
        }
        return sb.toString();
    }

    private String storageArraysToString(List listOfArrays) {
        StringBuffer sb = new StringBuffer();
        String[] arguments = new String[4];
        for (int i = 0; listOfArrays != null && i < listOfArrays.size(); ++i) {
            StorageArrayEnt1Interface array = (StorageArrayEnt1Interface)listOfArrays.get(i);
            arguments[0] = array.getName();
            arguments[1] = SizeConvert.bytesStringToDisplayValue((String)array.getRawTotalCapacity(this.storagePool).toString()).toString();
            arguments[2] = SizeConvert.bytesStringToDisplayValue((String)array.getRawConfiguredCapacity(this.storagePool).toString()).toString();
            arguments[3] = SizeConvert.bytesStringToDisplayValue((String)array.getRawAvailableCapacity(this.storagePool).toString()).toString();
            sb.append("\n").append(this.getString("cli.6920.StoragePool.SubList.Array", arguments));
        }
        return sb.toString();
    }

    public String toString(Locale locale) {
        this.setLocale(locale);
        if (!this.showDetails) {
            return this.poolBrief();
        }
        ListFormatter lf = new ListFormatter();
        try {
            NumberFormat nf = NumberFormat.getInstance();
            Number nCap = nf.parse(Convert.bytesStringToGB((String)this.capacity.toString()));
            Number nAllocd = nf.parse(Convert.bytesStringToGB((String)this.allocatedCapacity.toString()));
            Number nUnAllocd = nf.parse(Convert.bytesStringToGB((String)this.unallocatedCapacity.toString()));
            lf.addLine(this.getString("cli.6920.StoragePool.Label.StoragePool"), this.poolName);
            lf.addLine(this.getString("cli.6920.StoragePool.Label.Description"), this.description);
            lf.addLine(this.getString("cli.6920.StoragePool.Label.Domain"), this.domain);
            lf.addLine(this.getString("cli.6920.StoragePool.Label.Profile"), this.profile);
            lf.addLine(this.getString("cli.6920.StoragePool.Label.TotalCapacity"), new String(nf.format(nCap) + "GB"));
            lf.addLine(this.getString("cli.6920.StoragePool.Label.Allocated"), new String(nf.format(nAllocd) + "GB"));
            lf.addLine(this.getString("cli.6920.StoragePool.Label.Unallocated"), new String(nf.format(nUnAllocd) + "GB"));
            lf.addLine(this.getString("cli.6920.StoragePool.Title.Vdisks"), this.vdiskListToString(this.vdisks));
            lf.addLine(this.getString("cli.6920.StoragePool.Title.Volumes"), this.volumeListToString(this.volumes));
            lf.addLine(this.getString("cli.6920.StoragePool.Title.StorageArrays"), this.storageArraysToString(this.storageArrays));
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"toString", (Throwable)e);
        }
        return lf.getList();
    }
}

