/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.props;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.props.BaseProps;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ListFormatter;
import com.sun.netstorage.array.mgmt.cfg.cli.server.LocaleAware;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class StorageDomainProps
extends BaseProps
implements LocaleAware {
    private String domainName;
    private String description;
    private String capacity;
    private String allocated;
    private String unallocated;
    private List pools = null;
    private List initiators = null;
    private List volumes = null;
    boolean showDetails = false;

    public void setDomainName(String newDomainName) {
        this.domainName = newDomainName;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public void setCapacity(String newCapacity) {
        this.capacity = newCapacity;
    }

    public void setAllocated(String newAllocated) {
        this.allocated = newAllocated;
    }

    public void setUnallocated(String newUnallocated) {
        this.unallocated = newUnallocated;
    }

    public void setPools(List newPools) {
        this.pools = newPools;
    }

    public void setInitiators(List newInitiators) {
        this.initiators = newInitiators;
    }

    public void setVolumes(List newVolumes) {
        this.volumes = newVolumes;
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(boolean bValue) {
        this.showDetails = bValue;
    }

    private String poolListToString(List poolList) {
        StringBuffer sb = new StringBuffer();
        String[] arguments = new String[1];
        Iterator e = poolList.iterator();
        while (e.hasNext()) {
            StoragePoolInterface spi = (StoragePoolInterface)e.next();
            arguments[0] = spi.getName();
            String result = this.getString("cli.sdomain.pools", arguments);
            sb.append("\n").append(result);
        }
        return sb.toString();
    }

    private String initiatorListToString(List initiatorList) {
        StringBuffer sb = new StringBuffer();
        String[] arguments = new String[1];
        Iterator e = initiatorList.iterator();
        while (e.hasNext()) {
            InitiatorInterface ii = (InitiatorInterface)e.next();
            arguments[0] = ii.getName();
            String result = this.getString("cli.sdomain.initiators", arguments);
            sb.append("\n").append(result);
        }
        return sb.toString();
    }

    private String volumeListToString(List volumeList) {
        StringBuffer sb = new StringBuffer();
        String[] arguments = new String[1];
        Iterator e = volumeList.iterator();
        while (e.hasNext()) {
            StorageVolumeInterface svi = (StorageVolumeInterface)e.next();
            arguments[0] = svi.getName();
            String result = this.getString("cli.sdomain.volumes", arguments);
            sb.append("\n").append(result);
        }
        return sb.toString();
    }

    public String toString(Locale locale) {
        this.setLocale(locale);
        StringBuffer sb = new StringBuffer();
        if (!this.showDetails) {
            sb.append(this.getString("cli.sdomain.title")).append("  ").append(this.domainName);
            return sb.toString();
        }
        ListFormatter lf = new ListFormatter();
        try {
            NumberFormat nf = NumberFormat.getInstance();
            Number nCap = nf.parse(Convert.bytesStringToGB((String)this.capacity));
            Number nAllocd = nf.parse(Convert.bytesStringToGB((String)this.allocated));
            Number nUnAllocd = nf.parse(Convert.bytesStringToGB((String)this.unallocated));
            lf.addLine(this.getString("cli.sdomain.title"), this.domainName);
            lf.addLine(this.getString("cli.sdomain.description"), this.description);
            lf.addLine(this.getString("cli.sdomain.capacity"), new String(nf.format(nCap) + "GB"));
            lf.addLine(this.getString("cli.sdomain.allocated"), new String(nf.format(nAllocd) + "GB"));
            lf.addLine(this.getString("cli.sdomain.unallocated"), new String(nf.format(nUnAllocd) + "GB"));
            sb.append(lf.getList());
            int iChop = sb.length();
            sb.setLength(--iChop);
            sb.append(this.poolListToString(this.pools));
            sb.append(this.initiatorListToString(this.initiators));
            sb.append(this.volumeListToString(this.volumes));
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"toString", (Throwable)e);
        }
        return sb.toString();
    }
}

