/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.props;

import com.sun.netstorage.array.mgmt.cfg.cli.props.BaseProps;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ListFormatter;
import java.math.BigInteger;
import java.util.Locale;

public class RepsetProps
extends BaseProps {
    private int state;
    private int resyncProgress;
    private String repsetName;
    private String constgroupName;
    private boolean showRepGroup = false;
    private String localVolumeName;
    private String peerWWN;
    private String remoteVolumeWWN;
    private String queuePoolName;
    private String queueSize;
    private int queueFullAction;
    private int queueTimeCount;
    private BigInteger queueBlockCount;
    private int mode;
    private int role;
    private int replicationPriority;
    private boolean autoSync;
    private String storageDomain;
    private boolean snapWithPrimary;
    private boolean snapBeforeSync;
    private String bitmapPoolName;
    private String bitmapPoolSize;
    private int errorStatus;
    private boolean showDetails;
    private boolean hasQueue;
    private String wwn;

    public void setState(int newState) {
        this.state = newState;
    }

    public void setResyncProgress(int newProgress) {
        this.resyncProgress = newProgress;
    }

    public void setRepsetName(String newName) {
        this.repsetName = newName;
    }

    public void setRepgroupName(String newName) {
        this.constgroupName = newName;
        this.showRepGroup = true;
    }

    public void setLocalVolumeName(String newLocalVolumeName) {
        this.localVolumeName = newLocalVolumeName;
    }

    public void setPeerWWN(String newPeerWWN) {
        this.peerWWN = newPeerWWN;
    }

    public void setRemoteVolumeWWN(String newRemoteVolumeWWN) {
        this.remoteVolumeWWN = newRemoteVolumeWWN;
    }

    public void setQueuePoolName(String newQueuePoolName) {
        this.queuePoolName = newQueuePoolName;
    }

    public void setQueueSize(String newQueueSize) {
        this.queueSize = newQueueSize;
    }

    public void setQueueFullAction(int newQueueFullAction) {
        this.queueFullAction = newQueueFullAction;
    }

    public void setQueueTimeCount(int newQueueTimeCount) {
        this.queueTimeCount = newQueueTimeCount;
    }

    public void setQueueBlockCount(BigInteger newQueueBlockCount) {
        this.queueBlockCount = newQueueBlockCount;
    }

    public void setMode(int newMode) {
        this.mode = newMode;
    }

    public void setRole(int newRole) {
        this.role = newRole;
    }

    public void setReplicationPriority(int newRepPriority) {
        this.replicationPriority = newRepPriority;
    }

    public void setStorageDomain(String newStorageDomain) {
        this.storageDomain = newStorageDomain;
    }

    public void setAutoSync(boolean bValue) {
        this.autoSync = bValue;
    }

    public void setSnapWithPrimary(boolean bValue) {
        this.snapWithPrimary = bValue;
    }

    public void setSnapBeforeSync(boolean bValue) {
        this.snapBeforeSync = bValue;
    }

    public void setBitmapPoolName(String newBitmapPoolName) {
        this.bitmapPoolName = newBitmapPoolName;
    }

    public void setBitmapPoolSize(String newBitmapPoolSize) {
        this.bitmapPoolSize = newBitmapPoolSize;
    }

    public void setErrorStatus(int newErrorStatus) {
        this.errorStatus = newErrorStatus;
    }

    public void setShowDetails(boolean bValue) {
        this.showDetails = bValue;
    }

    private String listRepsetBrief() {
        if (this.showRepGroup) {
            String[] arguments = new String[]{this.repsetName, this.localVolumeName, this.storageDomain, this.constgroupName};
            return this.getString("cli.6920.ReplicationSet.Summary.WithGroup", arguments);
        }
        String[] arguments = new String[]{this.repsetName, this.localVolumeName, this.storageDomain};
        return this.getString("cli.6920.ReplicationSet.Summary", arguments);
    }

    public void setRepQueueDisplayed(boolean val) {
        this.hasQueue = val;
    }

    public void setWWN(String newWWN) {
        this.wwn = newWWN;
    }

    public String toString(Locale locale) {
        String replicationProgress;
        this.setLocale(locale);
        StringBuffer sb = new StringBuffer();
        if (!this.showDetails) {
            return this.listRepsetBrief();
        }
        ListFormatter lf = new ListFormatter();
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.Name"), this.repsetName);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Title.WWN"), this.wwn);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.LocalVolume"), this.localVolumeName);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.StorageDomain"), this.storageDomain);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.RemotePeer"), this.peerWWN);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.RemoteVolume"), this.remoteVolumeWWN);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.Mode"), this.getString("cli.6920.ReplicationSet.Value.Mode", this.mode));
        if (this.showRepGroup) {
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.Constgroup"), this.constgroupName);
        }
        if (this.errorStatus > 0) {
            replicationProgress = this.getString("cli.6920.ReplicationSet.Value.State", 3) + ", " + this.getString("error.cim", this.errorStatus);
        } else if (2 == this.state) {
            if (1 == this.role) {
                String[] syncParam = new String[]{Integer.toString(this.resyncProgress)};
                replicationProgress = this.getString("cli.6920.ReplicationSet.Value.State." + Integer.toString(this.state), syncParam);
            } else {
                replicationProgress = this.getString("cli.6920.ReplicationSet.Value.State.SynchronizingSecondary");
            }
        } else {
            replicationProgress = this.getString("cli.6920.ReplicationSet.Value.State", this.state);
        }
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.ReplicationProgress"), replicationProgress);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.ReplicationPriority"), this.getString("cli.6920.ReplicationSet.Value.ReplicationPriority", this.replicationPriority));
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.AutoSynchronize"), this.getString("cli.6920.ReplicationSet.Value.Enabled", Boolean.toString(this.autoSync)));
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.Role"), this.getString("cli.6920.ReplicationSet.Value.Role", this.role));
        lf.addLine(this.getString("cli.6920.ReplicationSet.Title.WhenSecondary"), "");
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.SnapBeforeSync"), this.getString("cli.6920.ReplicationSet.Value.Enabled", Boolean.toString(this.snapBeforeSync)));
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.SnapWithPrimary"), this.getString("cli.6920.ReplicationSet.Value.Enabled", Boolean.toString(this.snapWithPrimary)));
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.BitmapPool"), this.bitmapPoolName);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.BitmapSize"), this.bitmapPoolSize);
        if (this.hasQueue) {
            lf.addLine(this.getString("cli.6920.ReplicationSet.Title.AsyncQueue"), " ");
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.AsyncQueuePool"), this.queuePoolName);
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.AsyncQueueSize"), this.queueSize);
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.FullQueueAction"), this.getString("cli.6920.ReplicationSet.Value.FullQueue", this.queueFullAction));
            lf.addLine(this.getString("cli.6920.ReplicationSet.Title.FullWhen"), " ");
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.AsyncQueueBlockCount"), this.queueBlockCount.toString());
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.AsyncQueueTimeCount"), String.valueOf(this.queueTimeCount) + this.getString("cli.6920.ReplicationSet.Unit.Seconds"));
        }
        sb.append(lf.getList());
        return sb.toString();
    }
}

