/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.props;

import com.sun.netstorage.array.mgmt.cfg.cli.props.BaseProps;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ListFormatter;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationSetEnt1Interface;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;

public class RepgroupProps
extends BaseProps {
    private String constgroupName;
    private List repsetList;
    private String desc;
    private String peerWWN;
    private String queuePoolName;
    private String queueSize;
    private int queueFullAction;
    private int queueTimeCount;
    private BigInteger queueBlockCount;
    private int mode;
    private int role;
    private int replicationPriority;
    private String storageDomain;
    private boolean autoSync;
    private boolean snapWithPrimary;
    private boolean snapBeforeSync;
    private boolean showDetails;
    private boolean hasQueue;
    private String wwn;

    public void setConstgroupName(String newName) {
        this.constgroupName = newName;
    }

    public void setRepsetList(List inList) {
        this.repsetList = inList;
    }

    public void setDesc(String newDesc) {
        this.desc = newDesc;
    }

    public void setPeerWWN(String newPeerWWN) {
        this.peerWWN = newPeerWWN;
    }

    public void setQueuePoolName(String newQueuePoolName) {
        this.queuePoolName = newQueuePoolName;
    }

    public void setQueueSize(String newQueueSize) {
        this.queueSize = newQueueSize;
    }

    public void setQueueFullAction(int newQueueFullAction) {
        this.queueFullAction = newQueueFullAction;
    }

    public void setQueueTimeCount(int newQueueTimeCount) {
        this.queueTimeCount = newQueueTimeCount;
    }

    public void setQueueBlockCount(BigInteger newQueueBlockCount) {
        this.queueBlockCount = newQueueBlockCount;
    }

    public void setMode(int newMode) {
        this.mode = newMode;
    }

    public void setRole(int newRole) {
        this.role = newRole;
    }

    public void setReplicationPriority(int newRepPriority) {
        this.replicationPriority = newRepPriority;
    }

    public void setStorageDomain(String newStorageDomain) {
        this.storageDomain = newStorageDomain;
    }

    public void setAutoSync(boolean bValue) {
        this.autoSync = bValue;
    }

    public void setSnapWithPrimary(boolean bValue) {
        this.snapWithPrimary = bValue;
    }

    public void setSnapBeforeSync(boolean bValue) {
        this.snapBeforeSync = bValue;
    }

    public void setShowDetails(boolean bValue) {
        this.showDetails = bValue;
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    private String listConstgroupBrief() {
        String[] arguments = new String[]{this.constgroupName, this.storageDomain, this.peerWWN};
        return this.getString("cli.6920.ConsistencyGroup.Summary", arguments);
    }

    public void setGrpQueueDisplayed(boolean val) {
        this.hasQueue = val;
    }

    public void setWWN(String newWWN) {
        this.wwn = newWWN;
    }

    public String toString(Locale locale) {
        this.setLocale(locale);
        StringBuffer sb = new StringBuffer();
        if (!this.showDetails) {
            return this.listConstgroupBrief();
        }
        ListFormatter lf = new ListFormatter();
        lf.addLine(this.getString("cli.6920.ConsistencyGroup.Label.Name"), this.constgroupName);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Title.WWN"), this.wwn);
        lf.addLine(this.getString("cli.6920.ConsistencyGroup.Label.Desc"), null == this.desc ? " " : this.desc);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.StorageDomain"), this.storageDomain);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.RemotePeer"), this.peerWWN);
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.Mode"), this.getString("cli.6920.ReplicationSet.Value.Mode", this.mode));
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.ReplicationPriority"), this.getString("cli.6920.ReplicationSet.Value.ReplicationPriority", this.replicationPriority));
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.AutoSynchronize"), this.getString("cli.6920.ReplicationSet.Value.Enabled", Boolean.toString(this.autoSync)));
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.Role"), this.getString("cli.6920.ReplicationSet.Value.Role", this.role));
        lf.addLine(this.getString("cli.6920.ReplicationSet.Title.WhenSecondary"), "");
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.SnapBeforeSync"), this.getString("cli.6920.ReplicationSet.Value.Enabled", Boolean.toString(this.snapBeforeSync)));
        lf.addLine(this.getString("cli.6920.ReplicationSet.Label.SnapWithPrimary"), this.getString("cli.6920.ReplicationSet.Value.Enabled", Boolean.toString(this.snapWithPrimary)));
        if (this.hasQueue) {
            lf.addLine(this.getString("cli.6920.ReplicationSet.Title.AsyncQueue"), " ");
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.AsyncQueuePool"), this.queuePoolName);
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.AsyncQueueSize"), this.queueSize);
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.FullQueueAction"), this.getString("cli.6920.ReplicationSet.Value.FullQueue", this.queueFullAction));
            lf.addLine(this.getString("cli.6920.ReplicationSet.Title.FullWhen"), " ");
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.AsyncQueueBlockCount"), this.queueBlockCount.toString());
            lf.addLine(this.getString("cli.6920.ReplicationSet.Label.AsyncQueueTimeCount"), String.valueOf(this.queueTimeCount) + this.getString("cli.6920.ReplicationSet.Unit.Seconds"));
        }
        lf.addLine(this.getString("cli.6920.ConsistencyGroup.Title.Repsets"), " ");
        sb.append(lf.getList());
        int n = this.repsetList.size();
        for (int i = 0; i < n; ++i) {
            ReplicationSetEnt1Interface repset = (ReplicationSetEnt1Interface)this.repsetList.get(i);
            String[] repsetDetails = new String[3];
            repsetDetails[0] = repset.getName();
            repsetDetails[1] = repset.getRemoteVolumeWwn();
            int state = 0;
            int repsetRole = 0;
            int resyncProgress = 0;
            int errorStatus = repset.getErrorStatus();
            try {
                repsetRole = repset.getReplicationParameters().getRole();
                resyncProgress = repset.getSyncProgress();
                state = repset.getState();
            }
            catch (ConfigMgmtException cme) {
                continue;
            }
            if (errorStatus > 0) {
                repsetDetails[2] = this.getString("cli.6920.ReplicationSet.Value.State", 3) + ", " + this.getString("error.cim", errorStatus);
            } else if (2 == state) {
                if (1 == repsetRole) {
                    String[] syncParam = new String[]{Integer.toString(resyncProgress)};
                    repsetDetails[2] = this.getString("cli.6920.ReplicationSet.Value.State." + Integer.toString(state), syncParam);
                } else {
                    repsetDetails[2] = this.getString("cli.6920.ReplicationSet.Value.State.SynchronizingSecondary");
                }
            } else {
                repsetDetails[2] = this.getString("cli.6920.ReplicationSet.Value.State", state);
            }
            sb.append(this.getString("cli.6920.ConsistencyGroup.SubList.RepsetSummary", repsetDetails)).append("\n");
        }
        return sb.toString();
    }
}

