/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.props;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ListFormatter;
import com.sun.netstorage.array.mgmt.cfg.cli.props.VolumeBaseProps;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class LocalMirrorProps
extends VolumeBaseProps {
    private String name;
    private String description;
    private String creationDate;
    private int resilverPriority;
    private String domain;
    private BigInteger size;
    private int state;
    private Set condition;
    private int snapPoolSize;
    private int snapPctFull;
    private List snaps;
    private List associations;
    private List components;
    private boolean showDetails;
    private int isolationPolicy;
    private String wwn;
    private List mirrorLogs;
    private String snapshotCompName = null;
    private int snapPolicy;
    private String snapPool = null;
    private int snapActivity;
    private int snapCount;

    public void setName(String inString) {
        this.name = inString;
    }

    public void setDescription(String inString) {
        this.description = inString;
    }

    public void setResilverPriority(int inInt) {
        this.resilverPriority = inInt;
    }

    public void setCreationDate(String inString) {
        this.creationDate = inString;
    }

    public void setDomain(String inString) {
        this.domain = inString;
    }

    public void setSize(BigInteger inSize) {
        this.size = inSize;
    }

    public void setState(int inInt) {
        this.state = inInt;
    }

    public void setCondition(Set inSet) {
        this.condition = inSet;
    }

    public void setSnapPoolSize(int inInt) {
        this.snapPoolSize = inInt;
    }

    public void setSnapPctFull(int inInt) {
        this.snapPctFull = inInt;
    }

    public void setSnaps(List inList) {
        this.snaps = inList;
    }

    public void setAssociations(List inList) {
        this.associations = inList;
    }

    public void setComponents(List inList) {
        this.components = inList;
    }

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public void setIsolationPolicy(int inInt) {
        this.isolationPolicy = inInt;
    }

    public void setWWN(String inString) {
        this.wwn = inString;
    }

    public void setMirrorLogs(List inList) {
        this.mirrorLogs = inList;
    }

    public void setSnapshotCompName(String inString) {
        this.snapshotCompName = inString;
    }

    public void setSnapPolicy(int inInt) {
        this.snapPolicy = inInt;
    }

    public void setSnapPool(String inString) {
        this.snapPool = inString;
    }

    public void setSnapActivity(int inInt) {
        this.snapActivity = inInt;
    }

    public void setSnapCount(int inInt) {
        this.snapCount = inInt;
    }

    private String mirrorLogsToString(List logs) {
        StringBuffer sb = new StringBuffer();
        boolean firstPool = true;
        if (null == logs) {
            return "";
        }
        for (int i = 0; i < logs.size(); ++i) {
            StoragePoolInterface pool = (StoragePoolInterface)logs.get(i);
            if (!firstPool) {
                sb.append(", ");
            } else {
                firstPool = false;
            }
            sb.append(pool.getName());
        }
        return sb.toString();
    }

    private String mirrorComponentsListToString(List componentsList) {
        StringBuffer sb = new StringBuffer();
        String[] arguments = new String[6];
        int n = componentsList.size();
        for (int i = 0; i < n; ++i) {
            MirrorComponentEnt1Interface cvi = (MirrorComponentEnt1Interface)componentsList.get(i);
            arguments[0] = cvi.getName();
            arguments[1] = this.getString("cli.volume.state", cvi.getState());
            arguments[2] = this.cvtConditionToString(cvi.getConditionInfo(), false, 0);
            arguments[3] = cvi.getStoragePoolName();
            int resilver = 0;
            try {
                resilver = cvi.getResilverProgress();
            }
            catch (ConfigMgmtException cme) {
                // empty catch block
            }
            arguments[4] = Integer.toString(resilver);
            arguments[5] = SizeConvert.bytesStringToDisplayValue((String)cvi.getSize().toString()).toString();
            sb.append("\n").append(this.getString("cli.localmirror.component", arguments));
        }
        return sb.toString();
    }

    public String toString(Locale locale) {
        this.setLocale(locale);
        StringBuffer sb = new StringBuffer();
        ListFormatter lf = new ListFormatter();
        lf.addLine(this.getString("cli.localmirror.title"), this.name);
        lf.addLine(this.getString("cli.localmirror.description"), this.description);
        lf.addLine(this.getString("cli.localmirror.creationDate"), this.creationDate);
        lf.addLine(this.getString("cli.localmirror.wwn"), this.wwn);
        lf.addLine(this.getString("cli.localmirror.sdomain"), this.domain);
        lf.addLine(this.getString("cli.localmirror.size"), SizeConvert.bytesStringToDisplayValue((String)this.size.toString()).toString());
        lf.addLine(this.getString("cli.localmirror.state"), this.getString("cli.volume.state", this.state));
        lf.addLine(this.getString("cli.localmirror.condition"), this.cvtConditionToString(this.condition, false, 0));
        lf.addLine(this.getString("cli.localmirror.resilverpriority"), this.getString("cli.localmirror.resilver", this.resilverPriority));
        lf.addLine(this.getString("cli.localmirror.isolationPolicy"), this.getString("cli.localmirror.isolation", this.isolationPolicy));
        lf.addLine(this.getString("cli.localmirror.logs"), this.mirrorLogsToString(this.mirrorLogs));
        lf.addLine(this.getString("cli.volume.snapPolicy"), this.getString("cli.volume.snapPolicy", this.snapPolicy));
        lf.addLine(this.getString("cli.volume.snapPool"), this.snapPool);
        if (0 == this.snapCount) {
            lf.addLine(this.getString("cli.volume.snapCount"), this.getString("cli.volume.snapCount.noSnapshots"));
        } else {
            lf.addLine(this.getString("cli.volume.snapCount"), Integer.toString(this.snapCount) + this.getString("cli.volume.snapCount.snapshots"));
        }
        lf.addLine(this.getString("cli.volume.snapActivity"), this.getString("cli.volume.snapActivity", this.snapActivity));
        lf.addLine(this.getString("cli.volume.snapPoolSize"), Integer.toString(this.snapPoolSize));
        lf.addLine(this.getString("cli.volume.snapPctFull"), Integer.toString(this.snapPctFull));
        lf.addLine(this.getString("cli.localmirror.snapshotComponent"), null != this.snapshotCompName ? this.snapshotCompName : this.getString("cli.localmirror.noSnapshotComponent"));
        sb.append(lf.getList());
        sb.append(this.getString("cli.localmirror.snapsHeader"));
        sb.append(this.cvtSnapshotListToString(this.snaps));
        sb.append("\n").append(this.getString("cli.localmirror.componentsHeader"));
        sb.append(this.mirrorComponentsListToString(this.components));
        sb.append("\n").append(this.getString("cli.localmirror.assocHeader"));
        sb.append(this.cvtInitiatorListToString(this.associations));
        return sb.toString();
    }
}

