/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.props;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ListFormatter;
import com.sun.netstorage.array.mgmt.cfg.cli.props.VolumeBaseProps;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class LocalMirrorComponentProps
extends VolumeBaseProps {
    private String name;
    private String description;
    private String creationDate;
    private String domain;
    private String pool;
    private String profile;
    private BigInteger size;
    private int state;
    private Set condition;
    private List associations;
    private List vdisks;
    private String resilverTimeRemaining;
    private String resilverTimeElapsed;
    private int resilverPct;
    private String wwn;
    private boolean isSnapComp;

    public void setName(String inString) {
        this.name = inString;
    }

    public void setDescription(String inString) {
        this.description = inString;
    }

    public void setCreationDate(String inString) {
        this.creationDate = inString;
    }

    public void setDomain(String inString) {
        this.domain = inString;
    }

    public void setPool(String inString) {
        this.pool = inString;
    }

    public void setProfile(String inString) {
        this.profile = inString;
    }

    public void setSize(BigInteger inSize) {
        this.size = inSize;
    }

    public void setState(int inInt) {
        this.state = inInt;
    }

    public void setCondition(Set inSet) {
        this.condition = inSet;
    }

    public void setAssociations(List inList) {
        this.associations = inList;
    }

    public void setVdisk(List inList) {
        this.vdisks = inList;
    }

    public void setResilverTimeRemaining(String inString) {
        this.resilverTimeRemaining = inString;
    }

    public void setResilverTimeElapsed(String inString) {
        this.resilverTimeElapsed = inString;
    }

    public void setResilverPct(int inInt) {
        this.resilverPct = inInt;
    }

    public void setWWN(String inString) {
        this.wwn = inString;
    }

    public void setIsSnapComp(boolean inBool) {
        this.isSnapComp = inBool;
    }

    private String volumeSnapshotListToString(List snapshotList) throws IllegalArgumentException {
        StorageVolumeInterface svi = null;
        String[] arguments = new String[1];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < snapshotList.size(); ++i) {
            svi = (StorageVolumeInterface)snapshotList.get(i);
            arguments[0] = svi.getName();
            try {
                String result = this.getString("cli.localmirror.snapshot", arguments);
                sb.append("\n").append(result);
                continue;
            }
            catch (Exception e) {
                Trace.verbose((Object)this, (String)"toString", (Throwable)e);
                arguments[0] = arguments[0] + " bad message format";
                String result = this.getString("cli.localmirror.snapshot.badFmt", arguments);
            }
        }
        return sb.toString();
    }

    private String volumeInitiatorListToString(List initiatorList) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        String[] arguments = new String[3];
        for (int i = 0; i < initiatorList.size(); ++i) {
            InitiatorVolumeMappingInterface ivmi = (InitiatorVolumeMappingInterface)initiatorList.get(i);
            InitiatorInterface ii = (InitiatorInterface)ivmi.getObject();
            Iterator it = ivmi.getPermissions().iterator();
            StringBuffer perms = new StringBuffer();
            while (it.hasNext()) {
                Integer temp = (Integer)it.next();
                if (first) {
                    perms.append(Convert.cvtPermission((Integer)temp));
                    first = false;
                    continue;
                }
                perms.append("/").append(Convert.cvtPermission((Integer)temp));
            }
            arguments[0] = ii.getName();
            arguments[1] = ivmi.getLun();
            arguments[2] = perms.toString();
            String result = this.getString("cli.localmirror.association", arguments);
            sb.append("\n").append(result);
            first = true;
        }
        return sb.toString();
    }

    public String toString(Locale locale) {
        this.setLocale(locale);
        StringBuffer sb = new StringBuffer();
        ListFormatter lf = new ListFormatter();
        lf.addLine(this.getString("cli.localmirror.component.title"), this.name);
        lf.addLine(this.getString("cli.localmirror.description"), this.description);
        lf.addLine(this.getString("cli.localmirror.creationDate"), this.creationDate);
        lf.addLine(this.getString("cli.localmirror.wwn"), this.wwn);
        lf.addLine(this.getString("cli.localmirror.sdomain"), this.domain);
        lf.addLine(this.getString("cli.volume.pool"), this.pool);
        lf.addLine(this.getString("cli.localmirror.profile"), this.profile);
        lf.addLine(this.getString("cli.localmirror.size"), SizeConvert.bytesStringToDisplayValue((String)this.size.toString()).toString());
        lf.addLine(this.getString("cli.localmirror.state"), this.getString("cli.volume.state", this.state));
        lf.addLine(this.getString("cli.localmirror.condition"), this.cvtConditionToString(this.condition, false, 0));
        lf.addLine(this.getString("cli.localmirror.component.resilverPercent"), Integer.toString(this.resilverPct) + "%");
        lf.addLine(this.getString("cli.localmirror.component.resilverTimeRemaining"), this.resilverTimeRemaining);
        lf.addLine(this.getString("cli.localmirror.component.resilverTimeElapsed"), this.resilverTimeElapsed);
        lf.addLine(this.getString("cli.localmirror.component.isSnapComp"), this.getString("cli.localmirror", this.isSnapComp ? "yes" : "no"));
        sb.append(lf.getList());
        sb.append(this.getString("cli.localmirror.assocHeader"));
        sb.append(this.volumeInitiatorListToString(this.associations));
        return sb.toString();
    }
}

