/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.props;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Size;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.cli.props.BaseProps;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ListFormatter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationLinkEnt1Interface;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;

public class EtherportProps
extends BaseProps {
    private String portName;
    private String networkMask;
    private String localAddress;
    private String defaultGateway;
    private int wndSize;
    private List repLinks = null;
    private boolean replicationEnabled = false;
    private boolean showDetails = false;
    private int hardwareState;
    private int portType;
    private int portSpeed;
    private int duplexMode;
    private BigInteger writeCommands;
    private BigInteger readCommands;
    private BigInteger bytesWritten;
    private BigInteger bytesRead;
    private BigInteger readErrors;
    private BigInteger writeErrors;

    public void setPortName(String newPortName) {
        this.portName = newPortName;
    }

    public void setNetworkMask(String newNetworkMask) {
        this.networkMask = newNetworkMask;
    }

    public void setLocalAddress(String newLocalAddress) {
        this.localAddress = newLocalAddress;
    }

    public void setDefaultGateway(String newDefaultGateway) {
        this.defaultGateway = newDefaultGateway;
    }

    public void setWindowSize(int wndSize) {
        this.wndSize = wndSize;
    }

    public void setRepLinks(List inValue) {
        this.repLinks = inValue;
    }

    public void setReplicationEnabled(boolean inValue) {
        this.replicationEnabled = inValue;
    }

    public void setShowDetails(boolean inValue) {
        this.showDetails = inValue;
    }

    public void setHardwareState(int inValue) {
        this.hardwareState = inValue;
    }

    public void setPortType(int inValue) {
        this.portType = inValue;
    }

    public void setPortSpeed(int inValue) {
        this.portSpeed = inValue;
    }

    public void setDuplexMode(int inValue) {
        this.duplexMode = inValue;
    }

    public void setWriteCommands(BigInteger inValue) {
        this.writeCommands = inValue;
    }

    public void setReadCommands(BigInteger inValue) {
        this.readCommands = inValue;
    }

    public void setBytesWritten(BigInteger inValue) {
        this.bytesWritten = inValue;
    }

    public void setBytesRead(BigInteger inValue) {
        this.bytesRead = inValue;
    }

    public void setReadErrors(BigInteger inValue) {
        this.readErrors = inValue;
    }

    public void setWriteErrors(BigInteger inValue) {
        this.writeErrors = inValue;
    }

    private String cvtReplinksToString() {
        if (null == this.repLinks || this.repLinks.isEmpty()) {
            return "\n";
        }
        String[] arguments = new String[3];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.repLinks.size(); ++i) {
            ReplicationLinkEnt1Interface replink = (ReplicationLinkEnt1Interface)this.repLinks.get(i);
            arguments[0] = replink.getRemoteAddress();
            arguments[1] = this.getString("cli.6920.Etherport.Value.ReplinkState", replink.getState());
            arguments[2] = replink.getDescription() == null ? " " : replink.getDescription();
            sb.append("\n").append(this.getString("cli.6920.Etherport.SubList.ReplicationLinkDetails", arguments));
        }
        return sb.toString();
    }

    public String toString(Locale locale) {
        this.setLocale(locale);
        StringBuffer sb = new StringBuffer();
        if (!this.showDetails) {
            sb.append(this.getString("cli.6920.Etherport.Label.PortName")).append("\t");
            sb.append(this.portName);
            return sb.toString();
        }
        ListFormatter lf = new ListFormatter();
        lf.addLine(this.getString("cli.6920.Etherport.Label.PortName"), this.portName);
        lf.addLine(this.getString("cli.6920.Etherport.Label.State"), this.getString("cli.6920.Etherport.Value.HardwareState", this.hardwareState));
        lf.addLine(this.getString("cli.6920.Etherport.Label.Replication"), this.getString("cli.6920.Etherport.Value.ReplicationEnabled", Boolean.toString(this.replicationEnabled)));
        lf.addLine(this.getString("cli.6920.Etherport.Label.PortSpeed"), this.getString("cli.6920.Etherport.Value.Speed", this.portSpeed) + ", " + this.getString("cli.6920.Etherport.Value.Duplex", this.duplexMode));
        lf.addLine(this.getString("cli.6920.Etherport.Label.PortType"), this.getString("cli.6920.Etherport.Value.Type", this.portType));
        lf.addLine(this.getString("cli.6920.Etherport.Label.ErrorCount"), this.readErrors.add(this.writeErrors).toString());
        lf.addLine(this.getString("cli.6920.Etherport.Label.WriteCommands"), this.writeCommands.toString());
        lf.addLine(this.getString("cli.6920.Etherport.Label.ReadCommands"), this.readCommands.toString());
        lf.addLine(this.getString("cli.6920.Etherport.Label.BytesWritten"), this.bytesWritten.toString());
        lf.addLine(this.getString("cli.6920.Etherport.Label.BytesRead"), this.bytesRead.toString());
        lf.addLine(this.getString("cli.6920.Etherport.Label.ReadErrors"), this.readErrors.toString());
        lf.addLine(this.getString("cli.6920.Etherport.Label.WriteErrors"), this.writeErrors.toString());
        lf.addLine(this.getString("cli.6920.Etherport.Label.LocalAddress"), this.localAddress == null ? " " : this.localAddress);
        lf.addLine(this.getString("cli.6920.Etherport.Label.NetworkMask"), this.networkMask == null ? " " : this.networkMask);
        lf.addLine(this.getString("cli.6920.Etherport.Label.DefaultGateway"), this.defaultGateway == null ? " " : this.defaultGateway);
        String val = " ";
        if (this.wndSize >= 1024 && this.wndSize <= 0x100000) {
            Size s = SizeConvert.bytesStringToDisplayValue((String)Integer.toString(this.wndSize));
            val = s.getValue().toBigInteger().toString() + s.getUnit();
        }
        lf.addLine(this.getString("cli.6920.Etherport.Label.WindowSize"), val);
        sb.append(lf.getList());
        sb.append(this.getString("cli.6920.Etherport.Title.ReplicationLinks"));
        sb.append(this.cvtReplinksToString());
        return sb.toString();
    }
}

