/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.props;

import com.sun.netstorage.array.mgmt.cfg.cli.props.BaseProps;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.text.NumberFormat;
import java.util.Locale;

public class DisksProps
extends BaseProps {
    private boolean showDetails = false;
    private String diskCapacity;
    private String diskName;
    private String poolName;
    private String role;
    private String state;
    private int status = -1;

    public void setShowDetails(boolean listDetails) {
        this.showDetails = listDetails;
    }

    public void setDiskCapacity(String newDiskCapacity) {
        this.diskCapacity = newDiskCapacity;
    }

    public void setDiskName(String newDiskName) {
        this.diskName = newDiskName;
    }

    public void setPoolName(String newPoolName) {
        this.poolName = newPoolName;
    }

    public void setRole(String newRole) {
        this.role = newRole;
    }

    public void setState(String newState) {
        this.state = newState;
    }

    public void setStatus(int newStatus) {
        this.status = newStatus;
    }

    public String toString(Locale locale) {
        this.setLocale(locale);
        String UNKNOWN = this.getString("disk.tag.unknown");
        StringBuffer result = new StringBuffer();
        try {
            NumberFormat nf = NumberFormat.getInstance();
            Number nCap = nf.parse(Convert.bytesStringToGB((String)this.diskCapacity));
            result.append("\n").append(this.getString("disk.diskName"));
            result.append(this.diskName);
            result.append("\n").append(this.getString("disk.diskCapacity"));
            result.append(nf.format(nCap) + "GB");
            result.append("\n").append(this.getString("disk.status"));
            if (6 == this.status) {
                result.append("failed");
            } else if ("unassigned".equalsIgnoreCase(this.role)) {
                result.append("available");
            } else if ("standbyDisk".equalsIgnoreCase(this.role) || "globalStandbyDisk".equalsIgnoreCase(this.role) || "dataDisk".equalsIgnoreCase(this.role)) {
                result.append("in use");
            } else {
                result.append(UNKNOWN);
            }
            result.append("\n").append(this.getString("disk.state"));
            if ("disabled".equals(this.state) || "enabled".equals(this.state)) {
                result.append(this.state);
            } else {
                result.append(UNKNOWN);
            }
            result.append("\n").append(this.getString("disk.role"));
            if ("globalStandbyDisk".equals(this.role)) {
                result.append(this.getString("disk.role.arrayspare"));
            } else if ("standbyDisk".equals(this.role)) {
                result.append(this.getString("disk.role.dedicatedhotspare"));
            } else if ("dataDisk".equals(this.role)) {
                result.append(this.getString("disk.role.data"));
            } else if ("unassigned".equalsIgnoreCase(this.role)) {
                result.append(this.getString("disk.role.unassigned"));
            } else {
                result.append(UNKNOWN);
            }
            result.append("\n").append(this.getString("disk.vdisk"));
            result.append(this.poolName.equals("null") ? "-" : this.poolName);
            result.append("\n");
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"toString", (Throwable)e);
        }
        return result.toString();
    }
}

