/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.common.SEExceptionHelper;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.LocalMirrorComponentProps;
import com.sun.netstorage.array.mgmt.cfg.cli.props.LocalMirrorProps;
import com.sun.netstorage.array.mgmt.cfg.cli.props.VolumeBaseProps;
import com.sun.netstorage.array.mgmt.cfg.cli.props.VolumePropsS1;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.DSPMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageMirrorServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageSnapShotServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirroredVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.SnapShotVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wbem.cim.UnsignedInt16;
import org.apache.soap.rpc.SOAPContext;

public class VolumesEWS
extends CommandProcessorBase {
    private static final int VOLUME = 0;
    private static final int MIRROR = 1;
    private static final int EXPAND_ERROR = 0;
    private static final int EXPAND_EQUAL = 1;
    private static final int EXPAND_GREATER = 2;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS;

    protected CommandResult doCreate(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result;
        String METHOD_NAME = "doCreate";
        Trace.methodBegin((Object)this, (String)"doCreate");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        if ("external".equals(pcl.getOptionListName())) {
            Trace.verbose((Object)this, (String)"doCreate", (String)"Process with option list external");
            result = this.processCreateFromExternal(locale, pcl, argContext);
        } else if ("with_cow".equals(pcl.getOptionListName())) {
            Trace.verbose((Object)this, (String)"doCreate", (String)"Process with option list with_cow");
            result = this.processCreateVolumeWithCow(locale, pcl, argContext);
        } else {
            Trace.verbose((Object)this, (String)"doCreate", (String)"Process simple volume create");
            result = this.processCreateVolume(locale, pcl, argContext);
        }
        Trace.methodEnd((Object)this, (String)"doCreate");
        return result;
    }

    protected CommandResult doDelete(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doDelete";
        Trace.methodBegin((Object)this, (String)"doDelete");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = new CommandResult();
        String sDomainName = "DEFAULT";
        List volumeNames = pcl.getResource().getValues();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        List errors = this.actionDeleteVolume(argContext, sDomainName, volumeNames);
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"doDelete");
        return result;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        CommandResult result = new CommandResult();
        List volumeNames = pcl.getResource().getValues();
        List options = pcl.getOptions();
        String sPoolName = null;
        String sDomainName = null;
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-p".equals(name) || "--pool".equals(name)) {
                sPoolName = option.getFirstValue();
                continue;
            }
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"doList", (String)("-:-rq'd volumes" + volumeNames));
        }
        Vector volumes = this.actionListVolume(argContext, volumeNames, sPoolName, sDomainName);
        this.processResults(locale, result, volumes);
        Trace.methodEnd((Object)this, (String)"doList");
        return result;
    }

    protected CommandResult doMap(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws BadParameterException, Exception {
        String METHOD_NAME = "doMap";
        Trace.methodBegin((Object)this, (String)"doMap");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = new CommandResult();
        String sDomainName = "DEFAULT";
        String sPermission = null;
        List initiatorList = null;
        String lun = null;
        String volumeName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-P".equals(name) || "--permission".equals(name)) {
                sPermission = option.getFirstValue();
                continue;
            }
            if ("-i".equals(name) || "--initiator".equals(name)) {
                initiatorList = option.getValues();
                continue;
            }
            if (!"-l".equals(name) && !"--lun-id".equals(name)) continue;
            lun = option.getFirstValue();
        }
        List errors = this.actionMapVolume(argContext, sDomainName, sPermission, initiatorList, lun, volumeName);
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"doMap");
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result;
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String listName = pcl.getOptionListName();
        if ("expand_cow".equals(listName)) {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process with option list expand_cow");
            result = this.processExpandCow(locale, pcl, argContext);
        } else if ("config_cow_volume".equals(listName)) {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process with option list config_cow_volume");
            result = this.processConfigCow(locale, pcl, argContext, 0);
        } else if ("config_cow_mirror".equals(listName)) {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process with option list config_cow_mirror");
            result = this.processConfigCow(locale, pcl, argContext, 1);
        } else {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process as simple volume modify");
            result = this.processModifyVolume(locale, pcl, argContext);
        }
        Trace.methodEnd((Object)this, (String)"doModify");
        return result;
    }

    protected CommandResult doSnapshot(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doSnapshot";
        Trace.methodBegin((Object)this, (String)"doSnapshot");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = null;
        String listName = pcl.getOptionListName();
        if ("rollback".equals(listName)) {
            Trace.verbose((Object)this, (String)"doSnapshot", (String)"Process with option list rollback");
            result = this.processRollback(locale, pcl, argContext);
        } else if ("cancel_rollback".equals(listName)) {
            Trace.verbose((Object)this, (String)"doSnapshot", (String)"Process with option list cancel_rollback");
            result = this.processCancelRollback(locale, pcl, argContext);
        } else if ("just_snap".equals(listName)) {
            Trace.verbose((Object)this, (String)"doSnapshot", (String)"Process with option list just_snap");
            result = this.processSnapshot(locale, pcl, argContext);
        } else if ("snap_config_cow_volume".equals(listName)) {
            Trace.verbose((Object)this, (String)"doSnapshot", (String)"Process with option list snap_config_cow_volume");
            result = this.processSnapshotConfigCow(locale, pcl, argContext, 0);
        } else if ("snap_config_cow_mirror".equals(listName)) {
            Trace.verbose((Object)this, (String)"doSnapshot", (String)"Process with option list snap_config_cow_mirror");
            result = this.processSnapshotConfigCow(locale, pcl, argContext, 1);
        } else if ("snap_expand_cow".equals(listName)) {
            Trace.verbose((Object)this, (String)"doSnapshot", (String)"Process with option list snap_expand_cow");
            result = this.processSnapshotExpandCow(locale, pcl, argContext);
        } else if ("resnap".equals(listName)) {
            Trace.verbose((Object)this, (String)"doSnapshot", (String)"Process with option list resnap");
            result = this.processResnap(locale, pcl, argContext);
        } else if ("delete_snapshot_reserve".equals(listName)) {
            Trace.verbose((Object)this, (String)"doSnapshot", (String)"Process with option list delete_snapshot_reserve");
            result = this.processRemoveSnapshotReserve(locale, pcl, argContext);
        }
        Trace.methodEnd((Object)this, (String)"doSnapshot");
        return result;
    }

    protected CommandResult doUnmap(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doUnmap";
        Trace.methodBegin((Object)this, (String)"doUnmap");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = new CommandResult();
        String sDomainName = "DEFAULT";
        List initiatorList = null;
        String volumeName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if (!"-i".equals(name) && !"--initiator".equals(name)) continue;
            initiatorList = option.getValues();
        }
        List errors = this.actionUnmapVolume(argContext, sDomainName, initiatorList, volumeName);
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"doUnmap");
        return result;
    }

    private CommandResult processCancelRollback(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processCancelRollback";
        Trace.methodBegin((Object)this, (String)"processCancelRollback");
        String sDomainName = "DEFAULT";
        String snapName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        List errors = this.actionCancelRollback(argContext, snapName, sDomainName);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processCancelRollback");
        return result;
    }

    private CommandResult processCreateFromExternal(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processCreateFromExternal";
        Trace.methodBegin((Object)this, (String)"processCreateFromExternal");
        String volumeName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        String poolName = null;
        String volumeDesc = null;
        String extStorageName = null;
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-e".equals(name) || "--externalstorage".equals(name)) {
                extStorageName = option.getFirstValue();
            }
            if ("-p".equals(name) || "--pool".equals(name)) {
                poolName = option.getFirstValue();
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if (!"-d".equals(name) && !"--description".equals(name)) continue;
            volumeDesc = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == volumeName || null == poolName || null == extStorageName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionCreateFromExternalStorage(errors, argContext, extStorageName, poolName, sDomainName, volumeDesc, volumeName);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processCreateFromExternal");
        return result;
    }

    private CommandResult processCreateVolume(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processCreateVolume";
        Trace.methodBegin((Object)this, (String)"processCreateVolume");
        String volumeName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        String poolName = null;
        String size = null;
        boolean stripeAll = false;
        String volumeDesc = null;
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-p".equals(name) || "--pool".equals(name)) {
                poolName = option.getFirstValue();
                continue;
            }
            if ("-s".equals(name) || "--size".equals(name)) {
                size = option.getFirstValue();
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-t".equals(name) || "--stripe-all".equals(name)) {
                stripeAll = true;
                continue;
            }
            if (!"-d".equals(name) && !"--description".equals(name)) continue;
            volumeDesc = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == volumeName || null == poolName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionCreateVolume(errors, argContext, poolName, size, sDomainName, stripeAll, volumeDesc, volumeName);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processCreateVolume");
        return result;
    }

    private CommandResult processCreateVolumeWithCow(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processCreateVolumeWithCow";
        Trace.methodBegin((Object)this, (String)"processCreateVolumeWithCow");
        String volumeName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        int snapPolicy = CliUtilEWS.cvtSnapshotPolicy("DEFAULT");
        String poolName = null;
        String size = null;
        boolean stripeAll = false;
        Integer snapCount = null;
        Integer snapLevel = null;
        String volumeDesc = null;
        String snapPoolName = null;
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-p".equals(name) || "--pool".equals(name)) {
                poolName = option.getFirstValue();
                continue;
            }
            if ("-s".equals(name) || "--size".equals(name)) {
                size = option.getFirstValue();
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-t".equals(name) || "--stripe-all".equals(name)) {
                stripeAll = true;
                continue;
            }
            if ("-C".equals(name) || "--snapshot-count".equals(name)) {
                snapCount = new Integer(Integer.parseInt(Convert.cleanUpAndUpcase((String)option.getFirstValue())));
                continue;
            }
            if ("-L".equals(name) || "--snapshot-level".equals(name)) {
                snapLevel = new Integer(CliUtilEWS.cvtSnapLevel(option.getFirstValue()));
                continue;
            }
            if ("-d".equals(name) || "--description".equals(name)) {
                volumeDesc = option.getFirstValue();
                continue;
            }
            if ("-P".equals(name) || "--snapshot-pool".equals(name)) {
                snapPoolName = option.getFirstValue();
                continue;
            }
            if (!"-f".equals(name) && !"--favor".equals(name)) continue;
            snapPolicy = CliUtilEWS.cvtSnapshotPolicy(option.getFirstValue());
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == volumeName || null == snapCount || null == snapLevel || null == poolName || null == size) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionCreateVolumeWithCow(errors, argContext, poolName, size, sDomainName, stripeAll, snapCount, snapLevel, volumeDesc, volumeName, snapPoolName, snapPolicy);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processCreateVolumeWithCow");
        return result;
    }

    private CommandResult processExpandCow(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processExpandCow";
        Trace.methodBegin((Object)this, (String)"processExpandCow");
        String volumeName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        Integer snapCount = null;
        Integer snapLevel = null;
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-C".equals(name) || "--snapshot-count".equals(name)) {
                snapCount = new Integer(Integer.parseInt(Convert.cleanUpAndUpcase((String)option.getFirstValue())));
                continue;
            }
            if ("-L".equals(name) || "--snapshot-level".equals(name)) {
                snapLevel = new Integer(CliUtilEWS.cvtSnapLevel(Convert.cleanUpAndUpcase((String)option.getFirstValue())));
                continue;
            }
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == volumeName || null == snapCount || null == snapLevel) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionExpandCow(errors, argContext, volumeName, sDomainName, snapCount, snapLevel);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processExpandCow");
        return result;
    }

    private CommandResult processConfigCow(Locale locale, ParsedCommandLine pcl, SOAPContext argContext, int volType) throws Exception {
        String METHOD_NAME = "processConfigCow";
        Trace.methodBegin((Object)this, (String)"processConfigCow");
        String sDomainName = "DEFAULT";
        String volumeName = pcl.getResource().getFirstValue();
        Integer snapCount = null;
        Integer snapLevel = null;
        int snapPolicy = CliUtilEWS.cvtSnapshotPolicy("DEFAULT");
        String snapPoolName = null;
        String snapComponentName = null;
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-C".equals(name) || "--snapshot-count".equals(name)) {
                snapCount = new Integer(Integer.parseInt(Convert.cleanUpAndUpcase((String)option.getFirstValue())));
                continue;
            }
            if ("-L".equals(name) || "--snapshot-level".equals(name)) {
                snapLevel = new Integer(CliUtilEWS.cvtSnapLevel(Convert.cleanUpAndUpcase((String)option.getFirstValue())));
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-P".equals(name) || "--snapshot-pool".equals(name)) {
                snapPoolName = option.getFirstValue();
                continue;
            }
            if ("-f".equals(name) || "--favor".equals(name)) {
                snapPolicy = CliUtilEWS.cvtSnapshotPolicy(option.getFirstValue());
                continue;
            }
            if (!"-T".equals(name) && !"--snapshot-component".equals(name)) continue;
            snapComponentName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == volumeName || null == snapPoolName || null == snapCount || null == snapLevel || 1 == volType && null == snapComponentName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionConfigCow(errors, argContext, volumeName, volType, sDomainName, snapPoolName, null == snapCount ? 0 : snapCount, null == snapLevel ? 0 : snapLevel, snapPolicy, snapComponentName);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processConfigCow");
        return result;
    }

    private CommandResult processModifyVolume(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processModifyVolume";
        Trace.methodBegin((Object)this, (String)"processModifyVolume");
        String sPoolName = null;
        String sDomainName = "DEFAULT";
        String newName = null;
        String newDesc = null;
        String newSize = null;
        Integer newRollBackPriority = null;
        Integer newSnapshotPolicy = null;
        String volumeName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-p".equals(name) || "--pool".equals(name)) {
                sPoolName = option.getFirstValue();
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-N".equals(name) || "--new-name".equals(name)) {
                newName = option.getFirstValue();
                continue;
            }
            if ("-d".equals(name) || "--description".equals(name)) {
                newDesc = option.getFirstValue();
                continue;
            }
            if ("-e".equals(name) || "--extend".equals(name)) {
                newSize = option.getFirstValue();
                continue;
            }
            if ("-k".equals(name) || "--rollback-priority".equals(name)) {
                newRollBackPriority = new Integer(CliUtilEWS.cvtRollbackPriority(option.getFirstValue()));
                continue;
            }
            if (!"-f".equals(name) && !"--favor".equals(name)) continue;
            newSnapshotPolicy = new Integer(CliUtilEWS.cvtSnapshotPolicy(option.getFirstValue()));
        }
        ArrayList errors = new ArrayList();
        this.actionModifyVolume(errors, argContext, sPoolName, sDomainName, newDesc, newName, newSize, newRollBackPriority, newSnapshotPolicy, volumeName);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processModifyVolume");
        return result;
    }

    private CommandResult processRollback(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processRollback";
        Trace.methodBegin((Object)this, (String)"processRollback");
        String sDomainName = "DEFAULT";
        String snapName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == snapName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionRollbackSnapshot(errors, argContext, snapName, sDomainName);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processRollback");
        return result;
    }

    private CommandResult processSnapshot(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processSnapshot";
        Trace.methodBegin((Object)this, (String)"processSnapshot");
        String sVolName = null;
        String sDesc = "";
        String sDomainName = "DEFAULT";
        String sSnapName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-v".equals(name) || "--volume".equals(name)) {
                sVolName = option.getFirstValue();
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if (!"-d".equals(name) && !"--description".equals(name)) continue;
            sDesc = option.getFirstValue();
        }
        List errors = this.actionSnapshot(argContext, sVolName, sDomainName, sSnapName, sDesc);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processSnapshot");
        return result;
    }

    private CommandResult processSnapshotConfigCow(Locale locale, ParsedCommandLine pcl, SOAPContext argContext, int volType) throws Exception {
        String METHOD_NAME = "processSnapshotConfigCow";
        Trace.methodBegin((Object)this, (String)"processSnapshotConfigCow");
        String sDomainName = "DEFAULT";
        String snapName = pcl.getResource().getFirstValue();
        Integer snapCount = null;
        Integer snapLevel = null;
        String snapPoolName = null;
        String snapComponentName = null;
        String volumeName = null;
        String snapDesc = "";
        int snapPolicy = CliUtilEWS.cvtSnapshotPolicy("DEFAULT");
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-v".equals(name) || "--volume".equals(name)) {
                volumeName = option.getFirstValue();
                continue;
            }
            if ("-C".equals(name) || "--snapshot-count".equals(name)) {
                snapCount = new Integer(Integer.parseInt(option.getFirstValue()));
                continue;
            }
            if ("-L".equals(name) || "--snapshot-level".equals(name)) {
                snapLevel = new Integer(CliUtilEWS.cvtSnapLevel(option.getFirstValue()));
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-P".equals(name) || "--snapshot-pool".equals(name)) {
                snapPoolName = option.getFirstValue();
                continue;
            }
            if ("-f".equals(name) || "--favor".equals(name)) {
                snapPolicy = CliUtilEWS.cvtSnapshotPolicy(option.getFirstValue());
                continue;
            }
            if ("-d".equals(name) || "--description".equals(name)) {
                snapDesc = option.getFirstValue();
                continue;
            }
            if (!"-T".equals(name) && !"--snapshot-component".equals(name)) continue;
            snapComponentName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == snapName || null == volumeName || null == snapPoolName || null == snapCount || null == snapLevel || 1 == volType && null == snapComponentName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionSnapshotConfigCow(errors, argContext, volumeName, volType, sDomainName, null == snapCount ? 0 : snapCount, null == snapLevel ? 0 : snapLevel, snapPolicy, snapPoolName, snapName, snapDesc, snapComponentName);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processSnapshotConfigCow");
        return result;
    }

    private CommandResult processSnapshotExpandCow(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processSnapshotExpandCow";
        Trace.methodBegin((Object)this, (String)"processSnapshotExpandCow");
        String snapName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        String volumeName = null;
        Integer snapCount = null;
        Integer snapLevel = null;
        String snapDesc = "";
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-v".equals(name) || "--volume".equals(name)) {
                volumeName = option.getFirstValue();
                continue;
            }
            if ("-C".equals(name) || "--snapshot-count".equals(name)) {
                snapCount = new Integer(Integer.parseInt(Convert.cleanUpAndUpcase((String)option.getFirstValue())));
                continue;
            }
            if ("-L".equals(name) || "--snapshot-level".equals(name)) {
                snapLevel = new Integer(CliUtilEWS.cvtSnapLevel(Convert.cleanUpAndUpcase((String)option.getFirstValue())));
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if (!"-d".equals(name) && !"--description".equals(name)) continue;
            snapDesc = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == volumeName || null == snapCount || null == snapLevel || null == snapName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionSnapshotExpandCow(errors, argContext, volumeName, sDomainName, snapCount, snapLevel, snapName, snapDesc);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processSnapshotExpandCow");
        return result;
    }

    private CommandResult processResnap(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processResnap";
        Trace.methodBegin((Object)this, (String)"processResnap");
        String sDomainName = "DEFAULT";
        String sSnapVolName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        List errors = this.actionResnap(argContext, sSnapVolName, sDomainName);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processResnap");
        return result;
    }

    private CommandResult processRemoveSnapshotReserve(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "processDeleteSnapshotReserve";
        Trace.methodBegin((Object)this, (String)"processDeleteSnapshotReserve");
        String sDomainName = "DEFAULT";
        String sSnapVolName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        List errors = this.actionRemoveSnapshotReserve(argContext, sSnapVolName, sDomainName);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processDeleteSnapshotReserve");
        return result;
    }

    private void actionCreateFromExternalStorage(List errors, SOAPContext argContext, String extStorageName, String poolName, String sDomainName, String volumeDesc, String volumeName) throws BadParameterException, ItemNotFoundException, ConfigMgmtException, DSPMgmtException, Exception {
        block5: {
            ConfigContext context;
            ManageVDisksInterface mvdi;
            VDiskInterface vdisk;
            block6: {
                String METHOD_NAME = "actionCreateFromExternalStorage";
                Trace.methodBegin((Object)this, (String)"actionCreateFromExternalStorage");
                if (CliUtilEWS.validateName(errors, volumeName)) break block5;
                Trace.verbose((Object)this, (String)"actionCreateFromExternalStorage", (String)"Volume name is valid");
                if (null == volumeDesc) break block6;
                if (CliUtilEWS.validateDesc(errors, volumeDesc)) break block5;
                Trace.verbose((Object)this, (String)"actionCreateFromExternalStorage", (String)"Volume description is valid");
            }
            if (null == (vdisk = (mvdi = CliUtilEWS.getManageVDiskServices(context = this.getConfigContext(argContext))).getItemByName(extStorageName))) {
                errors.add(new ErrorBean(extStorageName, "error.objectNotFound", "15"));
                Trace.error((Object)this, (String)"actionCreateFromExternalStorage", (String)(extStorageName + " :External storage not found"));
            } else {
                Trace.verbose((Object)this, (String)"actionCreateFromExternalStorage", (String)(extStorageName + " :External storage found"));
                ManageStorageVolumesInterface mmvi = CliUtilEWS.getManageVolumeServices(context);
                MethodCallStatus mcs = mmvi.createVLV(volumeName, vdisk, poolName, sDomainName);
                Trace.verbose((Object)this, (String)"actionCreateFromExternalStorage", (String)"Done: createVLV");
                CliUtilEWS.checkMCS(mcs, errors);
            }
        }
        Trace.methodEnd((Object)this, (String)"actionCreateFromExternalStorage");
    }

    private void actionCreateVolume(List errors, SOAPContext argContext, String poolName, String size, String sDomainName, boolean stripeAll, String volumeDesc, String volumeName) throws BadParameterException, ItemNotFoundException, ConfigMgmtException, DSPMgmtException, Exception {
        block6: {
            BigInteger volumeSize;
            block5: {
                block4: {
                    String METHOD_NAME = "actionCreateVolume";
                    Trace.methodBegin((Object)this, (String)"actionCreateVolume");
                    if (!this.isMaxSize(size)) break block4;
                    volumeSize = BigInteger.ZERO;
                    break block5;
                }
                volumeSize = SizeConvert.stringToBytes((String)size);
                if (CliUtilEWS.validateVolumeSize(errors, volumeSize, size)) break block6;
            }
            if (!(CliUtilEWS.validateName(errors, volumeName) || null != volumeDesc && CliUtilEWS.validateDesc(errors, volumeDesc))) {
                ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(this.getConfigContext(argContext));
                ManageStorageVolumes msv = (ManageStorageVolumes)msvi;
                MethodCallStatus mcs = msv.createStorageVolume(volumeName, volumeDesc, volumeSize, poolName, sDomainName, stripeAll);
                Trace.verbose((Object)this, (String)"actionCreateVolume", (String)"Done: createStorageVolume");
                CliUtilEWS.checkMCS(mcs, errors);
            }
        }
        Trace.methodEnd((Object)this, (String)"actionCreateVolume");
    }

    private void actionCreateVolumeWithCow(List errors, SOAPContext argContext, String poolName, String size, String sDomainName, boolean stripeAll, int snapCount, int snapLevel, String volumeDesc, String volumeName, String snapPoolName, int snapPolicy) throws BadParameterException, ItemNotFoundException, ConfigMgmtException, DSPMgmtException, Exception {
        block7: {
            BigInteger volumeSize;
            block6: {
                block5: {
                    String METHOD_NAME = "actionCreateVolumeWithCow";
                    Trace.methodBegin((Object)this, (String)"actionCreateVolumeWithCow");
                    if (!this.isMaxSize(size)) break block5;
                    volumeSize = BigInteger.ZERO;
                    break block6;
                }
                volumeSize = SizeConvert.stringToBytes((String)size);
                if (CliUtilEWS.validateVolumeSize(errors, volumeSize, size)) break block7;
            }
            if (!(CliUtilEWS.validateName(errors, volumeName) || null != volumeDesc && CliUtilEWS.validateDesc(errors, volumeDesc))) {
                if (null == snapPoolName) {
                    snapPoolName = poolName;
                }
                ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(this.getConfigContext(argContext));
                ManageStorageVolumes msv = (ManageStorageVolumes)msvi;
                MethodCallStatus mcs = msv.createStorageVolume(volumeName, volumeDesc, volumeSize, poolName, sDomainName, stripeAll, snapCount, snapLevel, snapPoolName, snapPolicy);
                Trace.verbose((Object)this, (String)"actionCreateVolumeWithCow", (String)"Done: createStorageVolume");
                CliUtilEWS.checkMCS(mcs, errors);
            }
        }
        Trace.methodEnd((Object)this, (String)"actionCreateVolumeWithCow");
    }

    private List actionDeleteVolume(SOAPContext argContext, String sDomainName, List volumeNames) throws ConfigMgmtException, ItemNotFoundException, DSPMgmtException, Exception {
        String METHOD_NAME = "actionDeleteVolume";
        Trace.methodBegin((Object)this, (String)"actionDeleteVolume");
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(cfgctx);
        Trace.verbose((Object)this, (String)"actionDeleteVolume", (String)"Done: getManageVolumeServices");
        ManageMirrorServicesEnt1Interface mms = CliUtilEWS.getManageMirrorServices(cfgctx);
        Trace.verbose((Object)this, (String)"actionDeleteVolume", (String)"Done: getManageMirrorServices");
        if (volumeNames.size() != 0) {
            Iterator e = volumeNames.iterator();
            String sVolumeName = null;
            StorageVolumeInterface volume = null;
            while (e.hasNext()) {
                sVolumeName = (String)e.next();
                try {
                    volume = msvi.getItemByName(sVolumeName, null, sDomainName);
                }
                catch (ItemNotFoundException ex) {
                    Trace.error((Object)this, (String)"actionDeleteVolume", (String)("ItemNotFoundException: " + ex.toString() + "\n"));
                    errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                    continue;
                }
                if (null == volume) {
                    errors.add(new ErrorBean(sVolumeName, "error.objectNotFound", "15"));
                    continue;
                }
                MethodCallStatus mcs = null;
                if (volume instanceof MirroredVolumeEnt1Interface) {
                    MirroredVolumeEnt1Interface mirrorVol = (MirroredVolumeEnt1Interface)volume;
                    ArrayList snapshots = null;
                    try {
                        snapshots = mirrorVol.getAssociatedSnapShots();
                    }
                    catch (ConfigMgmtException cme) {
                        Trace.error((Object)this, (String)"actionDeleteVolume", (String)("ConfigMgmtException: " + cme.toString() + "\n"));
                    }
                    if (null != snapshots && !snapshots.isEmpty()) {
                        errors.add(new ErrorBean(mirrorVol.getName(), "cli.error.6920.localmirror.delete.mirrorWithSnapshots"));
                        continue;
                    }
                    ArrayList assocs = null;
                    try {
                        assocs = mirrorVol.getInitiatorMappings();
                    }
                    catch (ConfigMgmtException cme) {
                        Trace.error((Object)this, (String)"actionDeleteVolume", (String)("ConfigMgmtException: " + cme.toString() + "\n"));
                    }
                    if (null != assocs && !assocs.isEmpty()) {
                        errors.add(new ErrorBean(mirrorVol.getName(), "cli.error.6920.localmirror.delete.mappedMirror"));
                        continue;
                    }
                    if (CliUtilEWS.mirrorHasSplitComponent(mirrorVol)) {
                        errors.add(new ErrorBean(mirrorVol.getName(), "cli.error.6920.localmirror.delete.mirrorWithSplitComponents"));
                        continue;
                    }
                    ArrayList<Collection> mirrorToDel = new ArrayList<Collection>();
                    mirrorToDel.add(mirrorVol.getKey());
                    try {
                        mcs = mms.delete(mirrorToDel);
                    }
                    catch (ConfigMgmtException cme) {
                        List mirDelErrors = SEExceptionHelper.parseConfigMgmtException((ConfigMgmtException)cme, null);
                        if (null != mirDelErrors) {
                            StringBuffer mirDelErrorStr = new StringBuffer();
                            mirDelErrorStr.append((String)errors.get(0));
                            for (int i = 1; i < errors.size(); ++i) {
                                mirDelErrorStr.append('\n');
                                mirDelErrorStr.append((String)errors.get(i));
                            }
                            errors.add(new ErrorBean(mirrorVol.getName(), mirDelErrorStr.toString()));
                            continue;
                        }
                        errors.add(new ErrorBean(mirrorVol.getName(), cme));
                    }
                    continue;
                }
                if (volume instanceof MirrorComponentEnt1Interface) {
                    MirrorComponentEnt1Interface mirrorComponent = (MirrorComponentEnt1Interface)volume;
                    String msg = "";
                    msg = mirrorComponent.isSplit() ? "cli.error.6920.localmirror.delete.splitComponent" : "cli.error.6920.localmirror.delete.mirrorComponent";
                    errors.add(new ErrorBean(mirrorComponent.getName(), msg));
                    continue;
                }
                if (!(volume instanceof StorageVolumeInterface)) continue;
                try {
                    mcs = msvi.delete(volume.getKey());
                    CliUtilEWS.checkMCS(mcs, errors);
                }
                catch (ConfigMgmtException ex) {
                    Trace.error((Object)this, (String)"actionDeleteVolume", (String)("ConfigMgmtException: " + ex.toString() + "\n"));
                    errors.add(new ErrorBean(sVolumeName, "VOLUME_DELETION_EXCEPTION"));
                }
                catch (ItemNotFoundException ex) {
                    Trace.verbose((Object)this, (String)"actionDeleteVolume", (String)("ItemNotFoundException: " + ex.toString() + "\n"));
                    errors.add(new ErrorBean(sVolumeName, "error.objectNotFound", "15"));
                }
            }
        }
        Trace.methodEnd((Object)this, (String)"actionDeleteVolume");
        return errors;
    }

    private void actionExpandCow(ArrayList errors, SOAPContext argContext, String volumeName, String sDomainName, int snapCount, int snapLevel) throws ConfigMgmtException, Exception {
        block5: {
            String METHOD_NAME = "actionExpandCow";
            Trace.methodBegin((Object)this, (String)"actionExpandCow");
            ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(this.getConfigContext(argContext));
            StorageVolume sv = null;
            try {
                sv = (StorageVolume)msvi.getItemByName(volumeName, null, sDomainName);
            }
            catch (ItemNotFoundException infe) {
                errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                break block5;
            }
            if (null == sv) {
                errors.add(new ErrorBean(volumeName, "error.objectNotFound", "15"));
            } else {
                int cowExpandStatus = this.vaildateCowExpand(errors, sv, snapLevel, snapCount);
                if (0 != cowExpandStatus) {
                    MethodCallStatus mcs = sv.extendSnapshotPool(snapCount, snapLevel);
                    Trace.verbose((Object)this, (String)"actionExpandCow", (String)"Done: extendSnapshotPool");
                    CliUtilEWS.checkMCS(mcs, errors);
                }
            }
        }
        Trace.methodEnd((Object)this, (String)"actionExpandCow");
    }

    /*
     * Unable to fully structure code
     */
    private void actionConfigCow(ArrayList errors, SOAPContext argContext, String sVolName, int volType, String sDomainName, String snapPoolName, int snapCount, int snapLevel, int snapPolicy, String snapComponentName) throws ConfigMgmtException, UnauthorizedException {
        block12: {
            block15: {
                block17: {
                    block16: {
                        block14: {
                            METHOD_NAME = "actionConfigCow";
                            Trace.methodBegin((Object)this, (String)"actionConfigCow");
                            cfgctx = this.getConfigContext(argContext);
                            msvi = CliUtilEWS.getManageVolumeServices(cfgctx);
                            Trace.verbose((Object)this, (String)"actionConfigCow", (String)"Done: getManageVolumeServices");
                            storageVolume = null;
                            mirrorVolume = null;
                            volume = null;
                            try {
                                volume = msvi.getItemByName(sVolName, null, sDomainName);
                            }
                            catch (ItemNotFoundException infe) {
                                errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                                Trace.error((Object)this, (String)"actionConfigCow", (String)(sDomainName + " :Storage domain was not found"));
                                break block12;
                            }
                            if (null != volume) break block14;
                            errors.add(new ErrorBean(sVolName, "error.objectNotFound", "15"));
                            Trace.error((Object)this, (String)"actionConfigCow", (String)(sVolName + " :Volume was not found"));
                            break block12;
                        }
                        Trace.verbose((Object)this, (String)"actionConfigCow", (String)(sVolName + " :Volume was found"));
                        if (!(volume instanceof MirroredVolumeEnt1Interface)) break block15;
                        mirrorVolume = (MirroredVolumeEnt1Interface)volume;
                        Trace.verbose((Object)this, (String)"actionConfigCow", (String)(sVolName + " :Volume is of type MirroredVolumeEnt1Interface"));
                        if (null != snapComponentName) break block16;
                        errors.add(new ErrorBean(sVolName, "cli.error.6920.localmirror.snapshotConfig.missingSnapshotComponentOption"));
                        Trace.verbose((Object)this, (String)"actionConfigCow", (String)"Snapshot host mirror component option is missing");
                        break block12;
                    }
                    Trace.verbose((Object)this, (String)"actionConfigCow", (String)(snapComponentName + " :Mirror component to host snapshot was found"));
                    snapComp = this.getMirrorComponentByName(mirrorVolume, snapComponentName);
                    if (null != snapComp) break block17;
                    errors.add(new ErrorBean(snapComponentName, "cli.error.6920.localmirror.mirrorComponent.notFound"));
                    Trace.error((Object)this, (String)"actionConfigCow", (String)(snapComponentName + " :Mirror component was not found"));
                    break block12;
                }
                Trace.verbose((Object)this, (String)"actionConfigCow", (String)(snapComponentName + " :Mirror component was found"));
                mirrorVolume.setSnapshotComponent((Object)snapComp.getKey());
                Trace.verbose((Object)this, (String)"actionConfigCow", (String)"Done: setSnapshotComponent");
                ** GOTO lbl54
            }
            if (volume instanceof MirrorComponentEnt1Interface) {
                errors.add(new ErrorBean(sVolName, "cli.error.6920.localmirror.snapshotConfig.cannotConfigSnapshotForMirrorComponent"));
                Trace.error((Object)this, (String)"actionConfigCow", (String)"Cannot configure cow space on a mirror component");
            } else {
                block13: {
                    if (volume instanceof StorageVolumeInterface) {
                        storageVolume = (StorageVolumeEnt1Interface)volume;
                        Trace.verbose((Object)this, (String)"actionConfigCow", (String)(sVolName + " :Is of type StorageVolumeInterface"));
                    }
lbl54:
                    // 4 sources

                    mspi = CliUtilEWS.getManagePoolServices(cfgctx);
                    Trace.verbose((Object)this, (String)"actionConfigCow", (String)"Initialize pool manager service");
                    snapshotPool = null;
                    try {
                        snapshotPool = (StoragePool)mspi.getItemByName(snapPoolName, sDomainName);
                    }
                    catch (ItemNotFoundException infe) {
                        if (null != snapshotPool) break block13;
                        errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                        Trace.error((Object)this, (String)"actionConfigCow", (String)(sDomainName + " :Storage domain was not found"));
                        break block12;
                    }
                }
                if (null == snapshotPool) {
                    errors.add(new ErrorBean(snapPoolName, "error.objectNotFound", "15"));
                    Trace.error((Object)this, (String)"actionConfigCow", (String)(snapPoolName + " :Storage pool was not found"));
                } else {
                    Trace.verbose((Object)this, (String)"actionConfigCow", (String)(snapPoolName + " :Storage pool was found"));
                    mcs = null;
                    if (null != storageVolume) {
                        mcs = storageVolume.createSnapshotPool((StoragePoolInterface)snapshotPool, snapCount, snapLevel, snapPolicy);
                    } else if (null != mirrorVolume) {
                        mcs = mirrorVolume.createSnapshotPool((StoragePoolInterface)snapshotPool, snapCount, snapLevel, snapPolicy);
                    }
                    Trace.verbose((Object)this, (String)"actionConfigCow", (String)"Done: createSnapshotPool");
                    CliUtilEWS.checkMCS(mcs, errors);
                }
            }
        }
        Trace.methodEnd((Object)this, (String)"actionConfigCow");
    }

    private Vector actionListVolume(SOAPContext argContext, List volumeNames, String sPoolName, String sDomainName) throws ItemNotFoundException, ConfigMgmtException, Exception {
        String METHOD_NAME = "actionListVolume";
        Trace.methodBegin((Object)this, (String)"actionListVolume");
        ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(this.getConfigContext(argContext));
        Trace.verbose((Object)this, (String)"actionListVolume", (String)"Done: getManageVolumeServices");
        AbstractList allVolumes = new Vector();
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        boolean showDetails = false;
        if (volumeNames == null || volumeNames.isEmpty()) {
            try {
                if (sPoolName == null && sDomainName == null) {
                    allVolumes = msvi.getItemsBySystem();
                } else if (sPoolName != null && sDomainName == null) {
                    sDomainName = "DEFAULT";
                    allVolumes = msvi.getItemsByStoragePool(sPoolName, sDomainName);
                } else if (sPoolName != null && sDomainName != null) {
                    if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"list", (String)("-:-sPoolName: " + sPoolName + ", sDomainName: " + sDomainName));
                    }
                    allVolumes = msvi.getItemsByStoragePool(sPoolName, sDomainName);
                } else if (sPoolName == null && sDomainName != null) {
                    allVolumes = msvi.getItemsByStorageDomain(sDomainName);
                }
            }
            catch (ItemNotFoundException ex) {
                Trace.error((Object)this, (String)"actionListVolume", (String)("ItemNotFoundException: " + ex.toString() + "\n"));
                throw new ItemNotFoundException(sPoolName, sDomainName);
            }
            catch (ConfigMgmtException ex) {
                Trace.error((Object)this, (String)"actionListVolume", (String)("ConfigMgmtException: " + ex.toString() + "\n"));
                throw new ConfigMgmtException("error.objectNotFound", ex.toString() + ex.getExceptionMsg());
            }
            allVolumes.addAll(this.addSnapShotVolumes(argContext, allVolumes));
        } else {
            showDetails = true;
            int c = volumeNames.size();
            for (int i = 0; i < c; ++i) {
                String volName = (String)volumeNames.get(i);
                StorageVolumeInterface svi = null;
                if (sPoolName == null && sDomainName == null) {
                    svi = msvi.getItemByName(volName);
                } else if (sPoolName != null && sDomainName == null) {
                    sDomainName = "DEFAULT";
                    svi = msvi.getItemByName(volName, sPoolName, sDomainName);
                } else if (sPoolName == null && sDomainName != null) {
                    svi = msvi.getItemByName(volName, sPoolName, sDomainName);
                }
                if (svi == null) {
                    errors.add(new ErrorBean(volName, "error.objectNotFound", "15"));
                    continue;
                }
                allVolumes.add(svi);
            }
        }
        Vector result = this.createVolumePropsList(allVolumes, showDetails);
        result.addAll(errors);
        Trace.methodEnd((Object)this, (String)"actionListVolume");
        return result;
    }

    private List actionMapVolume(SOAPContext argContext, String sDomainName, String sPermission, List initiatorList, String lun, String volumeName) throws ItemNotFoundException, ConfigMgmtException, DSPMgmtException, Exception {
        long end;
        long start;
        ConfigContext cfgctx;
        StorageVolumeInterface svi;
        boolean addResult;
        ArrayList<String> errors;
        block24: {
            String METHOD_NAME = "actionMapVolume";
            Trace.methodBegin((Object)this, (String)"actionMapVolume");
            errors = new ArrayList<String>();
            addResult = false;
            svi = null;
            cfgctx = this.getConfigContext(argContext);
            ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(cfgctx);
            Trace.verbose((Object)this, (String)"actionMapVolume", (String)"Done: getManageVolumeServices");
            start = 0L;
            end = 0L;
            try {
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                    start = System.currentTimeMillis();
                }
                svi = msvi.getItemByName(volumeName);
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                    end = System.currentTimeMillis();
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"map", (String)("getItemByName: -v- " + volumeName + " " + (end - start)));
                }
            }
            catch (Exception e) {
                if (!Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) break block24;
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"map", (String)("e " + e.toString()));
            }
        }
        if (svi == null) {
            if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"map", (String)"volume/domain not found");
            }
            throw new ItemNotFoundException(volumeName);
        }
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
            start = System.currentTimeMillis();
        }
        if (!svi.getStorageDomainName().equals(sDomainName)) {
            throw new ItemNotFoundException(volumeName, sDomainName);
        }
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
            end = System.currentTimeMillis();
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"map", (String)("getStorageDomainName: " + sDomainName + " " + (end - start)));
        }
        HashSet<UnsignedInt16> permissionSet = new HashSet<UnsignedInt16>();
        permissionSet.add(new UnsignedInt16("5"));
        if (sPermission.equals("readwrite")) {
            permissionSet.add(new UnsignedInt16("6"));
        }
        ManageInitiatorsInterface mii = CliUtilEWS.getManageInitiatorsServices(cfgctx);
        Trace.verbose((Object)this, (String)"actionMapVolume", (String)"Done: getManageInitiatorsServices");
        int lunToSend = -1;
        if (lun != null) {
            lunToSend = Integer.parseInt(lun);
        }
        String initiatorName = null;
        Iterator e = initiatorList.iterator();
        InitiatorInterface ii = null;
        long start2 = 0L;
        long end2 = 0L;
        while (e.hasNext()) {
            block25: {
                initiatorName = (String)e.next();
                try {
                    if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                        start2 = System.currentTimeMillis();
                    }
                    ii = mii.getItemByName(initiatorName);
                    if (!Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) break block25;
                    end2 = System.currentTimeMillis();
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"map", (String)("getItemByName -i-: " + initiatorName + " " + (end2 - start2)));
                }
                catch (ConfigMgmtException ex) {
                    Trace.error((Object)this, (String)"actionMapVolume", (String)ex.toString());
                    addResult = errors.add(ex.getExceptionMsg());
                    continue;
                }
            }
            if (ii == null) {
                addResult = errors.add((String)new ErrorBean(initiatorName, "error.objectNotFound", "15"));
                continue;
            }
            MethodCallStatus mcs = null;
            long start3 = 0L;
            long end3 = 0L;
            try {
                if (lun == null) {
                    if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                        start3 = System.currentTimeMillis();
                    }
                    mcs = svi.createMapping(ii.getNextAvailableLUN(), permissionSet, ii);
                    if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                        end3 = System.currentTimeMillis();
                        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"map", (String)("createMapping: " + (end3 - start3)));
                    }
                } else {
                    long start4 = 0L;
                    long end4 = 0L;
                    if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                        start4 = System.currentTimeMillis();
                    }
                    mcs = svi.createMapping(lunToSend, permissionSet, ii);
                    if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                        end4 = System.currentTimeMillis();
                        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"map", (String)("createMapping: " + (end4 - start4)));
                    }
                }
                CliUtilEWS.checkMCS(mcs, errors);
            }
            catch (ConfigMgmtException ex) {
                Trace.error((Object)this, (String)"actionMapVolume", (String)(ex.toString() + "\n"));
                addResult = errors.add((String)new ErrorBean(ii.getName() + "/" + svi.getName() + " ", "cli.error.6920.volume.mapping"));
            }
        }
        Trace.methodEnd((Object)this, (String)"actionMapVolume");
        return errors;
    }

    /*
     * Unable to fully structure code
     */
    private void actionModifyVolume(List errors, SOAPContext argContext, String sPoolName, String sDomainName, String newDesc, String newName, String newSize, Integer newRollbackPriority, Integer newSnapshotPolicy, String volumeName) throws UnauthorizedException, DSPMgmtException, ConfigMgmtException {
        block10: {
            block14: {
                block15: {
                    block12: {
                        block13: {
                            block11: {
                                METHOD_NAME = "actionModifyVolume";
                                Trace.methodBegin((Object)this, (String)"actionModifyVolume");
                                sv = null;
                                msvi = CliUtilEWS.getManageVolumeServices(this.getConfigContext(argContext));
                                try {
                                    sv = (StorageVolumeEnt1Interface)msvi.getItemByName(volumeName, null, sDomainName);
                                }
                                catch (ItemNotFoundException infe) {
                                    errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                                    Trace.error((Object)this, (String)"actionModifyVolume", (String)(sDomainName + " :Storage domain not found"));
                                    break block10;
                                }
                                if (sv != null) break block11;
                                errors.add(new ErrorBean(volumeName, "error.objectNotFound", "15"));
                                Trace.error((Object)this, (String)"actionModifyVolume", (String)(volumeName + " :Volume not found"));
                                break block10;
                            }
                            Trace.verbose((Object)this, (String)"actionModifyVolume", (String)(volumeName + " :Volume found"));
                            if (null != newRollbackPriority) {
                                sv.setRollbackPriority(newRollbackPriority.intValue());
                                Trace.verbose((Object)this, (String)"actionModifyVolume", (String)(newRollbackPriority.toString() + " :Rollback priority value has been set"));
                            }
                            if (null != newSnapshotPolicy) {
                                sv.setSnapshotPolicy(newSnapshotPolicy.intValue());
                                Trace.verbose((Object)this, (String)"actionModifyVolume", (String)(newSnapshotPolicy.toString() + " :Snapshot policy value has been set"));
                            }
                            if (newName == null) break block12;
                            if (!CliUtilEWS.validateName(errors, newName)) break block13;
                            Trace.error((Object)this, (String)"actionModifyVolume", (String)(newName + " :New name not valid"));
                            break block10;
                        }
                        sv.setName(newName);
                        Trace.verbose((Object)this, (String)"actionModifyVolume", (String)(newName + " :New volume name has been set"));
                    }
                    if (newDesc == null) break block14;
                    if (!CliUtilEWS.validateDesc(errors, newDesc)) break block15;
                    Trace.error((Object)this, (String)"actionModifyVolume", (String)(newDesc + " :New description is not valid"));
                    break block10;
                }
                sv.setDescription(newDesc);
                Trace.verbose((Object)this, (String)"actionModifyVolume", (String)(newDesc + " :New volume description has been set"));
            }
            if (newSize == null) ** GOTO lbl62
            size = SizeConvert.stringToBytes((String)newSize);
            if (CliUtilEWS.validateVolumeSize(errors, size, newSize)) break block10;
            if (!(sv instanceof MirroredVolumeEnt1Interface)) ** GOTO lbl-1000
            snapshots = sv.getAssociatedSnapShots();
            if (null != snapshots && !snapshots.isEmpty()) {
                errors.add(new ErrorBean(sv.getName(), "cli.error.6920.localmirror.extend.mirrorWithSnapshots"));
            } else if (CliUtilEWS.mirrorHasSplitComponent((MirroredVolumeEnt1Interface)sv)) {
                errors.add(new ErrorBean(sv.getName(), "cli.error.6920.localmirror.extend.mirrorWithSplitComponents"));
            } else if (CliUtilEWS.mirrorHasVLVComponent((MirroredVolumeEnt1Interface)sv)) {
                errors.add(new ErrorBean(sv.getName(), "cli.error.6920.localmirror.extend.mirrorWithVLVComponents"));
            } else lbl-1000:
            // 2 sources

            {
                mcs = sv.extend(size);
                Trace.verbose((Object)this, (String)"actionModifyVolume", (String)"Done: extend");
                CliUtilEWS.checkMCS(mcs, errors);
lbl62:
                // 2 sources

                sv.save();
                Trace.verbose((Object)this, (String)"actionModifyVolume", (String)"-:- modify save reached");
            }
        }
        Trace.methodEnd((Object)this, (String)"actionModifyVolume");
    }

    private void actionRollbackSnapshot(List errors, SOAPContext argContext, String snapName, String sDomainName) throws ConfigMgmtException, DSPMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionRollbackSnapshot";
        Trace.methodBegin((Object)this, (String)"actionRollbackSnapshot");
        ManageSnapShotServicesEnt1Interface snapMan = CliUtilEWS.getManageSnapshotServices(this.getConfigContext(argContext));
        Trace.verbose((Object)this, (String)"actionRollbackSnapshot", (String)"Done: getManageSnapshotServices");
        SnapShotVolumeEnt1Interface snapshot = snapMan.getItemByName(snapName);
        if (snapshot == null) {
            errors.add(new ErrorBean(snapName, "error.objectNotFound", "15"));
            Trace.error((Object)this, (String)"actionRollbackSnapshot", (String)(snapName + " :Snapshot volume was not found"));
        } else {
            Trace.verbose((Object)this, (String)"actionRollbackSnapshot", (String)(snapName + " :Snapshot volume was found"));
            StorageVolumeEnt1Interface parent = snapshot.getParentVolume();
            if (null == parent) {
                errors.add(new ErrorBean("Parent Volume", "error.objectNotFound"));
                Trace.error((Object)this, (String)"actionRollbackSnapshot", (String)"The parent volume of the snapshot was not found");
            } else {
                Trace.verbose((Object)this, (String)"actionRollbackSnapshot", (String)"The paranet volume of the snapshto was was found");
                if (1 == parent.getRedundancyType()) {
                    errors.add(new ErrorBean(snapName, "cli.error.6920.localmirror.snapshotRollback"));
                    Trace.error((Object)this, (String)"actionRollbackSnapshot", (String)"Cannot rollback to a local mirror");
                } else {
                    MethodCallStatus mcs = snapMan.rollbackSnapshot((StorageVolume)snapshot);
                    Trace.verbose((Object)this, (String)"actionRollbackSnapshot", (String)"Done: rollbackSnapshot");
                    CliUtilEWS.checkMCS(mcs, errors);
                }
            }
        }
        Trace.methodEnd((Object)this, (String)"actionRollbackSnapshot");
    }

    private List actionCancelRollback(SOAPContext argContext, String sVolName, String sDomainName) throws BadParameterException, ConfigMgmtException, ItemNotFoundException, DSPMgmtException, Exception {
        ArrayList<ErrorBean> errors;
        block4: {
            String METHOD_NAME = "actionCancelRollback";
            Trace.methodBegin((Object)this, (String)"actionCancelRollback");
            errors = new ArrayList<ErrorBean>();
            ConfigContext cfgctx = this.getConfigContext(argContext);
            ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(cfgctx);
            Trace.verbose((Object)this, (String)"actionCancelRollback", (String)"Done: getManageVolumeServices");
            StorageVolume snapVol = null;
            try {
                snapVol = (StorageVolume)msvi.getItemByName(sVolName, null, sDomainName);
            }
            catch (ItemNotFoundException infe) {
                errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                Trace.verbose((Object)this, (String)"actionCancelRollback", (String)(sDomainName + " :Storage domain was not found"));
                break block4;
            }
            if (snapVol == null) {
                errors.add(new ErrorBean(sVolName, "error.objectNotFound", "15"));
                Trace.verbose((Object)this, (String)"actionCancelRollback", (String)(sVolName + " :Volume was not found"));
            } else {
                Trace.verbose((Object)this, (String)"actionCancelRollback", (String)(sVolName + " :Volume was found"));
                ManageSnapShotServicesEnt1Interface snapMan = CliUtilEWS.getManageSnapshotServices(cfgctx);
                Trace.verbose((Object)this, (String)"actionCancelRollback", (String)"Done: getManageSnapshotServices");
                snapMan.abortRollback((Object)snapVol.getKey());
            }
        }
        Trace.methodEnd((Object)this, (String)"actionCancelRollback");
        return errors;
    }

    private List actionSnapshot(SOAPContext argContext, String sVolName, String sDomainName, String sSnapName, String sDesc) throws BadParameterException, ConfigMgmtException, ItemNotFoundException, DSPMgmtException, Exception {
        ArrayList<ErrorBean> errors;
        block9: {
            String METHOD_NAME = "actionSnapshot";
            Trace.methodBegin((Object)this, (String)"actionSnapshot");
            errors = new ArrayList<ErrorBean>();
            if (!(CliUtilEWS.validateName(errors, sSnapName) || null != sDesc && CliUtilEWS.validateDesc(errors, sDesc))) {
                ConfigContext cfgctx = this.getConfigContext(argContext);
                ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(cfgctx);
                Trace.verbose((Object)this, (String)"actionSnapshot", (String)"Done: getManageVolumeServices");
                StorageVolume baseVolume = null;
                try {
                    baseVolume = (StorageVolume)msvi.getItemByName(sVolName, null, sDomainName);
                }
                catch (ItemNotFoundException infe) {
                    errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                    Trace.error((Object)this, (String)"actionSnapshot", (String)(sDomainName + " :Storage domain was not found"));
                    break block9;
                }
                if (baseVolume == null) {
                    errors.add(new ErrorBean(sVolName, "error.objectNotFound", "15"));
                    Trace.error((Object)this, (String)"actionSnapshot", (String)(sVolName + " :Volume was not found"));
                } else {
                    Trace.verbose((Object)this, (String)"actionSnapshot", (String)(sVolName + " :Volume was found"));
                    if (baseVolume.isMirrorComponent()) {
                        errors.add(new ErrorBean(sVolName, "cli.error.6920.snapshot.CannotSnapshotMirrorComponent"));
                        Trace.error((Object)this, (String)"actionSnapshot", (String)"Cannot take a snapshot of a mirror component");
                    } else if (baseVolume.getSnapshotPoolSize() == 0) {
                        errors.add(new ErrorBean(sVolName, "cli.error.6920.snapshot.NoSnapshotPool"));
                        Trace.error((Object)this, (String)"actionSnapshot", (String)(sVolName + " :Volume has no snapshot reserve"));
                    } else {
                        ManageSnapShotServicesEnt1Interface msss = CliUtilEWS.getManageSnapshotServices(cfgctx);
                        Trace.verbose((Object)this, (String)"actionSnapshot", (String)"Done: getManageSnapshotServices");
                        MethodCallStatus mcs = msss.createSnapshot(baseVolume, sSnapName, sDesc);
                        Trace.verbose((Object)this, (String)"actionSnapshot", (String)"Done: createSnapshot");
                        CliUtilEWS.checkMCS(mcs, errors);
                    }
                }
            }
        }
        Trace.methodEnd((Object)this, (String)"actionSnapshot");
        return errors;
    }

    /*
     * Unable to fully structure code
     */
    private void actionSnapshotConfigCow(ArrayList errors, SOAPContext argContext, String volumeName, int volType, String sDomainName, int snapCount, int snapLevel, int snapPolicy, String snapPoolName, String snapName, String snapDesc, String snapComponentName) throws BadParameterException, ConfigMgmtException, UnauthorizedException, DSPMgmtException {
        block10: {
            block13: {
                block15: {
                    block14: {
                        block12: {
                            block11: {
                                METHOD_NAME = "actionSnapshotConfigCow";
                                Trace.methodBegin((Object)this, (String)"actionSnapshotConfigCow");
                                if (CliUtilEWS.validateName(errors, snapName) || null != snapDesc && CliUtilEWS.validateDesc(errors, snapDesc)) break block10;
                                cfgctx = this.getConfigContext(argContext);
                                mspi = CliUtilEWS.getManagePoolServices(cfgctx);
                                Trace.verbose((Object)this, (String)"actionSnapshotConfigCow", (String)"Done: getManagePoolServices");
                                snapshotPool = null;
                                try {
                                    snapshotPool = (StoragePool)mspi.getItemByName(snapPoolName, sDomainName);
                                }
                                catch (ItemNotFoundException infe) {
                                    errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                                    Trace.error((Object)this, (String)"actionSnapshotConfigCow", (String)(sDomainName + " :Storage domain was not found"));
                                    break block10;
                                }
                                if (snapshotPool != null || null != snapshotPool) break block11;
                                errors.add(new ErrorBean(snapPoolName, "error.objectNotFound", "15"));
                                Trace.error((Object)this, (String)"actionSnapshotConfigCow", (String)(snapPoolName + " :Storage pool was not found"));
                                break block10;
                            }
                            Trace.verbose((Object)this, (String)"actionSnapshotConfigCow", (String)(snapPoolName + " :Storage pool was found"));
                            storageVolume = null;
                            mirrorVolume = null;
                            msvi = CliUtilEWS.getManageVolumeServices(cfgctx);
                            Trace.verbose((Object)this, (String)"actionSnapshotConfigCow", (String)"Done: getManageVolumeServices");
                            try {
                                volume = msvi.getItemByName(volumeName, null, sDomainName);
                            }
                            catch (ItemNotFoundException infe) {
                                errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                                Trace.error((Object)this, (String)"actionSnapshotConfigCow", (String)(sDomainName + " :Storage domain was not found"));
                                break block10;
                            }
                            if (null != volume) break block12;
                            errors.add(new ErrorBean(volumeName, "error.objectNotFound", "15"));
                            Trace.error((Object)this, (String)"actionSnapshotConfigCow", (String)(volumeName + " :Volume was not found"));
                            break block10;
                        }
                        Trace.verbose((Object)this, (String)"actionSnapshotConfigCow", (String)(volumeName + " :Volume was found"));
                        if (!(volume instanceof MirroredVolumeEnt1Interface)) break block13;
                        mirrorVolume = (MirroredVolumeEnt1Interface)volume;
                        Trace.verbose((Object)this, (String)"actionSnapshotConfigCow", (String)(volumeName + " :Is instance of MirroredVolumeEnt1Interface"));
                        if (null != snapComponentName) break block14;
                        errors.add(new ErrorBean(volumeName, "cli.error.6920.localmirror.snapshotConfig.missingSnapshotComponentOption"));
                        Trace.error((Object)this, (String)"actionSnapshotConfigCow", (String)"No snapshot host mirror component configured");
                        break block10;
                    }
                    snapComp = this.getMirrorComponentByName(mirrorVolume, snapComponentName);
                    if (null != snapComp) break block15;
                    errors.add(new ErrorBean(snapComponentName, "cli.error.6920.localmirror.mirrorComponent.notFound"));
                    Trace.error((Object)this, (String)"actionSnapshotConfigCow", (String)"The snapshot host mirror component was not found");
                    break block10;
                }
                Trace.verbose((Object)this, (String)"actionSnapshotConfigCow", (String)"The snapshot host mirror component was found");
                mirrorVolume.setSnapshotComponent((Object)snapComp.getKey());
                Trace.verbose((Object)this, (String)"actionSnapshotConfigCow", (String)"Done: setSnapshotComponent");
                ** GOTO lbl71
            }
            if (volume instanceof MirrorComponentEnt1Interface) {
                errors.add(new ErrorBean(volumeName, "cli.error.6920.snapshot.CannotSnapshotMirrorComponent"));
                Trace.error((Object)this, (String)"actionSnapshotConfigCow", (String)"Cannot snapshot a mirror component");
            } else {
                if (volume instanceof StorageVolumeInterface) {
                    storageVolume = (StorageVolumeEnt1Interface)volume;
                    Trace.verbose((Object)this, (String)"actionSnapshotConfigCow", (String)(volumeName + " :Is instance of StorageVolumeInterface"));
                }
lbl71:
                // 4 sources

                msss = CliUtilEWS.getManageSnapshotServices(cfgctx);
                Trace.verbose((Object)this, (String)"actionSnapshotConfigCow", (String)"Done: getManageSnapshotServices");
                mcs = null;
                if (null != storageVolume) {
                    mcs = msss.createSnapshot((StorageVolume)storageVolume, snapshotPool, snapName, snapDesc, snapCount, snapLevel, snapPolicy);
                } else if (null != mirrorVolume) {
                    mcs = msss.createSnapshot((StorageVolume)mirrorVolume, snapshotPool, snapName, snapDesc, snapCount, snapLevel, snapPolicy);
                }
                Trace.verbose((Object)this, (String)"actionSnapshotConfigCow", (String)"Done: createSnapshot");
                CliUtilEWS.checkMCS(mcs, errors);
            }
        }
        Trace.methodEnd((Object)this, (String)"actionSnapshotConfigCow");
    }

    private void actionSnapshotExpandCow(ArrayList errors, SOAPContext argContext, String volumeName, String sDomainName, int snapCount, int snapLevel, String snapName, String snapDesc) throws ConfigMgmtException, UnauthorizedException, DSPMgmtException {
        block10: {
            String METHOD_NAME = "actionSnapshotExpandCow";
            Trace.methodBegin((Object)this, (String)"actionSnapshotExpandCow");
            ConfigContext cfgctx = this.getConfigContext(argContext);
            ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(cfgctx);
            Trace.verbose((Object)this, (String)"actionSnapshotExpandCow", (String)"Done: getManageVolumeServices");
            StorageVolume baseVolume = null;
            try {
                baseVolume = (StorageVolume)msvi.getItemByName(volumeName, null, sDomainName);
            }
            catch (ItemNotFoundException infe) {
                errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                Trace.error((Object)this, (String)"actionSnapshotExpandCow", (String)(sDomainName + " :Storage domain was not found"));
                break block10;
            }
            if (baseVolume == null) {
                errors.add(new ErrorBean(volumeName, "error.objectNotFound", "15"));
                Trace.error((Object)this, (String)"actionSnapshotExpandCow", (String)(volumeName + " :Volume was not found"));
            } else {
                Trace.verbose((Object)this, (String)"actionSnapshotExpandCow", (String)(volumeName + " :Volume was found"));
                if (baseVolume.isMirrorComponent()) {
                    errors.add(new ErrorBean(volumeName, "cli.error.6920.snapshot.CannotSnapshotMirrorComponent"));
                    Trace.error((Object)this, (String)"actionSnapshotExpandCow", (String)"Cannot snapshot a mirror component");
                } else {
                    int cowExpandStatus = this.vaildateCowExpand(errors, baseVolume, snapLevel, snapCount);
                    if (0 != cowExpandStatus) {
                        ManageSnapShotServicesEnt1Interface msss = CliUtilEWS.getManageSnapshotServices(cfgctx);
                        Trace.verbose((Object)this, (String)"actionSnapshotExpandCow", (String)"Done: getManageSnapshotServices");
                        MethodCallStatus mcs = null;
                        if (1 == cowExpandStatus) {
                            mcs = msss.createSnapshot(baseVolume, snapName, snapDesc);
                        } else if (2 == cowExpandStatus) {
                            mcs = msss.createSnapshot(baseVolume, snapName, snapDesc, snapCount, snapLevel);
                        }
                        Trace.verbose((Object)this, (String)"actionSnapshotExpandCow", (String)"Done: createSnapshot");
                        CliUtilEWS.checkMCS(mcs, errors);
                    }
                }
            }
        }
        Trace.methodEnd((Object)this, (String)"actionSnapshotExpandCow");
    }

    private List actionResnap(SOAPContext argContext, String sSnapVolName, String sDomainName) throws ConfigMgmtException, DSPMgmtException, Exception {
        ArrayList<ErrorBean> errors;
        block4: {
            String METHOD_NAME = "actionResnap";
            Trace.methodBegin((Object)this, (String)"actionResnap");
            errors = new ArrayList<ErrorBean>();
            ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(this.getConfigContext(argContext));
            Trace.verbose((Object)this, (String)"actionResnap", (String)"Done: getManageVolumeServices");
            StorageVolume snapshotVolume = null;
            try {
                snapshotVolume = (StorageVolume)msvi.getItemByName(sSnapVolName, null, sDomainName);
            }
            catch (ItemNotFoundException infe) {
                errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                Trace.error((Object)this, (String)"actionResnap", (String)(sDomainName + " :Storage domain was not found"));
                break block4;
            }
            if (snapshotVolume == null) {
                errors.add(new ErrorBean(sSnapVolName, "error.objectNotFound", "15"));
                Trace.error((Object)this, (String)"actionResnap", (String)(sSnapVolName + " :Volume was not found"));
            } else {
                Trace.verbose((Object)this, (String)"actionResnap", (String)(sSnapVolName + " :Volume was found"));
                MethodCallStatus mcs = snapshotVolume.resetSnapshot();
                Trace.verbose((Object)this, (String)"actionResnap", (String)"Done: resetSnapshot");
                CliUtilEWS.checkMCS(mcs, errors);
            }
        }
        Trace.methodEnd((Object)this, (String)"actionResnap");
        return errors;
    }

    private List actionRemoveSnapshotReserve(SOAPContext argContext, String sSnapVolName, String sDomainName) throws ConfigMgmtException, DSPMgmtException, Exception {
        ArrayList<ErrorBean> errors;
        block4: {
            String METHOD_NAME = "actionRemoveSnapshotReserve";
            Trace.methodBegin((Object)this, (String)"actionRemoveSnapshotReserve");
            errors = new ArrayList<ErrorBean>();
            ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(this.getConfigContext(argContext));
            Trace.verbose((Object)this, (String)"actionRemoveSnapshotReserve", (String)"Done: getManageVolumeServices");
            StorageVolume snapshotVolume = null;
            try {
                snapshotVolume = (StorageVolume)msvi.getItemByName(sSnapVolName, null, sDomainName);
            }
            catch (ItemNotFoundException infe) {
                errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                Trace.error((Object)this, (String)"actionRemoveSnapshotReserve", (String)(sDomainName + " :Storage domain was not found"));
                break block4;
            }
            if (snapshotVolume == null) {
                errors.add(new ErrorBean(sSnapVolName, "error.objectNotFound", "15"));
                Trace.error((Object)this, (String)"actionRemoveSnapshotReserve", (String)(sSnapVolName + " :Snapshot volume was not found"));
            } else {
                Trace.verbose((Object)this, (String)"actionRemoveSnapshotReserve", (String)(sSnapVolName + " :Snapshot volume was found"));
                MethodCallStatus mcs = snapshotVolume.removeSnapshotPool();
                Trace.verbose((Object)this, (String)"actionRemoveSnapshotReserve", (String)"Done: removeSnapshotPool");
                CliUtilEWS.checkMCS(mcs, errors);
            }
        }
        Trace.methodEnd((Object)this, (String)"actionRemoveSnapshotReserve");
        return errors;
    }

    private List actionUnmapVolume(SOAPContext argContext, String sDomainName, List initiatorList, String volumeName) throws ConfigMgmtException, DSPMgmtException, Exception {
        String METHOD_NAME = "actionUnmapVolume";
        Trace.methodBegin((Object)this, (String)"actionUnmapVolume");
        ArrayList<String> errors = new ArrayList<String>();
        boolean addResult = false;
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(cfgctx);
        Trace.verbose((Object)this, (String)"actionUnmapVolume", (String)"Done: getManageVolumeServices");
        if (initiatorList != null) {
            ManageInitiatorsInterface mii = CliUtilEWS.getManageInitiatorsServices(cfgctx);
            Trace.verbose((Object)this, (String)"actionUnmapVolume", (String)"Done: getManageInitiatorsServices");
            String initiatorName = null;
            Iterator e = initiatorList.iterator();
            InitiatorInterface ii = null;
            StorageVolumeInterface svi = null;
            long start = 0L;
            long end = 0L;
            while (e.hasNext()) {
                block14: {
                    initiatorName = (String)e.next();
                    try {
                        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                            start = System.currentTimeMillis();
                        }
                        ii = mii.getItemByName(initiatorName);
                        if (!Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) break block14;
                        end = System.currentTimeMillis();
                        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"unmap", (String)("getItemByName: -i-" + initiatorName + " " + (end - start)));
                    }
                    catch (ConfigMgmtException ex) {
                        Trace.error((Object)this, (String)"actionUnmapVolume", (String)ex.toString());
                        addResult = errors.add(ex.getExceptionMsg());
                        continue;
                    }
                }
                if (ii == null) {
                    addResult = errors.add((String)new ErrorBean(initiatorName, "error.objectNotFound", "15"));
                    continue;
                }
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                    start = System.currentTimeMillis();
                }
                ArrayList al = ii.getVolumeMappings();
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                    end = System.currentTimeMillis();
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"map", (String)("getVolumeMappings: " + al + " " + (end - start)));
                }
                svi = null;
                svi = this.hasMap(al, volumeName);
                if (svi == null) {
                    addResult = errors.add((String)new ErrorBean(volumeName, "error.objectNotFound", "15"));
                    continue;
                }
                MethodCallStatus mcs = null;
                long start5 = 0L;
                long end5 = 0L;
                try {
                    if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                        start5 = System.currentTimeMillis();
                    }
                    mcs = svi.removeMapping(ii);
                    if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                        end5 = System.currentTimeMillis();
                        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"map", (String)("removeMapping: " + (end5 - start5)));
                    }
                    CliUtilEWS.checkMCS(mcs, errors);
                }
                catch (ItemNotFoundException ex) {
                    addResult = errors.add((String)new ErrorBean(initiatorName, "error.objectNotFound", "15"));
                }
                catch (ConfigMgmtException ex) {
                    Trace.error((Object)this, (String)"actionUnmapVolume", (String)(ex.toString() + "\n"));
                    addResult = errors.add(ex.getExceptionMsg());
                }
            }
        }
        Trace.methodEnd((Object)this, (String)"actionUnmapVolume");
        return errors;
    }

    private LocalMirrorComponentProps buildMirrorComponentBean(MirrorComponentEnt1Interface mci) throws ConfigMgmtException, Exception {
        String METHOD_NAME = "buildMirrorComponentBean";
        Trace.methodBegin((Object)this, (String)"buildMirrorComponentBean");
        LocalMirrorComponentProps lmcp = new LocalMirrorComponentProps();
        lmcp.setName(mci.getName());
        lmcp.setDomain(mci.getStorageDomainName());
        lmcp.setDescription(mci.getDescription());
        lmcp.setCreationDate(mci.getCreationDate().toString());
        lmcp.setResilverTimeElapsed("0");
        lmcp.setResilverTimeRemaining("0");
        lmcp.setPool(mci.getStoragePoolName());
        lmcp.setResilverPct(mci.getResilverProgress());
        lmcp.setWWN(mci.getWwn());
        lmcp.setProfile(mci.getProfileName());
        lmcp.setSize(mci.getSize());
        lmcp.setState(mci.getState());
        lmcp.setCondition(mci.getConditionInfo());
        lmcp.setAssociations(mci.getInitiatorMappings());
        lmcp.setIsSnapComp(mci.isSnapComponent());
        Trace.methodEnd((Object)this, (String)"buildMirrorComponentBean");
        return lmcp;
    }

    private LocalMirrorProps buildMirrorBean(MirroredVolumeEnt1Interface mvi) throws ConfigMgmtException, Exception {
        String METHOD_NAME = "buildMirrorBean";
        Trace.methodBegin((Object)this, (String)"buildMirrorBean");
        LocalMirrorProps lmp = new LocalMirrorProps();
        lmp.setShowDetails(true);
        lmp.setName(mvi.getName());
        lmp.setDomain(mvi.getStorageDomainName());
        lmp.setDescription(mvi.getDescription());
        lmp.setCreationDate(mvi.getCreationDate().toString());
        lmp.setResilverPriority(mvi.getResilverPriority());
        lmp.setSize(mvi.getSize());
        lmp.setState(mvi.getState());
        lmp.setCondition(mvi.getConditionInfo());
        lmp.setSnapPoolSize(mvi.getSnapshotPoolSize());
        lmp.setSnapPctFull(mvi.getSnapshotPoolPercentFull());
        lmp.setSnaps(mvi.getAssociatedSnapShots());
        lmp.setSnapCount(mvi.getNumAllocatedSnapshots());
        lmp.setSnapPolicy(mvi.getSnapshotPolicy());
        lmp.setSnapActivity(mvi.getSnapshotWriteActivity());
        StoragePoolInterface snapshotPool = mvi.getSnapshotReserveStoragePool();
        if (null == snapshotPool) {
            lmp.setSnapPool("");
        } else {
            lmp.setSnapPool(snapshotPool.getName());
        }
        MirrorComponentEnt1Interface snapComp = mvi.getSnapshotComponent();
        if (null != snapComp) {
            lmp.setSnapshotCompName(snapComp.getName());
        }
        lmp.setAssociations(mvi.getInitiatorMappings());
        lmp.setComponents(mvi.getAssociatedComponents());
        lmp.setIsolationPolicy(mvi.getIsolationPolicy());
        lmp.setWWN(mvi.getWwn());
        lmp.setMirrorLogs(mvi.getLogPools());
        Trace.methodEnd((Object)this, (String)"buildMirrorBean");
        return lmp;
    }

    private VolumePropsS1 buildVolumeBean(StorageVolumeInterface svi, boolean showDetails) throws ConfigMgmtException, Exception {
        String METHOD_NAME = "buildVolumeBean";
        Trace.methodBegin((Object)this, (String)"buildVolumeBean");
        VolumePropsS1 vp = new VolumePropsS1();
        StorageVolume sv = (StorageVolume)svi;
        vp.setShowDetails(showDetails);
        vp.setName(sv.getName());
        vp.setDomain(sv.getStorageDomainName());
        vp.setTypeSummary(sv.getSummaryTypeInfo());
        if (showDetails) {
            vp.setPool(sv.getStoragePoolName());
            vp.setWWN(sv.getWwn());
            vp.setDescription(sv.getDescription());
            vp.setCreationDate(sv.getCreationDate().toString());
            vp.setProfile(sv.getProfileName());
            vp.setSize(sv.getSize());
            vp.setState(sv.getState());
            vp.setCondition(sv.getConditionInfo());
            vp.setType(sv.getType());
            vp.setSnapPoolSize(sv.getSnapshotPoolSize());
            vp.setSnapPctFull(sv.getSnapshotPoolPercentFull());
            vp.setSnapCount(sv.getNumAllocatedSnapshots());
            vp.setSnapActivity(sv.getSnapshotWriteActivity());
            vp.setSnapPolicy(sv.getSnapshotPolicy());
            vp.setRollbackPercentage(sv.getRollbackPercentage());
            StoragePoolInterface snapshotPool = sv.getSnapshotReserveStoragePool();
            if (null == snapshotPool) {
                vp.setSnapPool("");
            } else {
                vp.setSnapPool(snapshotPool.getName());
            }
            vp.setSnaps(sv.getAssociatedSnapShots());
            vp.setAssociations(sv.getInitiatorMappings());
        }
        Trace.methodEnd((Object)this, (String)"buildVolumeBean");
        return vp;
    }

    private Vector createVolumePropsList(List volumeList, boolean showDetails) throws Exception {
        String METHOD_NAME = "createVolumePropsList";
        Trace.methodBegin((Object)this, (String)"createVolumePropsList");
        Vector<VolumeBaseProps> propsList = new Vector<VolumeBaseProps>();
        Iterator relevantVolumesIterator = volumeList.iterator();
        while (relevantVolumesIterator.hasNext()) {
            Object volume = relevantVolumesIterator.next();
            if (showDetails) {
                if (volume instanceof MirroredVolumeEnt1Interface) {
                    propsList.add(this.buildMirrorBean((MirroredVolumeEnt1Interface)volume));
                    continue;
                }
                if (volume instanceof MirrorComponentEnt1Interface) {
                    propsList.add(this.buildMirrorComponentBean((MirrorComponentEnt1Interface)volume));
                    continue;
                }
                if (!(volume instanceof StorageVolumeInterface)) continue;
                propsList.add(this.buildVolumeBean((StorageVolumeInterface)volume, showDetails));
                continue;
            }
            propsList.add(this.buildVolumeBean((StorageVolumeInterface)volume, false));
        }
        Trace.methodEnd((Object)this, (String)"createVolumePropsList");
        return propsList;
    }

    private StorageVolumeInterface hasMap(List al, String volumeName) {
        String METHOD_NAME = "hasMap";
        Trace.methodBegin((Object)this, (String)"hasMap");
        StorageVolumeInterface svi = null;
        long start = 0L;
        long end = 0L;
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
            start = System.currentTimeMillis();
        }
        for (int i = 0; i < al.size(); ++i) {
            InitiatorVolumeMappingInterface ivm = (InitiatorVolumeMappingInterface)al.get(i);
            svi = (StorageVolumeInterface)ivm.getObject();
            if (!svi.getName().equals(volumeName)) continue;
            if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                end = System.currentTimeMillis();
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"hasMap", (String)("time: " + (end - start)));
            }
            Trace.methodEnd((Object)this, (String)"hasMap");
            return svi;
        }
        Trace.methodEnd((Object)this, (String)"hasMap");
        return null;
    }

    private MirrorComponentEnt1Interface getMirrorComponentByName(MirroredVolumeEnt1Interface mirrorVolume, String compName) throws ConfigMgmtException {
        String METHOD_NAME = "getMirrorComponentByName";
        Trace.methodBegin((Object)this, (String)"getMirrorComponentByName");
        ArrayList allComps = mirrorVolume.getAssociatedComponents();
        MirrorComponentEnt1Interface snapComp = null;
        if (null != allComps && !allComps.isEmpty()) {
            for (int i = 0; i < allComps.size(); ++i) {
                snapComp = (MirrorComponentEnt1Interface)allComps.get(i);
                if (null == snapComp) continue;
                if (snapComp.getName().equals(compName)) break;
                snapComp = null;
            }
        }
        Trace.methodEnd((Object)this, (String)"getMirrorComponentByName");
        return snapComp;
    }

    private ArrayList addSnapShotVolumes(SOAPContext argContext, List allVolumes) throws ConfigMgmtException, Exception {
        String METHOD_NAME = "addSnapShotVolumes";
        Trace.methodBegin((Object)this, (String)"addSnapShotVolumes");
        ArrayList al = new ArrayList();
        ManageSnapShotServicesEnt1Interface mgrSnaps = CliUtilEWS.getManageSnapshotServices(this.getConfigContext(argContext));
        al.addAll(mgrSnaps.getItemList());
        Trace.methodEnd((Object)this, (String)"addSnapShotVolumes");
        return al;
    }

    private void findVolumes(ManageStorageVolumesInterface msvi, List volumeNames, ArrayList[] allVolumes) throws ItemNotFoundException, ConfigMgmtException {
        String METHOD_NAME = "findVolumes";
        Trace.methodBegin((Object)this, (String)"findVolumes");
        boolean addElement = false;
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"findVolumes", (String)("volumeNames " + volumeNames));
        }
        if (volumeNames == null || volumeNames.isEmpty()) {
            allVolumes[0] = msvi.getItemsBySystem();
            Trace.verbose((Object)this, (String)"findVolumes", (String)"volumeNames list object is either null or empty. Get all volumes in the system");
            Trace.methodEnd((Object)this, (String)"findVolumes");
            return;
        }
        StorageVolumeInterface svi = null;
        for (int i = 0; i < volumeNames.size(); ++i) {
            String name = (String)volumeNames.get(i);
            svi = null;
            svi = msvi.getItemByName(name);
            if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"findVolumes", (String)("svi " + svi + " allVolumes[FOUND] " + allVolumes[0]));
            }
            if (svi != null) {
                addElement = allVolumes[0].add(svi);
                continue;
            }
            if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"findVolumes", (String)("vol not found:  " + name));
            }
            addElement = allVolumes[1].add(name);
        }
        Trace.methodEnd((Object)this, (String)"findVolumes");
    }

    private Vector proposedList(SOAPContext argContext, List volumeNames, String sPoolName, String sDomainName) throws ItemNotFoundException, ConfigMgmtException, Exception {
        String METHOD_NAME = "proposedList";
        Trace.methodBegin((Object)this, (String)"proposedList");
        ManageStorageVolumesInterface msvi = CliUtilEWS.getManageVolumeServices(this.getConfigContext(argContext));
        Trace.verbose((Object)this, (String)"proposedList", (String)"Done: getManageVolumeServices");
        ArrayList[] allVolumes = new ArrayList[]{new ArrayList(), new ArrayList()};
        this.findVolumes(msvi, volumeNames, allVolumes);
        allVolumes[0].addAll(this.addSnapShotVolumes(argContext, allVolumes[0]));
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS = VolumesEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.VolumesEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$VolumesEWS), (String)"list", (String)("-:-found volumes " + allVolumes[0]));
        }
        Vector result = volumeNames == null || volumeNames.isEmpty() ? this.createVolumePropsList(allVolumes[0], false) : this.createVolumePropsList(allVolumes[0], true);
        if (allVolumes[1] != null && allVolumes[1].size() != 0) {
            for (int i = 0; i < allVolumes[1].size(); ++i) {
                result.add(new ErrorBean((String)allVolumes[1].get(i), "error.objectNotFound", "15"));
            }
        }
        return result;
    }

    private int vaildateCowExpand(List errors, StorageVolume volume, int newSnapLevel, int newSnapCount) throws ConfigMgmtException {
        String METHOD_NAME = "vaildateCowExpand";
        Trace.methodBegin((Object)this, (String)"vaildateCowExpand");
        int result = 0;
        if (0 == volume.getSnapshotPoolSize()) {
            errors.add(new ErrorBean(volume.getName(), "cli.error.6920.volume.snapExpand.noReserve"));
            Trace.error((Object)this, (String)"vaildateCowExpand", (String)"The volume does not have a snapshot reserve configured");
            result = 0;
        } else {
            int newNxM;
            int currentNxM = volume.getSnapshotWriteActivity() * volume.getNumAllocatedSnapshots();
            if (currentNxM == (newNxM = newSnapLevel * newSnapCount)) {
                result = 1;
                Trace.verbose((Object)this, (String)"vaildateCowExpand", (String)"Cow expansion N x M value is equal to the existing value for the volume");
            } else if (newNxM > currentNxM) {
                result = 2;
                Trace.verbose((Object)this, (String)"vaildateCowExpand", (String)"Cow expansion N x M value is greater then the existing value for the volume");
            } else {
                result = 0;
                errors.add(new ErrorBean(" ", "cli.error.6920.volume.snapExpand.noExpand"));
                Trace.error((Object)this, (String)"vaildateCowExpand", (String)"Cow expansion N x M value is less then the existing value for the volume");
            }
        }
        Trace.methodEnd((Object)this, (String)"vaildateCowExpand");
        return result;
    }

    private boolean isMaxSize(String volumeSize) {
        String METHOD_NAME = "isMaxSize";
        Trace.methodBegin((Object)this, (String)"isMaxSize");
        Pattern maxPattern = Pattern.compile("\\s*(?:MAX){1}\\s*", 2);
        Matcher maxMatch = maxPattern.matcher(volumeSize);
        Trace.methodEnd((Object)this, (String)"isMaxSize");
        return maxMatch.matches();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

