/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.TrayProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Trays;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.FilteringResult;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class TraysWS
extends CommandProcessorBase {
    private Trays bizObj = new Trays();
    private T4s arrayBizObj = new T4s();

    public List list(SOAPContext argContext, String arrayName, List trayNameList) throws UnauthorizedException, Exception {
        String METHOD_NAME = "list";
        Trace.verbose((Object)this, (String)"list", (String)"Get CIM Handle - list");
        ConfigContext context = this.getConfigContext(argContext);
        Vector result = new Vector();
        if (trayNameList == null || trayNameList.isEmpty()) {
            result = this.createPropsList(this.bizObj.list(context, null, this.bizObj.findArrayByName(context, arrayName)), false);
        } else {
            List allTrays = this.bizObj.list(context, null, this.bizObj.findArrayByName(context, arrayName));
            FilteringResult fr = FilterUtil.filterNamedObjects((List)trayNameList, (List)allTrays, (NameBasedComparator)BOComparators.TRAY_COMPARATOR);
            result = this.createPropsList(fr.getFoundItems(), true);
            if (fr.hasNotFoundItems()) {
                List notFoundItems = fr.getNotFoundItems();
                for (int i = 0; i < notFoundItems.size(); ++i) {
                    result.add(new ErrorBean((String)notFoundItems.get(i), "error.objectNotFound"));
                }
            }
        }
        return result;
    }

    protected TrayProps createProps(TrayInterface tray, boolean showDetails) throws Exception {
        TrayProps props = new TrayProps();
        props.setId(tray.getId());
        props.setType(tray.getTrayType() + "");
        props.setRole(tray.getRole());
        props.setState(tray.getState() + "");
        props.setStatus(tray.getStatus());
        props.setNumberOfDrives(tray.getNumberOfDrives() + "");
        props.setDriveCapacity(tray.getDriveCapacity() + "");
        props.setAreAllDrivesHealthy(tray.areAllDisksHealthy());
        props.setShowDetails(showDetails);
        List pools = tray.getRaidGroups();
        if (pools != null) {
            Iterator poolIterator = pools.iterator();
            while (poolIterator.hasNext()) {
                RaidGroupInterface pool = (RaidGroupInterface)poolIterator.next();
                props.addPoolName(pool.getName());
            }
        }
        return props;
    }

    protected Vector createPropsList(List trayList, boolean showDetails) throws Exception {
        Vector<TrayProps> propsList = new Vector<TrayProps>();
        Iterator relevantTraysIterator = trayList.iterator();
        while (relevantTraysIterator.hasNext()) {
            TrayInterface tray = (TrayInterface)relevantTraysIterator.next();
            propsList.add(this.createProps(tray, showDetails));
        }
        return propsList;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        String arrayName = null;
        List options = pcl.getOptions();
        List trayNames = pcl.getResource().getValues();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if (!"-a".equals(option.getName()) && !"--array".equals(option.getName())) continue;
            arrayName = option.getFirstValue();
        }
        List trays = this.list(argContext, arrayName, trayNames);
        this.processResults(locale, result, trays);
        return result;
    }

    protected boolean singleTrayAction(TrayInterface tray, String t4Name, String action) {
        String trayId = tray.getId().toString();
        String logKey = "TRAY_UNCONFIGURE_INITIATED";
        String logKeyBad = "TRAY_UNCONFIGURE_ERROR";
        Trace.verbose((Object)this, (String)"singleTrayAction", (String)("do " + action + " on tray " + trayId));
        try {
            if (action.indexOf("disable") != -1) {
                logKey = "TRAY_DISABLE_INITIATED";
                logKeyBad = "TRAY_DISABLE_ERROR";
                tray.enable(false);
            } else if (action.indexOf("enable") != -1) {
                logKey = "TRAY_ENABLE_INITIATED";
                logKeyBad = "TRAY_ENABLE_ERROR";
                tray.enable(true);
            } else {
                tray.unconfigure();
            }
        }
        catch (ConfigMgmtException e) {
            Trace.verbose((Object)this, (String)"singleTrayAction", (Throwable)e);
            LogAPI.staticLog((String)logKeyBad, (String[])new String[]{trayId, t4Name}, (String[])new String[0]);
            return false;
        }
        LogAPI.staticLog((String)logKey, (String[])new String[]{trayId, t4Name}, (String[])new String[0]);
        return true;
    }

    protected List doTraysAction(SOAPContext argContext, String action, String arrayName, List trayNameList) throws Exception {
        String METHOD_NAME = "doTraysAction";
        ConfigContext context = this.getConfigContext(argContext);
        Vector<ErrorBean> result = new Vector<ErrorBean>();
        List allTrays = this.bizObj.list(context, null, this.bizObj.findArrayByName(context, arrayName));
        FilteringResult fr = FilterUtil.filterNamedObjects((List)trayNameList, (List)allTrays, (NameBasedComparator)BOComparators.TRAY_COMPARATOR);
        if (fr.hasNotFoundItems()) {
            List notFoundItems = fr.getNotFoundItems();
            for (int i = 0; i < notFoundItems.size(); ++i) {
                result.add(new ErrorBean((String)notFoundItems.get(i), "error.objectNotFound"));
            }
        }
        List trays = fr.getFoundItems();
        Iterator it = trays.iterator();
        while (it.hasNext()) {
            TrayInterface tray = (TrayInterface)it.next();
            String key = this.bizObj.validateAction(tray, action, allTrays);
            if (key == null && !this.singleTrayAction(tray, arrayName, action)) {
                Trace.verbose((Object)this, (String)"doTraysAction", (String)(action + "failed for tray " + tray.getId()));
                key = "error.trayAction.actionFailed";
            }
            if (key == null) continue;
            result.add(new ErrorBean(tray.getId().toString(), key));
        }
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = new CommandResult();
        String arrayName = null;
        String action = null;
        String badOption = null;
        List options = pcl.getOptions();
        List trayNames = pcl.getResource().getValues();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-a".equals(option.getName()) || "--array".equals(option.getName())) {
                arrayName = option.getFirstValue();
                continue;
            }
            if ("-u".equals(option.getName()) || "--unconfigure".equals(option.getName())) {
                if (action != null) {
                    badOption = option.getName();
                }
                action = "unconfigure";
                continue;
            }
            if ("-d".equals(option.getName()) || "--disable".equals(option.getName())) {
                if (action != null) {
                    badOption = option.getName();
                }
                action = "disable";
                continue;
            }
            if (!"-e".equals(option.getName()) && !"--enable".equals(option.getName())) continue;
            if (action != null) {
                badOption = option.getName();
            }
            action = "enable";
        }
        if (badOption != null || action == null) {
            Trace.verbose((Object)this, (String)"doModify", (String)"Invalid action parameter(s)");
            throw new BadParameterException(badOption + " : ", "error.trayAction.invalidAction");
        }
        List actionResult = this.doTraysAction(argContext, action, arrayName, trayNames);
        this.processResults(locale, result, actionResult);
        return result;
    }
}

