/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.admin.business.SystemTimeAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.soap.rpc.SOAPContext;

public class TimeZoneProcessor
extends CommandProcessorBase {
    protected Admin bizObj = new Admin();

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult cr = new CommandResult();
        ConfigContext client = this.getConfigContext(argContext);
        SystemTimeAdminInterface timeInterface = this.bizObj.getSystemTimeAdminInterface(client);
        TimeZone timezone = timeInterface.getCurrentTimeZone();
        cr.setResult(timezone.getDisplayName(client.getLocale()));
        return cr;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doModify";
        String timeZone = pcl.getResource().getFirstValue();
        CommandResult result = new CommandResult();
        boolean found = false;
        String[] tzList = TimeZone.getAvailableIDs();
        for (int i = 0; i < tzList.length; ++i) {
            if (!tzList[i].equals(timeZone)) continue;
            found = true;
            break;
        }
        if (!found) {
            Trace.verbose((Object)this, (String)"doModify", (String)("Timezone not found " + timeZone));
            result.setErrorId("100");
            result.setResult(this.getResourceBundle(locale).getString("admin.InvalidTimeZone"));
        } else {
            ConfigContext client = this.getConfigContext(argContext);
            SystemTimeAdminInterface timeInterface = this.bizObj.getSystemTimeAdminInterface(client);
            this.changeTimeZone(timeZone, timeInterface, null);
        }
        return result;
    }

    protected final void changeTimeZone(String newTimeZoneValue, SystemTimeAdminInterface timeInterface, String arrayName) throws Exception {
        if (newTimeZoneValue != null) {
            TimeZone timeZone = TimeZone.getTimeZone(newTimeZoneValue);
            timeInterface.setCurrentTimeZone(timeZone);
            timeInterface.setTime(null);
            try {
                timeInterface.save();
                if (arrayName != null) {
                    LogAPI.staticLog((String)"ARRAY_TIME_ZONE_SET", (String[])new String[]{newTimeZoneValue, arrayName}, (String[])new String[0]);
                } else {
                    LogAPI.staticLog((String)"SP_TIME_ZONE_SET", (String[])new String[]{newTimeZoneValue}, (String[])new String[0]);
                }
            }
            catch (Exception e) {
                if (arrayName != null) {
                    LogAPI.staticLog((String)"ARRAY_TIME_ZONE_SET_FAILED", (String[])new String[]{newTimeZoneValue, arrayName}, (String[])new String[0]);
                } else {
                    LogAPI.staticLog((String)"SP_TIME_ZONE_SET_FAILED", (String[])new String[]{newTimeZoneValue}, (String[])new String[0]);
                }
                throw e;
            }
        }
    }
}

