/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.LocalizationUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.T4Props;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.FeatureNotSupportedException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AffectedPool;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.FilteringResult;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class T4sWS
extends CommandProcessorBase
implements Constants.T4 {
    T4s bizObj = new T4s();

    public List list(SOAPContext argContext, List arrayNameList) throws UnauthorizedException, Exception {
        String METHOD_NAME = "list";
        Trace.verbose((Object)this, (String)"list", (String)"Get CIM Handle -list");
        ConfigContext context = this.getConfigContext(argContext);
        Vector<Object> result = new Vector<Object>();
        List arrays = null;
        boolean showDetails = false;
        if (arrayNameList == null || arrayNameList.isEmpty()) {
            Trace.verbose((Object)this, (String)"list", (String)"no array name(s) provided - list them all");
            arrays = this.bizObj.list(context, null);
        } else {
            Trace.verbose((Object)this, (String)"list", (String)"Got a list of names - filtering out all other arrays");
            FilteringResult filtered = FilterUtil.filterNamedObjects((List)arrayNameList, (List)this.bizObj.list(context, null), (NameBasedComparator)BOComparators.ARRAY_COMPARATOR);
            arrays = filtered.getFoundItems();
            showDetails = true;
            Iterator notFoundArrayIter = filtered.getNotFoundItems().iterator();
            while (notFoundArrayIter.hasNext()) {
                String notFoundName = (String)notFoundArrayIter.next();
                result.add(new ErrorBean(notFoundName, "error.objectNotFound"));
            }
        }
        Iterator arrayIter = arrays.iterator();
        while (arrayIter.hasNext()) {
            T4Interface array = (T4Interface)arrayIter.next();
            result.add(this.createProps(array, showDetails));
            Trace.verbose((Object)this, (String)"list", (String)("Adding array " + array.getName()));
        }
        return result;
    }

    public StringBuffer modify(SOAPContext argContext, String arrayName, String segmentSize, String cacheMode, String ondgMode, String readAhead, String reconRate, String arrayHotSpares, String diskScrubbing, String failoverMode, String fcPortSpeed, String fcTopology, String description, Locale locale) throws UnauthorizedException, ConfigMgmtException, Exception {
        String METHOD_NAME = "modify";
        Trace.verbose((Object)this, (String)"modify", (String)"Get CIM Handle - modify");
        ConfigContext context = this.getConfigContext(argContext);
        T4Interface array = this.bizObj.findArrayByName(context, arrayName);
        if (!array.isFeatureSupported(1) && diskScrubbing != null || !array.isFeatureSupported(3) && arrayHotSpares != null) {
            Trace.verbose((Object)this, (String)"modify", (String)"Disk Scrubbing and Array Hot Spares are not available with current firmware version");
            throw new BadParameterException(array.getName(), "t4.error.features_not_supported");
        }
        int oldSegmentSize = array.getBlockSize();
        int oldReadAhead = array.getReadaheadMode();
        List affectedPools = this.changeReadAhead(context, array, readAhead);
        this.changeCacheMode(array, cacheMode);
        this.changeFailover(array, failoverMode);
        this.changeDiskScrubbing(array, diskScrubbing);
        this.changeArrayHotSpares(array, arrayHotSpares);
        this.changeReconRate(array, reconRate);
        this.changeDescription(array, description);
        this.changeFcPortSpeed(array, fcPortSpeed);
        this.changeFcTopology(array, fcTopology);
        this.changeSegmentSize(array, segmentSize);
        this.changeOndgMode(array, ondgMode);
        this.changeArrayHotSpares(array, arrayHotSpares);
        if (fcPortSpeed != null || fcTopology != null) {
            Trace.verbose((Object)this, (String)"modify", (String)"Save fiber channel");
            array.getFiberChannelPort().save();
            array.getFiberChannelPort().reload();
        }
        if (readAhead != null || cacheMode != null || failoverMode != null || reconRate != null || arrayHotSpares != null || diskScrubbing != null || segmentSize != null || description != null || ondgMode != null) {
            try {
                this.bizObj.save(oldSegmentSize, array);
            }
            catch (ConfigMgmtException ex) {
                Trace.error((Object)this, (String)"modify", (String)("ConfigMgmtException: " + ex.toString()));
                if (arrayHotSpares != null) {
                    throw new ConfigMgmtException("T4_MODIFY_HOT_SPARE_FAIL", ex.getExceptionMsg());
                }
                throw new ConfigMgmtException("T4_MODIFY_FAIL", ex.getExceptionMsg());
            }
        }
        StringBuffer result = new StringBuffer();
        result = this.applyModifiedProfiles(affectedPools, result, locale);
        return result;
    }

    private void changeCacheMode(T4Interface array, String cacheMode) throws BadParameterException {
        String METHOD_NAME = "changeCacheMode";
        Trace.methodBegin((Object)this, (String)"changeCacheMode");
        Trace.verbose((Object)this, (String)"changeCacheMode", (String)"Applying changes");
        if (cacheMode == null) {
            Trace.verbose((Object)this, (String)"changeCacheMode", (String)"New cache mode is null - returning without changes.");
            return;
        }
        Trace.verbose((Object)this, (String)"changeCacheMode", (String)("Attempting to set cache mode to " + cacheMode));
        if ("auto".equalsIgnoreCase(cacheMode)) {
            array.setCacheMode("auto");
        } else if ("writethrough".equalsIgnoreCase(cacheMode)) {
            array.setCacheMode("writeThrough");
        } else if ("writebehind".equalsIgnoreCase(cacheMode)) {
            array.setCacheMode("writeBehind");
        } else if ("off".equalsIgnoreCase(cacheMode)) {
            array.setCacheMode("disabled");
        } else {
            Trace.verbose((Object)this, (String)"changeCacheMode", (String)("Illegal cache mode: " + cacheMode));
            throw new BadParameterException(cacheMode, "error.illegalArgument");
        }
    }

    private void changeOndgMode(T4Interface array, String ondgMode) throws BadParameterException, ConfigMgmtException {
        String METHOD_NAME = "changeOndgMode";
        Trace.methodBegin((Object)this, (String)"changeOndgMode");
        Trace.verbose((Object)this, (String)"changeOndgMode", (String)"Applying changes");
        if (ondgMode == null) {
            Trace.verbose((Object)this, (String)"changeOndgMode", (String)"New ondgMode is null - returning without changes.");
            return;
        }
        String newOndgMode = ondgMode.equals("off") ? "off" : "befit";
        Trace.verbose((Object)this, (String)"changeOndgMode", (String)("ondgMode value is:" + ondgMode + ":"));
        if (newOndgMode.equals(array.getOndgMode())) {
            Trace.verbose((Object)this, (String)"changeOndgMode", (String)"New ondgMode value is same as current system value - returning without changes.");
            return;
        }
        try {
            array.setOndgMode(newOndgMode);
        }
        catch (FeatureNotSupportedException e) {
            throw new BadParameterException("-o [--ondg] " + ondgMode + ": ", "t4.error.feature_not_supported_message");
        }
    }

    private void changeDescription(T4Interface array, String description) throws BadParameterException {
        String METHOD_NAME = "changeDescription";
        Trace.methodBegin((Object)this, (String)"changeDescription");
        Trace.verbose((Object)this, (String)"changeDescription", (String)"Applying changes");
        if (description == null) {
            Trace.verbose((Object)this, (String)"changeDescription", (String)"New description is null - returning without changes.");
            return;
        }
        this.bizObj.validateDescription(description, Validate.ARRAY_DESC_OBJECT);
        Trace.verbose((Object)this, (String)"changeDescription", (String)("------------> setting description to " + description));
        array.setDescription(description);
    }

    private void changeDiskScrubbing(T4Interface array, String diskScrubbing) throws BadParameterException, ConfigMgmtException {
        String METHOD_NAME = "changeDiskScrubbing";
        Trace.methodBegin((Object)this, (String)"changeDiskScrubbing");
        Trace.verbose((Object)this, (String)"changeDiskScrubbing", (String)"Applying changes");
        if (diskScrubbing == null) {
            Trace.verbose((Object)this, (String)"changeDiskScrubbing", (String)"New diskScrubbing is null - returning without changes.");
            return;
        }
        boolean diskScrub = "enabled".equalsIgnoreCase(diskScrubbing);
        Trace.verbose((Object)this, (String)"changeDiskScrubbing", (String)("diskScrubbing value is:" + diskScrub + ":"));
        if (array.isDiskScrubbing() == diskScrub) {
            Trace.verbose((Object)this, (String)"changeDiskScrubbing", (String)"New diskScrubbing value is same as current system value - returning without changes.");
            return;
        }
        Trace.verbose((Object)this, (String)"changeDiskScrubbing", (String)("Attempting to set diskScrubbing value to " + diskScrub));
        array.setDiskScrubbing(diskScrub);
    }

    private void changeFailover(T4Interface array, String failover) throws BadParameterException {
        String METHOD_NAME = "changeFailover";
        Trace.methodBegin((Object)this, (String)"changeFailover");
        Trace.verbose((Object)this, (String)"changeFailover", (String)"Applying changes");
        if (failover == null) {
            Trace.verbose((Object)this, (String)"changeFailover", (String)"New failover is null - returning without changes.");
            return;
        }
        Trace.verbose((Object)this, (String)"changeFailover", (String)("Attempting to set failover mode to " + failover));
        if ("mpxio".equalsIgnoreCase(failover)) {
            array.setFailoverMode("mpxio");
        } else if ("readWrite".equalsIgnoreCase(failover)) {
            array.setFailoverMode("readWrite");
        } else if ("none".equalsIgnoreCase(failover)) {
            array.setFailoverMode("none");
        } else {
            Trace.verbose((Object)this, (String)"changeFailover", (String)("Illegal failover mode: " + failover));
            throw new BadParameterException(failover, "error.illegalArgument");
        }
    }

    private void changeFcPortSpeed(T4Interface array, String fcPortSpeed) throws BadParameterException, Exception {
        String METHOD_NAME = "changeFcPortSpeed";
        Trace.methodBegin((Object)this, (String)"changeFcPortSpeed");
        Trace.verbose((Object)this, (String)"changeFcPortSpeed", (String)"Applying changes");
        if (fcPortSpeed == null) {
            Trace.verbose((Object)this, (String)"changeFcPortSpeed", (String)"New fcPortSpeed is null - returning without changes.");
            return;
        }
        Trace.verbose((Object)this, (String)"changeFcPortSpeed", (String)("Attempting to set fcPortSpeed mode to " + fcPortSpeed));
        if ("1Gb".equalsIgnoreCase(fcPortSpeed)) {
            array.getFiberChannelPort().setPreferredSpeed(1);
        } else if ("2Gb".equalsIgnoreCase(fcPortSpeed)) {
            array.getFiberChannelPort().setPreferredSpeed(2);
        } else if ("auto".equalsIgnoreCase(fcPortSpeed)) {
            array.getFiberChannelPort().setPreferredSpeed(0);
        } else {
            Trace.verbose((Object)this, (String)"changeFcPortSpeed", (String)("Illegal fcPortSpeed mode: " + fcPortSpeed));
            throw new BadParameterException(fcPortSpeed, "error.illegalArgument");
        }
    }

    private void changeFcTopology(T4Interface array, String fcTopology) throws BadParameterException, Exception {
        String METHOD_NAME = "changeFcTopology";
        Trace.methodBegin((Object)this, (String)"changeFcTopology");
        Trace.verbose((Object)this, (String)"changeFcTopology", (String)"Applying changes");
        if (fcTopology == null) {
            Trace.verbose((Object)this, (String)"changeFcTopology", (String)"New fcTopology is null - returning without changes.");
            return;
        }
        Trace.verbose((Object)this, (String)"changeFcTopology", (String)("Attempting to set fcTopology mode to " + fcTopology));
        if ("auto".equalsIgnoreCase(fcTopology)) {
            array.getFiberChannelPort().setTopology(16001);
        } else if ("fabric_p2p".equalsIgnoreCase(fcTopology)) {
            array.getFiberChannelPort().setTopology(10);
        } else if ("loop".equalsIgnoreCase(fcTopology)) {
            array.getFiberChannelPort().setTopology(11);
        } else {
            Trace.verbose((Object)this, (String)"changeFcTopology", (String)("Illegal fcTopology mode: " + fcTopology));
            throw new BadParameterException(fcTopology, "error.illegalArgument");
        }
    }

    private List changeReadAhead(ConfigContext context, T4Interface array, String newReadAhead) throws ConfigMgmtException, BadParameterException, Exception {
        String METHOD_NAME = "changeReadAhead";
        Trace.methodBegin((Object)this, (String)"changeReadAhead");
        Trace.verbose((Object)this, (String)"changeReadAhead", (String)"change read-ahead mode");
        ArrayList<AffectedPool> impacts = new ArrayList<AffectedPool>();
        if (newReadAhead == null || !this.bizObj.isReadaheadChange(array.getReadaheadMode(), newReadAhead.equalsIgnoreCase("On") ? 0 : 1)) {
            Trace.verbose((Object)this, (String)"changeReadAhead", (String)"New readAhead is null - returning without changes.");
            return impacts;
        }
        Profiles profilesBizObj = new Profiles();
        List allPoolsOnT4 = array.getRaidGroups();
        if (allPoolsOnT4 != null && !allPoolsOnT4.isEmpty()) {
            Trace.verbose((Object)this, (String)"changeReadAhead", (String)("Looping trough list of pools on array: " + array.getName()));
            Iterator pools = allPoolsOnT4.iterator();
            while (pools.hasNext()) {
                RaidGroupInterface pool = (RaidGroupInterface)pools.next();
                String poolProfile = pool.getProfileName();
                AffectedPool ap = new AffectedPool();
                ap.setAffectedPool(pool);
                try {
                    StorageProfile profile = profilesBizObj.getOrCreateMatchingProfile(context, poolProfile, null, array);
                    Trace.verbose((Object)this, (String)"changeReadAhead", (String)("Matching profile is :" + profile.getName() + ", for pool :" + pool.getName()));
                    ap.setNewProfile(profile);
                    impacts.add(ap);
                }
                catch (Exception e) {
                    throw new ConfigMgmtException("t4.error.profile_not_created_msg", "Error while obtaining matching profile for pool", e);
                }
            }
        }
        if ("Off".equalsIgnoreCase(newReadAhead)) {
            Trace.verbose((Object)this, (String)"changeReadAhead", (String)"Setting readAhead mode to:1");
            array.setReadaheadMode(1);
        } else if ("On".equalsIgnoreCase(newReadAhead)) {
            Trace.verbose((Object)this, (String)"changeReadAhead", (String)"Setting readAhead mode to:0");
            array.setReadaheadMode(0);
        } else {
            Trace.verbose((Object)this, (String)"changeReadAhead", (String)("Illegal readAhead mode: " + newReadAhead));
            throw new BadParameterException(newReadAhead, "error.illegalArgument");
        }
        return impacts;
    }

    private void changeReconRate(T4Interface array, String reconRate) throws BadParameterException {
        String METHOD_NAME = "changeReconRate";
        Trace.methodBegin((Object)this, (String)"changeReconRate");
        Trace.verbose((Object)this, (String)"changeReconRate", (String)"Applying changes");
        if (reconRate == null) {
            Trace.verbose((Object)this, (String)"changeReconRate", (String)"New reconRate is null - returning without changes.");
            return;
        }
        if ("High".equalsIgnoreCase(reconRate)) {
            Trace.verbose((Object)this, (String)"changeReconRate", (String)("Setting reconRate mode to " + reconRate));
            array.setDiskReconRate(16);
        } else if ("Medium".equalsIgnoreCase(reconRate)) {
            array.setDiskReconRate(8);
        } else if ("Low".equalsIgnoreCase(reconRate)) {
            array.setDiskReconRate(1);
        } else {
            Trace.verbose((Object)this, (String)"changeReconRate", (String)("Illegal reconRate mode: " + reconRate));
            throw new BadParameterException(reconRate, "error.illegalArgument");
        }
    }

    private void changeSegmentSize(T4Interface array, String segmentSize) throws BadParameterException {
        String METHOD_NAME = "changeSegmentSize";
        Trace.methodBegin((Object)this, (String)"changeSegmentSize");
        Trace.verbose((Object)this, (String)"changeSegmentSize", (String)"Applying changes");
        if (segmentSize == null) {
            Trace.verbose((Object)this, (String)"changeSegmentSize", (String)"New segmentSize is null - returning without changes.");
            return;
        }
        if ("4K".equalsIgnoreCase(segmentSize)) {
            array.setBlockSize(4096);
        } else if ("8K".equalsIgnoreCase(segmentSize)) {
            array.setBlockSize(8192);
        } else if ("16K".equalsIgnoreCase(segmentSize)) {
            array.setBlockSize(16384);
        } else if ("32K".equalsIgnoreCase(segmentSize)) {
            array.setBlockSize(32768);
        } else if ("64K".equalsIgnoreCase(segmentSize)) {
            array.setBlockSize(65536);
        } else {
            Trace.verbose((Object)this, (String)"changeSegmentSize", (String)("Illegal segment size: " + segmentSize));
            throw new BadParameterException(segmentSize, "error.illegalArgument");
        }
        Trace.verbose((Object)this, (String)"changeSegmentSize", (String)("Set segment size to " + segmentSize));
    }

    private void changeArrayHotSpares(T4Interface array, String arrayHotSpares) throws ConfigMgmtException, BadParameterException {
        String METHOD_NAME = "changeArrayHotSpares";
        Trace.verbose((Object)this, (String)"changeArrayHotSpares", (String)"Applying changes");
        Trace.verbose((Object)this, (String)"changeArrayHotSpares", (String)("Specified arrayHotSpares value is: <" + arrayHotSpares + ">"));
        if (arrayHotSpares == null) {
            Trace.verbose((Object)this, (String)"changeArrayHotSpares", (String)"New arrayHotSpares value is null - returning without changes.");
            return;
        }
        arrayHotSpares = arrayHotSpares.trim();
        int maxAHSAllowed = array.getMaxAhsPoolSizeAllowed();
        int arrayHS = -1;
        try {
            arrayHS = Integer.parseInt(arrayHotSpares);
        }
        catch (NumberFormatException e) {
            Trace.verbose((Object)this, (String)"changeArrayHotSpares", (String)("Specified arrayHotSpares value : <" + arrayHotSpares + "> doesn't have appropriate integer format: \t" + e));
        }
        Trace.verbose((Object)this, (String)"changeArrayHotSpares", (String)("AHS values are - arrayHS: " + arrayHS + " maxAllowed: " + maxAHSAllowed));
        if (arrayHS > maxAHSAllowed) {
            String[] values = new String[]{arrayHotSpares, String.valueOf(maxAHSAllowed)};
            throw new BadParameterException(values, "t4.error.maximum_allowed_hot_spares");
        }
        Trace.verbose((Object)this, (String)"changeArrayHotSpares", (String)("Changing arrayHotSpares value :" + arrayHS));
        array.setAhsPoolSize(arrayHS);
        Trace.verbose((Object)this, (String)"changeArrayHotSpares", (String)("Set arrayHotSpares to " + arrayHS));
    }

    private T4Props createProps(T4Interface array, boolean showDetails) throws Exception {
        T4Props props = new T4Props();
        props.setName(array.getName());
        props.setStatus(array.getHealthStatus());
        props.setListDetails(showDetails);
        boolean isDiskScrubbingSupported = false;
        boolean isArrayHotSpareSupported = false;
        if (showDetails && 2 == array.getHealthStatus()) {
            props.setFirmwareVersion(array.getFirmwareVersion());
            props.setSegmentSize(array.getBlockSize());
            props.setCacheMode(array.getCacheMode());
            props.setReadAheadMode(array.getReadaheadMode());
            props.setDiskReconRate(array.getDiskReconRate());
            props.setFailoverMode(array.getFailoverMode());
            props.setOndgMode(array.getOndgMode());
            if (array.isFeatureSupported(1)) {
                props.setDiskScrubbing(array.isDiskScrubbing());
                isDiskScrubbingSupported = true;
            }
            props.setDiskScrubbingSupported(isDiskScrubbingSupported);
            if (array.isFeatureSupported(3)) {
                props.setArrayHotSpares(array.getAhsPoolSize());
                isArrayHotSpareSupported = true;
            }
            props.setArrayHotSpareSupported(isArrayHotSpareSupported);
            props.setDescription(array.getDescription());
            FiberChannelPortInterface port = array.getFiberChannelPort();
            props.setFcTopology(port.getTopology() + "");
            props.setFcPortSpeed(port.getPreferredSpeed() + "");
            List trays = array.getTrays();
            Iterator trayIter = trays.iterator();
            while (trayIter.hasNext()) {
                TrayInterface tray = (TrayInterface)trayIter.next();
                props.addTrayId(tray.getId());
            }
        }
        return props;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws Exception {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        StringBuffer resultString = new StringBuffer();
        CommandResult result = new CommandResult();
        List arrayNames = pcl.getResource().getValues();
        List arrays = this.list(argCtx, arrayNames);
        this.processResults(locale, result, arrays);
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws Exception {
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkIfReadOnly(argCtx, MenuData.STORAGE_MGMT_MENU);
        String arrayName = pcl.getResource().getFirstValue();
        CommandResult cr = new CommandResult();
        StringBuffer messages = new StringBuffer();
        String segmentSize = null;
        String cacheMode = null;
        String readahead = null;
        String diskScrubbing = null;
        String reconrate = null;
        String failover = null;
        String arrayHotSpares = null;
        String fcPortSpeed = null;
        String fcTopology = null;
        String description = null;
        String ondgMode = null;
        for (int i = 0; i < pcl.getOptions().size(); ++i) {
            Option option = (Option)pcl.getOptions().get(i);
            if (Repository.getRepository().getConfigInteger() == 3 || Repository.getRepository().getConfigInteger() == 2 || Repository.getRepository().getConfigInteger() == 1) {
                if ("-s".equals(option.getName()) || "--segment".equals(option.getName())) {
                    segmentSize = option.getFirstValue();
                } else if ("-r".equals(option.getName()) || "--readahead".equals(option.getName())) {
                    readahead = option.getFirstValue();
                } else if ("-p".equals(option.getName()) || "--fcportspeed".equals(option.getName())) {
                    fcPortSpeed = option.getFirstValue();
                } else if ("-F".equals(option.getName()) || "--fctopology".equals(option.getName())) {
                    fcTopology = option.getFirstValue();
                }
            }
            if ("-k".equals(option.getName()) || "--disk-scrubbing".equals(option.getName())) {
                diskScrubbing = option.getFirstValue();
                continue;
            }
            if ("-c".equals(option.getName()) || "--cache".equals(option.getName())) {
                cacheMode = option.getFirstValue();
                continue;
            }
            if ("-h".equals(option.getName()) || "--hot-spare".equals(option.getName())) {
                arrayHotSpares = option.getFirstValue();
                continue;
            }
            if ("-R".equals(option.getName()) || "--reconrate".equals(option.getName())) {
                reconrate = option.getFirstValue();
                continue;
            }
            if ("-f".equals(option.getName()) || "--failover".equals(option.getName())) {
                failover = option.getFirstValue();
                if ("explicit".equals(failover)) {
                    failover = "mpxio";
                    continue;
                }
                if ("implicit".equals(failover)) {
                    failover = "readWrite";
                    continue;
                }
                if ("standard".equals(failover)) {
                    failover = "std";
                    continue;
                }
                if (!"none".equals(failover)) continue;
                failover = "none";
                continue;
            }
            if ("-d".equals(option.getName()) || "--description".equals(option.getName())) {
                description = option.getFirstValue();
                continue;
            }
            if (!"-o".equals(option.getName()) && !"--ondg".equals(option.getName())) continue;
            ondgMode = option.getFirstValue();
        }
        messages = this.modify(argCtx, arrayName, segmentSize, cacheMode, ondgMode, readahead, reconrate, arrayHotSpares, diskScrubbing, failover, fcPortSpeed, fcTopology, description, locale);
        if (messages.length() != 0) {
            cr.setResult(messages.toString());
        }
        return cr;
    }

    protected StringBuffer applyModifiedProfiles(List affectedPools, StringBuffer result, Locale locale) throws ConfigMgmtException {
        String METHOD_NAME = "applyModifiedProfiles";
        Trace.methodBegin((Object)this, (String)"applyModifiedProfiles");
        ResourceBundle resource = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource", locale);
        StringBuffer applied = new StringBuffer();
        StringBuffer errors = new StringBuffer();
        StringBuffer resultMsg = new StringBuffer();
        if (affectedPools != null && !affectedPools.isEmpty()) {
            Trace.verbose((Object)this, (String)"applyModifiedProfiles", (String)"Looping trough list of pools affected by readahead change :");
            Iterator pools = affectedPools.iterator();
            while (pools.hasNext()) {
                AffectedPool ap = (AffectedPool)pools.next();
                RaidGroupInterface raidGroup = ap.getAffectedPool();
                StorageProfile profile = ap.getNewProfile();
                Trace.verbose((Object)this, (String)"applyModifiedProfiles", (String)("Apply new profile: " + profile.getName() + ", to pool :" + raidGroup.getName()));
                applied.append(LocalizationUtil.localizeString((ResourceBundle)resource, (String)"t4.poolLabel") + raidGroup.getName()).append(LocalizationUtil.localizeString((ResourceBundle)resource, (String)"t4.applied_profile_msg")).append(profile.getName() + "\n");
            }
            resultMsg.append(errors).append(applied);
        }
        return resultMsg;
    }
}

