/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.StoragePoolPropsS1;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class StoragePoolsEWS
extends CommandProcessorBase {
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS;

    protected CommandResult doCreate(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, BadParameterException, ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doCreate";
        Trace.methodBegin((Object)this, (String)"doCreate");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String profile = null;
        String desc = null;
        String sdomain = "DEFAULT";
        String pool = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-p".equals(option.getName()) || "--profile".equals(option.getName())) {
                profile = option.getFirstValue();
                continue;
            }
            if ("-d".equals(option.getName()) || "--description".equals(option.getName())) {
                desc = option.getFirstValue();
                continue;
            }
            if (!"-S".equals(option.getName()) && !"--sdomain".equals(option.getName())) continue;
            sdomain = option.getFirstValue();
        }
        List errors = this.create(argContext, pool, profile, sdomain, desc);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    public List create(SOAPContext argContext, String pool, String profile, String sdomain, String desc) throws UnauthorizedException, BadParameterException, ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "create";
        Trace.methodBegin((Object)this, (String)"create");
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        ManageStoragePoolsInterface mspi = ManageStoragePoolsFactory.getManager();
        if (mspi == null) {
            throw new ConfigMgmtException("error.bolMgr.noPoolMgr", "");
        }
        mspi.init(this.getConfigContext(argContext), null);
        MethodCallStatus mcs = mspi.createStoragePool(pool, desc, profile, sdomain);
        if (mcs != null && mcs.getReturnCode() != 0) {
            errors.add(new ErrorBean("", "error.cim." + mcs.getReturnCode()));
        }
        return errors;
    }

    public List delete(SOAPContext argContext, List poolNames, String sdomain) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "delete";
        Trace.methodBegin((Object)this, (String)"delete");
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        ManageStoragePoolsInterface mspi = ManageStoragePoolsFactory.getManager();
        if (mspi == null) {
            throw new ConfigMgmtException("error.bolMgr.noPoolMgr", "");
        }
        mspi.init(this.getConfigContext(argContext), null);
        for (int i = 0; i < poolNames.size(); ++i) {
            StoragePoolInterface spi = null;
            String pool = (String)poolNames.get(i);
            try {
                spi = mspi.getItemByName(pool, sdomain);
                if (spi == null) {
                    errors.add(new ErrorBean(pool, "error.objectNotFound"));
                    continue;
                }
                MethodCallStatus mcs = mspi.delete(spi.getKey());
                if (mcs == null || mcs.getReturnCode() == 0) continue;
                errors.add(new ErrorBean(pool, "error.cim." + mcs.getReturnCode()));
                continue;
            }
            catch (ItemNotFoundException infe) {
                errors.add(new ErrorBean(pool, "error.objectNotFound"));
            }
        }
        return errors;
    }

    protected CommandResult doDelete(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException, ItemNotFoundException, BadParameterException {
        String METHOD_NAME = "doDelete";
        Trace.methodBegin((Object)this, (String)"doDelete");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = new CommandResult();
        List poolNames = pcl.getResource().getValues();
        String sdomain = "DEFAULT";
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if (!"-S".equals(option.getName()) && !"--sdomain".equals(option.getName())) continue;
            sdomain = option.getFirstValue();
        }
        List errors = this.delete(argContext, poolNames, sdomain);
        this.processResults(locale, result, errors);
        return result;
    }

    private StoragePoolPropsS1 buildBean(StoragePoolInterface spi, boolean showDetails) throws ConfigMgmtException, Exception {
        Object sVolumeList = null;
        Object sVdiskList = null;
        Object assocVolumes = null;
        Object assocVdisks = null;
        StoragePoolPropsS1 pp = new StoragePoolPropsS1();
        pp.setShowDetails(showDetails);
        pp.setName(spi.getName());
        pp.setDomain(spi.getStorageDomainName());
        if (showDetails) {
            pp.setDescription(spi.getDescription());
            pp.setProfileName(spi.getProfileName());
            pp.setCapacity(spi.getStorageCapacity());
            pp.setAllocatedCapacity(spi.getAllocatedCapacity());
            pp.setUnAllocatedCapacity(spi.getUnAllocatedCapacity());
            pp.setVdisks(spi.getAssociatedVDisks());
            pp.setVolumes(spi.getAssociatedVolumes());
            pp.setStorageArrays(spi.getArrayControllers());
            pp.setStoragePool(spi);
        }
        return pp;
    }

    private Vector createPoolPropsList(List poolList, boolean showDetails) throws Exception {
        Vector<StoragePoolPropsS1> propsList = new Vector<StoragePoolPropsS1>();
        Iterator relevantPoolsIterator = poolList.iterator();
        while (relevantPoolsIterator.hasNext()) {
            StoragePoolInterface pool = (StoragePoolInterface)relevantPoolsIterator.next();
            propsList.add(this.buildBean(pool, showDetails));
        }
        return propsList;
    }

    protected ArrayList poolsByDomainf(SOAPContext argContext, ManageStoragePoolsInterface mspi) throws ConfigMgmtException, UnauthorizedException, ItemNotFoundException {
        ArrayList<StoragePoolInterface> al = new ArrayList<StoragePoolInterface>();
        boolean addResult = false;
        ManageStorageDomainsInterface msdi = ManageStorageDomainsFactory.getManager();
        if (msdi == null) {
            throw new ConfigMgmtException("error.bolMgr.notThere", "no storage domain manager");
        }
        msdi.init(this.getConfigContext(argContext), null);
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS = StoragePoolsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.StoragePoolsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS = StoragePoolsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.StoragePoolsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS), (String)"poolsByDomain", (String)"msdi.init() done");
        }
        List allDomains = msdi.getItemsBySystem();
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS = StoragePoolsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.StoragePoolsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS = StoragePoolsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.StoragePoolsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS), (String)"poolsByDomain", (String)("allDomains list: " + allDomains));
        }
        for (int i = 0; i < allDomains.size(); ++i) {
            StorageDomainInterface sdi = (StorageDomainInterface)allDomains.get(i);
            ArrayList domainPools = mspi.getItemsByStorageDomain(sdi.getName());
            if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS == null ? StoragePoolsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.StoragePoolsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS))) {
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS == null ? StoragePoolsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.StoragePoolsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS), (String)"poolsByDomain", (String)("domainPools list: " + domainPools));
            }
            for (int j = 0; j < domainPools.size(); ++j) {
                StoragePoolInterface spi = (StoragePoolInterface)domainPools.get(j);
                if (!sdi.getName().equals(spi.getStorageDomainName())) continue;
                addResult = al.add(spi);
            }
        }
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS = StoragePoolsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.StoragePoolsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS = StoragePoolsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.StoragePoolsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$StoragePoolsEWS), (String)"poolsByDomain", (String)("spi list: " + al));
        }
        return al;
    }

    public Vector list(SOAPContext argContext, List poolNames, String sdomain) throws ConfigMgmtException, UnauthorizedException, ItemNotFoundException, Exception {
        StoragePoolInterface spi;
        int i;
        String METHOD_NAME = "list";
        Trace.methodBegin((Object)this, (String)"list");
        Vector<Object> result = new Vector<Object>();
        ConfigContext context = this.getConfigContext(argContext);
        boolean showDetails = false;
        ManageStoragePoolsInterface mspi = CliUtilEWS.getManagePoolServices(context);
        Trace.verbose((Object)this, (String)"list", (String)"Done: getManagePoolServices");
        AbstractList pools = null;
        if (null == poolNames || poolNames.isEmpty()) {
            if (null == sdomain) {
                pools = mspi.getItemsBySystem();
                Trace.verbose((Object)this, (String)"list", (String)"Done: getItemsBySystem");
            } else {
                try {
                    pools = mspi.getItemsByStorageDomain(sdomain);
                    Trace.verbose((Object)this, (String)"list", (String)"Done: getItemsByStorageDomain");
                }
                catch (ItemNotFoundException infe) {
                    result.add(new ErrorBean(sdomain, "error.objectNotFound", "15"));
                    Trace.error((Object)this, (String)"list", (String)(sdomain + " :Storage domain was not found"));
                    Trace.methodEnd((Object)this, (String)"list");
                    return result;
                }
            }
        } else {
            showDetails = true;
            if (null == sdomain) {
                sdomain = "DEFAULT";
            }
            pools = new Vector();
            for (i = 0; i < poolNames.size(); ++i) {
                spi = null;
                String poolName = (String)poolNames.get(i);
                try {
                    spi = mspi.getItemByName(poolName, sdomain);
                }
                catch (ItemNotFoundException cme) {
                    result.add(new ErrorBean(sdomain, "error.objectNotFound", "15"));
                    Trace.error((Object)this, (String)"list", (String)(sdomain + " :Storage domain was not found"));
                    continue;
                }
                if (spi == null) {
                    result.add(new ErrorBean(poolName, "error.objectNotFound", "15"));
                    Trace.error((Object)this, (String)"list", (String)(poolName + " :Storage pool was not found"));
                    continue;
                }
                pools.add(spi);
                Trace.verbose((Object)this, (String)"list", (String)(poolName + " :Storage pool was found"));
            }
        }
        for (i = 0; i < pools.size(); ++i) {
            spi = (StoragePoolInterface)pools.get(i);
            StoragePoolPropsS1 pp = this.buildBean(spi, showDetails);
            result.add(pp);
        }
        Trace.methodEnd((Object)this, (String)"list");
        return result;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException, ItemNotFoundException, BadParameterException, Exception {
        Option option;
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        CommandResult result = new CommandResult();
        String sDomain = null;
        List poolNames = pcl.getResource().getValues();
        List options = pcl.getOptions();
        if (options.size() != 0 && ("-S".equals((option = (Option)options.get(0)).getName()) || "--sdomain".equals(option.getName()))) {
            sDomain = option.getFirstValue();
        }
        Vector pools = this.list(argContext, poolNames, sDomain);
        this.processResults(locale, result, pools);
        Trace.methodEnd((Object)this, (String)"doList");
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, BadParameterException, ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String sdomain = "DEFAULT";
        String newName = null;
        Object profile = null;
        String desc = null;
        Object sStatus = null;
        String poolName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-S".equals(option.getName()) || "--sdomain".equals(option.getName())) {
                sdomain = option.getFirstValue();
                continue;
            }
            if ("-d".equals(option.getName()) || "--description".equals(option.getName())) {
                desc = option.getFirstValue();
                continue;
            }
            if (!"-n".equals(option.getName()) && !"--new-name".equals(option.getName())) continue;
            newName = option.getFirstValue();
        }
        if (sdomain == null) {
            throw new BadParameterException("", "sdomain or array");
        }
        CommandResult result = new CommandResult();
        List errors = this.modify(argContext, poolName, sdomain, newName, desc);
        this.processResults(locale, result, errors);
        return result;
    }

    public List modify(SOAPContext argContext, String pool, String sdomain, String newName, String desc) throws UnauthorizedException, BadParameterException, ConfigMgmtException, ItemNotFoundException {
        ArrayList<ErrorBean> errors;
        block6: {
            String METHOD_NAME = "modify";
            Trace.methodBegin((Object)this, (String)"modify");
            errors = new ArrayList<ErrorBean>();
            ManageStoragePoolsInterface mspi = CliUtilEWS.getManagePoolServices(this.getConfigContext(argContext));
            Trace.verbose((Object)this, (String)"modify", (String)"Done: getManagePoolServices");
            StoragePoolInterface spi = null;
            try {
                spi = mspi.getItemByName(pool, sdomain);
            }
            catch (ItemNotFoundException cme) {
                errors.add(new ErrorBean(sdomain, "error.objectNotFound", "15"));
                Trace.error((Object)this, (String)"modify", (String)(sdomain + " :Storage domain was not found"));
                break block6;
            }
            if (null == spi) {
                errors.add(new ErrorBean(pool, "error.objectNotFound", "15"));
                Trace.error((Object)this, (String)"modify", (String)(pool + " :Storage pool was not found"));
            } else {
                Trace.verbose((Object)this, (String)"modify", (String)(pool + " :Storage pool was found"));
                if (null != newName) {
                    spi.setName(newName);
                    Trace.verbose((Object)this, (String)"modify", (String)(newName + " :New pool name set"));
                }
                if (null != desc) {
                    spi.setDescription(desc);
                    Trace.verbose((Object)this, (String)"modify", (String)(desc + " :New pool description set"));
                }
                spi.save();
                Trace.verbose((Object)this, (String)"modify", (String)"Done: save");
            }
        }
        Trace.methodEnd((Object)this, (String)"modify");
        return errors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

