/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.StorageDomainProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.DSPMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.FilteringResult;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class StorageDomainEWS
extends CommandProcessorBase {
    private static final String DEFAULT_STORAGE_DOMAIN_NAME = "DEFAULT";
    ResourceBundle resource = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource", Locale.getDefault());

    protected List create(SOAPContext argContext, String sDescription, String sDomainName) throws BadParameterException, UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "create";
        Trace.methodBegin((Object)this, (String)"create");
        ArrayList errors = new ArrayList();
        boolean addResult = false;
        ManageStorageDomainsInterface msdi = ManageStorageDomainsFactory.getManager();
        if (msdi == null) {
            Trace.verbose((Object)this, (String)"create", (String)"ManageStorageDomainsInterface is null");
            throw new ConfigMgmtException("error.bolMgr.noStrDomMgr", "");
        }
        msdi.init(this.getConfigContext(argContext), null);
        Trace.verbose((Object)this, (String)"create", (String)"msdi.init() done");
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.verbose((Object)this, (String)"create", (String)("args to msdi.createStorageVolume:  domain name = " + sDomainName + ", description = " + sDescription + "\n"));
        }
        MethodCallStatus mcs = null;
        mcs = msdi.create(sDomainName, sDescription);
        CliUtilEWS.checkMCS(mcs, errors);
        return errors;
    }

    protected CommandResult doCreate(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = new CommandResult();
        String METHOD_NAME = "doCreate";
        String sDescription = null;
        String sDomainName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if (!"-d".equals(option.getName()) && !"--description".equals(option.getName())) continue;
            sDescription = option.getFirstValue();
        }
        List errors = this.create(argContext, sDescription, sDomainName);
        this.processResults(locale, result, errors);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List delete(SOAPContext argContext, List domainNames) throws ConfigMgmtException, ItemNotFoundException, DSPMgmtException, Exception {
        String METHOD_NAME = "delete";
        Trace.methodBegin((Object)this, (String)"delete");
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        boolean addResult = false;
        ManageStorageDomainsInterface msdi = ManageStorageDomainsFactory.getManager();
        if (msdi == null) {
            Trace.verbose((Object)this, (String)"delete", (String)"ManageStorageDomainsInterface is null");
            throw new ConfigMgmtException("error.bolMgr.notThere", this.resource.getString("error.bolMgr.noDomMgr"));
        }
        msdi.init(this.getConfigContext(argContext), null);
        Trace.verbose((Object)this, (String)"delete", (String)"msdi.init() done");
        if (domainNames.size() != 0) {
            Iterator e = domainNames.iterator();
            String sdomainName = null;
            StorageDomainInterface sdi = null;
            while (e.hasNext()) {
                sdomainName = (String)e.next();
                try {
                    sdi = msdi.getItemByName(sdomainName);
                }
                catch (ConfigMgmtException ex) {
                    Trace.error((Object)this, (String)"delete", (String)("ConfigMgmtException: " + ex.toString() + "\n"));
                    addResult = errors.add(new ErrorBean(sdomainName, "error.objectNotFound"));
                    continue;
                }
                if (sdi == null) continue;
                MethodCallStatus mcs = null;
                try {
                    mcs = msdi.delete(sdomainName);
                }
                catch (ConfigMgmtException ex) {
                    Trace.error((Object)this, (String)"delete", (String)("ConfigMgmtException: " + ex.toString() + "\n"));
                    addResult = errors.add(new ErrorBean(sdomainName, "VOLUME_DELETION_EXCEPTION"));
                }
                catch (ItemNotFoundException ex) {
                    Trace.verbose((Object)this, (String)"delete", (String)("ItemNotFoundException: " + ex.toString() + "\n"));
                    addResult = errors.add(new ErrorBean(sdomainName, "error.objectNotFound"));
                }
                finally {
                    CliUtilEWS.checkMCS(mcs, errors);
                }
            }
        }
        return errors;
    }

    protected CommandResult doDelete(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = new CommandResult();
        String METHOD_NAME = "doDelete";
        Trace.methodBegin((Object)this, (String)"doDelete");
        List domainNames = pcl.getResource().getValues();
        List errors = this.delete(argContext, domainNames);
        this.processResults(locale, result, errors);
        return result;
    }

    private StorageDomainProps buildBean(StorageDomainInterface sdi, boolean showDetails) throws ConfigMgmtException, Exception {
        StorageDomainProps dp = new StorageDomainProps();
        dp.setShowDetails(showDetails);
        dp.setDomainName(sdi.getName());
        if (showDetails) {
            dp.setDescription(sdi.getDescription());
            dp.setCapacity(sdi.getStorageCapacity().toString());
            dp.setAllocated(sdi.getAllocatedCapacity().toString());
            dp.setUnallocated(sdi.getUnAllocatedCapacity().toString());
            dp.setInitiators(sdi.getAssocInitiators());
            dp.setPools(sdi.getAssocPools());
            dp.setVolumes(sdi.getAssocVolumes());
        }
        return dp;
    }

    private Vector createDomainPropsList(List domainList, boolean showDetails) throws Exception {
        Vector<StorageDomainProps> propsList = new Vector<StorageDomainProps>();
        Iterator relevantDomainsIterator = domainList.iterator();
        while (relevantDomainsIterator.hasNext()) {
            StorageDomainInterface domain = (StorageDomainInterface)relevantDomainsIterator.next();
            propsList.add(this.buildBean(domain, showDetails));
        }
        return propsList;
    }

    protected List list(SOAPContext argContext, List argList, String sParam) throws Exception {
        String METHOD_NAME = "list";
        Trace.methodBegin((Object)this, (String)"list");
        ManageStorageDomainsInterface msdi = ManageStorageDomainsFactory.getManager();
        if (msdi == null) {
            Trace.verbose((Object)this, (String)"list", (String)"ManageStorageDomainsInterface is null");
            throw new ConfigMgmtException("error.bolMgr.notThere", this.resource.getString("error.bolMgr.noDomMgr"));
        }
        msdi.init(this.getConfigContext(argContext), null);
        Trace.verbose((Object)this, (String)"list", (String)"msdi.init() done");
        List allDomains = msdi.getItemsBySystem();
        Trace.verbose((Object)this, (String)"list", (String)("-:-allDomains" + allDomains));
        FilteringResult fr = FilterUtil.filterNamedObjects((List)argList, (List)allDomains, (NameBasedComparator)BOComparators.DOMAIN_COMPARATOR);
        Trace.verbose((Object)this, (String)"list", (String)("-:-FR" + fr));
        Vector result = argList == null || argList.isEmpty() ? this.createDomainPropsList(allDomains, false) : this.createDomainPropsList(fr.getFoundItems(), true);
        if (fr.hasNotFoundItems()) {
            List notFoundItems = fr.getNotFoundItems();
            for (int i = 0; i < notFoundItems.size(); ++i) {
                result.add(new ErrorBean((String)notFoundItems.get(i), "error.objectNotFound"));
            }
        }
        return result;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        CommandResult result = new CommandResult();
        List domainNames = pcl.getResource().getValues();
        String sParam = null;
        List domains = this.list(argContext, domainNames, sParam);
        this.processResults(locale, result, domains);
        return result;
    }

    protected List modify(SOAPContext argContext, String sDescription, String sDomainName) throws UnauthorizedException, BadParameterException, ItemNotFoundException, ConfigMgmtException, Exception {
        String METHOD_NAME = "modify";
        Trace.methodBegin((Object)this, (String)"modify");
        ArrayList errors = new ArrayList();
        boolean addResult = false;
        ManageStorageDomainsInterface msdi = ManageStorageDomainsFactory.getManager();
        if (msdi == null) {
            throw new ConfigMgmtException("error.bolMgr.notThere", this.resource.getString("error.bolMgr.noDomMgr"));
        }
        msdi.init(this.getConfigContext(argContext), null);
        Trace.verbose((Object)this, (String)"modify", (String)"msdi.init() done");
        StorageDomainInterface sdi = null;
        try {
            sdi = msdi.getItemByName(sDomainName);
        }
        catch (ConfigMgmtException e) {
            Trace.verbose((Object)this, (String)"modify", (String)"no domain with specified name");
            throw new ItemNotFoundException(sDomainName);
        }
        if (sdi == null) {
            Trace.verbose((Object)this, (String)"modify", (String)"no domain with specified name");
            throw new ItemNotFoundException(sDomainName);
        }
        sdi.setDescription(sDescription);
        sdi.save();
        return errors;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String METHOD_NAME = "doModify";
        CommandResult result = new CommandResult();
        String sDescription = null;
        String sDomainName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if (!"-d".equals(option.getName()) && !"--description".equals(option.getName())) continue;
            sDescription = option.getFirstValue();
        }
        List errors = this.modify(argContext, sDescription, sDomainName);
        this.processResults(locale, result, errors);
        return result;
    }
}

