/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.RepsetProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationGroupEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationParametersEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationSetEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.soap.rpc.SOAPContext;

public class RepsetEWS
extends CommandProcessorBase {
    private static final int REPGROUP = 0;
    private static final int REPSET = 1;
    private static final int TIME_COUNT_DEFAULT = 0;

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        List repSetNamesList = pcl.getResource().getValues();
        String sDomainName = "DEFAULT";
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        List repSetBeansList = this.buildBeanList(argContext, repSetNamesList, sDomainName);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, repSetBeansList);
        Trace.methodEnd((Object)this, (String)"doList");
        return result;
    }

    protected CommandResult doDelete(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doDelete";
        Trace.methodBegin((Object)this, (String)"doDelete");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        List repSetNamesList = pcl.getResource().getValues();
        String sDomainName = "DEFAULT";
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == repSetNamesList || repSetNamesList.size() < 1) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionDeleteRepset(errors, argContext, repSetNamesList, sDomainName);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"doDelete");
        return result;
    }

    protected CommandResult doCreate(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "doCreate";
        Trace.methodBegin((Object)this, (String)"doCreate");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String oln = pcl.getOptionListName();
        CommandResult result = null;
        if ("no_group".equals(oln)) {
            Trace.verbose((Object)this, (String)"doCreate", (String)"Process with option list no_group");
            result = this.processCreateRepset(locale, pcl, argContext, false);
        } else if ("new_group".equals(oln)) {
            Trace.verbose((Object)this, (String)"doCreate", (String)"Process with option list new_group");
            result = this.processCreateRepset(locale, pcl, argContext, true);
        } else if ("in_group".equals(oln)) {
            Trace.verbose((Object)this, (String)"doCreate", (String)"Process with option list in_groupl");
            result = this.processCreateRepsetInExistingGroup(locale, pcl, argContext);
        }
        Trace.methodEnd((Object)this, (String)"doCreate");
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        CommandResult result;
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String oln = pcl.getOptionListName();
        if ("suspend_repset".equals(oln)) {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process with option list suspend_repset");
            result = this.processSuspend(locale, pcl, argContext, 1);
        } else if ("suspend_constgroup".equals(oln)) {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process with option list suspend_constgroup");
            result = this.processSuspend(locale, pcl, argContext, 0);
        } else if ("resume_repset".equals(oln)) {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process with option list resume_repset");
            result = this.processResume(locale, pcl, argContext, 1);
        } else if ("resume_constgroup".equals(oln)) {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process with option list resume_constgroup");
            result = this.processResume(locale, pcl, argContext, 0);
        } else if ("modify_repset".equals(oln)) {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process with option list modify_repset");
            result = this.processModify(locale, pcl, argContext, 1);
        } else if ("modify_constgroup".equals(oln)) {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process with option list modify_constgroup");
            result = this.processModify(locale, pcl, argContext, 0);
        } else {
            Trace.verbose((Object)this, (String)"doModify", (String)"Process with option list modify_repset as a default");
            result = this.processModify(locale, pcl, argContext, 1);
        }
        Trace.methodEnd((Object)this, (String)"doModify");
        return result;
    }

    private CommandResult processCreateRepset(Locale locale, ParsedCommandLine pcl, SOAPContext argContext, boolean newGroup) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processCreateRepset";
        Trace.methodBegin((Object)this, (String)"processCreateRepset");
        String localVolumeName = null;
        String peerWWN = null;
        String remoteVolumeWWN = null;
        String bitmapPoolName = null;
        Integer role = null;
        Integer mode = null;
        boolean snapWithPrimary = false;
        boolean autoSynchronize = false;
        boolean snapBeforeSync = true;
        int priority = CliUtilEWS.cvtReplicationPriority("MEDIUM");
        BigInteger blockCount = BigInteger.ZERO;
        int timeCount = 0;
        int queueAction = 1;
        String queuePoolName = null;
        String sDomainName = "DEFAULT";
        String newGroupName = null;
        String groupDesc = null;
        String queueSizeString = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-l".equals(name) || "--local-volume".equals(name)) {
                localVolumeName = option.getFirstValue();
                continue;
            }
            if ("-w".equals(name) || "--peer-wwn".equals(name)) {
                peerWWN = option.getFirstValue();
                continue;
            }
            if ("-o".equals(name) || "--remote-volume".equals(name)) {
                remoteVolumeWWN = option.getFirstValue();
                continue;
            }
            if ("-b".equals(name) || "--bitmap-pool".equals(name)) {
                bitmapPoolName = option.getFirstValue();
                continue;
            }
            if ("-r".equals(name) || "--role".equals(name)) {
                role = new Integer(CliUtilEWS.cvtReplicationRole(option.getFirstValue()));
                continue;
            }
            if ("-m".equals(name) || "--mode".equals(name)) {
                mode = new Integer(CliUtilEWS.cvtReplicationMode(option.getFirstValue()));
                continue;
            }
            if ("-s".equals(name) || "--auto-sync".equals(name)) {
                autoSynchronize = CliUtilEWS.cvtEnableDisable(option.getFirstValue());
                continue;
            }
            if ("-x".equals(name) || "--snap-with-primary".equals(name)) {
                snapWithPrimary = CliUtilEWS.cvtEnableDisable(option.getFirstValue());
                continue;
            }
            if ("-p".equals(name) || "--snap-before-sync".equals(name)) {
                snapBeforeSync = CliUtilEWS.cvtEnableDisable(option.getFirstValue());
                continue;
            }
            if ("-q".equals(name) || "--async-queue".equals(name)) {
                queuePoolName = option.getFirstValue();
                continue;
            }
            if ("-u".equals(name) || "--full-queue".equals(name)) {
                queueAction = CliUtilEWS.cvtReplicationQueueAction(option.getFirstValue());
                continue;
            }
            if ("-k".equals(name) || "--queue-blocks".equals(name)) {
                blockCount = new BigInteger(option.getFirstValue());
                continue;
            }
            if ("-t".equals(name) || "--queue-time".equals(name)) {
                timeCount = Integer.parseInt(option.getFirstValue());
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-G".equals(name) || "--new-group".equals(name)) {
                newGroupName = option.getFirstValue();
                continue;
            }
            if ("-d".equals(name) || "--description".equals(name)) {
                groupDesc = option.getFirstValue();
                continue;
            }
            if ("-R".equals(name) || "--replication-priority".equals(name)) {
                priority = CliUtilEWS.cvtReplicationPriority(option.getFirstValue());
                continue;
            }
            if (!"-Q".equals(name) && !"--queue-size".equals(name)) continue;
            queueSizeString = Convert.cleanUpAndUpcase((String)option.getFirstValue());
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == localVolumeName || null == peerWWN || null == remoteVolumeWWN || null == bitmapPoolName || newGroup && (null == role || null == mode)) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionCreateRepset(errors, argContext, localVolumeName, sDomainName, peerWWN, remoteVolumeWWN, bitmapPoolName, role, mode, snapWithPrimary, autoSynchronize, snapBeforeSync, blockCount, timeCount, queueAction, queuePoolName, newGroupName, groupDesc, priority, queueSizeString);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processCreateRepset");
        return result;
    }

    private CommandResult processCreateRepsetInExistingGroup(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processCreateRepsetInExistingGroup";
        Trace.methodBegin((Object)this, (String)"processCreateRepsetInExistingGroup");
        String localVolumeName = null;
        String remoteVolumeWWN = null;
        String bitmapPoolName = null;
        String constgroupName = null;
        String sDomainName = "DEFAULT";
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-l".equals(name) || "--local-volume".equals(name)) {
                localVolumeName = option.getFirstValue();
                continue;
            }
            if ("-o".equals(name) || "--remote-volume".equals(name)) {
                remoteVolumeWWN = option.getFirstValue();
                continue;
            }
            if ("-b".equals(name) || "--bitmap-pool".equals(name)) {
                bitmapPoolName = option.getFirstValue();
                continue;
            }
            if ("-g".equals(name) || "--constgroup".equals(name)) {
                constgroupName = option.getFirstValue();
                continue;
            }
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == localVolumeName || null == remoteVolumeWWN || null == bitmapPoolName || null == constgroupName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionCreateRepsetInExistingGroup(errors, argContext, localVolumeName, sDomainName, remoteVolumeWWN, bitmapPoolName, constgroupName);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processCreateRepsetInExistingGroup");
        return result;
    }

    private CommandResult processModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext, int repType) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processModify";
        Trace.methodBegin((Object)this, (String)"processModify");
        String repName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        Integer mode = null;
        Boolean snapWithPrimary = null;
        Boolean autoSynchronize = null;
        Boolean snapBeforeSync = null;
        Integer timeCount = null;
        Integer queueAction = null;
        BigInteger blockCount = null;
        String queuePoolName = null;
        String newGroupName = null;
        String groupDesc = null;
        String queueSizeString = null;
        Integer role = null;
        Integer priority = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-m".equals(name) || "--mode".equals(name)) {
                mode = new Integer(CliUtilEWS.cvtReplicationMode(option.getFirstValue()));
                continue;
            }
            if ("-s".equals(name) || "--auto-sync".equals(name)) {
                autoSynchronize = new Boolean(CliUtilEWS.cvtEnableDisable(option.getFirstValue()));
                continue;
            }
            if ("-x".equals(name) || "--snap-with-primary".equals(name)) {
                snapWithPrimary = new Boolean(CliUtilEWS.cvtEnableDisable(option.getFirstValue()));
                continue;
            }
            if ("-p".equals(name) || "--snap-before-sync".equals(name)) {
                snapBeforeSync = new Boolean(CliUtilEWS.cvtEnableDisable(option.getFirstValue()));
                continue;
            }
            if ("-q".equals(name) || "--async-queue".equals(name)) {
                queuePoolName = option.getFirstValue();
                continue;
            }
            if ("-Q".equals(name) || "--queue-size".equals(name)) {
                queueSizeString = Convert.cleanUpAndUpcase((String)option.getFirstValue());
                continue;
            }
            if ("-u".equals(name) || "--full-queue".equals(name)) {
                queueAction = new Integer(CliUtilEWS.cvtReplicationQueueAction(option.getFirstValue()));
                continue;
            }
            if ("-k".equals(name) || "--queue-blocks".equals(name)) {
                blockCount = new BigInteger(option.getFirstValue());
                continue;
            }
            if ("-t".equals(name) || "--queue-time".equals(name)) {
                timeCount = new Integer(Integer.parseInt(option.getFirstValue()));
                continue;
            }
            if ("-N".equals(name) || "--new-name".equals(name)) {
                newGroupName = option.getFirstValue();
                continue;
            }
            if ("-d".equals(name) || "--description".equals(name)) {
                groupDesc = option.getFirstValue();
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-r".equals(name) || "--role".equals(name)) {
                role = new Integer(CliUtilEWS.cvtReplicationRole(option.getFirstValue()));
                continue;
            }
            if (!"-R".equals(name) && !"--replication-priority".equals(name)) continue;
            priority = new Integer(CliUtilEWS.cvtReplicationPriority(option.getFirstValue()));
        }
        ArrayList errors = new ArrayList();
        this.actionModify(errors, argContext, sDomainName, repName, repType, mode, snapWithPrimary, autoSynchronize, snapBeforeSync, blockCount, timeCount, queueAction, queuePoolName, queueSizeString, newGroupName, groupDesc, role, priority);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processModify");
        return result;
    }

    private CommandResult processSuspend(Locale locale, ParsedCommandLine pcl, SOAPContext argContext, int repType) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processSuspend";
        Trace.methodBegin((Object)this, (String)"processSuspend");
        String repName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        boolean fastStart = false;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-T".equals(name) || "--fast-start".equals(name)) {
                fastStart = true;
                continue;
            }
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == repName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionSuspend(errors, argContext, repName, sDomainName, fastStart, repType);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processSuspend");
        return result;
    }

    private CommandResult processResume(Locale locale, ParsedCommandLine pcl, SOAPContext argContext, int repType) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processResume";
        Trace.methodBegin((Object)this, (String)"processResume");
        String repName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        boolean full = false;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-F".equals(name) || "--full".equals(name)) {
                full = true;
                continue;
            }
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == repName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionResume(errors, argContext, repName, sDomainName, full, repType);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        Trace.methodEnd((Object)this, (String)"processResume");
        return result;
    }

    private void actionDeleteRepset(List errors, SOAPContext argContext, List repSetNames, String sDomainName) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionDeleteRepset";
        Trace.methodBegin((Object)this, (String)"actionDeleteRepset");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageReplicationServicesEnt1Interface repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
        ArrayList<ReplicationSetEnt1Interface> repSetList = new ArrayList<ReplicationSetEnt1Interface>();
        int n = repSetNames.size();
        for (int i = 0; i < n; ++i) {
            String repSetName = (String)repSetNames.get(i);
            ReplicationSetEnt1Interface repSet = repMgr.getReplicationSetByName(repSetName, sDomainName);
            if (null == repSet) {
                errors.add(new ErrorBean(repSetName, "error.objectNotFound", "15"));
                continue;
            }
            repSetList.add(repSet);
        }
        if (!repSetList.isEmpty()) {
            repMgr.delete(repSetList);
        }
        Trace.methodEnd((Object)this, (String)"actionDeleteRepset");
    }

    /*
     * Unable to fully structure code
     */
    private void actionCreateRepset(List errors, SOAPContext argContext, String localVolumeName, String sDomainName, String peerWWN, String remoteVolumeWWN, String bitmapPoolName, int role, int mode, boolean snapWithPrimary, boolean autoSynchronize, boolean snapBeforeSync, BigInteger blockCount, int timeCount, int queueAction, String queuePoolName, String groupName, String groupDesc, int priority, String queueSizeString) throws ConfigMgmtException, UnauthorizedException {
        block13: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    METHOD_NAME = "actionCreateRepset";
                                    Trace.methodBegin((Object)this, (String)"actionCreateRepset");
                                    if (2 != mode || null != queuePoolName) break block14;
                                    errors.add(new ErrorBean("", "error.repset.missingAsyncQ"));
                                    break block13;
                                }
                                if (CliUtilEWS.validateWWN16(errors, peerWWN) || CliUtilEWS.validateWWN(errors, remoteVolumeWWN)) break block13;
                                if (null == groupName) break block15;
                                if (!CliUtilEWS.validateName(errors, groupName) && (null == groupDesc || !CliUtilEWS.validateDesc(errors, groupDesc))) break block16;
                                break block13;
                            }
                            groupDesc = null;
                        }
                        cfgctx = this.getConfigContext(argContext);
                        volMgr = CliUtilEWS.getManageVolumeServices(cfgctx);
                        Trace.verbose((Object)this, (String)"actionCreateRepset", (String)"Done: getManageVolumeServices");
                        localVolume = null;
                        try {
                            localVolume = volMgr.getItemByName(localVolumeName, null, sDomainName);
                            Trace.verbose((Object)this, (String)"actionCreateRepset", (String)"Done: volume manager getItemByName");
                        }
                        catch (ItemNotFoundException infe) {
                            errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                            break block13;
                        }
                        if (null != localVolume) break block17;
                        errors.add(new ErrorBean(localVolumeName, "error.objectNotFound", "15"));
                        break block13;
                    }
                    if (CliUtilEWS.validateAlreadyReplicated(errors, localVolume)) break block13;
                    poolMgr = CliUtilEWS.getManagePoolServices(cfgctx);
                    Trace.verbose((Object)this, (String)"actionCreateRepset", (String)"Done: getManagePoolServices");
                    queuePool = null;
                    if (null == queuePoolName) break block18;
                    try {
                        queuePool = poolMgr.getItemByName(queuePoolName, sDomainName);
                        Trace.verbose((Object)this, (String)"actionCreateRepset", (String)"Done: pool manager getItemByName");
                    }
                    catch (ItemNotFoundException infe) {
                        errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                        break block13;
                    }
                    if (null != queuePool) break block18;
                    errors.add(new ErrorBean(queuePoolName, "error.objectNotFound", "15"));
                    break block13;
                }
                bitmapPool = null;
                try {
                    bitmapPool = poolMgr.getItemByName(bitmapPoolName, sDomainName);
                    Trace.verbose((Object)this, (String)"actionCreateRepset", (String)"Done: pool manager getItemByName");
                }
                catch (ItemNotFoundException infe) {
                    errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                    break block13;
                }
                if (null != bitmapPool) break block19;
                errors.add(new ErrorBean(bitmapPoolName, "error.objectNotFound", "15"));
                break block13;
            }
            repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
            Trace.verbose((Object)this, (String)"actionCreateRepset", (String)"Done: getManageReplicationServices");
            queueSize = BigInteger.ZERO;
            if (null == queueSizeString) ** GOTO lbl-1000
            queueSize = this.stringToBytes(queueSizeString);
            if (queueSize.compareTo(new BigInteger("-1")) == 0) {
                errors.add(new ErrorBean(queueSizeString, "cli.error.6920.replication.illegalQueueSizeFormat"));
            } else if (queueSize.compareTo(ConstantsEnt.StorageVolumeProperties.MIN_ASYNCQ_SIZE) < 0) {
                errors.add(new ErrorBean(queueSizeString, "cli.error.6920.replication.queueTooSmall"));
            } else lbl-1000:
            // 2 sources

            {
                repParams = repMgr.createReplicationParameters(role, mode, autoSynchronize, snapBeforeSync, snapWithPrimary, priority, 0, blockCount, timeCount, queueSize, queueAction);
                peerWWN = CliUtilEWS.stripColons(peerWWN);
                remoteVolumeWWN = CliUtilEWS.stripColons(remoteVolumeWWN);
                props = new Properties();
                props.put("LOCALVOLUME", localVolume);
                props.put("REMOTEPEERWWN", peerWWN);
                props.put("REMOVEVOLUMEWWN", remoteVolumeWWN);
                props.put("REPLICATIONPARAMS", repParams);
                props.put("BITMAPPOOL", bitmapPool);
                if (null != queuePool) {
                    props.put("ASYNCQUEUE", queuePool);
                }
                if (null != groupName) {
                    props.put("GROUPNAME", groupName);
                }
                if (null != groupDesc) {
                    props.put("GROUPDESCRIPTION", groupDesc);
                }
                repMgr.create(props);
                Trace.verbose((Object)this, (String)"actionCreateRepset", (String)"Done: replication manager create");
            }
        }
        Trace.methodEnd((Object)this, (String)"actionCreateRepset");
    }

    private void actionCreateRepsetInExistingGroup(List errors, SOAPContext argContext, String localVolumeName, String sDomainName, String remoteVolumeWWN, String bitmapPoolName, String constgroupName) throws ConfigMgmtException, UnauthorizedException {
        block12: {
            String METHOD_NAME = "actionCreateRepsetInExistingGroup";
            Trace.methodBegin((Object)this, (String)"actionCreateRepsetInExistingGroup");
            if (!CliUtilEWS.validateWWN(errors, remoteVolumeWWN)) {
                ConfigContext cfgctx = this.getConfigContext(argContext);
                ManageStorageVolumesInterface volMgr = CliUtilEWS.getManageVolumeServices(cfgctx);
                Trace.verbose((Object)this, (String)"actionCreateRepsetInExistingGroup", (String)"Done: getManageVolumeServices");
                StorageVolumeInterface localVolume = null;
                try {
                    localVolume = volMgr.getItemByName(localVolumeName, null, sDomainName);
                    Trace.verbose((Object)this, (String)"actionCreateRepsetInExistingGroup", (String)"Done: volume manager getItemByName");
                }
                catch (ItemNotFoundException infe) {
                    errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                    break block12;
                }
                if (null == localVolume) {
                    errors.add(new ErrorBean(localVolumeName, "error.objectNotFound", "15"));
                } else if (!CliUtilEWS.validateAlreadyReplicated(errors, localVolume)) {
                    ManageStoragePoolsInterface poolMgr = CliUtilEWS.getManagePoolServices(cfgctx);
                    Trace.verbose((Object)this, (String)"actionCreateRepsetInExistingGroup", (String)"Done: getManagePoolServices");
                    StoragePoolInterface bitmapPool = null;
                    try {
                        bitmapPool = poolMgr.getItemByName(bitmapPoolName, sDomainName);
                        Trace.verbose((Object)this, (String)"actionCreateRepsetInExistingGroup", (String)"Done: pool manager getItemByName");
                    }
                    catch (ItemNotFoundException infe) {
                        errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                        break block12;
                    }
                    if (null == bitmapPool) {
                        errors.add(new ErrorBean(bitmapPoolName, "error.objectNotFound", "15"));
                    } else {
                        ManageReplicationServicesEnt1Interface repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
                        Trace.verbose((Object)this, (String)"actionCreateRepsetInExistingGroup", (String)"Done: getManageReplicationServices");
                        ReplicationGroupEnt1Interface repGroup = repMgr.getReplicationGroupByName(constgroupName, sDomainName);
                        Trace.verbose((Object)this, (String)"actionCreateRepsetInExistingGroup", (String)"Done: getReplicationGroupByName");
                        if (null == repGroup) {
                            errors.add(new ErrorBean(constgroupName, "error.objectNotFound", "15"));
                        } else {
                            ReplicationParametersEnt1Interface repParams = repGroup.getReplicationParameters();
                            Trace.verbose((Object)this, (String)"actionCreateRepsetInExistingGroup", (String)"Done: getReplicationParameters");
                            remoteVolumeWWN = CliUtilEWS.stripColons(remoteVolumeWWN);
                            Properties props = new Properties();
                            props.put("LOCALVOLUME", localVolume);
                            props.put("REMOTEPEERWWN", CliUtilEWS.stripColons(repGroup.getPeerWwn()));
                            Trace.verbose((Object)this, (String)"actionCreateRepsetInExistingGroup", (String)"Done: getPeerWwn");
                            props.put("REMOVEVOLUMEWWN", remoteVolumeWWN);
                            props.put("BITMAPPOOL", bitmapPool);
                            props.put("REPLICATIONPARAMS", repParams);
                            props.put("REPLICATIONGROUP", repGroup);
                            repMgr.create(props);
                            Trace.verbose((Object)this, (String)"actionCreateRepsetInExistingGroup", (String)"Done: replication manager create");
                        }
                    }
                }
            }
        }
        Trace.methodEnd((Object)this, (String)"actionCreateRepsetInExistingGroup");
    }

    /*
     * Unable to fully structure code
     */
    private void actionSuspend(List errors, SOAPContext argContext, String repName, String sDomainName, boolean fastStart, int repType) throws UnauthorizedException, ConfigMgmtException {
        block6: {
            block5: {
                METHOD_NAME = "actionSuspend";
                Trace.methodBegin((Object)this, (String)"actionSuspend");
                cfgctx = this.getConfigContext(argContext);
                repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
                Trace.verbose((Object)this, (String)"actionSuspend", (String)"Done: getManageReplicationServices");
                repset = null;
                constgroup = null;
                if (repType != 1) break block5;
                repset = repMgr.getReplicationSetByName(repName, sDomainName);
                Trace.verbose((Object)this, (String)"actionSuspend", (String)"Done: getReplicationSetByName");
                if (null != repset) ** GOTO lbl-1000
                errors.add(new ErrorBean(repName, "error.objectNotFound", "15"));
                break block6;
            }
            if (repType != 0) ** GOTO lbl-1000
            constgroup = repMgr.getReplicationGroupByName(repName, sDomainName);
            Trace.verbose((Object)this, (String)"actionSuspend", (String)"Done: getReplicationGroupByName");
            if (null == constgroup) {
                errors.add(new ErrorBean(repName, "error.objectNotFound", "15"));
            } else if (null != repset) {
                repMgr.scoreboard((Object)repset.getKey(), fastStart);
                Trace.verbose((Object)this, (String)"actionSuspend", (String)"Done: scoreboard");
            } else if (null != constgroup) {
                repMgr.scoreboardReplicationGroup((Object)constgroup.getKey(), fastStart);
                Trace.verbose((Object)this, (String)"actionSuspend", (String)"Done: scoreboardReplicationGroup");
            }
        }
        Trace.methodEnd((Object)this, (String)"actionSuspend");
    }

    /*
     * Unable to fully structure code
     */
    private void actionResume(List errors, SOAPContext argContext, String repName, String sDomainName, boolean full, int repType) throws UnauthorizedException, ConfigMgmtException {
        block6: {
            block5: {
                METHOD_NAME = "actionResume";
                Trace.methodBegin((Object)this, (String)"actionResume");
                cfgctx = this.getConfigContext(argContext);
                repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
                Trace.verbose((Object)this, (String)"actionResume", (String)"Done: getManageReplicationServices");
                repset = null;
                constgroup = null;
                if (repType != 1) break block5;
                repset = repMgr.getReplicationSetByName(repName, sDomainName);
                Trace.verbose((Object)this, (String)"actionResume", (String)"Done: getReplicationSetByName");
                if (null != repset) ** GOTO lbl-1000
                errors.add(new ErrorBean(repName, "error.objectNotFound", "15"));
                break block6;
            }
            if (repType != 0) ** GOTO lbl-1000
            constgroup = repMgr.getReplicationGroupByName(repName, sDomainName);
            Trace.verbose((Object)this, (String)"actionResume", (String)"Done: getReplicationGroupByName");
            if (null == constgroup) {
                errors.add(new ErrorBean(repName, "error.objectNotFound", "15"));
            } else lbl-1000:
            // 3 sources

            {
                mcs = null;
                if (null != repset) {
                    mcs = repMgr.resync((Object)repset.getKey(), full);
                    Trace.verbose((Object)this, (String)"actionResume", (String)"Done: resync");
                } else if (null != constgroup) {
                    mcs = repMgr.resyncReplicationGroup((Object)constgroup.getKey(), full);
                    Trace.verbose((Object)this, (String)"actionResume", (String)"Done: resyncReplicationGroup");
                }
                CliUtilEWS.checkMCS(mcs, errors);
            }
        }
        Trace.methodEnd((Object)this, (String)"actionResume");
    }

    /*
     * Unable to fully structure code
     */
    private void actionModify(List errors, SOAPContext argContext, String sDomainName, String repName, int repType, Integer mode, Boolean snapWithPrimary, Boolean autoSynchronize, Boolean snapBeforeSync, BigInteger blockCount, Integer timeCount, Integer queueAction, String queuePoolName, String queueSizeString, String newGroupName, String groupDesc, Integer role, Integer priority) throws ConfigMgmtException, UnauthorizedException {
        block31: {
            block39: {
                block38: {
                    block36: {
                        block37: {
                            block35: {
                                block34: {
                                    block32: {
                                        block33: {
                                            METHOD_NAME = "actionModify";
                                            Trace.methodBegin((Object)this, (String)"actionModify");
                                            cfgctx = this.getConfigContext(argContext);
                                            repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
                                            Trace.verbose((Object)this, (String)"actionModify", (String)"Done: getManageReplicationServices");
                                            repset = null;
                                            constgroup = null;
                                            currentQueuePool = null;
                                            currentQueueSize = null;
                                            currentMode = -1;
                                            if (1 != repType) break block32;
                                            repset = repMgr.getReplicationSetByName(repName, sDomainName);
                                            Trace.verbose((Object)this, (String)"actionModify", (String)"Done: getReplicationSetByName");
                                            if (null != repset) break block33;
                                            errors.add(new ErrorBean(repName, "error.objectNotFound", "15"));
                                            break block31;
                                        }
                                        constgroup = repset.getReplicationGroup();
                                        Trace.verbose((Object)this, (String)"actionModify", (String)"Done: getReplicationGroup");
                                        if (null == constgroup) break block34;
                                        repset = null;
                                        break block34;
                                    }
                                    if (0 != repType) break block34;
                                    constgroup = repMgr.getReplicationGroupByName(repName, sDomainName);
                                    Trace.verbose((Object)this, (String)"actionModify", (String)"Done: getReplicationGroupByName");
                                    if (null != constgroup) break block34;
                                    errors.add(new ErrorBean(repName, "error.objectNotFound", "15"));
                                    break block31;
                                }
                                if (null != constgroup) {
                                    currentMode = constgroup.getReplicationParameters().getSyncMode();
                                    Trace.verbose((Object)this, (String)"actionModify", (String)"Done: getSyncMode");
                                    queueVolume = constgroup.getAsyncQStorage();
                                    Trace.verbose((Object)this, (String)"actionModify", (String)"Done: getAsyncQStorage");
                                    if (null != queueVolume) {
                                        currentQueuePool = queueVolume.getStoragePool();
                                        Trace.verbose((Object)this, (String)"actionModify", (String)"Done: volume getStoragePool");
                                        currentQueueSize = constgroup.getAsyncQueueSize();
                                    }
                                } else if (null != repset) {
                                    currentMode = repset.getReplicationParameters().getSyncMode();
                                    Trace.verbose((Object)this, (String)"actionModify", (String)"Done: getSyncMode");
                                    queueVdisk = repset.getAsyncQStorage();
                                    Trace.verbose((Object)this, (String)"actionModify", (String)"Done: getAsyncQStorage");
                                    if (null != queueVdisk) {
                                        currentQueuePool = queueVdisk.getStoragePool();
                                        currentQueueSize = repset.getAsyncQueueSize();
                                    }
                                }
                                if (null == currentQueuePool || null == queuePoolName) break block35;
                                errors.add(new ErrorBean("", "cli.error.6920.replication.noNewQueueAllowed"));
                                break block31;
                            }
                            if (null == mode || 2 != mode || currentMode == mode || null != currentQueuePool) break block36;
                            if (null != queuePoolName) break block37;
                            errors.add(new ErrorBean("", "error.repset.missingAsyncQ"));
                            break block31;
                        }
                        if (null == timeCount) {
                            timeCount = new Integer(0);
                        }
                        if (null == blockCount) {
                            blockCount = BigInteger.ZERO;
                        }
                    }
                    poolMgr = CliUtilEWS.getManagePoolServices(cfgctx);
                    Trace.verbose((Object)this, (String)"actionModify", (String)"Done: getManagePoolServices");
                    queuePool = null;
                    if (null == queuePoolName) break block38;
                    try {
                        queuePool = poolMgr.getItemByName(queuePoolName, sDomainName);
                        Trace.verbose((Object)this, (String)"actionModify", (String)"Done: pool manager getItemByName");
                    }
                    catch (ItemNotFoundException infe) {
                        errors.add(new ErrorBean(sDomainName, "error.objectNotFound", "15"));
                        break block31;
                    }
                    if (null != queuePool) break block38;
                    errors.add(new ErrorBean(queuePoolName, "error.objectNotFound", "15"));
                    break block31;
                }
                props = new Properties();
                if (null != snapWithPrimary) {
                    props.put("SNAPSECONDARY", snapWithPrimary);
                }
                if (null != autoSynchronize) {
                    props.put("AUTOSYNC", autoSynchronize);
                }
                if (null != snapBeforeSync) {
                    props.put("SNAPBEFORESYNC", snapBeforeSync);
                }
                if (null != mode) {
                    props.put("MODE", mode);
                }
                if (null == queueSizeString) ** GOTO lbl115
                queueSize = this.stringToBytes(queueSizeString);
                if (queueSize.compareTo(new BigInteger("-1")) != 0) break block39;
                errors.add(new ErrorBean(queueSizeString, "cli.error.6920.replication.illegalQueueSizeFormat"));
                break block31;
            }
            if (queueSize.compareTo(BigInteger.ZERO) <= 0) ** GOTO lbl-1000
            if (null != currentQueueSize && queueSize.compareTo(currentQueueSize) <= 0) {
                errors.add(new ErrorBean(queueSizeString, "cli.error.6920.replication.queueExpandSizeTooSmall"));
            } else if (queueSize.compareTo(ConstantsEnt.StorageVolumeProperties.MIN_ASYNCQ_SIZE) < 0) {
                errors.add(new ErrorBean(queueSizeString, "cli.error.6920.replication.queueTooSmall"));
            } else lbl-1000:
            // 2 sources

            {
                props.put("QUEUESIZE", queueSize);
lbl115:
                // 2 sources

                if (null != currentQueuePool) {
                    props.put("ASYNCQUEUE", currentQueuePool);
                } else if (null != queuePool) {
                    props.put("ASYNCQUEUE", queuePool);
                }
                if (null != queueAction) {
                    props.put("QUEUEACTION", queueAction);
                }
                if (null != blockCount) {
                    props.put("QUEUEBLOCKCOUNT", blockCount);
                }
                if (null != timeCount) {
                    props.put("QUEUETIME", timeCount);
                }
                if (null != role) {
                    props.put("ROLE", role);
                }
                if (null != priority) {
                    props.put("PRIORITY", priority);
                }
                if (null != constgroup) {
                    if (null != newGroupName) {
                        props.put("NAME", newGroupName);
                    }
                    if (null != groupDesc) {
                        props.put("DESCRIPTION", groupDesc);
                    }
                }
                if (null != repset) {
                    repMgr.modify((Object)repset, props);
                    Trace.verbose((Object)this, (String)"actionModify", (String)"Done: modify");
                } else if (null != constgroup) {
                    repMgr.modify((Object)constgroup, props);
                    Trace.verbose((Object)this, (String)"actionModify", (String)"Done: modify");
                }
            }
        }
        Trace.methodEnd((Object)this, (String)"actionModify");
    }

    private List buildBeanList(SOAPContext argContext, List repSetNames, String sDomainName) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "buildBeanList";
        Trace.methodBegin((Object)this, (String)"buildBeanList");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageReplicationServicesEnt1Interface repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
        Trace.verbose((Object)this, (String)"buildBeanList", (String)"Done: getManageReplicationServices");
        Vector<RepsetProps> result = new Vector<RepsetProps>();
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        if (null == repSetNames || repSetNames.isEmpty()) {
            List allRepSets = repMgr.getReplicationSetList();
            Trace.verbose((Object)this, (String)"buildBeanList", (String)"Done: getReplicationSetList");
            if (null == allRepSets) {
                Trace.methodEnd((Object)this, (String)"buildBeanList");
                return result;
            }
            int j = allRepSets.size();
            for (int i = 0; i < j; ++i) {
                result.add(this.buildBean((ReplicationSetEnt1Interface)allRepSets.get(i), false));
                Trace.verbose((Object)this, (String)"buildBeanList", (String)"Done: buildBean");
            }
        } else {
            int j = repSetNames.size();
            for (int i = 0; i < j; ++i) {
                String repSetName = (String)repSetNames.get(i);
                ReplicationSetEnt1Interface repSet = repMgr.getReplicationSetByName(repSetName, sDomainName);
                Trace.verbose((Object)this, (String)"buildBeanList", (String)"Done: getReplicationSetByName");
                if (null == repSet) {
                    errors.add(new ErrorBean(repSetName, "error.objectNotFound", "15"));
                    continue;
                }
                result.add(this.buildBean(repSet, true));
                Trace.verbose((Object)this, (String)"buildBeanList", (String)"Done: buildBean");
            }
            result.addAll(errors);
        }
        Trace.methodEnd((Object)this, (String)"buildBeanList");
        return result;
    }

    private RepsetProps buildBean(ReplicationSetEnt1Interface repset, boolean showDetails) throws ConfigMgmtException {
        String METHOD_NAME = "buildBean";
        Trace.methodBegin((Object)this, (String)"buildBean");
        RepsetProps rsp = new RepsetProps();
        rsp.setRepsetName(repset.getName());
        rsp.setShowDetails(showDetails);
        StorageVolumeInterface svi = repset.getLocalVolume();
        Trace.verbose((Object)this, (String)"buildBean", (String)"Done: repset getLocalVolume");
        rsp.setLocalVolumeName(svi.getName());
        rsp.setStorageDomain(svi.getStorageDomainName());
        ReplicationGroupEnt1Interface repGroup = repset.getReplicationGroup();
        Trace.verbose((Object)this, (String)"buildBean", (String)"Done: repset getReplicationGroup");
        if (null == repGroup) {
            rsp.setRepgroupName(" ");
        } else {
            rsp.setRepgroupName(repGroup.getName());
        }
        if (showDetails) {
            ReplicationParametersEnt1Interface params = repset.getReplicationParameters();
            Trace.verbose((Object)this, (String)"buildBean", (String)"Done: getReplicationParameters");
            rsp.setMode(params.getSyncMode());
            rsp.setRole(params.getRole());
            rsp.setReplicationPriority(params.getPriority());
            rsp.setPeerWWN(repset.getPeerWwn());
            Trace.verbose((Object)this, (String)"buildBean", (String)"Done: repset getPeerWwn");
            rsp.setRemoteVolumeWWN(repset.getRemoteVolumeWwn());
            rsp.setAutoSync(params.isAutoSync());
            rsp.setSnapBeforeSync(params.isSnapBeforeSync());
            rsp.setSnapWithPrimary(params.isSnapWithPrimary());
            rsp.setBitmapPoolSize(SizeConvert.bytesStringToDisplayValue((String)repset.getBitmapSize().toString()).toString());
            String bitmapPool = " ";
            VDiskEnt1Interface vDisk = repset.getBitmapVDisk();
            Trace.verbose((Object)this, (String)"buildBean", (String)"Done: repset getBitmapVDisk");
            if (vDisk != null) {
                bitmapPool = vDisk.getStoragePoolName();
            }
            rsp.setBitmapPoolName(bitmapPool);
            String asyncQPool = " ";
            String asyncQSize = " ";
            Object asyncQobj = null;
            asyncQobj = null == repGroup ? repset.getAsyncQStorage() : repGroup.getAsyncQStorage();
            Trace.verbose((Object)this, (String)"buildBean", (String)"Done: repset getAsyncQStorage");
            if (asyncQobj != null) {
                if (asyncQobj instanceof StorageVolumeInterface) {
                    StorageVolumeInterface vol = (StorageVolumeInterface)asyncQobj;
                    asyncQPool = vol.getStoragePoolName();
                    asyncQSize = SizeConvert.bytesStringToDisplayValue((String)String.valueOf(vol.getCapacity())).toString();
                } else if (asyncQobj instanceof VDiskEnt1Interface) {
                    VDiskEnt1Interface vdisk = asyncQobj;
                    asyncQPool = vdisk.getStoragePoolName();
                    asyncQSize = SizeConvert.bytesStringToDisplayValue((String)String.valueOf(repset.getAsyncQueueSize())).toString();
                }
            }
            rsp.setQueuePoolName(asyncQPool);
            rsp.setQueueSize(asyncQSize);
            rsp.setQueueFullAction(params.getAsyncQAction());
            rsp.setQueueBlockCount(params.getAsyncQBlockCount());
            rsp.setQueueTimeCount(params.getAsyncQTimeCount());
            rsp.setState(repset.getState());
            Trace.verbose((Object)this, (String)"buildBean", (String)"Done: repset getState");
            rsp.setResyncProgress(repset.getSyncProgress());
            Trace.verbose((Object)this, (String)"buildBean", (String)"Done: repset getSyncProgress");
            rsp.setErrorStatus(repset.getErrorStatus());
            rsp.setRepQueueDisplayed(asyncQobj != null);
            rsp.setWWN(repset.getSetWwn());
        }
        Trace.methodEnd((Object)this, (String)"buildBean");
        return rsp;
    }

    private BigInteger stringToBytes(String size) {
        Pattern sizePattern = null;
        Matcher sizeMatch = null;
        BigDecimal unitMultiplier = null;
        BigDecimal decimalValue = null;
        BigInteger sizeInBytes = BigInteger.ZERO;
        sizePattern = Pattern.compile("\\s*(\\d{1}(?:.\\d{0,4}))\\s*T{1}B?\\s*", 2);
        sizeMatch = sizePattern.matcher(size);
        if (sizeMatch.matches()) {
            decimalValue = new BigDecimal(sizeMatch.group(1));
            unitMultiplier = Constants.StorageSize.ONE_TB;
        } else {
            sizePattern = Pattern.compile("\\s*(\\d{1,4}(?:.\\d{0,4}))\\s*G{1}B?\\s*", 2);
            sizeMatch = sizePattern.matcher(size);
            if (sizeMatch.matches()) {
                decimalValue = new BigDecimal(sizeMatch.group(1));
                sizeInBytes = sizeInBytes.multiply(Constants.StorageSize.ONE_GB.toBigInteger());
                unitMultiplier = Constants.StorageSize.ONE_GB;
            } else {
                sizePattern = Pattern.compile("\\s*(\\d{1,7}(?:.\\d{0,4}))\\s*M{1}B?\\s*", 2);
                sizeMatch = sizePattern.matcher(size);
                if (sizeMatch.matches()) {
                    decimalValue = new BigDecimal(sizeMatch.group(1));
                    unitMultiplier = Constants.StorageSize.ONE_MB;
                } else {
                    sizePattern = Pattern.compile("\\s*(\\d{1,10})\\s*K{1}B?\\s*", 2);
                    sizeMatch = sizePattern.matcher(size);
                    if (sizeMatch.matches()) {
                        decimalValue = new BigDecimal(sizeMatch.group(1));
                        unitMultiplier = Constants.StorageSize.ONE_KB;
                    }
                }
            }
        }
        if (null == decimalValue) {
            return new BigInteger("-1");
        }
        try {
            decimalValue = decimalValue.multiply(unitMultiplier);
            decimalValue = decimalValue.setScale(0, 4);
            sizeInBytes = decimalValue.toBigInteger();
        }
        catch (NumberFormatException nfe) {
            return new BigInteger("-1");
        }
        return sizeInBytes;
    }
}

