/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.RepgroupProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationGroupEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationParametersEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationSetEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.soap.rpc.SOAPContext;

public class RepgroupEWS
extends CommandProcessorBase {
    private static final int ADD = 0;
    private static final int REMOVE = 1;

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        List repGroupNamesList = pcl.getResource().getValues();
        String sDomainName = "DEFAULT";
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        List repSetBeansList = this.buildBeanList(argContext, repGroupNamesList, sDomainName);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, repSetBeansList);
        return result;
    }

    protected CommandResult doDelete(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doDelete";
        Trace.methodBegin((Object)this, (String)"doDelete");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        List constgroupNamesList = pcl.getResource().getValues();
        String sDomainName = "DEFAULT";
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == constgroupNamesList || constgroupNamesList.isEmpty()) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionDeleteRepgroup(errors, argContext, constgroupNamesList, sDomainName);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected CommandResult doAdd(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doAdd";
        Trace.methodBegin((Object)this, (String)"doAdd");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = this.processAddRemove(locale, pcl, argContext, 0);
        return result;
    }

    protected CommandResult doRemove(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doRemove";
        Trace.methodBegin((Object)this, (String)"doRemove");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = this.processAddRemove(locale, pcl, argContext, 1);
        return result;
    }

    private CommandResult processAddRemove(Locale locale, ParsedCommandLine pcl, SOAPContext argContext, int action) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processAddRemove";
        Trace.methodBegin((Object)this, (String)"processAddRemove");
        String constgroupName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        String repsetName = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if (!"-r".equals(name) && !"--repset".equals(name)) continue;
            repsetName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == constgroupName || null == repsetName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionAddRemoveRepsetToFromRepgroup(errors, argContext, constgroupName, repsetName, sDomainName, action);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private void actionDeleteRepgroup(List errors, SOAPContext argContext, List constgroupNames, String sDomainName) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionDeleteRepgroup";
        Trace.methodBegin((Object)this, (String)"actionDeleteRepgroup");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageReplicationServicesEnt1Interface repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
        int n = constgroupNames.size();
        for (int i = 0; i < n; ++i) {
            String constgroupName = (String)constgroupNames.get(i);
            ReplicationGroupEnt1Interface constgroup = null;
            constgroup = repMgr.getReplicationGroupByName(constgroupName, sDomainName);
            if (null == constgroup) {
                errors.add(new ErrorBean(constgroupName, "error.objectNotFound"));
                continue;
            }
            try {
                repMgr.deleteReplicationGroup((Object)constgroup.getKey());
                continue;
            }
            catch (ConfigMgmtException cme) {
                errors.add(new ErrorBean("", cme));
            }
        }
    }

    private void actionAddRemoveRepsetToFromRepgroup(List errors, SOAPContext argContext, String constgroupName, String repsetName, String sDomainName, int action) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionAddRepsetToRepgroup";
        Trace.methodBegin((Object)this, (String)"actionAddRepsetToRepgroup");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageReplicationServicesEnt1Interface repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
        ReplicationGroupEnt1Interface constgroup = null;
        constgroup = repMgr.getReplicationGroupByName(constgroupName, sDomainName);
        if (null == constgroup) {
            errors.add(new ErrorBean(constgroupName, "error.objectNotFound", "15"));
            return;
        }
        ReplicationSetEnt1Interface repset = null;
        repset = repMgr.getReplicationSetByName(repsetName, sDomainName);
        if (null == repset) {
            errors.add(new ErrorBean(repsetName, "error.objectNotFound", "15"));
            return;
        }
        Properties props = new Properties();
        if (0 == action) {
            props.put("REPGROUP", constgroup);
            repMgr.modify((Object)repset, props);
        } else {
            props.put("REPSET", repset);
            repMgr.modify((Object)constgroup, props);
        }
    }

    private List buildBeanList(SOAPContext argContext, List repGroupNames, String sDomainName) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "buildBeanList";
        Trace.methodBegin((Object)this, (String)"buildBeanList");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageReplicationServicesEnt1Interface repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
        ArrayList<RepgroupProps> result = new ArrayList<RepgroupProps>();
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == repGroupNames || repGroupNames.isEmpty()) {
            List allRepGroups = repMgr.getReplicationGroupList();
            if (null == allRepGroups) {
                return result;
            }
            int j = allRepGroups.size();
            for (int i = 0; i < j; ++i) {
                ReplicationGroupEnt1Interface repGroup = (ReplicationGroupEnt1Interface)allRepGroups.get(i);
                result.add(this.buildBean(repGroup, false));
            }
        } else {
            int j = repGroupNames.size();
            for (int i = 0; i < j; ++i) {
                String repGroupName = (String)repGroupNames.get(i);
                ReplicationGroupEnt1Interface repGroup = repMgr.getReplicationGroupByName(repGroupName, sDomainName);
                if (null == repGroup) {
                    errors.add(new ErrorBean(repGroupName, "error.objectNotFound"));
                    continue;
                }
                result.add(this.buildBean(repGroup, true));
            }
        }
        result.addAll(errors);
        return result;
    }

    private RepgroupProps buildBean(ReplicationGroupEnt1Interface repGroup, boolean showDetails) throws ConfigMgmtException {
        String METHOD_NAME = "buildBean";
        Trace.methodBegin((Object)this, (String)"buildBean");
        List allRepSets = repGroup.getReplicationSets();
        ReplicationSetEnt1Interface repSet = (ReplicationSetEnt1Interface)allRepSets.get(0);
        RepgroupProps rgp = new RepgroupProps();
        rgp.setConstgroupName(repGroup.getName());
        rgp.setShowDetails(showDetails);
        rgp.setStorageDomain(repSet.getLocalVolume().getStorageDomainName());
        rgp.setPeerWWN(repGroup.getPeerWwn());
        if (showDetails) {
            ReplicationParametersEnt1Interface params = repGroup.getReplicationParameters();
            rgp.setMode(params.getSyncMode());
            rgp.setRole(params.getRole());
            rgp.setReplicationPriority(params.getPriority());
            rgp.setAutoSync(params.isAutoSync());
            rgp.setSnapBeforeSync(params.isSnapBeforeSync());
            rgp.setSnapWithPrimary(params.isSnapWithPrimary());
            String asyncQPool = " ";
            String asyncQSize = " ";
            StorageVolumeEnt1Interface asyncQobj = repGroup.getAsyncQStorage();
            if (asyncQobj != null) {
                if (asyncQobj instanceof StorageVolumeInterface) {
                    StorageVolumeInterface vol = (StorageVolumeInterface)asyncQobj;
                    asyncQPool = vol.getStoragePoolName();
                    asyncQSize = SizeConvert.bytesStringToDisplayValue((String)String.valueOf(vol.getCapacity())).toString();
                } else if (asyncQobj instanceof VDiskEnt1Interface) {
                    VDiskEnt1Interface vdisk = (VDiskEnt1Interface)asyncQobj;
                    asyncQPool = vdisk.getStoragePoolName();
                    asyncQSize = SizeConvert.bytesStringToDisplayValue((String)String.valueOf(repGroup.getAsyncQueueSize())).toString();
                }
            }
            rgp.setQueuePoolName(asyncQPool);
            rgp.setQueueSize(asyncQSize);
            rgp.setQueueFullAction(params.getAsyncQAction());
            rgp.setQueueBlockCount(params.getAsyncQBlockCount());
            rgp.setQueueTimeCount(params.getAsyncQTimeCount());
            rgp.setRepsetList(allRepSets);
            rgp.setDesc(repGroup.getDescription());
            rgp.setGrpQueueDisplayed(asyncQobj != null);
            rgp.setWWN(repGroup.getGroupWwn());
        }
        return rgp;
    }
}

