/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ProfilePropsS1;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.DSPMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageProfileParameters;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.FilteringResult;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class ProfileEWS
extends CommandProcessorBase {
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS;

    private ProfilePropsS1 buildBean(StorageProfileInterface spi, boolean showDetails) throws ConfigMgmtException, Exception {
        ProfilePropsS1 pp = new ProfilePropsS1();
        pp.setShowDetails(showDetails);
        pp.setName(spi.getName());
        if (showDetails) {
            pp.setDescription(spi.getDescription());
            pp.setRaidLevel(spi.getRAIDLevel());
            pp.setSegmentSize(spi.getSegmentSize());
            pp.setReadAhead(spi.isReadAheadEnabled());
            pp.setNumberOfDrives(spi.getNumberOfDisks());
            pp.setArrayType(spi.getArrayType());
            pp.setVirtStrategy(spi.getVirtualizationStrategy());
            if (pp.getVirtStrategy().equals("stripe")) {
                pp.setStripeSize(spi.getStripeSize());
            }
            pp.setDedicatedHotSpare(spi.dedicatedSpareExists());
            pp.setInUse(spi.isInUse());
            pp.setFactoryProfile(spi.isFactoryProfile());
        }
        return pp;
    }

    private Vector createProfilePropsList(List profileList, boolean showDetails) throws Exception {
        Vector<ProfilePropsS1> propsList = new Vector<ProfilePropsS1>();
        Iterator relevantProfilesIterator = profileList.iterator();
        while (relevantProfilesIterator.hasNext()) {
            StorageProfileInterface profile = (StorageProfileInterface)relevantProfilesIterator.next();
            propsList.add(this.buildBean(profile, showDetails));
        }
        return propsList;
    }

    protected List list(SOAPContext argContext, List profileNames) throws Exception {
        String METHOD_NAME = "list";
        Trace.methodBegin((Object)this, (String)"list");
        ManageStorageProfilesInterface mspi = null;
        Object spi = null;
        mspi = ManageStorageProfilesFactory.getManager();
        if (mspi == null) {
            Trace.verbose((Object)this, (String)"list", (String)"ManageStorageProfilesInterface is null");
            throw new ConfigMgmtException("error.bolMgr.noProfMgr", "");
        }
        mspi.init(this.getConfigContext(argContext), null);
        Trace.verbose((Object)this, (String)"list", (String)"mspi.init() done");
        ArrayList allProfiles = null;
        allProfiles = mspi.getItemsBySystem();
        Trace.verbose((Object)this, (String)"list", (String)("-:-allProfiles" + allProfiles));
        FilteringResult fr = FilterUtil.filterNamedObjects((List)profileNames, (List)allProfiles, (NameBasedComparator)BOComparators.PROFILE_COMPARATOR);
        Trace.verbose((Object)this, (String)"list", (String)("-:-FR" + fr));
        Vector result = profileNames == null || profileNames.isEmpty() ? this.createProfilePropsList(allProfiles, false) : this.createProfilePropsList(fr.getFoundItems(), true);
        if (fr.hasNotFoundItems()) {
            List notFoundItems = fr.getNotFoundItems();
            for (int i = 0; i < notFoundItems.size(); ++i) {
                result.add(new ErrorBean((String)notFoundItems.get(i), "error.objectNotFound"));
            }
        }
        return result;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        List profileNames = pcl.getResource().getValues();
        List profiles = this.list(argContext, profileNames);
        this.processResults(locale, result, profiles);
        return result;
    }

    protected List create(SOAPContext argContext, String sRaidLevel, String sArrayType, String sSegsize, String sReadahead, String sNumberOfDisks, String sVirtStrategy, String sStripeSize, String sDedicatedHotSpare, String sDescription, String profileName) throws UnauthorizedException, ConfigMgmtException {
        String empty;
        String METHOD_NAME = "create";
        Trace.methodBegin((Object)this, (String)"create");
        ArrayList errors = new ArrayList();
        boolean addResult = false;
        ManageStorageProfilesInterface mspi = null;
        mspi = ManageStorageProfilesFactory.getManager();
        if (mspi == null) {
            Trace.verbose((Object)this, (String)"create", (String)"ManageStorageProfilesInterface is null");
            throw new ConfigMgmtException("error.bolMgr.noProfMgr", "");
        }
        mspi.init(this.getConfigContext(argContext), null);
        Trace.verbose((Object)this, (String)"create", (String)"mspi.init() done");
        if (Trace.isTraceEnabled((Object)this)) {
            empty = "empty";
            Trace.verbose((Object)this, (String)"create", (String)("args: sArrayType " + (sArrayType == null ? empty : sArrayType) + " sDescription " + (sDescription == null ? empty : sDescription) + " sDedicatedHotSpare " + (sDedicatedHotSpare == null ? empty : sDedicatedHotSpare) + " profileName " + (profileName == null ? empty : profileName) + " sNumberOfDisks " + (sNumberOfDisks == null ? empty : sNumberOfDisks) + " sRaidLevel " + (sRaidLevel == null ? empty : sRaidLevel) + " sReadahead " + (sReadahead == null ? empty : sReadahead) + " sSegsize " + (sSegsize == null ? empty : sSegsize) + " sStripeSize " + (sStripeSize == null ? empty : sStripeSize) + " sVirtStrategy " + (sVirtStrategy == null ? empty : sVirtStrategy) + "\n"));
        }
        if (Trace.isTraceEnabled((Object)this)) {
            empty = "empty";
            Trace.verbose((Object)this, (String)"create", (String)("args xformed: sArrayType " + this.cvtArrayType(sArrayType) + " sDescription " + sDescription + " sDedicatedHotSpare " + this.cvtHotSpare(sDedicatedHotSpare) + " profileName " + profileName + " sNumberOfDisks " + this.cvtNumberOfDisks(sNumberOfDisks) + " sRaidLevel " + this.cvtRaidLevel(sRaidLevel) + " sReadahead " + this.cvtReadAhead(sReadahead) + " sSegsize " + this.cvtSegmentSize(sSegsize) + " sStripeSize " + this.cvtStripeSize(sStripeSize) + " sVirtStrategy " + this.cvtVirtStrategy(sVirtStrategy) + "\n"));
        }
        StorageProfileParameters params = new StorageProfileParameters();
        params.setArrayType(this.cvtArrayType(sArrayType));
        params.setDescription(sDescription);
        params.setHotSpare(this.cvtHotSpare(sDedicatedHotSpare));
        params.setName(profileName);
        params.setNumDisks(this.cvtNumberOfDisks(sNumberOfDisks));
        params.setRaidLevel(this.cvtRaidLevel(sRaidLevel));
        params.setReadAhead(this.cvtReadAhead(sReadahead));
        params.setSegmentSize(this.cvtSegmentSize(sSegsize));
        params.setStripeSize(this.cvtStripeSize(sStripeSize));
        params.setVirtType(this.cvtVirtStrategy(sVirtStrategy));
        MethodCallStatus mcs = null;
        mcs = mspi.createStorageProfile(params);
        CliUtilEWS.checkMCS(mcs, errors);
        return errors;
    }

    protected List createLegacyProfile(SOAPContext argContext, String sDescription, String profileName) throws ConfigMgmtException, DSPMgmtException, Exception {
        String METHOD_NAME = "createLegacyProfile";
        Trace.methodBegin((Object)this, (String)"createLegacyProfile");
        return this.create(argContext, "0", "bandwidth", "64K", "on", "variable", "legacy", "1M", "no", sDescription, profileName);
    }

    protected CommandResult doCreate(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = new CommandResult();
        String METHOD_NAME = "doCreate";
        Trace.methodBegin((Object)this, (String)"doCreate");
        String sRaidLevel = null;
        String sArrayType = null;
        String sSegsize = null;
        String sReadahead = null;
        String sNumberOfDisks = null;
        String sVirtStrategy = null;
        String sStripeSize = null;
        String sDedicatedHotSpare = null;
        String sDescription = null;
        String profileName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        List errors = null;
        if ("legacy".equals(pcl.getOptionListName())) {
            for (int i = 0; i < options.size(); ++i) {
                Option option = (Option)options.get(i);
                if (!"-d".equals(option.getName()) && !"--description".equals(option.getName())) continue;
                sDescription = option.getFirstValue();
            }
            errors = this.createLegacyProfile(argContext, sDescription, profileName);
            this.processResults(locale, result, errors);
            return result;
        }
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-r".equals(option.getName()) || "--raid-level".equals(option.getName())) {
                sRaidLevel = option.getFirstValue();
                continue;
            }
            if ("-t".equals(option.getName()) || "--array-type".equals(option.getName())) {
                sArrayType = option.getFirstValue();
                continue;
            }
            if ("-s".equals(option.getName()) || "--segsize".equals(option.getName())) {
                sSegsize = option.getFirstValue();
                continue;
            }
            if ("-h".equals(option.getName()) || "--readahead".equals(option.getName())) {
                sReadahead = option.getFirstValue();
                continue;
            }
            if ("-n".equals(option.getName()) || "--number-of-disks".equals(option.getName())) {
                sNumberOfDisks = option.getFirstValue();
                continue;
            }
            if ("-v".equals(option.getName()) || "--virt-strategy".equals(option.getName())) {
                sVirtStrategy = option.getFirstValue();
                continue;
            }
            if ("-p".equals(option.getName()) || "--stripe-size".equals(option.getName())) {
                sStripeSize = option.getFirstValue();
                continue;
            }
            if ("-D".equals(option.getName()) || "--dedicated-hot-spare".equals(option.getName())) {
                sDedicatedHotSpare = option.getFirstValue();
                continue;
            }
            if (!"-d".equals(option.getName()) && !"--description".equals(option.getName())) continue;
            sDescription = option.getFirstValue();
        }
        if (this.cvtVirtStrategy(sVirtStrategy) == 1 && sStripeSize == null) {
            throw new BadParameterException(sVirtStrategy, "error.profile.create.haveStripe");
        }
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS = ProfileEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.ProfileEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS = ProfileEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.ProfileEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS), (String)"doCreate", (String)("sVirtStrategy " + sVirtStrategy + " iVirtStrategy " + Integer.toString(this.cvtVirtStrategy(sVirtStrategy)) + " sStripeSize " + sStripeSize));
        }
        if (this.cvtVirtStrategy(sVirtStrategy) == 0 && sStripeSize != null) {
            throw new BadParameterException(sVirtStrategy, "error.profile.create.noStripe");
        }
        errors = this.create(argContext, sRaidLevel, sArrayType, sSegsize, sReadahead, sNumberOfDisks, sVirtStrategy, sStripeSize, sDedicatedHotSpare, sDescription, profileName);
        this.processResults(locale, result, errors);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List delete(SOAPContext argContext, List profileNames) throws ConfigMgmtException, ItemNotFoundException, Exception {
        String METHOD_NAME = "delete";
        Trace.methodBegin((Object)this, (String)"delete");
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        boolean addResult = false;
        ManageStorageProfilesInterface mspi = null;
        mspi = ManageStorageProfilesFactory.getManager();
        if (mspi == null) {
            Trace.verbose((Object)this, (String)"delete", (String)"ManageStorageProfilesInterface is null");
            throw new ConfigMgmtException("error.bolMgr.noProfMgr", "");
        }
        mspi.init(this.getConfigContext(argContext), null);
        Trace.verbose((Object)this, (String)"delete", (String)"mspi.init() done");
        if (profileNames.size() != 0) {
            Iterator e = profileNames.iterator();
            String sProfileName = null;
            StorageProfileInterface spi = null;
            while (e.hasNext()) {
                block17: {
                    sProfileName = (String)e.next();
                    try {
                        spi = mspi.getItemByName(sProfileName);
                    }
                    catch (ConfigMgmtException ex) {
                        Trace.error((Object)this, (String)"delete", (String)("ItemNotFoundException: " + ex.toString() + "\n"));
                        addResult = errors.add(new ErrorBean(sProfileName, "error.objectNotFound"));
                        continue;
                    }
                    if (spi == null) {
                        addResult = errors.add(new ErrorBean(sProfileName, "error.objectNotFound"));
                        continue;
                    }
                    try {
                        if (spi.isInUse()) {
                            addResult = errors.add(new ErrorBean(sProfileName, "error.profile.delete.profileInUse"));
                        }
                        break block17;
                    }
                    catch (ConfigMgmtException ex) {
                        Trace.error((Object)this, (String)"delete", (String)("ConfigMgmtException: " + ex.toString() + "\n"));
                        addResult = errors.add(new ErrorBean(sProfileName, "error.profile.delete.profileInUse"));
                    }
                    continue;
                }
                if (spi.isFactoryProfile()) {
                    Trace.error((Object)this, (String)"delete", (String)"Profile is factory, not deleting\n");
                    addResult = errors.add(new ErrorBean(sProfileName, "error.profile.delete.factory"));
                    continue;
                }
                if (spi == null) continue;
                MethodCallStatus mcs = null;
                try {
                    mcs = mspi.delete(spi.getKey());
                }
                catch (ConfigMgmtException ex) {
                    Trace.error((Object)this, (String)"delete", (String)("ConfigMgmtException: " + ex.toString() + "\n"));
                    addResult = errors.add(new ErrorBean(sProfileName, "error.profile.delete.factory"));
                }
                catch (ItemNotFoundException ex) {
                    Trace.verbose((Object)this, (String)"delete", (String)("ItemNotFoundException: " + ex.toString() + "\n"));
                    addResult = errors.add(new ErrorBean(sProfileName, "error.profile.delete.factory"));
                }
                finally {
                    CliUtilEWS.checkMCS(mcs, errors);
                }
            }
        }
        return errors;
    }

    protected CommandResult doDelete(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = new CommandResult();
        String METHOD_NAME = "doDelete";
        Trace.methodBegin((Object)this, (String)"doDelete");
        List profileNames = pcl.getResource().getValues();
        List errors = this.delete(argContext, profileNames);
        this.processResults(locale, result, errors);
        return result;
    }

    protected List modify(SOAPContext argContext, String sDescription, String sNewName, String sRaidLevel, String sArrayType, String sSegsize, String sReadahead, String sNumberOfDisks, String sVirtStrategy, String sStripeSize, String sDedicatedHotSpare, String sProfileName) throws ConfigMgmtException, BadParameterException, Exception {
        String METHOD_NAME = "modify";
        Trace.methodBegin((Object)this, (String)"modify");
        ArrayList errors = new ArrayList();
        boolean addResult = false;
        ManageStorageProfilesInterface mspi = ManageStorageProfilesFactory.getManager();
        if (mspi == null) {
            Trace.verbose((Object)this, (String)"modify", (String)"ManageStorageProfilesInterface is null");
            throw new ConfigMgmtException("error.bolMgr.noProfMgr", "");
        }
        mspi.init(this.getConfigContext(argContext), null);
        StorageProfileInterface spi = mspi.getItemByName(sProfileName);
        if (spi == null) {
            Trace.verbose((Object)this, (String)"modify", (String)"could not find profile specified by name");
            throw new ItemNotFoundException(sProfileName);
        }
        if (spi.isInUse()) {
            throw new ConfigMgmtException(sProfileName, "error.profile.modify.profileInUse");
        }
        if (spi.isFactoryProfile()) {
            Trace.error((Object)this, (String)"modify", (String)"Profile is factory, not allowing modification\n");
            throw new ConfigMgmtException(sProfileName, "error.profile.modify.factory");
        }
        if (sDescription != null) {
            spi.setDescription(sDescription);
        }
        ArrayList al = null;
        al = spi.getAssocPools();
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS = ProfileEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.ProfileEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS = ProfileEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.ProfileEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$ProfileEWS), (String)"modify", (String)("getAssocPools " + (al.isEmpty() ? new String("has") : new String("has not"))));
        }
        if (!al.isEmpty()) {
            throw new ConfigMgmtException(sProfileName, "error.profile.modify.assocPools");
        }
        if (sNewName != null) {
            spi.setName(sNewName);
        }
        if (sRaidLevel != null) {
            spi.setRAIDLevel(this.cvtRaidLevel(sRaidLevel));
        }
        if (sArrayType != null) {
            spi.setArrayType(this.cvtArrayType(sArrayType));
        }
        if (sSegsize != null) {
            spi.setSegmentSize(this.cvtSegmentSize(sSegsize));
        }
        if (sReadahead != null) {
            spi.setReadAhead(this.cvtReadAhead(sReadahead));
        }
        if (sNumberOfDisks != null) {
            spi.setNumberOfDisks(this.cvtNumberOfDisks(sNumberOfDisks));
        }
        if (sVirtStrategy != null) {
            spi.setVirtualizationStrategy(this.cvtVirtStrategy(sVirtStrategy));
        }
        if (sStripeSize != null) {
            spi.setStripeSize(this.cvtStripeSize(sStripeSize));
        }
        if (sDedicatedHotSpare != null) {
            spi.setDedicatedSpare(this.cvtHotSpare(sDedicatedHotSpare));
        }
        spi.save();
        return errors;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String METHOD_NAME = "doModify";
        CommandResult result = new CommandResult();
        String sDescription = null;
        String sNewName = null;
        String sRaidLevel = null;
        String sArrayType = null;
        String sSegsize = null;
        String sReadahead = null;
        String sNumberOfDisks = null;
        String sVirtStrategy = null;
        String sStripeSize = null;
        String sDedicatedHotSpare = null;
        String sProfileName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-d".equals(option.getName()) || "--description".equals(option.getName())) {
                sDescription = option.getFirstValue();
            }
            if ("-N".equals(option.getName()) || "--new-name".equals(option.getName())) {
                sNewName = option.getFirstValue();
            }
            if ("-r".equals(option.getName()) || "--raid-level".equals(option.getName())) {
                sRaidLevel = option.getFirstValue();
            }
            if ("-t".equals(option.getName()) || "--array-type".equals(option.getName())) {
                sArrayType = option.getFirstValue();
            }
            if ("-s".equals(option.getName()) || "--segsize".equals(option.getName())) {
                sSegsize = option.getFirstValue();
            }
            if ("-h".equals(option.getName()) || "--readahead".equals(option.getName())) {
                sReadahead = option.getFirstValue();
            }
            if ("-n".equals(option.getName()) || "--number-of-disks".equals(option.getName())) {
                sNumberOfDisks = option.getFirstValue();
            }
            if ("-v".equals(option.getName()) || "--virt-strategy".equals(option.getName())) {
                sVirtStrategy = option.getFirstValue();
            }
            if ("-p".equals(option.getName()) || "--stripe-size".equals(option.getName())) {
                sStripeSize = option.getFirstValue();
            }
            if (!"-D".equals(option.getName()) && !"--dedicated-hot-spare".equals(option.getName())) continue;
            sDedicatedHotSpare = option.getFirstValue();
        }
        List errors = this.modify(argContext, sDescription, sNewName, sRaidLevel, sArrayType, sSegsize, sReadahead, sNumberOfDisks, sVirtStrategy, sStripeSize, sDedicatedHotSpare, sProfileName);
        this.processResults(locale, result, errors);
        return result;
    }

    protected CommandResult doExport(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        return result;
    }

    protected CommandResult doImport(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        return result;
    }

    private boolean cvtHotSpare(String inHotSpare) {
        if (inHotSpare == null) {
            return false;
        }
        if (inHotSpare.equalsIgnoreCase("yes")) {
            return true;
        }
        if (inHotSpare.equalsIgnoreCase("no")) {
            return false;
        }
        return false;
    }

    private boolean cvtReadAhead(String inReadAhead) {
        if (inReadAhead == null) {
            return false;
        }
        if (inReadAhead.equalsIgnoreCase("on")) {
            return true;
        }
        if (inReadAhead.equalsIgnoreCase("off")) {
            return false;
        }
        return false;
    }

    private int cvtSegmentSize(String inSegmentSize) {
        if (inSegmentSize == null) {
            return -1;
        }
        if (inSegmentSize.equals("4K")) {
            return 0;
        }
        if (inSegmentSize.equals("8K")) {
            return 1;
        }
        if (inSegmentSize.equals("16K")) {
            return 2;
        }
        if (inSegmentSize.equals("32K")) {
            return 3;
        }
        if (inSegmentSize.equals("64K")) {
            return 4;
        }
        return -1;
    }

    private int cvtRaidLevel(String inRaidLevel) {
        if (inRaidLevel == null) {
            return -1;
        }
        if (inRaidLevel.equals("0")) {
            return 0;
        }
        if (inRaidLevel.equals("1")) {
            return 1;
        }
        if (inRaidLevel.equals("5")) {
            return 5;
        }
        return -1;
    }

    private int cvtNumberOfDisks(String inNumberOfDisks) {
        if (inNumberOfDisks == null) {
            return -1;
        }
        if (inNumberOfDisks.equals("variable")) {
            return 0;
        }
        if (inNumberOfDisks.equals("2")) {
            return 2;
        }
        if (inNumberOfDisks.equals("3")) {
            return 3;
        }
        if (inNumberOfDisks.equals("4")) {
            return 4;
        }
        if (inNumberOfDisks.equals("5")) {
            return 5;
        }
        if (inNumberOfDisks.equals("6")) {
            return 6;
        }
        if (inNumberOfDisks.equals("7")) {
            return 7;
        }
        if (inNumberOfDisks.equals("8")) {
            return 8;
        }
        if (inNumberOfDisks.equals("9")) {
            return 9;
        }
        if (inNumberOfDisks.equals("10")) {
            return 10;
        }
        if (inNumberOfDisks.equals("11")) {
            return 11;
        }
        if (inNumberOfDisks.equals("12")) {
            return 12;
        }
        if (inNumberOfDisks.equals("13")) {
            return 13;
        }
        if (inNumberOfDisks.equals("14")) {
            return 14;
        }
        return -1;
    }

    private int cvtVirtStrategy(String inVirtStrategy) {
        if (inVirtStrategy == null) {
            return -1;
        }
        if (inVirtStrategy.equalsIgnoreCase("concat")) {
            return 0;
        }
        if (inVirtStrategy.equalsIgnoreCase("stripe")) {
            return 1;
        }
        if (inVirtStrategy.equalsIgnoreCase("legacy")) {
            return 2;
        }
        return -1;
    }

    private int cvtStripeSize(String inStripeSize) {
        if (inStripeSize == null) {
            return 0;
        }
        if (inStripeSize.equals("128K")) {
            return 0;
        }
        if (inStripeSize.equals("512K")) {
            return 1;
        }
        if (inStripeSize.equals("1M")) {
            return 2;
        }
        if (inStripeSize.equals("2M")) {
            return 3;
        }
        if (inStripeSize.equals("4M")) {
            return 4;
        }
        if (inStripeSize.equals("8M")) {
            return 5;
        }
        if (inStripeSize.equals("16M")) {
            return 6;
        }
        return -1;
    }

    private int cvtArrayType(String inArrayType) {
        if (inArrayType == null) {
            return -1;
        }
        if (inArrayType.equalsIgnoreCase("iops")) {
            return 0;
        }
        if (inArrayType.equalsIgnoreCase("bandwidth")) {
            return 1;
        }
        if (inArrayType.equalsIgnoreCase("capacity")) {
            return 2;
        }
        if (inArrayType.equalsIgnoreCase("bm_iops")) {
            return 3;
        }
        if (inArrayType.equalsIgnoreCase("bm_bandwidth")) {
            return 4;
        }
        if (inArrayType.equalsIgnoreCase("bm_capacity")) {
            return 5;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

