/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.admin.business.GeneralAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.core.ResourceLocator;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.soap.rpc.SOAPContext;

public class PowerProcessor
extends CommandProcessorBase {
    protected Admin bizObj = new Admin();
    protected Map powerStateMap;

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        ConfigContext client = this.getConfigContext(argContext);
        GeneralAdminInterface generalInterface = this.bizObj.getGeneralAdminInterface(client);
        String powerString = this.getPowerStatusString(generalInterface.getStatus());
        if (powerString != null) {
            result.setResult(ResourceLocator.getString((String)powerString, (Locale)locale));
        } else {
            result.setErrorId("100");
            result.setResult(pcl.getResource().getType() + ResourceLocator.getString((String)"power.NotValidState", (Locale)locale));
        }
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        Trace.verbose((Object)this, (String)"doModify", (String)"checking permissions");
        this.checkIfReadOnly(argContext, MenuData.ADMIN_MENU);
        String powerState = pcl.getResource().getFirstValue();
        this.modifyPower(argContext, powerState);
        return new CommandResult();
    }

    protected void modifyPower(SOAPContext argContext, String newValue) throws UnauthorizedException, Exception {
        String METHOD_NAME = "modifyPower";
        String badLog = null;
        Trace.methodBegin((Object)this, (String)"modifyPower");
        Trace.verbose((Object)this, (String)"modifyPower", (String)("new value is " + newValue));
        try {
            ConfigContext client = this.getConfigContext(argContext);
            GeneralAdminInterface generalInterface = this.bizObj.getGeneralAdminInterface(client);
            int powerStatus = generalInterface.getStatus();
            Trace.verbose((Object)this, (String)"modifyPower", (String)("Power status: " + powerStatus));
            if (!generalInterface.isPartialShutdownAvailable()) {
                throw new BadParameterException("", "error.powerManagement.powerDownUnsupported");
            }
            if ("down".equalsIgnoreCase(newValue)) {
                if (powerStatus != 2) {
                    throw new BadParameterException("", "error.powerManagement.alreadyPoweredDown");
                }
                badLog = "POWER_SERVICE_PARTIAL_SHUTDOWN_ERROR";
                generalInterface.partialShutdown();
                LogAPI.staticLog((String)"POWER_SERVICE_PARTIAL_SHUTDOWN_INITIATED", (String[])new String[0], (String[])new String[0]);
            } else if ("on".equalsIgnoreCase(newValue)) {
                if (powerStatus == 2) {
                    throw new BadParameterException("", "error.powerManagement.alreadyPoweredOn");
                }
                badLog = "POWER_SERVICE_REBOOT_ERROR";
                generalInterface.startUp();
                LogAPI.staticLog((String)"POWER_SERVICE_REBOOT_INITIATED", (String[])new String[0], (String[])new String[0]);
            } else if ("off".equalsIgnoreCase(newValue)) {
                if (powerStatus == 3) {
                    throw new BadParameterException("", "error.powerManagement.alreadyPoweredDown");
                }
                badLog = "POWER_SERVICE_FULL_SHUTDOWN_ERROR";
                LogAPI.staticLog((String)"POWER_SERVICE_FULL_SHUTDOWN_INITIATED", (String[])new String[0], (String[])new String[0]);
                generalInterface.fullShutDown();
            }
        }
        catch (Exception e) {
            if (badLog != null) {
                LogAPI.staticLog(badLog, (String[])new String[0], (String[])new String[0]);
            }
            Trace.verbose((Object)this, (String)"modifyPower", (Throwable)e);
            throw e;
        }
        Trace.verbose((Object)this, (String)"modifyPower", (String)"Method end.");
    }

    protected final String getPowerStatusString(int numericPowerStatus) {
        this.initPowerStateMap();
        return (String)this.powerStateMap.get(new Integer(numericPowerStatus));
    }

    protected void initPowerStateMap() {
        if (this.powerStateMap == null) {
            this.powerStateMap = new HashMap();
            this.powerStateMap.put(new Integer(2), "power.FullPower");
            this.powerStateMap.put(new Integer(3), "power.FullShutdown");
            this.powerStateMap.put(new Integer(1), "power.PowerSaveLowPower");
            this.powerStateMap.put(new Integer(4), "power.PowerServiceError");
        }
    }
}

