/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.admin.business.PasswordsAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.login.Login;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.core.ResourceLocator;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.InvalidCredentials;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.rpc.SOAPContext;

public class PasswordProcessor
extends CommandProcessorBase {
    private Admin bizObj = new Admin();

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result;
        block17: {
            result = new CommandResult();
            String METHOD_NAME = "doPassword";
            String mSubcommand = pcl.getCommandName();
            List options = pcl.getOptions();
            String user = pcl.getResource().getFirstValue();
            String oldPassword = null;
            String newPassword = null;
            String newRP = null;
            Option option = null;
            Trace.verbose((Object)this, (String)"doPassword", (String)"Get password options");
            for (int i = 0; i < options.size(); ++i) {
                option = (Option)options.get(i);
                Trace.verbose((Object)this, (String)"doPassword", (String)option.getName());
                String firstValue = option.getFirstValue();
                if (option.getName().equals("old_password")) {
                    oldPassword = firstValue;
                    continue;
                }
                if (option.getName().equals("new_password")) {
                    newPassword = firstValue;
                    continue;
                }
                if (!option.getName().equals("new_verify_password")) continue;
                newRP = firstValue;
            }
            HttpSession session = (HttpSession)argContext.getProperty(Constants.BAG_HTTPSESSION);
            if (oldPassword == null || newPassword == null || newRP == null) {
                if (oldPassword == null) {
                    session.setAttribute("cli.interactive.optionName", (Object)"old_password");
                    result.setResult(ResourceLocator.getString((String)"login.OldPassword", (Locale)locale));
                } else if (newPassword == null) {
                    session.setAttribute("cli.interactive.optionName", (Object)"new_password");
                    result.setResult(ResourceLocator.getString((String)"login.NewPassword", (Locale)locale));
                } else if (newRP == null) {
                    session.setAttribute("cli.interactive.optionName", (Object)"new_verify_password");
                    result.setResult(ResourceLocator.getString((String)"login.ReenterPassword", (Locale)locale));
                }
                result.setErrorId("888");
            } else {
                session.removeAttribute("cli.interactive.optionName");
                session.removeAttribute("user.input.phase");
                session.removeAttribute("cli.interactive.spec");
                session.removeAttribute("cli.interactive.pcl");
                if (oldPassword.equals("") || oldPassword.equals("\n") || newPassword.equals("") || newPassword.equals("\n")) {
                    result.setResult(ResourceLocator.getString((String)"login.CannotEmptyPassword", (Locale)locale) + "\n");
                    result.setErrorId("100");
                } else if (newPassword.equals(newRP)) {
                    Login login = new Login();
                    try {
                        if (login.initUserSession(user, oldPassword, locale) != null) {
                            Trace.verbose((Object)this, (String)"doPassword", (String)"Old password is OK");
                            this.modifyPassword(argContext, user, oldPassword, newPassword);
                            break block17;
                        }
                        Trace.verbose((Object)this, (String)"doPassword", (String)"not authorized");
                        result.setResult(ResourceLocator.getString((String)"password.OldPasswordNotAuthorized", (Locale)locale) + "\n");
                        result.setErrorId("100");
                    }
                    catch (InvalidCredentials e) {
                        Trace.verbose((Object)this, (String)"doPassword", (Throwable)e);
                        result.setResult(ResourceLocator.getString((String)"password.OldPasswordNotAuthorized", (Locale)locale) + "\n");
                        result.setErrorId("100");
                    }
                } else {
                    result.setResult(ResourceLocator.getString((String)"login.PasswordsMissmatch", (Locale)locale) + "\n");
                    result.setErrorId("100");
                }
            }
        }
        return result;
    }

    private void modifyPassword(SOAPContext argContext, String userName, String oldPassword, String newPassword) throws UnauthorizedException, Exception {
        String METHOD_NAME = "Password";
        Trace.methodBegin((Object)this, (String)"Password");
        Trace.verbose((Object)this, (String)"Password", (String)"Administration Get CIM Handle - modifyPassword");
        Trace.verbose((Object)this, (String)"Password", (String)("userName value is " + userName));
        Trace.verbose((Object)this, (String)"Password", (String)("old value is " + oldPassword));
        Trace.verbose((Object)this, (String)"Password", (String)("new value is " + newPassword));
        ConfigContext client = this.getConfigContext(argContext);
        PasswordsAdminInterface passInterface = this.bizObj.getPasswordsAdminInterface(client);
        try {
            if (userName != null && "guest".equalsIgnoreCase(userName)) {
                passInterface.setGuestPassword(newPassword);
            } else if (userName != null && "admin".equalsIgnoreCase(userName)) {
                passInterface.setStorageSystemAdminPassword(newPassword);
            } else if (userName != null && "storage".equalsIgnoreCase(userName)) {
                passInterface.setStorageAdminPassword(newPassword);
            } else {
                throw new UnauthorizedException("password.NotValidUserName");
            }
            LogAPI.staticLog((String)"AUTH_MODIFY_PASSWORD_COMPLETED", (String[])new String[]{userName}, (String[])new String[0]);
        }
        catch (Exception e) {
            LogAPI.staticLog((String)"AUTH_MODIFY_PASSWORD_FAILED", (String[])new String[]{userName}, (String[])new String[0]);
            throw e;
        }
        Trace.verbose((Object)this, (String)"Password", (String)"Method end.");
    }
}

