/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.admin.business.SystemTimeAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.core.ResourceLocator;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.soap.rpc.SOAPContext;

public class NtpProcessor
extends CommandProcessorBase {
    protected Admin bizObj = new Admin();

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext context) throws Exception {
        CommandResult result = new CommandResult();
        SystemTimeAdminInterface admin = this.bizObj.getSystemTimeAdminInterface(this.getConfigContext(context));
        String ipAddress = this.getNtpIP(admin);
        if (ipAddress == null) {
            result.setResult(ResourceLocator.getString((String)"admin.NtpDisabled", (Locale)locale));
        } else {
            result.setResult(ResourceLocator.getString((String)"admin.NtpServer", (Locale)locale) + ipAddress);
        }
        return result;
    }

    protected String getNtpIP(SystemTimeAdminInterface admin) {
        if (Boolean.TRUE.equals(admin.getUseNTPServer())) {
            return admin.getNtpServerIp();
        }
        return null;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext soapContext) throws Exception {
        this.checkIfReadOnly(soapContext, MenuData.ADMIN_MENU);
        CommandResult result = new CommandResult();
        ResourceBundle rb = this.getResourceBundle(locale);
        List options = pcl.getOptions();
        String ipAddress = null;
        Option optionE = pcl.getOptionByName("-e", "--enable");
        Option optionD = pcl.getOptionByName("-d", "--disable");
        boolean enableNtp = false;
        if (optionE != null && optionD != null) {
            result.setResult("-d|-e" + rb.getString("error.validation.conflictingOptions"));
            result.setErrorId("30");
        } else if (optionE == null && optionD == null) {
            result.setResult("-d|-e" + rb.getString("error.validation.requiredOptionMissing"));
            result.setErrorId("30");
        } else if (optionE != null) {
            ipAddress = pcl.getResource().getFirstValue();
            if (ipAddress == null) {
                result.setResult(rb.getString("admin.NtpAddressMissing"));
                result.setErrorId("30");
            } else {
                enableNtp = true;
            }
        }
        SystemTimeAdminInterface admin = this.bizObj.getSystemTimeAdminInterface(this.getConfigContext(soapContext));
        if (enableNtp) {
            this.enableNtp(admin, ipAddress, null);
        } else {
            this.disableNtp(admin, null);
        }
        return result;
    }

    protected void enableNtp(SystemTimeAdminInterface adminInterface, String ipAddress, String arrayName) throws Exception {
        try {
            adminInterface.setUseNTPServer(Boolean.TRUE);
            adminInterface.setNtpServerIp(ipAddress);
            adminInterface.save();
            if (arrayName != null) {
                LogAPI.staticLog((String)"ARRAY_TIME_NTP_ENABLED", (String[])new String[]{ipAddress, arrayName}, (String[])new String[0]);
            } else {
                LogAPI.staticLog((String)"SP_TIME_NTP_ENABLED", (String[])new String[]{ipAddress}, (String[])new String[0]);
            }
        }
        catch (ConfigMgmtException e) {
            if (arrayName != null) {
                LogAPI.staticLog((String)"ARRAY_TIME_NTP_ENABLED_ERROR", (String[])new String[]{ipAddress, arrayName}, (String[])new String[0]);
            } else {
                LogAPI.staticLog((String)"SP_TIME_NTP_ENABLED_ERROR", (String[])new String[]{ipAddress}, (String[])new String[0]);
            }
            throw e;
        }
    }

    protected void disableNtp(SystemTimeAdminInterface adminInterface, String arrayName) throws Exception {
        try {
            adminInterface.setUseNTPServer(Boolean.FALSE);
            adminInterface.save();
            if (arrayName != null) {
                LogAPI.staticLog((String)"ARRAY_TIME_NTP_DISABLED", (String[])new String[]{arrayName}, (String[])new String[0]);
            } else {
                LogAPI.staticLog((String)"SP_TIME_NTP_DISABLED", (String[])new String[0], (String[])new String[0]);
            }
        }
        catch (ConfigMgmtException e) {
            if (arrayName != null) {
                LogAPI.staticLog((String)"ARRAY_TIME_NTP_DISABLED_ERROR", (String[])new String[]{arrayName}, (String[])new String[0]);
            } else {
                LogAPI.staticLog((String)"SP_TIME_NTP_DISABLED_ERROR", (String[])new String[0], (String[])new String[0]);
            }
            throw e;
        }
    }
}

