/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.admin.business.NetworkAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.LoginWS;
import com.sun.netstorage.array.mgmt.cfg.cli.props.NetProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.business.NetSettingsSaverThread;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import java.util.Locale;
import org.apache.soap.rpc.SOAPContext;

public class NetProcessor
extends CommandProcessorBase {
    protected Admin bizObj = new Admin();

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(this.listNet(argContext).toString(locale));
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        String dhcp = null;
        String gateway = null;
        String nameserver = null;
        String ipaddress = null;
        String netmask = null;
        String domain = null;
        this.checkIfReadOnly(argContext, MenuData.ADMIN_MENU);
        Option optionDhcp = pcl.getOptionByName("-d", "--dhcp");
        Option optionGateway = pcl.getOptionByName("-g", "--gateway");
        Option optionNameserver = pcl.getOptionByName("-n", "--nameserver");
        Option optionIpAddress = pcl.getOptionByName("-i", "--ipaddress");
        Option optionNetmask = pcl.getOptionByName("-m", "--netmask");
        Option optionDomain = pcl.getOptionByName("-D", "--domain");
        if (optionDhcp != null) {
            dhcp = optionDhcp.getFirstValue();
        }
        if (optionGateway != null) {
            gateway = optionGateway.getFirstValue();
        }
        if (optionNameserver != null) {
            nameserver = optionNameserver.getFirstValue();
        }
        if (optionIpAddress != null) {
            ipaddress = optionIpAddress.getFirstValue();
        }
        if (optionNetmask != null) {
            netmask = optionNetmask.getFirstValue();
        }
        if (optionDomain != null) {
            domain = optionDomain.getFirstValue();
        }
        this.modifyNet(argContext, dhcp, gateway, nameserver, ipaddress, netmask, domain);
        result.setResult(this.localizeString(locale, "admin.networkSettingChanged.reloginRequired"));
        result.setErrorId("80");
        return result;
    }

    protected NetProps listNet(SOAPContext argContext) throws UnauthorizedException, Exception {
        String METHOD_NAME = "listNet";
        Trace.methodBegin((Object)this, (String)"listNet");
        Trace.verbose((Object)this, (String)"listNet", (String)"Admnistration Get CIM Handle -listNet");
        NetProps result = new NetProps();
        ConfigContext client = this.getConfigContext(argContext);
        NetworkAdminInterface networkInterface = this.bizObj.getNetworkAdminInterface(client);
        networkInterface.init(client);
        result.setDhcp(networkInterface.isDhcp());
        result.setGateway(networkInterface.getGatewayIp());
        result.setIpaddress(networkInterface.getIpAddress());
        result.setNameserver(networkInterface.getDnsAddress());
        result.setNetmask(networkInterface.getNetmask());
        String domainName = networkInterface.getDomainName();
        result.setDomain(domainName != null ? domainName : "");
        Trace.verbose((Object)this, (String)"listNet", (String)"Method end.");
        return result;
    }

    protected void modifyNet(SOAPContext argContext, String dhcp, String gateway, String nameserver, String ipaddress, String netmask, String domain) throws UnauthorizedException, Exception {
        String METHOD_NAME = "modifyNet";
        Trace.methodBegin((Object)this, (String)"modifyNet");
        Trace.verbose((Object)this, (String)"modifyNet", (String)"Administration Get CIM Handle - modifyNet");
        Trace.verbose((Object)this, (String)"modifyNet", (String)("new value is " + dhcp));
        Trace.verbose((Object)this, (String)"modifyNet", (String)("new value is " + gateway));
        Trace.verbose((Object)this, (String)"modifyNet", (String)("new value is " + nameserver));
        Trace.verbose((Object)this, (String)"modifyNet", (String)("new value is " + ipaddress));
        Trace.verbose((Object)this, (String)"modifyNet", (String)("new value is " + netmask));
        Trace.verbose((Object)this, (String)"modifyNet", (String)("new value is " + domain));
        ConfigContext client = this.getConfigContext(argContext);
        NetworkAdminInterface networkInterface = this.bizObj.getNetworkAdminInterface(client);
        networkInterface.init(client);
        boolean networkParamsChanged = false;
        boolean domainChanged = false;
        boolean useDhcp = false;
        if ("on".equalsIgnoreCase(dhcp) || networkInterface.isDhcp() && !"off".equalsIgnoreCase(dhcp)) {
            useDhcp = true;
        }
        networkInterface.setDhcp(useDhcp);
        if (gateway != null) {
            if (useDhcp) {
                throw new BadParameterException(gateway, "admin.CannotSpecifyGateway");
            }
            networkParamsChanged = true;
            networkInterface.setGatewayIp(gateway);
        }
        if (ipaddress != null) {
            if (useDhcp) {
                throw new BadParameterException(ipaddress, "admin.CannotSpecifyIpAddress");
            }
            networkParamsChanged = true;
            networkInterface.setIpAddress(ipaddress);
        }
        if (nameserver != null) {
            networkInterface.setDnsAddress(nameserver);
        }
        if (netmask != null) {
            if (useDhcp) {
                throw new BadParameterException(netmask, "admin.CannotSpecifyNetmask");
            }
            networkParamsChanged = true;
            networkInterface.setNetmask(netmask);
        }
        if (domain != null) {
            domainChanged = true;
            networkInterface.setDomainName(domain);
        }
        NetSettingsSaverThread processorThread = new NetSettingsSaverThread(useDhcp, networkParamsChanged, networkInterface, null, client, domainChanged);
        processorThread.start();
        LoginWS login = new LoginWS();
        login.exit(argContext);
        Trace.verbose((Object)this, (String)"modifyNet", (String)"Method end.");
    }
}

