/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.admin.business.SystemTimeAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ValidationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.validator.date.DateParser;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class LogProcessor
extends CommandProcessorBase {
    private Admin bizObj = new Admin();
    private static final int ALL_LOG_ENTRIES = -1;

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        int tail = -1;
        String startDate = null;
        String finishDate = null;
        List options = pcl.getOptions();
        if (options != null && options.size() > 0) {
            for (int i = 0; i < options.size(); ++i) {
                Option option = (Option)options.get(i);
                if ("-t".equals(option.getName()) || "--tail".equals(option.getName())) {
                    tail = Integer.parseInt(option.getFirstValue());
                    continue;
                }
                if ("-s".equals(option.getName()) || "--start".equals(option.getName())) {
                    startDate = option.getFirstValue();
                    continue;
                }
                if (!"-f".equals(option.getName()) && !"--finish".equals(option.getName())) continue;
                finishDate = option.getFirstValue();
            }
        }
        List v = this.listLog(argContext, locale.toString(), startDate, finishDate, tail);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.size(); ++i) {
            sb.append((String)v.get(i) + "\n");
        }
        result.setResult(sb.toString());
        return result;
    }

    public List listLog(SOAPContext argContext, String argLocale, String start, String finish, int tail) throws UnauthorizedException, Exception {
        String METHOD_NAME = "listLog";
        Trace.methodBegin((Object)this, (String)"listLog");
        Trace.verbose((Object)this, (String)"listLog", (String)"Admnistration Get CIM Handle -listLog");
        Trace.verbose((Object)this, (String)"listLog", (String)(" Options: Start " + start + " Finish:" + finish + " Tail:" + tail));
        ConfigContext client = this.getConfigContext(argContext);
        int severity = -1;
        List result = this.bizObj.getLogEvents(argLocale);
        if (result.isEmpty()) {
            return result;
        }
        Date serverDate = null;
        TimeZone timezone = null;
        Locale locale = new Locale(argLocale);
        int currentConfiguration = Repository.getRepository().getConfigInteger();
        if (currentConfiguration < 3) {
            serverDate = Calendar.getInstance().getTime();
            timezone = TimeZone.getDefault();
        } else {
            SystemTimeAdminInterface timeInterface = this.bizObj.getSystemTimeAdminInterface(client);
            timezone = timeInterface.getCurrentTimeZone();
            serverDate = timeInterface.getTime();
        }
        result = this.bizObj.formatLogEntries(result, locale, timezone, true);
        if (start != null || finish != null) {
            String firstLogEntry = (String)result.get(0);
            String lastLogEntry = null;
            lastLogEntry = result.size() > 0 ? (String)result.get(result.size() - 1) : firstLogEntry;
            if (start != null || finish != null) {
                Date startDate = this.makeDate(start, timezone, locale, serverDate, firstLogEntry);
                Date finishDate = this.makeDate(finish, timezone, locale, serverDate, lastLogEntry);
                result = this.getEntriesForDateRange(result, locale, startDate, finishDate, timezone);
            }
        }
        result = this.getTail(tail, result);
        Trace.verbose((Object)this, (String)"listLog", (String)"Method end.");
        return result;
    }

    private Date makeDate(String dateString, TimeZone timezone, Locale locale, Date serverDate, String firstLogEntry) throws ValidationException, Exception {
        Date date;
        DateParser parser = DateParser.getInstance();
        if (dateString != null) {
            Calendar calendar = Calendar.getInstance(timezone, locale);
            calendar.setTime(serverDate);
            date = parser.parseDate(dateString, calendar).getTime();
        } else {
            date = this.parseLogEventRecordDate(this.parseLogEventRecordDateString(firstLogEntry), 1, 2, locale, timezone);
        }
        return date;
    }

    private String parseLogEventRecordDateString(String record) {
        return record.substring(0, record.lastIndexOf(":"));
    }

    private List getEntriesForDateRange(List logList, Locale locale, Date startDate, Date finishDate, TimeZone timezone) throws Exception {
        Vector logEntriesWithinRange = new Vector();
        for (int i = 0; i < logList.size(); ++i) {
            String currDateStr = this.parseLogEventRecordDateString((String)logList.get(i));
            Date currDate = this.parseLogEventRecordDate(currDateStr, 1, 2, locale, timezone);
            if (currDate.getTime() < startDate.getTime() || currDate.getTime() > finishDate.getTime()) continue;
            logEntriesWithinRange.add(logList.get(i));
        }
        return logEntriesWithinRange;
    }

    private List getTail(int tail, List result) {
        int tailStart;
        if (tail <= 0 || tail >= result.size()) {
            return result;
        }
        Vector requestedRecords = new Vector();
        for (int i = tailStart = result.size() - tail; i < result.size(); ++i) {
            requestedRecords.add(result.get(i));
        }
        return requestedRecords;
    }

    private Date parseLogEventRecordDate(String date, int dateStyle, int timeStyle, Locale locale, TimeZone timezone) throws ParseException {
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        df.setTimeZone(timezone);
        return df.parse(date);
    }
}

