/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageMirrorServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirroredVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class LocalMirrorEWS
extends CommandProcessorBase {
    private static final int NO_COW = 0;
    private static final int WITH_COW = 1;
    private static final int MIRROR_ACTION = 2;
    private static final int ADD_ACTION = 3;

    protected CommandResult doCreate(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "doCreate";
        Trace.methodBegin((Object)this, (String)"doCreate");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String oln = pcl.getOptionListName();
        CommandResult result = "mirror_with_cow".equals(oln) ? this.processCreate(locale, pcl, argContext, 1) : this.processCreate(locale, pcl, argContext, 0);
        return result;
    }

    protected CommandResult doAdd(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "doAdd";
        Trace.methodBegin((Object)this, (String)"doAdd");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        CommandResult result = this.processAddComponent(locale, pcl, argContext);
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String oln = pcl.getOptionListName();
        CommandResult result = null;
        if ("break".equals(oln)) {
            result = this.processBreak(locale, pcl, argContext);
        } else if ("split".equals(oln)) {
            result = this.processSplit(locale, pcl, argContext);
        } else if ("rejoin".equals(oln)) {
            result = this.processRejoin(locale, pcl, argContext);
        } else if ("mirror".equals(oln)) {
            result = this.processMirrorExistingVolume(locale, pcl, argContext);
        } else if ("modify_resilver".equals(oln)) {
            result = this.processModifyResilver(locale, pcl, argContext);
        } else if ("repair_mirror".equals(oln)) {
            result = this.processRepairLogs(locale, pcl, argContext);
        }
        return result;
    }

    private CommandResult processSplit(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processSplit";
        Trace.methodBegin((Object)this, (String)"processSplit");
        String componentName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == componentName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionSplitComponent(errors, argContext, componentName, sDomainName);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private CommandResult processRejoin(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processRejoin";
        Trace.methodBegin((Object)this, (String)"processRejoin");
        boolean reverse = false;
        String sDomainName = "DEFAULT";
        String componentName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if (!"-R".equals(name) && !"--reverse".equals(name)) continue;
            reverse = true;
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == componentName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionRejoinComponent(errors, argContext, componentName, sDomainName, reverse);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private CommandResult processBreak(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processBreak";
        Trace.methodBegin((Object)this, (String)"processBreak");
        boolean forced = false;
        String sDomainName = "DEFAULT";
        String componentName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if (!"-f".equals(name) && !"--force".equals(name)) continue;
            forced = true;
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == componentName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionBreakComponent(errors, argContext, componentName, sDomainName, forced);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private CommandResult processMirrorExistingVolume(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processMirrorExistingVolume";
        Trace.methodBegin((Object)this, (String)"processMirrorExistingVolume");
        String baseVolumeName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        int resilverPriority = CliUtilEWS.cvtResilverPriority("MEDIUM");
        int isolationPolicy = CliUtilEWS.cvtIsolationPolicy("REQUIRED");
        String logsPoolName = null;
        String desc = null;
        List componentPoolNames = null;
        List componentVolumeNames = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-g".equals(name) || "--logs-pool".equals(name)) {
                logsPoolName = option.getFirstValue();
                continue;
            }
            if ("-v".equals(name) || "--resilver-priority".equals(name)) {
                resilverPriority = CliUtilEWS.cvtResilverPriority(option.getFirstValue());
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-d".equals(name) || "--description".equals(name)) {
                desc = option.getFirstValue();
                continue;
            }
            if ("-i".equals(name) || "--isolation".equals(name)) {
                isolationPolicy = CliUtilEWS.cvtIsolationPolicy(option.getFirstValue());
                continue;
            }
            if ("-m".equals(name) || "--mirror-pool".equals(name)) {
                componentPoolNames = option.getValues();
                continue;
            }
            if (!"-c".equals(name) && !"--component-volume".equals(name)) continue;
            componentVolumeNames = option.getValues();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == baseVolumeName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionMirrorExisting(errors, argContext, baseVolumeName, componentVolumeNames, componentPoolNames, sDomainName, desc, logsPoolName, resilverPriority, isolationPolicy);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private CommandResult processModifyResilver(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processModifyResilver";
        Trace.methodBegin((Object)this, (String)"processModifyResilver");
        String mirrorName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        Integer resilverPriority = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-v".equals(name) || "--resilver-priority".equals(name)) {
                resilverPriority = new Integer(CliUtilEWS.cvtResilverPriority(option.getFirstValue()));
                continue;
            }
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == mirrorName || null == resilverPriority) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionModifyResilver(errors, argContext, mirrorName, sDomainName, resilverPriority);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private CommandResult processAddComponent(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processAddComponent";
        Trace.methodBegin((Object)this, (String)"processAddComponent");
        String mirrorName = pcl.getResource().getFirstValue();
        List componentVolumeNames = null;
        List componentPoolNames = null;
        String sDomainName = "DEFAULT";
        Integer resilverPriority = null;
        Integer isolationPolicy = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-c".equals(name) || "--component-volume".equals(name)) {
                componentVolumeNames = option.getValues();
                continue;
            }
            if ("-m".equals(name) || "--mirror-pool".equals(name)) {
                componentPoolNames = option.getValues();
                continue;
            }
            if ("-v".equals(name) || "--resilver-priority".equals(name)) {
                resilverPriority = new Integer(CliUtilEWS.cvtResilverPriority(option.getFirstValue()));
                continue;
            }
            if (!"-i".equals(name) && !"--isolation".equals(name)) continue;
            isolationPolicy = new Integer(CliUtilEWS.cvtIsolationPolicy(option.getFirstValue()));
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == mirrorName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionAddComponent(errors, argContext, mirrorName, sDomainName, componentVolumeNames, componentPoolNames, resilverPriority, isolationPolicy);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private CommandResult processCreate(Locale locale, ParsedCommandLine pcl, SOAPContext argContext, int creationType) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processCreate";
        Trace.methodBegin((Object)this, (String)"processCreate");
        String mirrorName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        int resilverPriority = CliUtilEWS.cvtResilverPriority("MEDIUM");
        int isolationPolicy = CliUtilEWS.cvtIsolationPolicy("REQUIRED");
        int snapPolicy = CliUtilEWS.cvtSnapshotPolicy("DEFAULT");
        String logsPoolName = null;
        String desc = null;
        List componentPoolNames = null;
        String sizeString = null;
        String snapPoolName = null;
        String snapComponentName = null;
        Integer snapLevel = null;
        Integer snapCount = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-g".equals(name) || "--logs-pool".equals(name)) {
                logsPoolName = option.getFirstValue();
                continue;
            }
            if ("-v".equals(name) || "--resilver-priority".equals(name)) {
                resilverPriority = CliUtilEWS.cvtResilverPriority(option.getFirstValue());
                continue;
            }
            if ("-S".equals(name) || "--sdomain".equals(name)) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-d".equals(name) || "--description".equals(name)) {
                desc = option.getFirstValue();
                continue;
            }
            if ("-i".equals(name) || "--isolation".equals(name)) {
                isolationPolicy = CliUtilEWS.cvtIsolationPolicy(option.getFirstValue());
                continue;
            }
            if ("-m".equals(name) || "--mirror-pool".equals(name)) {
                componentPoolNames = option.getValues();
                continue;
            }
            if ("-s".equals(name) || "--size".equals(name)) {
                sizeString = option.getFirstValue();
                continue;
            }
            if ("-C".equals(name) || "--snapshot-count".equals(name)) {
                snapCount = new Integer(Integer.parseInt(Convert.cleanUpAndUpcase((String)option.getFirstValue())));
                continue;
            }
            if ("-L".equals(name) || "--snapshot-level".equals(name)) {
                snapLevel = new Integer(CliUtilEWS.cvtSnapLevel(option.getFirstValue()));
                continue;
            }
            if ("-P".equals(name) || "--snapshot-pool".equals(name)) {
                snapPoolName = option.getFirstValue();
                continue;
            }
            if ("-f".equals(name) || "--favor".equals(name)) {
                snapPolicy = CliUtilEWS.cvtSnapshotPolicy(option.getFirstValue());
                continue;
            }
            if (!"-T".equals(name) && !"--snapshot-component".equals(name)) continue;
            snapComponentName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == sizeString || null == mirrorName || null == componentPoolNames || componentPoolNames.isEmpty() || 1 == creationType && (null == snapPoolName || null == snapCount || null == snapLevel || null == snapComponentName)) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionCreateMirror(errors, argContext, componentPoolNames, mirrorName, sDomainName, sizeString, desc, resilverPriority, isolationPolicy, null == snapCount ? 0 : snapCount, null == snapLevel ? 0 : snapLevel, logsPoolName, snapPoolName, snapPolicy, snapComponentName, creationType);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private CommandResult processRepairLogs(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "processRepairLogs";
        Trace.methodBegin((Object)this, (String)"processRepairLogs");
        String mirrorName = pcl.getResource().getFirstValue();
        String sDomainName = "DEFAULT";
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-S".equals(name) && !"--sdomain".equals(name)) continue;
            sDomainName = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == mirrorName) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionRepairLogs(errors, argContext, mirrorName, sDomainName);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private void actionCreateMirror(List errors, SOAPContext argContext, List sourcePoolNames, String mirrorName, String sDomainName, String sizeString, String mirrorDesc, int resilverPriority, int isolationPolicy, int snapCount, int snapLevel, String logsPoolName, String snapPoolName, int snapPolicy, String snapCompName, int creationType) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionCreateMirror";
        Trace.methodBegin((Object)this, (String)"actionCreateMirror");
        BigInteger size = SizeConvert.stringToBytes((String)Convert.cleanUpAndUpcase((String)sizeString));
        if (CliUtilEWS.validateVolumeSize(errors, size, sizeString)) {
            return;
        }
        if (CliUtilEWS.validateName(errors, mirrorName)) {
            return;
        }
        if (null != mirrorDesc && CliUtilEWS.validateDesc(errors, mirrorDesc)) {
            return;
        }
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageStorageDomainsInterface msdi = ManageStorageDomainsFactory.getManager();
        msdi.init(cfgctx, null);
        StorageDomainInterface sdomain = null;
        try {
            sdomain = msdi.getItemByName(sDomainName);
        }
        catch (ConfigMgmtException cme) {
            errors.add(new ErrorBean(sDomainName, cme));
            return;
        }
        if (null == sdomain) {
            errors.add(new ErrorBean(sDomainName, "error.objectNotFound"));
            return;
        }
        if (sourcePoolNames.size() > 4) {
            errors.add(new ErrorBean("", "error.localmirror.create.toManyMirrorPools"));
            return;
        }
        if (sourcePoolNames.size() < 2) {
            errors.add(new ErrorBean("", "error.localmirror.create.tooFewComponents"));
            return;
        }
        Vector sources = new Vector();
        if (!this.getPoolsByName(errors, sourcePoolNames, sDomainName, cfgctx, size, sources)) {
            return;
        }
        ManageStoragePoolsInterface poolMan = CliUtilEWS.getManagePoolServices(cfgctx);
        StoragePoolInterface logsPool = null;
        if (null != logsPoolName) {
            try {
                logsPool = poolMan.getItemByName(logsPoolName, sDomainName);
            }
            catch (ItemNotFoundException infe) {
                errors.add(new ErrorBean(logsPoolName, "error.objectNotFound"));
                return;
            }
            if (null == logsPool) {
                errors.add(new ErrorBean(logsPoolName, "error.objectNotFound"));
                return;
            }
        }
        Integer snapCompIndex = null;
        StoragePoolInterface snapPool = null;
        if (1 == creationType) {
            for (int i = 0; i < sourcePoolNames.size(); ++i) {
                String poolName = (String)sourcePoolNames.get(i);
                if (!poolName.equals(snapCompName)) continue;
                snapCompIndex = new Integer(i + 1);
                break;
            }
            if (null == snapCompIndex) {
                errors.add(new ErrorBean(snapCompName, "error.localmirror.mirrorComponent.notFound"));
                return;
            }
            try {
                snapPool = poolMan.getItemByName(snapPoolName, sDomainName);
            }
            catch (ItemNotFoundException infe) {
                errors.add(new ErrorBean(snapPoolName, "error.objectNotFound"));
                return;
            }
            if (null == snapPool) {
                errors.add(new ErrorBean(snapPoolName, "error.objectNotFound"));
                return;
            }
        }
        Properties props = new Properties();
        props.put("name", mirrorName);
        if (null != mirrorDesc) {
            props.put("description", mirrorDesc);
        }
        props.put("domain", sdomain);
        props.put("sources", sources);
        props.put("size", size);
        props.put("isolationPolicy", new Integer(isolationPolicy));
        props.put("resilverPriority", new Integer(resilverPriority));
        props.put("snamNum", new Integer(0));
        if (null != logsPool) {
            Vector<StoragePoolInterface> logsPoolVector = new Vector<StoragePoolInterface>();
            logsPoolVector.add(logsPool);
            props.put("logPools", logsPoolVector);
        }
        if (1 == creationType) {
            props.put("snapComponent", snapCompIndex);
            props.put("snapPool", snapPool);
            props.put("snapChange", new Integer(snapLevel));
            props.put("snamNum", new Integer(snapCount));
            props.put("snapPolicy", new Integer(snapPolicy));
        }
        ManageMirrorServicesEnt1Interface mms = CliUtilEWS.getManageMirrorServices(cfgctx);
        mms.create(props);
    }

    private void actionBreakComponent(List errors, SOAPContext argContext, String componentName, String sDomainName, boolean forced) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionBreakComponent";
        Trace.methodBegin((Object)this, (String)"actionBreakComponent");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageMirrorServicesEnt1Interface mms = CliUtilEWS.getManageMirrorServices(cfgctx);
        MirrorComponentEnt1Interface comp = (MirrorComponentEnt1Interface)mms.getMirrorComponentByName(componentName, sDomainName);
        if (comp == null) {
            errors.add(new ErrorBean(componentName, "error.objectNotFound"));
            return;
        }
        if (forced) {
            mms.forceBreakComponent((Object)comp.getKey());
        } else {
            mms.breakComponent((Object)comp.getKey());
        }
    }

    private void actionSplitComponent(List errors, SOAPContext argContext, String componentName, String sDomainName) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionSplitComponent";
        Trace.methodBegin((Object)this, (String)"actionSplitComponent");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageMirrorServicesEnt1Interface mms = CliUtilEWS.getManageMirrorServices(cfgctx);
        MirrorComponentEnt1Interface comp = (MirrorComponentEnt1Interface)mms.getMirrorComponentByName(componentName, sDomainName);
        if (comp == null) {
            errors.add(new ErrorBean(componentName, "error.objectNotFound"));
            return;
        }
        mms.splitComponent((Object)comp.getKey());
    }

    private void actionAddComponent(List errors, SOAPContext argContext, String mirrorName, String sDomainName, List componentVolumeNames, List componentPoolNames, Integer resilverPriority, Integer isolationPolicy) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionAddComponent";
        Trace.methodBegin((Object)this, (String)"actionAddComponent");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageMirrorServicesEnt1Interface mms = CliUtilEWS.getManageMirrorServices(cfgctx);
        MirroredVolumeEnt1Interface mv = (MirroredVolumeEnt1Interface)mms.getMirroredVolumeByName(mirrorName, sDomainName);
        if (null == mv) {
            errors.add(new ErrorBean(mirrorName, "error.objectNotFound"));
            return;
        }
        int openMirrorSlots = 4 - mv.getNumberOfComponents();
        if (openMirrorSlots < 1) {
            errors.add(new ErrorBean(mirrorName, "error.localmirror.addComponent.fullMirror"));
            return;
        }
        int volCount = 0;
        int poolCount = 0;
        if (null != componentVolumeNames) {
            volCount = componentVolumeNames.size();
        }
        if (null != componentPoolNames) {
            poolCount = componentPoolNames.size();
        }
        if (volCount + poolCount == 0) {
            errors.add(new ErrorBean("", "error.localmirror.addComponent.missingComponent"));
            return;
        }
        if (volCount + poolCount > openMirrorSlots) {
            errors.add(new ErrorBean("", "error.localmirror.toManyNewComponents"));
            return;
        }
        BigInteger size = mv.getSize();
        Vector sources = new Vector();
        if (volCount > 0 && !this.getVolumesByName(errors, componentVolumeNames, sDomainName, cfgctx, size, sources)) {
            return;
        }
        if (poolCount > 0 && !this.getPoolsByName(errors, componentPoolNames, sDomainName, cfgctx, size, sources)) {
            return;
        }
        if (null == isolationPolicy) {
            isolationPolicy = new Integer(mv.getIsolationPolicy());
        }
        if (null == resilverPriority) {
            resilverPriority = new Integer(mv.getResilverPriority());
        }
        Properties props = new Properties();
        props.put("sources", sources);
        props.put("isolationPolicy", isolationPolicy);
        props.put("resilverPriority", resilverPriority);
        props.put("snamNum", new Integer(0));
        mms.addComponent((Object)mv.getKey(), props);
    }

    private void actionRejoinComponent(List errors, SOAPContext argContext, String componentName, String sDomainName, boolean reverse) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionRejoinComponent";
        Trace.methodBegin((Object)this, (String)"actionRejoinComponent");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageMirrorServicesEnt1Interface mms = CliUtilEWS.getManageMirrorServices(cfgctx);
        MirrorComponentEnt1Interface comp = (MirrorComponentEnt1Interface)mms.getMirrorComponentByName(componentName, sDomainName);
        if (comp == null) {
            errors.add(new ErrorBean(componentName, "error.objectNotFound"));
            return;
        }
        ArrayList mappings = comp.getInitiatorMappings();
        if (null != mappings && !mappings.isEmpty()) {
            errors.add(new ErrorBean(componentName, "error.localmirror.rejoin.mappedComponent"));
            return;
        }
        MethodCallStatus mcs = null;
        mcs = reverse ? mms.reverseRejoinComponent((Object)comp.getKey()) : mms.rejoinComponent((Object)comp.getKey());
        CliUtilEWS.checkMCS(mcs, errors);
    }

    private void actionMirrorExisting(List errors, SOAPContext argContext, String baseVolumeName, List componentVolumeNames, List componentPoolNames, String sDomainName, String mirrorDesc, String logsPoolName, int resilverPriority, int isolationPolicy) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionMirrorExisting";
        Trace.methodBegin((Object)this, (String)"actionMirrorExisting");
        if (null != mirrorDesc) {
            if (CliUtilEWS.validateDescLength(mirrorDesc)) {
                errors.add(new ErrorBean(mirrorDesc, "error.desc.tooLong"));
                return;
            }
            if (CliUtilEWS.validateDescChars(mirrorDesc)) {
                errors.add(new ErrorBean(mirrorDesc, "error.desc.illegalChar"));
                return;
            }
        }
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageStorageDomainsInterface msdi = ManageStorageDomainsFactory.getManager();
        if (null == msdi) {
            Trace.verbose((Object)this, (String)"actionMirrorExisting", (String)"ManageStorageDomainsInterface is null");
            throw new ConfigMgmtException("error.bolMgr.noSdomainMgr", "");
        }
        msdi.init(cfgctx, null);
        StorageDomainInterface sdomain = msdi.getItemByName(sDomainName);
        if (null == sdomain) {
            errors.add(new ErrorBean(sDomainName, "error.objectNotFound"));
            return;
        }
        ManageStorageVolumes msv = (ManageStorageVolumes)ManageStorageVolumesFactory.getManager();
        if (msv == null) {
            Trace.verbose((Object)this, (String)"actionMirrorExisting", (String)"ManageStorageVolumes is null");
            throw new ConfigMgmtException("error.bolMgr.noVolMgr", "");
        }
        msv.init(cfgctx, null);
        Trace.verbose((Object)this, (String)"actionMirrorExisting", (String)"msv.init() done");
        StorageVolumeInterface sourceVolume = null;
        try {
            sourceVolume = msv.getItemByName(baseVolumeName, null, sDomainName);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, (String)"actionMirrorExisting", (String)("ConfigMgmtException: " + cme.toString() + "\n"));
            errors.add(new ErrorBean("", cme));
            return;
        }
        catch (ItemNotFoundException ex) {
            Trace.error((Object)this, (String)"actionMirrorExisting", (String)("ItemNotFoundException: " + ex.toString() + "\n"));
            errors.add(new ErrorBean(baseVolumeName, "error.objectNotFound"));
            return;
        }
        if (null == sourceVolume) {
            errors.add(new ErrorBean(baseVolumeName, "error.objectNotFound"));
            return;
        }
        if (this.validateVolumeGoodForMirror(errors, sourceVolume, 2)) {
            return;
        }
        BigInteger size = sourceVolume.getSize();
        Vector<StorageVolumeInterface> sources = new Vector<StorageVolumeInterface>();
        sources.add(sourceVolume);
        int volCount = 0;
        int poolCount = 0;
        if (null != componentVolumeNames) {
            volCount = componentVolumeNames.size();
        }
        if (null != componentPoolNames) {
            poolCount = componentPoolNames.size();
        }
        if (volCount + poolCount > 3) {
            errors.add(new ErrorBean("", "error.localmirror.toManyNewComponents"));
            return;
        }
        if (volCount + poolCount == 0) {
            errors.add(new ErrorBean("", "error.localmirror.addComponent.missingComponent"));
            return;
        }
        if (volCount > 0 && !this.getVolumesByName(errors, componentVolumeNames, sDomainName, cfgctx, size, sources)) {
            return;
        }
        if (poolCount > 0 && !this.getPoolsByName(errors, componentPoolNames, sDomainName, cfgctx, size, sources)) {
            return;
        }
        ManageStoragePoolsInterface poolMan = CliUtilEWS.getManagePoolServices(cfgctx);
        StoragePoolInterface logsPool = null;
        if (null != logsPoolName) {
            try {
                logsPool = poolMan.getItemByName(logsPoolName, sDomainName);
            }
            catch (ItemNotFoundException infe) {
                errors.add(new ErrorBean(logsPoolName, "error.objectNotFound"));
                return;
            }
            if (null == logsPool) {
                errors.add(new ErrorBean(logsPoolName, "error.objectNotFound"));
                return;
            }
        }
        Properties props = new Properties();
        if (null != mirrorDesc) {
            props.put("description", mirrorDesc);
        }
        props.put("domain", sdomain);
        props.put("sources", sources);
        props.put("isolationPolicy", new Integer(isolationPolicy));
        props.put("resilverPriority", new Integer(resilverPriority));
        props.put("snamNum", new Integer(0));
        if (null != logsPool) {
            Vector<StoragePoolInterface> logsPoolVector = new Vector<StoragePoolInterface>();
            logsPoolVector.add(logsPool);
            props.put("logPools", logsPoolVector);
        }
        ManageMirrorServicesEnt1Interface mms = CliUtilEWS.getManageMirrorServices(cfgctx);
        mms.create(props);
    }

    private void actionModifyResilver(List errors, SOAPContext argContext, String mirrorName, String sDomainName, int resilverPriority) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionModifyResilver";
        Trace.methodBegin((Object)this, (String)"actionModifyResilver");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageMirrorServicesEnt1Interface mms = CliUtilEWS.getManageMirrorServices(cfgctx);
        MirroredVolumeEnt1Interface mv = (MirroredVolumeEnt1Interface)mms.getMirroredVolumeByName(mirrorName, sDomainName);
        if (null == mv) {
            errors.add(new ErrorBean(mirrorName, "error.objectNotFound"));
            return;
        }
        mv.setResilverPriority(resilverPriority);
        mv.save();
    }

    private void actionRepairLogs(List errors, SOAPContext argContext, String mirrorName, String sDomainName) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "actionRepairLogs";
        Trace.methodBegin((Object)this, (String)"actionRepairLogs");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManageMirrorServicesEnt1Interface mms = CliUtilEWS.getManageMirrorServices(cfgctx);
        MirroredVolumeEnt1Interface mv = (MirroredVolumeEnt1Interface)mms.getMirroredVolumeByName(mirrorName, sDomainName);
        if (null == mv) {
            errors.add(new ErrorBean(mirrorName, "error.objectNotFound"));
            return;
        }
        mms.repairLogs((Object)mv.getKey());
    }

    private boolean getVolumesByName(List errors, List sourceVolumeName, String sDomainName, ConfigContext cfgctx, BigInteger size, List sources) throws ConfigMgmtException {
        String METHOD_NAME = "getVolumesByName";
        Trace.methodBegin((Object)this, (String)"getVolumesByName");
        ManageStorageVolumes msv = (ManageStorageVolumes)ManageStorageVolumesFactory.getManager();
        if (msv == null) {
            Trace.verbose((Object)this, (String)"getVolumesByName", (String)"ManageStorageVolumes is null");
            throw new ConfigMgmtException("error.bolMgr.noVolMgr", "");
        }
        msv.init(cfgctx, null);
        Trace.verbose((Object)this, (String)"getVolumesByName", (String)"msv.init() done");
        int n = sourceVolumeName.size();
        for (int i = 0; i < n; ++i) {
            String componentVolumeName = (String)sourceVolumeName.get(i);
            StorageVolumeInterface componentVolume = null;
            try {
                componentVolume = msv.getItemByName(componentVolumeName, null, sDomainName);
                if (null == componentVolume) {
                    errors.add(new ErrorBean(componentVolumeName, "error.objectNotFound"));
                    return false;
                }
                this.validateVolumeGoodForMirror(errors, componentVolume, 3);
                if (componentVolume.getSize().compareTo(size) < 0) {
                    errors.add(new ErrorBean(componentVolumeName, "error.localmirror.componentVolume.insufficientCapacity"));
                    return false;
                }
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, (String)"getVolumesByName", (String)("ConfigMgmtException: " + cme.toString() + "\n"));
                errors.add(new ErrorBean("", cme));
                return false;
            }
            catch (ItemNotFoundException ex) {
                Trace.error((Object)this, (String)"getVolumesByName", (String)("ItemNotFoundException: " + ex.toString() + "\n"));
                errors.add(new ErrorBean(componentVolumeName, "error.objectNotFound"));
                return false;
            }
            sources.add(componentVolume);
        }
        return true;
    }

    private boolean getPoolsByName(List errors, List sourcePoolNames, String sDomainName, ConfigContext cfgctx, BigInteger size, List sources) throws ConfigMgmtException {
        String METHOD_NAME = "getPoolsByName";
        Trace.methodBegin((Object)this, (String)"getPoolsByName");
        ManageStoragePoolsInterface poolMgr = ManageStoragePoolsFactory.getManager();
        poolMgr.init(cfgctx, null);
        ManageStorageProfilesInterface profileMgr = ManageStorageProfilesFactory.getManager();
        profileMgr.init(cfgctx, null);
        boolean first = true;
        int virtStrategy = 0;
        int stripSize = 0;
        for (int i = 0; i < sourcePoolNames.size(); ++i) {
            String poolName = (String)sourcePoolNames.get(i);
            StoragePoolInterface storagePool = null;
            try {
                storagePool = poolMgr.getItemByName(poolName, sDomainName);
            }
            catch (ItemNotFoundException infe) {
                errors.add(new ErrorBean(poolName, "error.objectNotFound"));
                return false;
            }
            if (null == storagePool) {
                errors.add(new ErrorBean(poolName, "error.objectNotFound"));
                return false;
            }
            if (storagePool.getUnAllocatedCapacity().compareTo(size) < 0) {
                errors.add(new ErrorBean(poolName, "error.localmirror.newComponentSourcePool.insufficientCapacity"));
                return false;
            }
            StorageProfileInterface storageProfile = profileMgr.getItemByName(storagePool.getProfileName());
            if (first) {
                virtStrategy = storageProfile.getVirtualizationStrategy();
                if (virtStrategy == 1) {
                    stripSize = storageProfile.getStripeSize();
                }
                first = false;
            } else {
                if (storageProfile.getVirtualizationStrategy() != virtStrategy) {
                    errors.add(new ErrorBean(poolName, "error.localmirror.newComponentSourcePool.incompatibleVirtualization"));
                    return false;
                }
                if (virtStrategy == 1 && storageProfile.getStripeSize() != stripSize) {
                    errors.add(new ErrorBean(poolName, "error.localmirror.newComponentSourcePool.incompatibleStripeSize"));
                    return false;
                }
            }
            sources.add(storagePool);
        }
        return true;
    }

    private boolean validateVolumeGoodForMirror(List errors, StorageVolumeInterface inVolume, int inAction) {
        if (inVolume.isSnapshot()) {
            if (2 == inAction) {
                errors.add(new ErrorBean(inVolume.getName(), "error.localmirror.create.snapshot"));
                return true;
            }
            if (3 == inAction) {
                errors.add(new ErrorBean(inVolume.getName(), "error.localmirror.addComponent.snapshot"));
                return true;
            }
        }
        if (inVolume.isMirrorComponent()) {
            if (2 == inAction) {
                errors.add(new ErrorBean(inVolume.getName(), "error.localmirror.create.alreadyComponent"));
                return true;
            }
            if (3 == inAction) {
                errors.add(new ErrorBean(inVolume.getName(), "error.localmirror.addComponent.alreadyComponent"));
                return true;
            }
        }
        if (1 == inVolume.getRedundancyType()) {
            if (2 == inAction) {
                errors.add(new ErrorBean(inVolume.getName(), "error.localmirror.create.alreadyMirror"));
                return true;
            }
            if (3 == inAction) {
                errors.add(new ErrorBean(inVolume.getName(), "error.localmirror.addComponent.alreadyMirror"));
                return true;
            }
        }
        if (3 == inAction) {
            if (6 == inVolume.getState()) {
                errors.add(new ErrorBean(inVolume.getName(), "error.localmirror.addComponent.mapped"));
                return true;
            }
            if (inVolume.getSnapshotPoolSize() > 0) {
                errors.add(new ErrorBean(inVolume.getName(), "error.localmirror.addComponent.snapshotReserve"));
                return true;
            }
        }
        return false;
    }
}

