/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.LicenseProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.license.License;
import com.sun.netstorage.array.mgmt.cfg.license.LicenseManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.license.LicenseManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.license.Summary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.soap.rpc.SOAPContext;

public class LicenseEWS
extends CommandProcessorBase {
    protected CommandResult doAdd(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doAdd";
        Trace.methodBegin((Object)this, (String)METHOD_NAME);
        String sLicenseKey = pcl.getResource().getFirstValue();
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == sLicenseKey) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionAddLicense(errors, argContext, sLicenseKey);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected CommandResult doRemove(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doRemove";
        Trace.methodBegin((Object)this, (String)METHOD_NAME);
        String sLicenseKey = pcl.getResource().getFirstValue();
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == sLicenseKey) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionRemoveLicense(errors, argContext, sLicenseKey);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)METHOD_NAME);
        List keys = pcl.getResource().getValues();
        boolean showCompliance = false;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-c".equals(name) && !"--compliance".equals(name)) continue;
            showCompliance = true;
        }
        List licenseList = this.buildBeanList(argContext, keys, showCompliance);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, licenseList);
        return result;
    }

    private void actionAddLicense(List errors, SOAPContext argContext, String inLicenseKey) throws UnauthorizedException {
        String METHOD_NAME = "actionAddLicense";
        Trace.methodBegin((Object)this, (String)METHOD_NAME);
        ConfigContext cfgctx = this.getConfigContext(argContext);
        LicenseManagerInterface lmi = LicenseManagerFactory.getManager((ConfigContext)cfgctx);
        if (!lmi.add(inLicenseKey)) {
            errors.add(new ErrorBean(inLicenseKey, "error.license.add"));
        }
    }

    private void actionRemoveLicense(List errors, SOAPContext argContext, String inLicenseKey) throws UnauthorizedException {
        String METHOD_NAME = "actionRemoveLicense";
        Trace.methodBegin((Object)this, (String)METHOD_NAME);
        ConfigContext cfgctx = this.getConfigContext(argContext);
        LicenseManagerInterface lmi = LicenseManagerFactory.getManager((ConfigContext)cfgctx);
        lmi.remove(inLicenseKey);
    }

    private List buildBeanList(SOAPContext argContext, List keys, boolean showCompliance) throws UnauthorizedException {
        String METHOD_NAME = "buildBeanList";
        Trace.methodBegin((Object)this, (String)METHOD_NAME);
        ArrayList<LicenseProps> results = new ArrayList<LicenseProps>();
        ConfigContext cfgctx = this.getConfigContext(argContext);
        LicenseManagerInterface licMan = LicenseManagerFactory.getManager((ConfigContext)cfgctx);
        License[] allLicenses = licMan.getLicenses();
        if (showCompliance) {
            HashMap<String, Integer> licenseCounts = new HashMap<String, Integer>();
            for (int i = 0; i < allLicenses.length; ++i) {
                Integer count = (Integer)licenseCounts.get(allLicenses[i].getFeatureName());
                if (count == null) {
                    count = new Integer(0);
                }
                count = new Integer(count + 1);
                licenseCounts.put(allLicenses[i].getFeatureName(), count);
            }
            Summary[] allSummaries = licMan.getSummary();
            for (int i = 0; i < allSummaries.length; ++i) {
                LicenseProps lp = new LicenseProps();
                lp.setFeature(allSummaries[i].getFeatureName());
                Integer count = (Integer)licenseCounts.get(allSummaries[i].getFeatureName());
                if (null == count) {
                    lp.setLicenseCount("0");
                } else {
                    lp.setLicenseCount(count.toString());
                }
                boolean compliance = allSummaries[i].getAmountLicensed() == Long.MAX_VALUE ? true : allSummaries[i].getAmountLicensed() >= allSummaries[i].getAmountInUse();
                lp.setInCompliance(compliance);
                lp.setAmountLicensed(this.cvtAmountToStr(allSummaries[i].getAmountLicensed(), true));
                lp.setAmountInUse(this.cvtAmountToStr(allSummaries[i].getAmountInUse(), false));
                results.add(lp);
            }
        } else if (null != keys && !keys.isEmpty()) {
            ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
            int c = keys.size();
            for (int i = 0; i < c; ++i) {
                String key = (String)keys.get(i);
                boolean keyFound = false;
                for (int j = 0; j < allLicenses.length; ++j) {
                    if (!key.equals(allLicenses[j].toString())) continue;
                    keyFound = true;
                    License lic = allLicenses[j];
                    LicenseProps lp = new LicenseProps();
                    lp.showDetails();
                    lp.setKey(key);
                    lp.setFeature(allLicenses[j].getFeatureName());
                    lp.setAmountLicensed(this.cvtAmountToStr(allLicenses[j].getAmount(), true));
                    lp.setVersion("" + allLicenses[j].getVersion());
                    lp.setSystemId(allLicenses[j].getSystemId());
                    lp.setLicenseId(Long.toString(allLicenses[j].getLicenseId()));
                    if (null == allLicenses[j].getExpiration()) {
                        lp.setExpDate("");
                    } else {
                        lp.setExpDate(allLicenses[j].getExpiration().toString());
                    }
                    results.add(lp);
                    break;
                }
                if (keyFound) continue;
                errors.add(new ErrorBean(key, "error.objectNotFound"));
            }
            results.addAll(errors);
        } else {
            for (int i = 0; i < allLicenses.length; ++i) {
                LicenseProps lp = new LicenseProps();
                lp.setKey(allLicenses[i].toString());
                lp.setFeature(allLicenses[i].getFeatureName());
                lp.setAmountLicensed(this.cvtAmountToStr(allLicenses[i].getAmount(), true));
                results.add(lp);
            }
        }
        return results;
    }

    private String cvtAmountToStr(long inAmount, boolean CheckUnlimited) {
        if (CheckUnlimited && inAmount == Long.MAX_VALUE) {
            return "Unlimited";
        }
        return Long.toString(inAmount / 0x40000000L) + "GB";
    }
}

