/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.JobProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.FilteringResult;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class JobsEWS
extends CommandProcessorBase {
    public static final int ALL_JOBS = 0;
    public static final int OUTSTANDING_JOBS_ONLY = 1;
    public static final int COMPLETED_JOBS_ONLY = 2;
    private Jobs jobzBizObj = new Jobs();

    private List getDSPallJobs(JobManagerInterface jmi) throws ConfigMgmtException {
        jmi.reload();
        jmi.setShowAllJobs(true);
        return jmi.getItemList();
    }

    private List getDSPoutstandingJobs(JobManagerInterface jmi) throws ConfigMgmtException {
        jmi.reload();
        jmi.setShowAllJobs(false);
        return jmi.getItemList();
    }

    private List getDSPcompletedJobs(JobManagerInterface jmi) throws ConfigMgmtException {
        jmi.reload();
        jmi.setShowAllJobs(true);
        return jmi.getCompletedList();
    }

    public List list(SOAPContext argContext, int jobStatus, List jobIdList) throws UnauthorizedException, ConfigMgmtException, Exception {
        String METHOD_NAME = "list";
        ConfigContext context = this.getConfigContext(argContext);
        Vector result = null;
        List allJobs = null;
        JobManagerInterface jmi = JobManagerFactory.create();
        jmi.init(this.getConfigContext(argContext), null);
        allJobs = jobStatus == 0 ? this.getDSPallJobs(jmi) : (jobStatus == 1 ? this.getDSPoutstandingJobs(jmi) : this.getDSPcompletedJobs(jmi));
        if (jobIdList != null && jobIdList.size() > 0) {
            FilteringResult fr = FilterUtil.filterNamedObjects((List)jobIdList, (List)allJobs, (NameBasedComparator)BOComparators.JOB_COMPARATOR);
            List jobsToProcess = fr.getFoundItems();
            result = this.createJobDescriptionList(jobsToProcess, true);
            if (fr.hasNotFoundItems()) {
                List notFoundItems = fr.getNotFoundItems();
                for (int i = 0; i < notFoundItems.size(); ++i) {
                    result.add(new ErrorBean((String)notFoundItems.get(i), "error.objectNotFound"));
                }
            }
        } else {
            result = this.createJobDescriptionList(allJobs, false);
        }
        return result;
    }

    public Vector modify(SOAPContext argContext, List jobsToKill, List jobsToDelete) throws UnauthorizedException, Exception {
        String METHOD_NAME = "modify";
        Trace.verbose((Object)this, (String)"modify", (String)"Get CIM Handle - modify");
        ConfigContext context = this.getConfigContext(argContext);
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        try {
            if (jobsToKill != null) {
                errors.addAll(this.killJob(context, jobsToKill));
            }
            if (jobsToDelete != null) {
                errors.addAll(this.deleteJob(context, jobsToDelete));
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"Error modifying job: ", (Throwable)e);
            errors.add(new ErrorBean("", "error.jobProcessingFailure"));
        }
        return errors;
    }

    public Vector getCompletedJobs(ConfigContext context) throws Exception {
        Vector<JobInterface> result = new Vector<JobInterface>();
        List allJobs = this.jobzBizObj.getAllJobsList(context, null);
        Iterator allJobsIterator = allJobs.iterator();
        while (allJobsIterator.hasNext()) {
            JobInterface job = (JobInterface)allJobsIterator.next();
            if (job.getPercentComplete() < 100) continue;
            result.add(job);
        }
        return result;
    }

    public List getOutstandingJobs(ConfigContext context) throws Exception {
        return this.jobzBizObj.getOutstandingJobsList(context, null);
    }

    public List killJob(ConfigContext context, List jobsToKill) throws Exception {
        String METHOD_NAME = "killJob";
        Trace.methodBegin((Object)this, (String)"killJob");
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        Trace.verbose((Object)this, (String)"killJob", (String)("Attempting to kill " + jobsToKill.size() + " job(s)"));
        List allJobs = this.jobzBizObj.getAllJobsList(context, null);
        FilteringResult fr = FilterUtil.filterNamedObjects((List)jobsToKill, (List)allJobs, (NameBasedComparator)BOComparators.JOB_COMPARATOR);
        this.jobzBizObj.killJobs(fr.getFoundItems());
        if (fr.hasNotFoundItems()) {
            List notFoundItems = fr.getNotFoundItems();
            for (int i = 0; i < notFoundItems.size(); ++i) {
                errors.add(new ErrorBean((String)notFoundItems.get(i), "error.objectNotFound"));
            }
        }
        return errors;
    }

    public Vector deleteJob(ConfigContext context, List jobNames) throws Exception {
        String METHOD_NAME = "deleteJob";
        Trace.methodBegin((Object)this, (String)"deleteJob");
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        Trace.verbose((Object)this, (String)"deleteJob", (String)("Attempting to delete " + jobNames.size() + " job(s)"));
        List allJobs = this.jobzBizObj.getAllJobsList(context, null);
        FilteringResult fr = FilterUtil.filterNamedObjects((List)jobNames, (List)allJobs, (NameBasedComparator)BOComparators.JOB_COMPARATOR);
        this.jobzBizObj.deleteJobs(fr.getFoundItems());
        if (fr.hasNotFoundItems()) {
            List notFoundItems = fr.getNotFoundItems();
            for (int i = 0; i < notFoundItems.size(); ++i) {
                errors.add(new ErrorBean((String)notFoundItems.get(i), "error.objectNotFound"));
            }
        }
        return errors;
    }

    protected JobProps buildBean(JobInterface job, boolean showDetails) {
        JobProps result = new JobProps();
        result.setShowDetails(showDetails);
        result.setId(job.getId());
        result.setDescription(job.getDescription());
        result.setPercentComplete(job.getPercentComplete());
        result.setStartTime(job.getStartTime());
        result.setFinishTime(job.getEndTime());
        return result;
    }

    protected Vector createJobDescriptionList(List jobs, boolean showDetails) {
        Vector<JobProps> result = new Vector<JobProps>();
        if (jobs != null) {
            Iterator iter = jobs.iterator();
            while (iter.hasNext()) {
                JobInterface job = (JobInterface)iter.next();
                result.add(this.buildBean(job, showDetails));
            }
        }
        return result;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        List options = pcl.getOptions();
        List jobIds = new ArrayList();
        int jobStatus = 0;
        jobIds = pcl.getResource().getValues();
        if (options != null) {
            for (int i = 0; i < options.size(); ++i) {
                Option option = (Option)options.get(i);
                if (option != null && ("-o".equals(option.getName()) || "--outstanding".equals(option.getName()))) {
                    jobStatus = 1;
                    continue;
                }
                if (option == null || !"-C".equals(option.getName()) && !"--completed".equals(option.getName())) continue;
                jobStatus = 2;
            }
        }
        List jobs = this.list(argContext, jobStatus, jobIds);
        this.processResults(locale, result, jobs);
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        List options = pcl.getOptions();
        List jobsToKill = null;
        List jobsToDelete = null;
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-k".equals(option.getName()) || "--kill".equals(option.getName())) {
                jobsToKill = option.getValues();
                continue;
            }
            if (!"-d".equals(option.getName()) && !"--delete".equals(option.getName())) continue;
            jobsToDelete = option.getValues();
        }
        Vector errors = this.modify(argContext, jobsToKill, jobsToDelete);
        this.processResults(locale, result, errors);
        return result;
    }
}

