/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.LocalizationUtil;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.InitiatorPropsS1;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.DSPMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.FilteringResult;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.wbem.cim.UnsignedInt16;
import org.apache.soap.rpc.SOAPContext;

public class InitiatorsEWS
extends CommandProcessorBase {
    final String DEFAULT_OS_TYPE = "standard";
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS;

    private InitiatorPropsS1 buildBean(InitiatorInterface ii, boolean showDetails, boolean bByWWN) throws ConfigMgmtException {
        InitiatorPropsS1 ip = new InitiatorPropsS1();
        ip.setShowDetails(showDetails);
        ip.setByWWN(bByWWN);
        ip.setName(ii.getName());
        ip.setWWN(ii.getWWN());
        ip.setSdomain(ii.getStorageDomain());
        ip.setStatus(ii.getStatus());
        if (showDetails) {
            ip.setDescription(ii.getDescription());
            ip.setOsType(ii.getOSType());
            ip.setState(ii.getState());
            ip.setAssociations(ii.getVolumeMappings());
        }
        return ip;
    }

    private Vector createInitiatorPropsList(List initiatorList, boolean showDetails, boolean bByWWN) throws ConfigMgmtException {
        Vector<InitiatorPropsS1> propsList = new Vector<InitiatorPropsS1>();
        Iterator relevantInitiatorsIterator = initiatorList.iterator();
        while (relevantInitiatorsIterator.hasNext()) {
            InitiatorInterface initiator = (InitiatorInterface)relevantInitiatorsIterator.next();
            propsList.add(this.buildBean(initiator, showDetails, bByWWN));
        }
        return propsList;
    }

    protected Vector list(SOAPContext argContext, List initiators, String sDomain, boolean bByWWN) throws UnauthorizedException, ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "list";
        Trace.methodBegin((Object)this, (String)"list");
        ManageInitiatorsInterface mii = ManageInitiatorsFactory.getManager();
        if (mii == null) {
            throw new ConfigMgmtException("error.bolMgr.noIniMgr", "");
        }
        mii.init(this.getConfigContext(argContext), null);
        ArrayList allInitiators = null;
        allInitiators = sDomain != null ? mii.getItemsByStorageDomain(sDomain) : mii.getItemsBySystem();
        Trace.verbose((Object)this, (String)"list", (String)("-:-allInitiators" + allInitiators));
        FilteringResult fr = bByWWN ? FilterUtil.filterNamedObjects((List)initiators, (List)allInitiators, (NameBasedComparator)BOComparators.INITIATOR_COMPARATOR_WWN) : FilterUtil.filterNamedObjects((List)initiators, (List)allInitiators, (NameBasedComparator)BOComparators.INITIATOR_COMPARATOR);
        Trace.verbose((Object)this, (String)"list", (String)("-:-FR" + fr));
        Vector result = initiators == null || initiators.isEmpty() ? this.createInitiatorPropsList(allInitiators, false, bByWWN) : this.createInitiatorPropsList(fr.getFoundItems(), true, bByWWN);
        if (fr.hasNotFoundItems()) {
            List notFoundItems = fr.getNotFoundItems();
            for (int i = 0; i < notFoundItems.size(); ++i) {
                result.add(new ErrorBean((String)notFoundItems.get(i), "error.objectNotFound"));
            }
        }
        return result;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        CommandResult result = new CommandResult();
        List options = pcl.getOptions();
        List initiatorNames = pcl.getResource().getValues();
        String sDomain = null;
        String sNameType = new String("initiator-name");
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-S".equals(option.getName()) || "--sdomain".equals(option.getName())) {
                sDomain = option.getFirstValue();
                continue;
            }
            if (!"-T".equals(option.getName()) && !"--name-type".equals(option.getName())) continue;
            sNameType = option.getFirstValue();
        }
        boolean bByWWN = sNameType.equals("wwn");
        Vector initiators = this.list(argContext, initiatorNames, sDomain, bByWWN);
        this.processResults(locale, result, initiators);
        return result;
    }

    protected CommandResult doMap(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws BadParameterException, UnauthorizedException, ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doMap";
        Trace.methodBegin((Object)this, (String)"doMap");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String DEFAULT_PERMISSION = "readonly";
        String initiatorName = pcl.getResource().getFirstValue();
        String sdomain = "DEFAULT";
        List volumeList = null;
        Object volgroupList = null;
        String perm = "readonly";
        String lunid = null;
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-S".equals(option.getName()) || "--sdomain".equals(option.getName())) {
                sdomain = option.getFirstValue();
                continue;
            }
            if ("-v".equals(option.getName()) || "--volume".equals(option.getName())) {
                volumeList = option.getValues();
                continue;
            }
            if ("-P".equals(option.getName()) || "--permission".equals(option.getName())) {
                perm = Convert.cleanUpAndUpcase((String)option.getFirstValue());
                continue;
            }
            if (!"-l".equals(option.getName()) && !"--lun-id".equals(option.getName())) continue;
            lunid = Convert.cleanUpAndUpcase((String)option.getFirstValue());
        }
        if (lunid != null && volumeList.size() != 1) {
            throw new BadParameterException(lunid, "initiator.error.lun");
        }
        CommandResult result = new CommandResult();
        List errors = this.map(argContext, initiatorName, sdomain, perm, lunid, volumeList);
        this.processResults(locale, result, errors);
        return result;
    }

    private List map(SOAPContext argContext, String initiatorName, String sdomain, String perm, String lunid, List volumeList) throws BadParameterException, UnauthorizedException, ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "map";
        Trace.methodBegin((Object)this, (String)"map");
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        ManageStorageVolumesInterface mvi = ManageStorageVolumesFactory.getManager();
        if (mvi == null) {
            Trace.verbose((Object)this, (String)"map", (String)"ManageStorageVolumesInterface is null");
            throw new ConfigMgmtException("error.bolMgr.noVolMgr", "");
        }
        ConfigContext context = this.getConfigContext(argContext);
        mvi.init(context, null);
        Trace.verbose((Object)this, (String)"map", (String)"-:- mvi.init() done");
        ManageInitiatorsInterface mi = ManageInitiatorsFactory.getManager();
        if (mi == null) {
            Trace.verbose((Object)this, (String)"map", (String)"mi null");
            throw new ConfigMgmtException("error.bolMgr.noIniMgr", "");
        }
        mi.init(context, null);
        Trace.verbose((Object)this, (String)"map", (String)"mi.init done");
        InitiatorInterface ii = mi.getItemByName(initiatorName);
        if (ii == null) {
            throw new ItemNotFoundException(initiatorName);
        }
        HashSet<UnsignedInt16> permissionSet = new HashSet<UnsignedInt16>();
        permissionSet.add(new UnsignedInt16("5"));
        if (perm.equalsIgnoreCase("readwrite")) {
            permissionSet.add(new UnsignedInt16("6"));
        }
        Trace.verbose((Object)this, (String)"map", (String)("-:- permission specified:  " + perm + ", " + permissionSet));
        Iterator vi = volumeList.iterator();
        while (vi.hasNext()) {
            String volumeName = (String)vi.next();
            StorageVolumeInterface svi = mvi.getItemByName(volumeName);
            if (svi == null) {
                throw new ItemNotFoundException(volumeName);
            }
            if (!sdomain.equals(svi.getStorageDomainName())) {
                Trace.verbose((Object)this, (String)"map", (String)("specified domain not equal that of volume" + sdomain + "-:-" + svi.getStorageDomainName()));
                errors.add(new ErrorBean(sdomain + ": " + volumeName, "error.objectNotFound"));
                continue;
            }
            int lun = -1;
            lun = lunid != null ? Integer.parseInt(lunid) : ii.getNextAvailableLUN();
            MethodCallStatus mcs = null;
            long start3 = 0L;
            long end3 = 0L;
            try {
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS))) {
                    start3 = System.currentTimeMillis();
                }
                mcs = svi.createMapping(lun, permissionSet, ii);
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS))) {
                    end3 = System.currentTimeMillis();
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS), (String)"map", (String)("createMapping: " + (end3 - start3)));
                }
            }
            catch (ConfigMgmtException cme) {
                throw new DSPMgmtException((Exception)((Object)cme), mcs);
            }
            int rc = mcs.getReturnCode();
            if (rc == 0) continue;
            errors.add(new ErrorBean(LocalizationUtil.processMCS((MethodCallStatus)mcs), "error.mcs"));
        }
        return errors;
    }

    protected CommandResult doUnmap(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doUnmap";
        Trace.methodBegin((Object)this, (String)"doUnmap");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String initiatorName = pcl.getResource().getFirstValue();
        String sdomain = "DEFAULT";
        List volumeList = null;
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-S".equals(option.getName()) || "--sdomain".equals(option.getName())) {
                sdomain = option.getFirstValue();
                continue;
            }
            if (!"-v".equals(option.getName()) && !"--volume".equals(option.getName())) continue;
            volumeList = option.getValues();
        }
        CommandResult result = new CommandResult();
        List errors = this.unmap(argContext, initiatorName, sdomain, volumeList);
        this.processResults(locale, result, errors);
        return result;
    }

    private List unmap(SOAPContext argContext, String initiatorName, String sdomain, List volumeList) throws UnauthorizedException, ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "unmap";
        Trace.methodBegin((Object)this, (String)"unmap");
        ManageInitiatorsInterface mi = ManageInitiatorsFactory.getManager();
        if (mi == null) {
            Trace.verbose((Object)this, (String)"unmap", (String)"ManageInitiatorsInterface null");
            throw new ConfigMgmtException("error.bolMgr.noIniMgr", "");
        }
        ConfigContext context = this.getConfigContext(argContext);
        mi.init(context, null);
        Trace.verbose((Object)this, (String)"unmap", (String)"mi.init done");
        InitiatorInterface ii = mi.getItemByName(initiatorName);
        if (ii == null) {
            throw new ItemNotFoundException(initiatorName);
        }
        ManageStorageVolumesInterface mvi = ManageStorageVolumesFactory.getManager();
        if (mvi == null) {
            Trace.verbose((Object)this, (String)"unmap", (String)"ManageStorageVolumesInterface null");
            throw new ConfigMgmtException("error.bolMgr.noVolMgr", "");
        }
        mvi.init(context, null);
        Trace.verbose((Object)this, (String)"unmap", (String)"-:- mvi.init() done");
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        Iterator vi = volumeList.iterator();
        while (vi.hasNext()) {
            String volName = (String)vi.next();
            StorageVolumeInterface svi = mvi.getItemByName(volName);
            if (svi == null) {
                errors.add(new ErrorBean(volName, "error.objectNotFound"));
                continue;
            }
            if (!sdomain.equals(svi.getStorageDomainName())) {
                Trace.verbose((Object)this, (String)"unmap", (String)("specified domain not equal that of volume" + sdomain + "-:-" + svi.getStorageDomainName()));
                errors.add(new ErrorBean(volName, "error.objectNotFound"));
                continue;
            }
            MethodCallStatus mcs = null;
            long start5 = 0L;
            long end5 = 0L;
            try {
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS))) {
                    start5 = System.currentTimeMillis();
                }
                mcs = svi.removeMapping(ii);
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS))) {
                    end5 = System.currentTimeMillis();
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS), (String)"map", (String)("removeMapping: " + (end5 - start5)));
                }
            }
            catch (ConfigMgmtException cme) {
                throw new DSPMgmtException((Exception)((Object)cme), mcs);
            }
            int rc = mcs.getReturnCode();
            if (rc == 0) continue;
            errors.add(new ErrorBean(LocalizationUtil.processMCS((MethodCallStatus)mcs), "error.mcs"));
        }
        return errors;
    }

    protected CommandResult doCreate(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, BadParameterException, ItemNotFoundException, UnauthorizedException {
        String METHOD_NAME = "doCreate";
        Trace.methodBegin((Object)this, (String)"doCreate");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String wwn = null;
        String osType = "standard";
        String sdomain = "DEFAULT";
        String desc = null;
        String initiatorName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-w".equals(option.getName()) || "--wwn".equals(option.getName())) {
                String t = option.getFirstValue();
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS))) {
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS), (String)"doCreate", (String)("-:-t ln " + Integer.toString(t.length())));
                }
                wwn = Convert.cleanUpAndUpcase((String)option.getFirstValue());
                if (!Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS))) continue;
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS), (String)"doCreate", (String)("-:-wwn ln " + Integer.toString(wwn.length())));
                continue;
            }
            if ("-o".equals(option.getName()) || "--os-type".equals(option.getName())) {
                osType = Convert.cleanUpAndUpcase((String)option.getFirstValue());
                continue;
            }
            if ("-S".equals(option.getName()) || "--sdomain".equals(option.getName())) {
                sdomain = option.getFirstValue();
                continue;
            }
            if (!"-d".equals(option.getName()) && !"--description".equals(option.getName())) continue;
            desc = option.getFirstValue();
        }
        CommandResult result = new CommandResult();
        List errors = this.create(argContext, initiatorName, wwn, osType, sdomain, desc);
        this.processResults(locale, result, errors);
        return result;
    }

    private List create(SOAPContext argContext, String initiatorName, String wwn, String osType, String sdomain, String desc) throws ConfigMgmtException, BadParameterException, ItemNotFoundException, UnauthorizedException {
        String METHOD_NAME = "create";
        Trace.methodBegin((Object)this, (String)"create");
        StringBuffer sb = new StringBuffer();
        ManageInitiatorsInterface mii = ManageInitiatorsFactory.getManager();
        if (mii == null) {
            Trace.verbose((Object)this, (String)"create", (String)"ManageInitiatorsInterface null");
            throw new ConfigMgmtException("error.bolMgr.noIniMgr", "");
        }
        ConfigContext context = this.getConfigContext(argContext);
        mii.init(context, null);
        Trace.verbose((Object)this, (String)"create", (String)"mii.init done");
        ArrayList errors = new ArrayList();
        MethodCallStatus mcs = null;
        mcs = mii.create(initiatorName, wwn, desc, this.cvtOSStringToInt(osType), sdomain);
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS = InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS = InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS), (String)"create", (String)("mcsRet:-:- " + (mcs == null ? new String("null") : Integer.toString(mcs.getReturnCode()))));
        }
        CliUtilEWS.checkMCS(mcs, errors);
        Trace.verbose((Object)this, (String)"create", (String)"Initiator create complete");
        return errors;
    }

    protected CommandResult doDelete(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "doDelete";
        Trace.methodBegin((Object)this, (String)"doDelete");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String sdomain = null;
        List initiatorNameList = pcl.getResource().getValues();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if (!"-S".equals(option.getName()) && !"--sdomain".equals(option.getName())) continue;
            sdomain = option.getFirstValue();
        }
        List errors = this.delete(argContext, initiatorNameList);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private List delete(SOAPContext argContext, List initiatorNames) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "delete";
        Trace.methodBegin((Object)this, (String)"delete");
        ConfigContext context = this.getConfigContext(argContext);
        ManageInitiatorsFactory mif = new ManageInitiatorsFactory();
        ManageInitiatorsInterface mii = mif.getManager();
        if (mii == null) {
            Trace.verbose((Object)this, (String)"delete", (String)"ManageInitiatorsInterface null");
            throw new ConfigMgmtException("error.bolMgr.noIniMgr", "");
        }
        mii.init(context, null);
        Trace.verbose((Object)this, (String)"delete", (String)"mii.init done");
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        Iterator iter = initiatorNames.iterator();
        while (iter.hasNext()) {
            String initiatorName = (String)iter.next();
            InitiatorInterface ii = mii.getItemByName(initiatorName);
            if (ii != null) {
                if (ii.getStatus() == 1) {
                    errors.add(new ErrorBean(initiatorName, "initiator.error.deleteOnline"));
                    continue;
                }
                MethodCallStatus mcs = null;
                try {
                    mcs = mii.delete(ii.getKey());
                    int rc = mcs.getReturnCode();
                    if (rc == 0) continue;
                    errors.add(new ErrorBean(LocalizationUtil.processMCS((MethodCallStatus)mcs), "error.mcs"));
                    continue;
                }
                catch (ItemNotFoundException infe) {
                    errors.add(new ErrorBean(initiatorName, "error.objectNotFound"));
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    throw new DSPMgmtException((Exception)((Object)cme), mcs);
                }
            }
            errors.add(new ErrorBean(initiatorName, "error.objectNotFound"));
        }
        return errors;
    }

    protected List modify(SOAPContext argContext, String iniName, String sDescription, String sOsType, String sNewName, String sDomainName, String sWWN, String sType) throws ItemNotFoundException, BadParameterException, DSPMgmtException, ConfigMgmtException, UnauthorizedException, Exception {
        String METHOD_NAME = "modify";
        Trace.methodBegin((Object)this, (String)"modify");
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        ManageInitiatorsInterface mi = ManageInitiatorsFactory.getManager();
        if (mi == null) {
            Trace.verbose((Object)this, (String)"modify", (String)"ManageInitiatorsInterface null");
            throw new ConfigMgmtException("error.bolMgr.noIniMgr", "");
        }
        mi.init(this.getConfigContext(argContext), null);
        Trace.verbose((Object)this, (String)"modify", (String)"-:- mi.init done");
        InitiatorInterface ii = null;
        ii = sType != null && sType.equals("wwn") ? mi.getItemByWwn(iniName) : mi.getItemByName(iniName);
        if (ii == null) {
            throw new ItemNotFoundException(iniName);
        }
        if (sDescription != null) {
            ii.setDescription(sDescription);
        }
        if (sNewName != null) {
            ii.setName(sNewName);
        }
        if (sOsType != null) {
            Trace.verbose((Object)this, (String)"modify", (String)("Setting os type: " + sOsType + ", " + this.cvtOSStringToInt(sOsType)));
            ii.setOSType(this.cvtOSStringToInt(sOsType));
        }
        if (sDomainName != null) {
            ManageStorageDomainsInterface msdi = ManageStorageDomainsFactory.getManager();
            if (msdi == null) {
                throw new ConfigMgmtException("error.bolMgr.noSdMgr", "");
            }
            msdi.init(this.getConfigContext(argContext), null);
            Trace.verbose((Object)this, (String)"modify", (String)"msdi.init() done");
            StorageDomainInterface sdi = null;
            try {
                sdi = msdi.getItemByName(sDomainName);
            }
            catch (ConfigMgmtException e) {
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS = InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS))) {
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS = InitiatorsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.InitiatorsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$InitiatorsEWS), (String)"modify", (String)("e " + e.toString() + " sdi " + (sdi != null ? sdi.toString() : "null")));
                }
                throw new ItemNotFoundException(sDomainName);
            }
            Vector<InitiatorInterface> collection = new Vector<InitiatorInterface>();
            collection.add(ii);
            MethodCallStatus mcs = null;
            try {
                mcs = sdi.addInitiators(collection);
            }
            catch (ConfigMgmtException cme) {
                throw new DSPMgmtException((Exception)((Object)cme), mcs);
            }
            if (mcs.getReturnCode() != 0) {
                errors.add(new ErrorBean(LocalizationUtil.processMCS((MethodCallStatus)mcs), "error.mcs"));
            }
        }
        ii.save();
        return errors;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String sDescription = null;
        String sOsType = null;
        String sNewName = null;
        String sDomainName = null;
        String sWWN = null;
        String sType = null;
        String iniName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if ("-d".equals(option.getName()) || "--description".equals(option.getName())) {
                sDescription = option.getFirstValue();
                continue;
            }
            if ("-o".equals(option.getName()) || "--os-type".equals(option.getName())) {
                sOsType = option.getFirstValue();
                continue;
            }
            if ("-N".equals(option.getName()) || "--new-name".equals(option.getName())) {
                sNewName = option.getFirstValue();
                continue;
            }
            if ("-S".equals(option.getName()) || "--sdomain".equals(option.getName())) {
                sDomainName = option.getFirstValue();
                continue;
            }
            if ("-w".equals(option.getName()) || "--wwn".equals(option.getName())) {
                sWWN = option.getFirstValue();
                continue;
            }
            if (!"-T".equals(option.getName()) && !"--name-type".equals(option.getName())) continue;
            sType = option.getFirstValue();
        }
        List errors = this.modify(argContext, iniName, sDescription, sOsType, sNewName, sDomainName, sWWN, sType);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private int cvtOSStringToInt(String inOS) {
        if (inOS.equalsIgnoreCase("STANDARD")) {
            return 2;
        }
        if (inOS.equalsIgnoreCase("HPUX")) {
            return 4;
        }
        if (inOS.equalsIgnoreCase("EMULEX")) {
            return 32768;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

