/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.admin.business.FirewallAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.FirewallRuleInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.FirewallProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.soap.rpc.SOAPContext;

public class FirewallProcessor
extends CommandProcessorBase {
    private Admin bizObj = new Admin();

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        List services = pcl.getResource().getValues();
        List propsList = this.listFirewall(argContext, services);
        this.processResults(locale, result, propsList);
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, BadParameterException, CoreUIBusException, ItemNotFoundException, UnauthorizedException {
        this.checkIfReadOnly(argContext, MenuData.ADMIN_MENU);
        CommandResult result = new CommandResult();
        boolean enable = false;
        boolean disable = false;
        String serviceName = pcl.getResource().getFirstValue();
        List options = pcl.getOptions();
        if (options != null && options.size() > 0) {
            for (int i = 0; i < options.size(); ++i) {
                Option option = (Option)options.get(i);
                if ("-e".equals(option.getName()) || "--enable".equals(option.getName())) {
                    enable = true;
                    continue;
                }
                if (!"-d".equals(option.getName()) && !"--disable".equals(option.getName())) continue;
                disable = true;
            }
        }
        if (!enable && !disable || enable && disable) {
            throw new BadParameterException(serviceName, "error.illegalArgument");
        }
        List errors = this.modifyFirewall(argContext, serviceName, enable);
        this.processResults(locale, result, errors);
        return result;
    }

    public List listFirewall(SOAPContext argContext, List services) throws UnauthorizedException, ConfigMgmtException, CoreUIBusException {
        String METHOD_NAME = "listFirewall";
        Trace.methodBegin((Object)this, (String)"listFirewall");
        ConfigContext client = this.getConfigContext(argContext);
        FirewallAdminInterface adminInterface = this.bizObj.getFirewallAdminInterface(client);
        List allServices = adminInterface.getItemList();
        ArrayList<FirewallProps> propsList = new ArrayList<FirewallProps>();
        for (int i = 0; i < allServices.size(); ++i) {
            FirewallRuleInterface svc = (FirewallRuleInterface)allServices.get(i);
            boolean found = true;
            if (services != null && services.size() > 0) {
                found = false;
                for (int j = 0; j < services.size(); ++j) {
                    String service = (String)services.get(j);
                    if (!service.equals(svc.getServiceName())) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            FirewallProps result = new FirewallProps();
            result.setName(svc.getServiceName());
            result.setPort(svc.getPort());
            result.setDirection(svc.getDirection());
            result.setEnabled(svc.isOpen());
            result.setReadOnly(svc.isReadOnly());
            propsList.add(result);
        }
        Trace.verbose((Object)this, (String)"listFirewall", (String)"Method end.");
        return propsList;
    }

    public List modifyFirewall(SOAPContext argContext, String serviceName, boolean enable) throws CoreUIBusException, ConfigMgmtException, UnauthorizedException, ItemNotFoundException {
        String METHOD_NAME = "modifyFirewall";
        Trace.methodBegin((Object)this, (String)"modifyFirewall");
        ConfigContext client = this.getConfigContext(argContext);
        FirewallAdminInterface adminInterface = this.bizObj.getFirewallAdminInterface(client);
        List serviceList = adminInterface.getItemList();
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        for (int i = 0; i < serviceList.size(); ++i) {
            FirewallRuleInterface svc = (FirewallRuleInterface)serviceList.get(i);
            if (!serviceName.equals(svc.getServiceName())) continue;
            if (svc.isReadOnly()) {
                errors.add(new ErrorBean(serviceName, "admin.firewall.error.readonly"));
                return errors;
            }
            svc.setOpen(enable);
            svc.save();
            return errors;
        }
        throw new ItemNotFoundException(serviceName);
    }
}

