/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.FCPortPropsS1;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManagePortsEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManagePortsFactory;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class FCPortsEWS
extends CommandProcessorBase {
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS;

    private FCPortPropsS1 buildBean(FiberChannelPortEnt1Interface fcpi, boolean showDetails) throws ConfigMgmtException {
        FCPortPropsS1 fp = new FCPortPropsS1();
        fp.setShowDetails(showDetails);
        fp.setName(fcpi.getPortName());
        if (showDetails) {
            fp.setPortId(fcpi.getPortID());
            fp.setPortWWN(fcpi.getPortWWN());
            fp.setNodeWWN(fcpi.getNodeWWN());
            fp.setUnitType(fcpi.getFcUnitType());
            fp.setModuleType(fcpi.getModuleType());
            fp.setConfiguredSpeed(fcpi.getSpeedConfigured());
            fp.setOperationalSpeed(fcpi.getSpeedOperational());
            fp.setErrorCount(fcpi.getErrorCount());
            fp.setWriteCommands(fcpi.getWriteCommands());
            fp.setReadCommands(fcpi.getReadCommands());
            fp.setLoopResetEvents(fcpi.getLoopResetEvents());
            fp.setLoopDownEvents(fcpi.getLoopDownEvents());
            fp.setHardwareState(fcpi.getHardwareState());
            fp.setPortType(fcpi.getPortType());
            fp.setLinkState(fcpi.getLinkState());
            fp.setCapableClasses(fcpi.getProtocolsCapable());
            fp.setOperationalProtocols(fcpi.getProtocolsOperational());
            fp.setCapableProtocols(fcpi.getProtocolsCapable());
            fp.setCapableClasses(fcpi.getClassesCapable());
            fp.setOperationalClasses(fcpi.getClassesOperational());
            fp.setBytesRead(fcpi.getBytesRead());
            fp.setBytesWritten(fcpi.getBytesWritten());
            fp.setLinkFailureCount(fcpi.getLinkFailureCount());
            fp.setLinkSyncLossCount(fcpi.getLinkSyncLossCount());
            fp.setLinkDownCount(fcpi.getLinkDownCount());
            fp.setPrimSeqProtoErrorCount(fcpi.getPrimSeqProtoErrorCount());
            fp.setCRCErrors(fcpi.getCRCErrors());
            fp.setInvalidTransWords(fcpi.getInvalidTransWords());
            fp.setReplicationEnabled(fcpi.isReplicationEnabled());
        }
        return fp;
    }

    private Vector createFCPortPropsList(List portList, boolean showDetails) throws ConfigMgmtException {
        Vector<FCPortPropsS1> propsList = new Vector<FCPortPropsS1>();
        Iterator pi = portList.iterator();
        while (pi.hasNext()) {
            FiberChannelPortEnt1Interface fcpi = (FiberChannelPortEnt1Interface)pi.next();
            propsList.add(this.buildBean(fcpi, showDetails));
        }
        return propsList;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        List portNames = pcl.getResource().getValues();
        CommandResult result = new CommandResult();
        List errors = this.list(argContext, portNames);
        this.processResults(locale, result, errors);
        return result;
    }

    private List list(SOAPContext argContext, List portNames) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "list";
        Trace.methodBegin((Object)this, (String)"list");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManagePortsEnt1Interface portMgr = (ManagePortsEnt1Interface)ManagePortsFactory.getManager((ConfigContext)cfgctx);
        portMgr.init(cfgctx, null, null);
        Vector<FiberChannelPortEnt1Interface> ports = null;
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        boolean showDetail = false;
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS = FCPortsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.FCPortsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS = FCPortsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.FCPortsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS), (String)"list", (String)("portNames " + portNames));
        }
        if (null == portNames || portNames.isEmpty()) {
            ports = portMgr.getFiberChannelPortList();
        } else {
            showDetail = true;
            Iterator e = portNames.iterator();
            ports = new Vector<FiberChannelPortEnt1Interface>();
            while (e.hasNext()) {
                String portName = (String)e.next();
                FiberChannelPortEnt1Interface fcpi = portMgr.getFiberChannelPortByName(portName);
                if (fcpi == null) {
                    errors.add(new ErrorBean(portName, "error.objectNotFound"));
                    if (!Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS == null ? FCPortsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.FCPortsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS))) continue;
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS == null ? FCPortsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.FCPortsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS), (String)"list", (String)("fcpi-get " + fcpi));
                    continue;
                }
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS == null ? FCPortsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.FCPortsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS))) {
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS == null ? FCPortsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.FCPortsEWS") : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS), (String)"list", (String)("portName " + portName + " fcpi " + fcpi));
                }
                ports.add(fcpi);
            }
        }
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS = FCPortsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.FCPortsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS))) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS = FCPortsEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.FCPortsEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$FCPortsEWS), (String)"list", (String)("ports " + ports));
        }
        Vector beanList = this.createFCPortPropsList(ports, showDetail);
        beanList.addAll(errors);
        return beanList;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, BadParameterException, ConfigMgmtException {
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        String oln = pcl.getOptionListName();
        if ("replication".equals(oln)) {
            return this.processModifyReplication(locale, pcl, argContext);
        }
        if ("portspeed".equals(oln)) {
            return this.processModifyPortSpeed(locale, pcl, argContext);
        }
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        errors.add(new ErrorBean("", "error.applicationError"));
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private CommandResult processModifyReplication(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, BadParameterException, ConfigMgmtException {
        String METHOD_NAME = "processModifyReplication";
        Trace.methodBegin((Object)this, (String)"processModifyReplication");
        String portname = pcl.getResource().getFirstValue();
        Boolean enable = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-r".equals(name) && !"--replication".equals(name)) continue;
            enable = new Boolean(CliUtilEWS.cvtEnableDisable(option.getFirstValue()));
        }
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        if (null == portname || null == enable) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionModifyReplication(errors, argContext, portname, enable);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private CommandResult processModifyPortSpeed(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, BadParameterException, ConfigMgmtException {
        String METHOD_NAME = "processModifyPortSpeed";
        Trace.methodBegin((Object)this, (String)"processModifyPortSpeed");
        String portname = pcl.getResource().getFirstValue();
        Integer portspeed = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-s".equals(option.getName()) && !"--speed".equals(option.getName())) continue;
            String s = option.getFirstValue();
            if (s.equalsIgnoreCase("auto")) {
                portspeed = new Integer(0);
                continue;
            }
            if (s.startsWith("1", 0)) {
                portspeed = new Integer(1);
                continue;
            }
            if (!s.startsWith("2", 0)) continue;
            portspeed = new Integer(2);
        }
        Vector<ErrorBean> errors = new Vector<ErrorBean>();
        if (null == portname || null == portspeed) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionModifyPortSpeed(errors, argContext, portname, portspeed);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private void actionModifyPortSpeed(List errors, SOAPContext argContext, String portname, int speed) throws UnauthorizedException, BadParameterException, ConfigMgmtException {
        String METHOD_NAME = "actionModifyPortSpeed";
        Trace.methodBegin((Object)this, (String)"actionModifyPortSpeed");
        FiberChannelPortEnt1Interface fcpi = this.getFCPortByName(argContext, portname);
        if (fcpi == null) {
            errors.add(new ErrorBean(portname, "error.objectNotFound"));
            return;
        }
        fcpi.setSpeedConfigured(speed);
        fcpi.save();
    }

    private void actionModifyReplication(List errors, SOAPContext argContext, String portname, boolean enable) throws UnauthorizedException, BadParameterException, ConfigMgmtException {
        String METHOD_NAME = "actionModifyReplication";
        Trace.methodBegin((Object)this, (String)"actionModifyReplication");
        FiberChannelPortEnt1Interface fcpi = this.getFCPortByName(argContext, portname);
        if (fcpi == null) {
            errors.add(new ErrorBean(portname, "error.objectNotFound"));
            return;
        }
        fcpi.setReplicationEnabled(enable);
        fcpi.save();
    }

    private FiberChannelPortEnt1Interface getFCPortByName(SOAPContext argContext, String portname) throws ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "getFCPortByName";
        Trace.methodBegin((Object)this, (String)"getFCPortByName");
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManagePortsEnt1Interface portMgr = (ManagePortsEnt1Interface)ManagePortsFactory.getManager((ConfigContext)cfgctx);
        portMgr.init(cfgctx, null, null);
        FiberChannelPortEnt1Interface fcpi = portMgr.getFiberChannelPortByName(portname);
        return fcpi;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

