/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.ExternalStorageProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageArrayEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.FilteringResult;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class ExternalStorageEWS
extends CommandProcessorBase {
    private ExternalStorageProps buildBean(VDiskEnt1Interface vdi, boolean showDetails) throws ConfigMgmtException {
        ExternalStorageProps esp = new ExternalStorageProps();
        esp.setShowDetails(showDetails);
        esp.setExternalStorageId(vdi.getName());
        esp.setStorageDomain(vdi.getStorageDomainName());
        esp.setPool(vdi.getStoragePoolName());
        if (showDetails) {
            esp.setWWN(vdi.getWWN());
            esp.setState(vdi.isInUse());
            esp.setStatus(vdi.getStatus());
            esp.setModel(vdi.getModel());
            esp.setVendor(vdi.getVendor());
            esp.setTotalCapacity(vdi.getTotalCapacity());
            StorageArrayEnt1Interface array = vdi.getArrayController();
            if (null != array) {
                esp.setArrayId(array.getName());
            } else {
                esp.setArrayId("");
            }
            StorageVolumeInterface assocVLV = vdi.getAssociatedVLV();
            if (null != assocVLV) {
                esp.setAssocVLVName(assocVLV.getName());
            }
        }
        return esp;
    }

    private Vector createExternalStoragePropsList(List extStorageList, boolean showDetails) throws Exception {
        Vector<ExternalStorageProps> propsList = new Vector<ExternalStorageProps>();
        Iterator relevantExtStoragesIterator = extStorageList.iterator();
        while (relevantExtStoragesIterator.hasNext()) {
            VDiskEnt1Interface extStorage = (VDiskEnt1Interface)relevantExtStoragesIterator.next();
            propsList.add(this.buildBean(extStorage, showDetails));
        }
        return propsList;
    }

    protected List list(SOAPContext argContext, List extStorageNames) throws ItemNotFoundException, ConfigMgmtException, Exception {
        String METHOD_NAME = "list";
        Trace.methodBegin((Object)this, (String)"list");
        Vector result = null;
        ConfigContext context = this.getConfigContext(argContext);
        ManageVDisksInterface mvdi = ManageVDisksFactory.getManager();
        mvdi.init(context, null);
        ArrayList externalDiskList = mvdi.getExternalItemsBySystem();
        if (null != externalDiskList || !externalDiskList.isEmpty()) {
            if (null == extStorageNames || extStorageNames.isEmpty()) {
                result = this.createExternalStoragePropsList(externalDiskList, false);
            } else {
                FilteringResult fr = FilterUtil.filterNamedObjects((List)extStorageNames, (List)externalDiskList, (NameBasedComparator)BOComparators.VDISK_COMPARATOR);
                result = this.createExternalStoragePropsList(fr.getFoundItems(), true);
                if (fr.hasNotFoundItems()) {
                    List notFoundItems = fr.getNotFoundItems();
                    for (int i = 0; i < notFoundItems.size(); ++i) {
                        result.add(new ErrorBean((String)notFoundItems.get(i), "error.objectNotFound"));
                    }
                }
            }
        }
        return result;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        List extStorageNames = pcl.getResource().getValues();
        List externalStorage = this.list(argContext, extStorageNames);
        this.processResults(locale, result, externalStorage);
        return result;
    }
}

