/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.EtherportProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationLinkEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.EthernetPortEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManagePortsEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManagePortsFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.soap.rpc.SOAPContext;

public class EtherportEWS
extends CommandProcessorBase {
    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        List etherPortNames = pcl.getResource().getValues();
        ArrayList output = new ArrayList();
        this.actionListEtherports(output, argContext, etherPortNames);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, output);
        return result;
    }

    protected CommandResult doAdd(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doAdd";
        Trace.methodBegin((Object)this, (String)"doAdd");
        String portName = pcl.getResource().getFirstValue();
        String remoteAddress = null;
        String desc = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-t".equals(name) || "--remote-address".equals(name)) {
                remoteAddress = option.getFirstValue();
                continue;
            }
            if (!"-d".equals(name) && !"--description".equals(name)) continue;
            desc = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == portName || null == remoteAddress) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionAddRemoteAddress(errors, argContext, portName, remoteAddress, desc);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected CommandResult doRemove(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doRemove";
        Trace.methodBegin((Object)this, (String)"doRemove");
        String portName = pcl.getResource().getFirstValue();
        List remoteAddresses = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if (!"-t".equals(name) && !"--remote-address".equals(name)) continue;
            remoteAddresses = option.getValues();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == portName || null == remoteAddresses || remoteAddresses.isEmpty()) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionRemoveRemoteAddress(errors, argContext, portName, remoteAddresses);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        String portName = pcl.getResource().getFirstValue();
        String gateway = null;
        String mask = null;
        String localAddress = null;
        String wndSize = null;
        Boolean enableReplication = null;
        List options = pcl.getOptions();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String name = option.getName();
            if ("-r".equals(name) || "--replication".equals(name)) {
                enableReplication = new Boolean(CliUtilEWS.cvtEnableDisable(option.getFirstValue()));
                continue;
            }
            if ("-g".equals(name) || "--gateway".equals(name)) {
                gateway = option.getFirstValue();
                continue;
            }
            if ("-m".equals(name) || "--network-mask".equals(name)) {
                mask = option.getFirstValue();
                continue;
            }
            if ("-l".equals(name) || "--local-address".equals(name)) {
                localAddress = option.getFirstValue();
                continue;
            }
            if (!"-w".equals(name) && !"--window-size".equals(name)) continue;
            wndSize = option.getFirstValue();
        }
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        if (null == portName || null == enableReplication) {
            errors.add(new ErrorBean("", "error.applicationError"));
        } else {
            this.actionModify(errors, argContext, portName, enableReplication, gateway, mask, localAddress, wndSize);
        }
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    private void actionListEtherports(List output, SOAPContext argContext, List etherPortNames) throws ConfigMgmtException, UnauthorizedException {
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManagePortsEnt1Interface portMgr = (ManagePortsEnt1Interface)ManagePortsFactory.getManager((ConfigContext)cfgctx);
        portMgr.init(cfgctx, null, null);
        if (null == etherPortNames || etherPortNames.isEmpty()) {
            List allPorts = portMgr.getEthernetPortList();
            int c = allPorts.size();
            for (int i = 0; i < c; ++i) {
                EthernetPortEnt1Interface etherPort = (EthernetPortEnt1Interface)allPorts.get(i);
                EtherportProps epp = new EtherportProps();
                epp.setPortName(etherPort.getPortName());
                output.add(epp);
            }
        } else {
            int c = etherPortNames.size();
            for (int i = 0; i < c; ++i) {
                String portName = (String)etherPortNames.get(i);
                EthernetPortEnt1Interface etherPort = portMgr.getEthernetPortByName(portName);
                if (null == etherPort) {
                    output.add(new ErrorBean(portName, "error.objectNotFound"));
                    continue;
                }
                EtherportProps epp = new EtherportProps();
                epp.setShowDetails(true);
                epp.setPortName(etherPort.getPortName());
                epp.setHardwareState(etherPort.getHardwareState());
                epp.setReplicationEnabled(etherPort.isReplicationEnabled());
                epp.setPortSpeed(etherPort.getSpeedOperational());
                epp.setDuplexMode(etherPort.getDuplexMode());
                epp.setPortType(etherPort.getPortType());
                epp.setWriteCommands(etherPort.getWriteCommands());
                epp.setReadCommands(etherPort.getReadCommands());
                epp.setBytesWritten(etherPort.getBytesWritten());
                epp.setBytesRead(etherPort.getBytesRead());
                epp.setReadErrors(etherPort.getReadErrors());
                epp.setWriteErrors(etherPort.getWriteErrors());
                epp.setLocalAddress(etherPort.getLocalAddress());
                epp.setNetworkMask(etherPort.getNetworkMask());
                epp.setDefaultGateway(etherPort.getDefaultGateway());
                epp.setWindowSize(etherPort.getWindowSize());
                epp.setRepLinks(etherPort.getAssociatedReplicationLinks());
                output.add(epp);
            }
        }
    }

    private void actionAddRemoteAddress(List errors, SOAPContext argContext, String portName, String remoteAddress, String desc) throws ConfigMgmtException, UnauthorizedException {
        if (null != desc && CliUtilEWS.validateDesc(errors, desc)) {
            return;
        }
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManagePortsEnt1Interface portMgr = (ManagePortsEnt1Interface)ManagePortsFactory.getManager((ConfigContext)cfgctx);
        portMgr.init(cfgctx, null, null);
        EthernetPortEnt1Interface etherPort = portMgr.getEthernetPortByName(portName);
        if (null == etherPort) {
            errors.add(new ErrorBean(portName, "error.objectNotFound"));
            return;
        }
        if (!etherPort.isReplicationEnabled()) {
            errors.add(new ErrorBean(portName, "error.etherPort.replicationNotEnabled"));
            return;
        }
        ManageReplicationServicesEnt1Interface repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
        ArrayList<ReplicationLinkEnt1Interface> link = new ArrayList<ReplicationLinkEnt1Interface>();
        link.add(repMgr.createReplicationLink(remoteAddress, desc));
        repMgr.addReplicationLinks((Object)etherPort.getKey(), link);
    }

    private void actionRemoveRemoteAddress(List errors, SOAPContext argContext, String portName, List remoteAddresses) throws ConfigMgmtException, UnauthorizedException {
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManagePortsEnt1Interface portMgr = (ManagePortsEnt1Interface)ManagePortsFactory.getManager((ConfigContext)cfgctx);
        portMgr.init(cfgctx, null, null);
        EthernetPortEnt1Interface etherPort = portMgr.getEthernetPortByName(portName);
        if (null == etherPort) {
            errors.add(new ErrorBean(portName, "error.objectNotFound"));
            return;
        }
        List curLinks = etherPort.getAssociatedReplicationLinks();
        ArrayList<ReplicationLinkEnt1Interface> links = new ArrayList<ReplicationLinkEnt1Interface>();
        for (int i = 0; i < remoteAddresses.size(); ++i) {
            String remoteAddress = (String)remoteAddresses.get(i);
            if (null == remoteAddress || remoteAddress.length() <= 0) continue;
            boolean found = false;
            for (int j = 0; j < curLinks.size(); ++j) {
                ReplicationLinkEnt1Interface curLink = (ReplicationLinkEnt1Interface)curLinks.get(j);
                if (!curLink.getRemoteAddress().equals(remoteAddress)) continue;
                links.add(curLink);
                found = true;
                break;
            }
            if (found) continue;
            errors.add(new ErrorBean(remoteAddress, "error.objectNotFound"));
        }
        if (!links.isEmpty()) {
            ManageReplicationServicesEnt1Interface repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
            repMgr.removeReplicationLinks((Object)etherPort.getKey(), links);
        }
    }

    private void actionModify(List errors, SOAPContext argContext, String portName, Boolean enableReplication, String gateway, String mask, String localAddress, String wndSize) throws ConfigMgmtException, UnauthorizedException {
        ConfigContext cfgctx = this.getConfigContext(argContext);
        ManagePortsEnt1Interface portMgr = (ManagePortsEnt1Interface)ManagePortsFactory.getManager((ConfigContext)cfgctx);
        portMgr.init(cfgctx, null, null);
        EthernetPortEnt1Interface etherPort = portMgr.getEthernetPortByName(portName);
        if (null == etherPort) {
            errors.add(new ErrorBean(portName, "error.objectNotFound"));
            return;
        }
        ManageReplicationServicesEnt1Interface repMgr = CliUtilEWS.getManageReplicationServices(cfgctx);
        if (enableReplication.booleanValue()) {
            if (etherPort.isReplicationEnabled()) {
                errors.add(new ErrorBean(portName, "error.etherPort.alreadyReplicationEnabled"));
                return;
            }
            boolean missingOption = false;
            if (null == gateway || null == mask || null == localAddress) {
                errors.add(new ErrorBean("", "error.etherPort.enableOptionsMissing"));
                return;
            }
            Properties props = new Properties();
            props.put("DefaultGateway", gateway);
            props.put("NetworkMask", mask);
            props.put("LocalAddress", localAddress);
            if (wndSize != null) {
                BigInteger wS = SizeConvert.stringToBytes((String)wndSize);
                if (CliUtilEWS.validateSize(errors, wS, wndSize, new BigInteger("1024"), new BigInteger("1048576"))) {
                    return;
                }
                props.put("WindowSize", new Integer(wS.intValue()));
            }
            repMgr.enableReplicationPort((Object)etherPort.getKey(), props);
        } else {
            repMgr.disableReplicationPort((Object)etherPort.getKey());
        }
    }
}

