/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.props.DisksProps;
import com.sun.netstorage.array.mgmt.cfg.cli.props.TrayDiskProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageRaidGroups;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.RaidGroup;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Disks;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Trays;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class DiskProcessor
extends CommandProcessorBase {
    private Disks bizObj = new Disks();

    public List list(SOAPContext argContext, String arrayName, String trayId, List diskNamesList) throws UnauthorizedException, Exception {
        String METHOD_NAME = "list";
        Trace.methodBegin((Object)this, (String)"list");
        Trace.verbose((Object)this, (String)"list", (String)"Get CIM Handle -list");
        Vector<ErrorBean> errorCollector = new Vector<ErrorBean>();
        Vector result = new Vector();
        ConfigContext context = this.getConfigContext(argContext);
        T4s t4BizObj = new T4s();
        T4Interface t4 = t4BizObj.getArrayByName(context, arrayName);
        Trays traysBizObj = new Trays();
        if (t4 == null) {
            throw new ItemNotFoundException(arrayName);
        }
        List<TrayInterface> traysToProcess = new ArrayList();
        if (trayId == null && (diskNamesList == null || diskNamesList.isEmpty())) {
            traysToProcess = traysBizObj.list(context, null, t4);
        } else if (!(trayId != null || diskNamesList == null && diskNamesList.isEmpty())) {
            ArrayList<String> disksNotFound = new ArrayList<String>();
            Iterator iter = diskNamesList.iterator();
            while (iter.hasNext()) {
                String diskName = (String)iter.next();
                String extractedTrayId = this.bizObj.extractTrayId(diskName);
                if (extractedTrayId != null) {
                    TrayInterface trayID = traysBizObj.getTrayByName(context, t4, extractedTrayId);
                    if (trayID == null || traysToProcess.contains(trayID)) continue;
                    traysToProcess.add(trayID);
                    continue;
                }
                disksNotFound.add(diskName);
                errorCollector.add(new ErrorBean(diskName, "error.objectNotFound"));
            }
            if (!disksNotFound.isEmpty()) {
                Iterator iterator = disksNotFound.iterator();
                while (iterator.hasNext()) {
                    String diskNotFound = (String)iterator.next();
                    diskNamesList.remove(diskNotFound);
                }
            }
        } else if (trayId != null) {
            List allTrays = traysBizObj.list(context, null, traysBizObj.findArrayByName(context, arrayName));
            boolean found = false;
            Iterator alltrays = allTrays.iterator();
            while (alltrays.hasNext()) {
                TrayInterface TRAY = (TrayInterface)alltrays.next();
                String TRAYID = TRAY.getId().trim();
                if (!TRAYID.equals(trayId)) continue;
                found = true;
            }
            if (found) {
                traysToProcess.add(traysBizObj.getTrayByName(context, t4, trayId));
            } else {
                throw new ItemNotFoundException(trayId);
            }
        }
        result = this.createTrayDiskPropsList(context, traysToProcess, diskNamesList, false);
        if (!errorCollector.isEmpty()) {
            for (int i = 0; i < errorCollector.size(); ++i) {
                result.add(errorCollector.get(i));
            }
        }
        return result;
    }

    protected Vector createTrayDiskPropsList(ConfigContext context, List trayNamesList, List diskNamesList, boolean showDetails) throws Exception {
        Vector<Object> result = new Vector<Object>();
        if ((trayNamesList.isEmpty() || trayNamesList == null) && !diskNamesList.isEmpty()) {
            Iterator diskNotFoundIterator = diskNamesList.iterator();
            while (diskNotFoundIterator.hasNext()) {
                result.add(new ErrorBean((String)diskNotFoundIterator.next(), "error.objectNotFound"));
            }
            return result;
        }
        Iterator relevantTrayDiskPropsIterator = trayNamesList.iterator();
        while (relevantTrayDiskPropsIterator.hasNext()) {
            TrayInterface tray = (TrayInterface)relevantTrayDiskPropsIterator.next();
            TrayDiskProps trayDiskProps = this.createTrayDiskProps(context, tray, diskNamesList, false);
            result.add(trayDiskProps);
            if (trayDiskProps.getNotFoundDisks().isEmpty()) continue;
            Iterator iter = trayDiskProps.getNotFoundDisks().iterator();
            while (iter.hasNext()) {
                result.add(new ErrorBean((String)iter.next(), "error.objectNotFound"));
            }
        }
        return result;
    }

    protected TrayDiskProps createTrayDiskProps(ConfigContext context, TrayInterface tray, List diskNames, boolean showDetails) throws Exception {
        ArrayList<DisksProps> disksList = new ArrayList<DisksProps>();
        ArrayList notFoundDisks = new ArrayList();
        TrayDiskProps trayDiskProps = new TrayDiskProps();
        trayDiskProps.setTrayId(tray.getId());
        List allTrayDisks = tray.getDiskList();
        if (diskNames == null) {
            diskNames = new ArrayList<String>();
        }
        if (diskNames.isEmpty()) {
            Iterator iter3 = allTrayDisks.iterator();
            while (iter3.hasNext()) {
                DiskInterface diskInt = (DiskInterface)iter3.next();
                diskNames.add(diskInt.getName());
            }
        }
        ManageRaidGroups mrg = new ManageRaidGroups();
        mrg.setScope((InstanceWrapper)tray);
        mrg.init(context, null);
        List raidGroupList = mrg.getItemList();
        Iterator relevantDiskIterator = allTrayDisks.iterator();
        while (relevantDiskIterator.hasNext()) {
            DiskInterface disk = (DiskInterface)relevantDiskIterator.next();
            if (diskNames.contains(disk.getName())) {
                disksList.add(this.createDiskProps(context, raidGroupList, disk, false));
                diskNames.remove(disk.getName());
            }
            trayDiskProps.setDisks(disksList);
        }
        trayDiskProps.setNotFoundDisks(diskNames);
        if (!disksList.isEmpty() && disksList != null) {
            trayDiskProps.setDiskOnTrayExists(true);
        }
        return trayDiskProps;
    }

    protected DisksProps createDiskProps(ConfigContext context, List raidGroupList, DiskInterface disk, boolean showDetails) throws Exception {
        DisksProps props = new DisksProps();
        props.setDiskName(disk.getName());
        props.setDiskCapacity(disk.getCapacity().toString());
        String rgName = disk.getRaidGroupName();
        String vDiskName = "";
        if (null != rgName) {
            RaidGroup rg = null;
            Iterator iter = raidGroupList.iterator();
            while (iter.hasNext()) {
                StorageVolumeInterface sv;
                String wwn;
                rg = (RaidGroup)iter.next();
                if (!rgName.equals(rg.getName())) continue;
                List svList = rg.getVolumes();
                if (null == svList || svList.size() < 1 || null == (wwn = (sv = (StorageVolumeInterface)svList.get(0)).getDeviceID()) || wwn.length() <= 8) break;
                wwn = wwn.substring(8);
                ManageVDisks mvd = new ManageVDisks();
                mvd.init(context, null);
                VDiskInterface vdisk = mvd.getItemByWwn(wwn);
                if (vdisk == null) break;
                vDiskName = vdisk.getName();
                break;
            }
        }
        props.setPoolName(vDiskName);
        props.setRole(disk.getRole());
        props.setState(disk.getState());
        props.setStatus(disk.getStatus());
        props.setShowDetails(showDetails);
        return props;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        List options = pcl.getOptions();
        String arrayName = null;
        String trayId = null;
        List disksNames = pcl.getResource().getValues();
        if (options != null) {
            for (int i = 0; i < options.size(); ++i) {
                Option option = (Option)options.get(i);
                if (option != null && ("-t".equals(option.getName()) || "--tray".equals(option.getName()))) {
                    trayId = option.getFirstValue();
                    continue;
                }
                if (option == null || !"-a".equals(option.getName()) && !"--array".equals(option.getName())) continue;
                arrayName = option.getFirstValue();
            }
        }
        List disks = this.list(argContext, arrayName, trayId, disksNames);
        this.processResults(locale, result, disks);
        return result;
    }
}

