/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.admin.business.SystemTimeAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.commands.LoginWS;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ValidationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.validator.date.DateParser;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.soap.rpc.SOAPContext;

public class DateProcessor
extends CommandProcessorBase {
    protected Admin bizObj = new Admin();

    protected String buildDateString(Locale locale, SystemTimeAdminInterface ti) {
        Date td = ti.getTime();
        TimeZone zone = ti.getCurrentTimeZone();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", locale);
        sdf.setTimeZone(zone);
        return sdf.format(td);
    }

    protected void modifyDate(SOAPContext soapContext, String dateString, boolean isGmt, Locale locale) throws UnauthorizedException, Exception {
        String METHOD_NAME = "modifyDate";
        Trace.methodBegin((Object)this, (String)"modifyDate");
        ConfigContext context = this.getConfigContext(soapContext);
        SystemTimeAdminInterface timeInterface = this.bizObj.getSystemTimeAdminInterface(context);
        timeInterface.init(context);
        TimeZone timezone = timeInterface.getCurrentTimeZone();
        if (isGmt) {
            timezone = TimeZone.getTimeZone("GMT");
        }
        Date newDate = this.buildDate(dateString, timeInterface.getTime(), locale, timezone);
        timeInterface.setTime(newDate);
        SimpleDateFormat df = new SimpleDateFormat();
        String formattedDate = df.format(newDate);
        try {
            timeInterface.save();
            this.login(soapContext);
            LogAPI.staticLog((String)"SP_TIME_TIME_SET", (String[])new String[]{formattedDate}, (String[])new String[0]);
        }
        catch (Exception e) {
            LogAPI.staticLog((String)"SP_TIME_TIME_SET_FAILED", (String[])new String[]{formattedDate}, (String[])new String[0]);
            throw e;
        }
        Trace.verbose((Object)this, (String)"modifyDate", (String)"Method end.");
    }

    protected Date buildDate(String newDate, Date systemDate, Locale locale, TimeZone timezone) throws BadParameterException {
        Calendar calendar = Calendar.getInstance(timezone, locale);
        calendar.setTime(systemDate);
        DateParser dateParser = DateParser.getInstance();
        try {
            calendar = dateParser.parseDate(newDate, calendar);
        }
        catch (ValidationException e) {
            throw new BadParameterException(newDate, "error.illegalArgument");
        }
        return calendar.getTime();
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext soapContext) throws Exception {
        ConfigContext context = this.getConfigContext(soapContext);
        SystemTimeAdminInterface ti = this.bizObj.getSystemTimeAdminInterface(context);
        ti.init(context);
        CommandResult cr = new CommandResult();
        cr.setResult(this.buildDateString(locale, ti));
        return cr;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult cr = new CommandResult();
        boolean isGmt = false;
        Option optionGmt = pcl.getOptionByName("-G", "--GMT");
        if (optionGmt != null) {
            isGmt = new Boolean(optionGmt.getFirstValue());
        }
        this.modifyDate(argContext, pcl.getResource().getFirstValue(), isGmt, locale);
        return cr;
    }

    private void login(SOAPContext soapContext) throws Exception {
        ConfigContext context = this.getConfigContext(soapContext);
        String userName = context.getUserPrincipal().getName();
        String userPassword = context.getPasswordCredential().getUserPassword();
        LoginWS loginObject = new LoginWS();
        ResourceBundle rb = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource");
        String sscsVersion = (String)Repository.getRepository().getProperty((Object)"version");
        loginObject.initCLIUserSession(soapContext, userName, userPassword, true, sscsVersion, new CommandResult(), rb, context.getLocale());
    }
}

