/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.LocaleAware;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.ActiveUserInfo;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserData;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.rpc.SOAPContext;

public class CommandProcessorBase
implements CommandProcessor {
    private static final String NOT_IMPLEMENTED = "error.methodNotImplemented";
    public static final String RESOURCE_BUNDLE = "com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource";

    public CommandResult execute(ParsedCommandLine pcl, Locale locale, SOAPContext argCtx) throws Exception {
        String METHOD_NAME = "execute";
        Trace.methodBegin((Object)this, (String)"execute");
        ResourceBundle rb = this.getResourceBundle(locale);
        CommandResult cr = null;
        String subcommand = pcl.getCommandName();
        if (subcommand.startsWith("l")) {
            cr = this.doList(locale, pcl, argCtx);
        } else if (subcommand.startsWith("c")) {
            cr = this.doCreate(locale, pcl, argCtx);
        } else if (subcommand.startsWith("d")) {
            cr = this.doDelete(locale, pcl, argCtx);
        } else if (subcommand.startsWith("ma")) {
            cr = this.doMap(locale, pcl, argCtx);
        } else if (subcommand.startsWith("mo")) {
            cr = this.doModify(locale, pcl, argCtx);
        } else if (subcommand.startsWith("a")) {
            cr = this.doAdd(locale, pcl, argCtx);
        } else if (subcommand.startsWith("rem")) {
            cr = this.doRemove(locale, pcl, argCtx);
        } else if (subcommand.startsWith("e")) {
            cr = this.doExport(locale, pcl, argCtx);
        } else if (subcommand.startsWith("i")) {
            cr = this.doImport(locale, pcl, argCtx);
        } else if (subcommand.startsWith("u")) {
            cr = this.doUnmap(locale, pcl, argCtx);
        } else if (subcommand.startsWith("s")) {
            cr = this.doSnapshot(locale, pcl, argCtx);
        } else if (subcommand.startsWith("r")) {
            cr = this.doRescan(locale, pcl, argCtx);
        }
        if (cr == null) {
            cr.setResult(new ErrorBean(subcommand, NOT_IMPLEMENTED).toString(locale));
            cr.setErrorId("100");
        }
        return cr;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        return rb;
    }

    protected String localizeString(Locale locale, String key) {
        return this.getResourceBundle(locale).getString(key);
    }

    protected CommandResult doCreate(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doCreate", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doDelete(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doDelete", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doAdd(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doAdd", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doRemove(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doRemove", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doMap(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doMap", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doUnmap(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doUnmap", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doSnapshot(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doSnapshot", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doModify", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doList", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doExport(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doExport", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doImport(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doImport", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doRescan(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doRescan", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected void processResults(Locale locale, CommandResult result, List toProcess) {
        StringBuffer sb = new StringBuffer();
        int errorCount = 0;
        String errorCode = "";
        if (null != toProcess && null != result) {
            for (int i = 0; i < toProcess.size(); ++i) {
                Object bean = toProcess.get(i);
                if (bean instanceof ErrorBean) {
                    ++errorCount;
                    ErrorBean error = (ErrorBean)bean;
                    errorCode = error.getReturnCode();
                    sb.append(error.toString(locale)).append("\n");
                    continue;
                }
                sb.append(((LocaleAware)bean).toString(locale)).append("\n");
            }
            result.setResult(sb.toString());
            if (errorCount == 1) {
                result.setErrorId(errorCode);
            } else if (errorCount > 1) {
                result.setErrorId("100");
            }
        }
    }

    protected ConfigContext getConfigContext(SOAPContext context) throws UnauthorizedException {
        ActiveUserInfo aui;
        if (context == null) {
            return null;
        }
        HttpSession session = (HttpSession)context.getProperty(Constants.BAG_HTTPSESSION);
        ConfigContext client = (ConfigContext)session.getAttribute("ConfigContext");
        String sessionId = session.getId();
        Repository rep = Repository.getRepository();
        ActiveUserInfo activeUserInfo = aui = rep.getProperty((Object)sessionId) == null ? new ActiveUserInfo() : (ActiveUserInfo)rep.getProperty((Object)sessionId);
        if (aui.isLoggedOff) {
            client = null;
            session.invalidate();
            throw new UnauthorizedException("error.user.session.userForcedOut");
        }
        if (client == null) {
            throw new UnauthorizedException("error.user.session.userNotLoggedIn");
        }
        return client;
    }

    protected void checkIfReadOnly(SOAPContext argContext, String pageIdentifier) throws UnauthorizedException {
        ConfigContext context = this.getConfigContext(argContext);
        HttpSession session = (HttpSession)argContext.getProperty(Constants.BAG_HTTPSESSION);
        Repository rep = Repository.getRepository();
        ActiveUserInfo aui = (ActiveUserInfo)rep.getProperty((Object)session.getId());
        if (UserData.getInstance().isReadOnly(aui.role, pageIdentifier)) {
            session.removeAttribute("cli.interactive.optionName");
            session.removeAttribute("user.input.phase");
            session.removeAttribute("cli.interactive.spec");
            session.removeAttribute("cli.interactive.pcl");
            throw new UnauthorizedException("error.authorization.notEnoughPrivilegies");
        }
    }
}

