/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.LocalizationUtil;
import com.sun.netstorage.array.mgmt.cfg.cli.props.JobProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageMirrorServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageSnapShotServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirroredVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CliUtilEWS {
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$cli$commands$CliUtilEWS;

    public static int cvtSnapLevel(String sIn) {
        if (sIn == null) {
            return 10;
        }
        if (sIn.equalsIgnoreCase("LOW")) {
            return 10;
        }
        if (sIn.equalsIgnoreCase("VERYLITTLE")) {
            return 20;
        }
        if (sIn.equalsIgnoreCase("LITTLE")) {
            return 40;
        }
        if (sIn.equalsIgnoreCase("AVERAGE")) {
            return 50;
        }
        if (sIn.equalsIgnoreCase("HIGH")) {
            return 75;
        }
        if (sIn.equalsIgnoreCase("FULL")) {
            return 100;
        }
        return 10;
    }

    public static int cvtRollbackPriority(String sIn) {
        if (sIn == null) {
            return 128;
        }
        if (sIn.equalsIgnoreCase("LOW")) {
            return 192;
        }
        if (sIn.equalsIgnoreCase("MEDIUM")) {
            return 128;
        }
        if (sIn.equalsIgnoreCase("HIGH")) {
            return 64;
        }
        return 128;
    }

    public static int cvtSnapshotPolicy(String sIn) {
        if (null == sIn) {
            return 0;
        }
        if (sIn.equalsIgnoreCase("SNAPSHOT")) {
            return 1;
        }
        if (sIn.equalsIgnoreCase("VOLUME")) {
            return 0;
        }
        return 0;
    }

    public static int cvtResilverPriority(String sIn) {
        if (sIn == null) {
            return 128;
        }
        if (sIn.equalsIgnoreCase("LOW")) {
            return 192;
        }
        if (sIn.equalsIgnoreCase("MEDIUM")) {
            return 128;
        }
        if (sIn.equalsIgnoreCase("HIGH")) {
            return 64;
        }
        return 128;
    }

    public static int cvtIsolationPolicy(String sIn) {
        if (sIn == null) {
            return 1;
        }
        if (sIn.equalsIgnoreCase("REQUIRED")) {
            return 1;
        }
        if (sIn.equalsIgnoreCase("OPTIONAL")) {
            return 0;
        }
        return 1;
    }

    public static boolean cvtEnableDisable(String inValue) {
        if (null == inValue) {
            return false;
        }
        if (inValue.equalsIgnoreCase("enable")) {
            return true;
        }
        if (inValue.equalsIgnoreCase("disable")) {
            return false;
        }
        return false;
    }

    public static int cvtReplicationRole(String inValue) {
        if (null == inValue) {
            return 1;
        }
        if (inValue.equalsIgnoreCase("primary")) {
            return 1;
        }
        if (inValue.equalsIgnoreCase("secondary")) {
            return 2;
        }
        return 1;
    }

    public static int cvtReplicationMode(String inValue) {
        if (null == inValue) {
            return 3;
        }
        if (inValue.equalsIgnoreCase("sync")) {
            return 3;
        }
        if (inValue.equalsIgnoreCase("async")) {
            return 2;
        }
        return 3;
    }

    public static int cvtReplicationQueueAction(String inValue) {
        if (null == inValue) {
            return 1;
        }
        if (inValue.equalsIgnoreCase("block")) {
            return 1;
        }
        if (inValue.equalsIgnoreCase("suspend")) {
            return 2;
        }
        return 1;
    }

    public static int cvtReplicationPriority(String inValue) {
        if (null == inValue) {
            return 128;
        }
        if (inValue.equalsIgnoreCase("LOW")) {
            return 192;
        }
        if (inValue.equalsIgnoreCase("MEDIUM")) {
            return 128;
        }
        if (inValue.equalsIgnoreCase("HIGH")) {
            return 64;
        }
        return 128;
    }

    public static boolean validateNameLength(String inName) {
        if (null == inName) {
            return true;
        }
        return inName.length() > 16;
    }

    public static boolean validateNameChars(String inName) {
        if (null == inName) {
            return true;
        }
        return !Pattern.matches("[A-Za-z0-9\\_\\-]+", inName);
    }

    public static boolean validateDescLength(String inDesc) {
        if (null == inDesc) {
            return true;
        }
        return inDesc.length() > 64;
    }

    public static boolean validateDescChars(String inDesc) {
        if (null == inDesc) {
            return true;
        }
        return !Pattern.matches("[A-Za-z0-9\\_\\-\\.\\:\\,\\%\\(\\)\\{\\}\\[\\]\\`\\~\\| ]*", inDesc);
    }

    public static boolean validateMinVolumeSize(BigInteger inSize) {
        if (null == inSize) {
            return true;
        }
        return inSize.compareTo(ConstantsEnt.StorageVolumeProperties.MIN_VOLUME_SIZE) < 0;
    }

    public static boolean validateMaxVolumeSize(BigInteger inSize) {
        if (null == inSize) {
            return true;
        }
        return inSize.compareTo(ConstantsEnt.StorageVolumeProperties.MAX_VOLUME_SIZE) > 0;
    }

    public static boolean validateSizeNotZero(BigInteger inSize) {
        if (null == inSize) {
            return true;
        }
        return inSize.compareTo(new BigInteger("0")) == 0;
    }

    public static boolean validateVolumeSize(List errors, BigInteger inSize, String inSizeString) {
        if (CliUtilEWS.validateSizeNotZero(inSize)) {
            errors.add(new ErrorBean(inSizeString, "error.size.invalidformat"));
            return true;
        }
        if (CliUtilEWS.validateMinVolumeSize(inSize)) {
            errors.add(new ErrorBean(inSizeString, "error.size.tooSmall"));
            return true;
        }
        if (CliUtilEWS.validateMaxVolumeSize(inSize)) {
            errors.add(new ErrorBean(inSizeString, "error.size.tooLarge"));
            return true;
        }
        return false;
    }

    public static boolean validateDesc(List errors, String inDesc) {
        if (CliUtilEWS.validateDescLength(inDesc)) {
            errors.add(new ErrorBean(inDesc, "error.desc.tooLong"));
            return true;
        }
        if (CliUtilEWS.validateDescChars(inDesc)) {
            errors.add(new ErrorBean(inDesc, "error.desc.illegalChar"));
            return true;
        }
        return false;
    }

    public static boolean validateName(List errors, String inName) {
        if (CliUtilEWS.validateNameLength(inName)) {
            errors.add(new ErrorBean(inName, "error.name.tooLong"));
            return true;
        }
        if (CliUtilEWS.validateNameChars(inName)) {
            errors.add(new ErrorBean(inName, "error.name.illegalChar"));
            return true;
        }
        return false;
    }

    public static boolean validateWWN(List errors, String inWWN) {
        if (null == inWWN) {
            errors.add(new ErrorBean(inWWN, "error.wwn.malformed"));
            return true;
        }
        boolean match = false;
        match = Pattern.matches("[A-Fa-f0-9]{32}", inWWN);
        if (!match) {
            match = Pattern.matches("(?:[A-Fa-f0-9]{2}\\:){15}[A-Fa-f0-9]{2}", inWWN);
        }
        if (!match) {
            errors.add(new ErrorBean(inWWN + " ", "error.wwn.malformed"));
            return true;
        }
        return false;
    }

    public static boolean validateWWN16(List errors, String inWWN) {
        if (null == inWWN) {
            errors.add(new ErrorBean(inWWN, "error.wwn.malformed"));
            return true;
        }
        boolean match = false;
        match = Pattern.matches("[A-Fa-f0-9]{16}", inWWN);
        if (!match) {
            match = Pattern.matches("(?:[A-Fa-f0-9]{2}\\:){7}[A-Fa-f0-9]{2}", inWWN);
        }
        if (!match) {
            errors.add(new ErrorBean(inWWN + " ", "error.wwn.malformed"));
            return true;
        }
        return false;
    }

    public static boolean validateSize(List errors, BigInteger inSize, String inSizeString, BigInteger minSize, BigInteger maxSize) {
        if (CliUtilEWS.validateSizeNotZero(inSize)) {
            errors.add(new ErrorBean(inSizeString, "error.etherPort.InvalidFormat"));
            return true;
        }
        if (inSize.compareTo(minSize) == -1) {
            errors.add(new ErrorBean(inSizeString, "error.etherPort.Small"));
            return true;
        }
        if (inSize.compareTo(maxSize) == 1) {
            errors.add(new ErrorBean(inSizeString, "error.etherPort.Large"));
            return true;
        }
        return false;
    }

    public static ManageMirrorServicesEnt1Interface getManageMirrorServices(ConfigContext cfgctx) throws ConfigMgmtException {
        ManageMirrorServicesEnt1Interface mms = (ManageMirrorServicesEnt1Interface)ManageDataServicesFactory.getMirrorServicesManager((ConfigContext)cfgctx);
        if (null == mms) {
            throw new ConfigMgmtException("error.bolMgr.noMirrorMgr", "");
        }
        mms.init(cfgctx, null, null);
        return mms;
    }

    public static ManageStorageVolumesInterface getManageVolumeServices(ConfigContext cfgctx) throws ConfigMgmtException {
        ManageStorageVolumesInterface msvi = ManageStorageVolumesFactory.getManager();
        if (null == msvi) {
            throw new ConfigMgmtException("error.bolMgr.noVolMgr", "");
        }
        msvi.init(cfgctx, null);
        return msvi;
    }

    public static ManageReplicationServicesEnt1Interface getManageReplicationServices(ConfigContext cfgctx) throws ConfigMgmtException {
        ManageReplicationServicesEnt1Interface mrsi = (ManageReplicationServicesEnt1Interface)ManageDataServicesFactory.getReplicationServicesManager();
        if (null == mrsi) {
            throw new ConfigMgmtException("error.bolMgr.noReplicationMgr", "");
        }
        mrsi.init(cfgctx, null, null);
        return mrsi;
    }

    public static ManageStoragePoolsInterface getManagePoolServices(ConfigContext cfgctx) throws ConfigMgmtException {
        ManageStoragePoolsInterface mspi = ManageStoragePoolsFactory.getManager();
        if (mspi == null) {
            throw new ConfigMgmtException("error.bolMgr.noPoolMgr", "");
        }
        mspi.init(cfgctx, null);
        return mspi;
    }

    public static ManageSnapShotServicesEnt1Interface getManageSnapshotServices(ConfigContext cfgctx) throws ConfigMgmtException {
        ManageSnapShotServicesEnt1Interface mgrSnaps = (ManageSnapShotServicesEnt1Interface)ManageDataServicesFactory.getSnapShotServicesManager();
        if (null == mgrSnaps) {
            throw new ConfigMgmtException("error.bolMgr.noSnapShotMgr", "");
        }
        mgrSnaps.init(cfgctx, null, null);
        return mgrSnaps;
    }

    public static ManageVDisksInterface getManageVDiskServices(ConfigContext cfgctx) throws ConfigMgmtException {
        ManageVDisksInterface mvdi = ManageVDisksFactory.getManager();
        if (null == mvdi) {
            throw new ConfigMgmtException("error.bolMgr.noVdiskMgr", "");
        }
        mvdi.init(cfgctx, null);
        return mvdi;
    }

    public static ManageInitiatorsInterface getManageInitiatorsServices(ConfigContext cfgctx) throws ConfigMgmtException {
        ManageInitiatorsInterface mii = ManageInitiatorsFactory.getManager();
        if (mii == null) {
            throw new ConfigMgmtException("error.bolMgr.noIniMgr", "");
        }
        mii.init(cfgctx, null);
        return mii;
    }

    public static ManageStorageProfilesInterface getManageProfileServices(ConfigContext cfgctx) throws ConfigMgmtException {
        ManageStorageProfilesInterface mspi = ManageStorageProfilesFactory.getManager();
        if (mspi == null) {
            throw new ConfigMgmtException("error.bolMgr.noIniMgr", "");
        }
        mspi.init(cfgctx, null);
        return mspi;
    }

    public static String stripColons(String inStr) {
        return inStr.replaceAll("\\:", "");
    }

    public static boolean validateAlreadyReplicated(List errors, StorageVolumeInterface inVolume) {
        if (null == inVolume) {
            return true;
        }
        if (2 == inVolume.getRedundancyType()) {
            errors.add(new ErrorBean(inVolume.getName(), "error.repset.volumeAlreadyReplicated"));
            return true;
        }
        return false;
    }

    public static void checkMCS(MethodCallStatus mcs, List errors) {
        if (mcs != null) {
            int rc = mcs.getReturnCode();
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$commands$CliUtilEWS == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$commands$CliUtilEWS = CliUtilEWS.class$("com.sun.netstorage.array.mgmt.cfg.cli.commands.CliUtilEWS")) : class$com$sun$netstorage$array$mgmt$cfg$cli$commands$CliUtilEWS), (String)" checkMCS:-:- ", (String)Integer.toString(rc));
            if (0 == rc) {
                return;
            }
            if (4096 == rc) {
                ArrayList jobs = mcs.getJobs();
                for (int i = 0; i < jobs.size(); ++i) {
                    JobInterface ji = (JobInterface)jobs.get(i);
                    JobProps jp = new JobProps();
                    jp.setDescription(ji.getDescription());
                    jp.setId(ji.getId());
                    jp.setDisplayJobStartedMessage(true);
                    errors.add(jp);
                }
                return;
            }
            errors.add(new ErrorBean(LocalizationUtil.processMCS((MethodCallStatus)mcs), "error.mcs"));
        }
    }

    public static boolean mirrorHasSplitComponent(MirroredVolumeEnt1Interface inMirror) {
        if (null == inMirror) {
            return false;
        }
        try {
            ArrayList components = inMirror.getAssociatedComponents();
            for (int i = 0; i < components.size(); ++i) {
                MirrorComponentEnt1Interface comp = (MirrorComponentEnt1Interface)components.get(i);
                if (!comp.isSplit()) continue;
                return true;
            }
        }
        catch (ConfigMgmtException configMgmtException) {
            // empty catch block
        }
        return false;
    }

    public static boolean mirrorHasVLVComponent(MirroredVolumeEnt1Interface inMirror) {
        if (null == inMirror) {
            return false;
        }
        try {
            ArrayList components = inMirror.getAssociatedComponents();
            for (int i = 0; i < components.size(); ++i) {
                MirrorComponentEnt1Interface comp = (MirrorComponentEnt1Interface)components.get(i);
                if (!"Legacy".equalsIgnoreCase(comp.getType())) continue;
                return true;
            }
        }
        catch (ConfigMgmtException configMgmtException) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

