/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.commands;

import com.sun.netstorage.array.mgmt.cfg.cli.commands.PowerProcessor;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ArrayStatusNotOkException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.soap.rpc.SOAPContext;

public class ArrayPowerProcessor
extends PowerProcessor {
    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        ResourceBundle rb = this.getResourceBundle(locale);
        ConfigContext client = this.getConfigContext(argContext);
        String arrayName = pcl.getOptionByName("-a", "--array").getFirstValue();
        T4Interface array = null;
        String powerString = rb.getString("t4.status.2");
        try {
            array = this.bizObj.findArrayByName(client, arrayName);
        }
        catch (ArrayStatusNotOkException e) {
            powerString = rb.getString("error.general.arrayStatusNotOk") + rb.getString("t4.status." + e.getMessage());
        }
        result.setResult(powerString);
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        this.checkIfReadOnly(argContext, MenuData.ADMIN_MENU);
        String powerState = pcl.getResource().getFirstValue();
        String arrayName = pcl.getOptionByName("-a", "--array").getFirstValue();
        this.modifyPower(argContext, arrayName, powerState);
        return new CommandResult();
    }

    public void modifyPower(SOAPContext argContext, String arrayName, String newValue) throws UnauthorizedException, Exception {
        try {
            ConfigContext client = this.getConfigContext(argContext);
            T4Interface array = this.bizObj.findArrayByName(client, arrayName);
            if ("off".equalsIgnoreCase(newValue)) {
                array.shutdown();
                LogAPI.staticLog((String)"ARRAY_SHUTDOWN_INITIATED", (String[])new String[]{arrayName}, (String[])new String[0]);
            } else if ("restart".equalsIgnoreCase(newValue)) {
                array.reboot();
                LogAPI.staticLog((String)"ARRAY_REBOOT_INITIATED", (String[])new String[]{arrayName}, (String[])new String[0]);
            } else if ("restore".equalsIgnoreCase(newValue)) {
                array.resetLabels(false);
                LogAPI.staticLog((String)"ARRAY_RESET_LABELS_INITIATED", (String[])new String[]{arrayName}, (String[])new String[0]);
            }
        }
        catch (Exception e) {
            if ("off".equalsIgnoreCase(newValue)) {
                LogAPI.staticLog((String)"ARRAY_SHUTDOWN_ERROR", (String[])new String[]{arrayName}, (String[])new String[0]);
            } else if ("restart".equalsIgnoreCase(newValue)) {
                LogAPI.staticLog((String)"ARRAY_REBOOT_ERROR", (String[])new String[]{arrayName}, (String[])new String[0]);
            } else if ("rad".equalsIgnoreCase(newValue)) {
                LogAPI.staticLog((String)"ARRAY_RESET_LABELS_ERROR", (String[])new String[]{arrayName}, (String[])new String[0]);
            }
            throw new BadParameterException("", "error.powerManagement.unableToSetPowerMode");
        }
    }
}

