/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.StoragePoolsSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.StoragePoolsSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEAction;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionOperands;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionParameters;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MapInitiatorsModel;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MapInitiatorsView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.NewVolumeInitiatorsPageView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.NewVolumeNameDescPageView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.NewVolumeSelectPoolMirrorPageView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.NewVolumeSelectPoolPageView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.NewVolumeWizardData;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageMirrorServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.InitiatorVolumeMapping;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.wbem.cim.UnsignedInt16;

public class NewVolumeImpl
extends SEWizardImpl {
    public static final String MODELNAME = "NewVolumeWizard_ModelName";
    public static final String IMPLNAME = "NewVolumeWizard_ImplName";
    private static String SUCCESS_SUMMARY = "se6x20ui.wizards.volume.NewVolume.VolumeAndMap";
    private static String FAILURE_SUMMARY = "se6x20ui.error.wizards.volume.NewVolume.failed";
    private static String PARTIAL_SUMMARY = "se6x20ui.error.wizards.volume.NewVolume.partial";
    static final String NAMEDESC_PAGE = "1";
    static final String POOL_PAGE = "2";
    static final String CAPACITY_PAGE = "3";
    static final String POOL_MIRROR_PAGE = "4";
    static final String CAPACITY_MIRROR_PAGE = "5";
    static final String SNAPSHOT_PAGE = "6";
    static final String INITIATORS_PAGE = "7";
    private String domain = null;
    private LinkedList pools = null;
    private Integer isolationPolicy = null;
    private Integer resilverPriority = null;
    private LinkedList mapObjects = null;
    private BigInteger bdCapacity = null;
    private BigInteger bigIntCapacity = null;
    private int numSnapshots = 0;
    private int snapChange = 10;
    private int snapPolicy = 0;
    private String snapPool = "";
    private Integer snapComponent = null;
    private boolean boolPoolSelectionNeeded = true;
    private boolean isMirror = false;

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.volume.NewVolume.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.NewVolumeImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        model.setValue("wizPassPageSession", (Object)"false");
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new NewVolumeImpl(requestContext);
    }

    public NewVolumeImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public String getNextPageId(String pageId) {
        Trace.methodBegin((Object)((Object)this), (String)"getNextPageId");
        int page = this.pageIdToPage(pageId);
        String nextPageId = Integer.toString(this.nextPages[page][0]);
        if (pageId.equals(NAMEDESC_PAGE)) {
            if (!this.isMirror) {
                if (!this.boolPoolSelectionNeeded) {
                    nextPageId = Integer.toString(this.nextPages[page + 1][0]);
                }
            } else {
                nextPageId = Integer.toString(this.nextPages[page + 2][0]);
            }
        }
        if (pageId.equals(CAPACITY_PAGE)) {
            nextPageId = Integer.toString(this.nextPages[page + 2][0]);
        }
        return nextPageId;
    }

    public String[] getFutureSteps(String currentPageId) {
        return new String[0];
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        String pageId = wizardEvent.getPageId();
        if (pageId.equals(NAMEDESC_PAGE)) {
            this.processNameDescPage(wizardEvent);
            this.wizardModel.setValue("ProcessedNameDescPage", (Object)"true");
        } else if (pageId.equals(POOL_PAGE)) {
            this.processPoolsPage(wizardEvent);
            this.wizardModel.setValue("ProcessedPoolsPage", (Object)"true");
        } else if (pageId.equals(CAPACITY_PAGE)) {
            this.processCapacityPage(wizardEvent);
            this.wizardModel.setValue("ProcessedCapacityPage", (Object)"true");
        } else if (pageId.equals(POOL_MIRROR_PAGE)) {
            this.processPoolsMirrorPage(wizardEvent);
        } else if (pageId.equals(CAPACITY_MIRROR_PAGE)) {
            this.processCapacityPage(wizardEvent);
            this.wizardModel.setValue("ProcessedCapacityPage", (Object)"true");
        } else if (pageId.equals(SNAPSHOT_PAGE)) {
            this.processSnapshotPage(wizardEvent);
        } else if (pageId.equals(INITIATORS_PAGE)) {
            this.processInitiatorsPage(wizardEvent);
        }
        this.wizardModel.setValue("ProcessedInitiatorsPage", (Object)"true");
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        String name = (String)this.wizardModel.getValue("VolNameField");
        boolean retVal = false;
        ConfigContext context = UIUtil.getConfigContext();
        if (context == null) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Configcontext is empty");
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        ManageStorageVolumesInterface mgr = ManageStorageVolumesFactory.getManager();
        try {
            mgr.init(context, null);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        retVal = this.isMirror ? this.createMirror(context) : this.createVolume(mgr);
        if (retVal) {
            StorageVolumeInterface vol = null;
            try {
                vol = mgr.getItemByName(name);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
                this.transaction.addFailedOperation();
                this.transaction.setSummary(FAILURE_SUMMARY);
                return false;
            }
            if (null == vol) {
                Trace.error((Object)((Object)this), (String)"finishStep", (String)("Error retrieving the just created volume " + name));
                this.transaction.addFailedOperation(name, "se6x20ui.error.systemerror");
                this.transaction.setSummary(FAILURE_SUMMARY);
            } else if (this.mapObjects.size() > 0) {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Mapping volume...");
                LinkedList<StorageVolumeInterface> volumesList = new LinkedList<StorageVolumeInterface>();
                if (volumesList == null) {
                    this.transaction.addFailedOperation();
                    this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.volumecreated.mapsystemerror"));
                    return true;
                }
                volumesList.add(vol);
                SEActionOperands actionOperands = new SEActionOperands();
                if (actionOperands == null) {
                    this.transaction.addFailedOperation();
                    this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.volumecreated.mapsystemerror"));
                    return true;
                }
                actionOperands.add(volumesList, this.mapObjects, UIUtil.getBUIString((String)"se6920.action.mapping.fromtoseperator"));
                int nOps = actionOperands.getSize();
                int actionType = 3;
                SEActionParameters actionParams = new SEActionParameters(actionType);
                if (actionParams != null) {
                    int opThreshold = UIUtil.getInitParamInt((String)"VOLUME_MAP_THRESHOLD");
                    boolean requestAsync = opThreshold < 0 ? false : nOps >= opThreshold;
                    SEAction action = new SEAction(context, actionOperands, actionParams, requestAsync);
                    if (requestAsync && !action.isAsync()) {
                        Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"failed job initiation");
                        this.transaction.addFailedOperation();
                        this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.volumecreated.mapjobnotinitiated"));
                    } else {
                        Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Successful job initiation, starting action");
                        action.execute();
                        Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Back from action initiation");
                        if (requestAsync) {
                            String jobID = action.getJobID();
                            if (jobID == null) {
                                jobID = UIUtil.getBUIString((String)"se6920.action.jobunknown");
                            }
                            String jobInfo = UIUtil.getBUIString1Subst((String)"se6920.action.volumecreated.mapjobinitiated", (String)jobID);
                            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Volume created, successful job initiation for mapping, job is:" + jobID));
                            this.transaction.addSuccessfulOperation("");
                            this.transaction.setSummary(jobInfo);
                            this.transaction.setSummaryIsJobRelated();
                        } else {
                            this.transaction = action.getTransaction();
                            this.wizardModel.setDefaultContextValue("WIZARD_TRANSACTION", (Object)this.transaction);
                            this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, PARTIAL_SUMMARY);
                        }
                    }
                } else {
                    this.transaction.addFailedOperation();
                    this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.volumecreated.mapsystemerror"));
                }
            } else {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"No mapping requested");
                this.transaction.setSummary("se6x20ui.wizards.volume.NewVolume.VolumeOnly");
            }
        }
        return true;
    }

    private boolean createVolume(ManageStorageVolumesInterface mgr) {
        String name = (String)this.wizardModel.getValue("VolNameField");
        String desc = (String)this.wizardModel.getValue("VolDescField");
        String poolStr = (String)this.wizardModel.getValue("PoolNameField");
        String domain = (String)this.wizardModel.getValue("StorageDomainField");
        String stripeAll = (String)this.wizardModel.getValue("StripeAllCheckBox");
        boolean boolStripeAll = false;
        if (null != stripeAll && stripeAll.equals("true")) {
            boolStripeAll = true;
        }
        if (null == this.pools || this.pools.size() <= 0) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"pool is empty");
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        if (null == domain || domain.length() <= 0) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"domain is empty");
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        if (null == name || name.length() <= 0) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"The volume name is empty.");
            this.transaction.addFailedOperation("se6x20ui.wizards.volume.NewVolume.Name", "se6x20ui.error.wizards.volume.NewVolume.noName");
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Volume create: Name=" + name + ", desc=" + desc + ", size=" + this.bdCapacity + ", pool=" + poolStr + ", domain=" + domain + ", snaps=" + this.numSnapshots + ", activity=" + this.snapChange));
        try {
            MethodCallStatus mcs = null;
            String pool = (String)this.pools.get(0);
            Trace.verbose((Object)((Object)this), (String)"finishStep, create volume", (String)("Create Volume: Name: " + name + ", Description: " + desc + ", #Snaps: " + this.numSnapshots + ", Change: " + this.snapChange + ", Capacity: " + this.bdCapacity + ", Pool: " + pool + ", Domain: " + domain + ", Stripe All: " + boolStripeAll + ", SnapPool: " + this.snapPool + ", SnapPolicy: " + this.snapPolicy));
            ManageStorageVolumes msv = (ManageStorageVolumes)mgr;
            mcs = msv.createStorageVolume(name, desc, this.bdCapacity, pool, domain, boolStripeAll, this.numSnapshots, this.snapChange, this.snapPool, this.snapPolicy);
            Trace.verbose((Object)((Object)this), (String)"finishStep, create volume", (String)"Create Volume: No exceptions thrown");
            if (!UIUtil.isMCSSuccess((MethodCallStatus)mcs)) {
                Trace.error((Object)((Object)this), (String)"finishStep, create volume", (String)("Error creating the storage volume " + name));
                Trace.error((Object)((Object)this), (String)"finishStep, create volume", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
                this.transaction.addFailedOperation(name, "error.cim." + mcs.getReturnCode());
                this.transaction.setSummary(FAILURE_SUMMARY);
                return false;
            }
            Trace.verbose((Object)((Object)this), (String)"finishStep, create volume", (String)("Volume '" + name + "' created"));
            this.transaction.addSuccessfulOperation(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.volume.NewVolume.createStorageVolume", (String)name));
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep, create volume", (String)("ConfigMgmt Exception creating the storage volume " + name));
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.transaction.addFailedOperation(name, (Exception)((Object)cme));
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)((Object)this), (String)"finishStep, create volume", (String)("ItemNotFound Exception creating the storage volume " + name));
            Trace.error((Object)((Object)this), (Throwable)infe);
            this.transaction.addFailedOperation(name, (Exception)((Object)infe));
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        return true;
    }

    private boolean createMirror(ConfigContext context) {
        Properties props = new Properties();
        boolean haveRequiredParams = true;
        String missingRequiredParams = "";
        String MIR_SUCCESS_SUMMARY = "se6x20ui.wizards.volume.NewVolume.mirrorVolume";
        String MIR_FAILURE_SUMMARY = "se6x20ui.error.wizards.volume.Mirror.failed";
        String name = (String)this.wizardModel.getValue("VolNameField");
        String desc = (String)this.wizardModel.getValue("VolDescField");
        String domain = (String)this.wizardModel.getValue("StorageDomainField");
        boolean retVal = false;
        try {
            ManageStoragePoolsInterface mgr = ManageStoragePoolsFactory.getManager();
            mgr.init(UIUtil.getConfigContext(), null);
            if (name != null && name.length() > 0) {
                props.put("name", name);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Name, ";
            }
            if (desc != null && desc.length() > 0) {
                props.put("description", desc);
            }
            if (domain != null && domain.length() > 0) {
                ManageStorageDomainsInterface domainMgr = ManageStorageDomainsFactory.getManager();
                domainMgr.init(UIUtil.getConfigContext(), null);
                StorageDomainInterface domainObj = null;
                domainObj = domainMgr.getItemByName(domain);
                if (domainObj != null) {
                    props.put("domain", domainObj);
                } else {
                    haveRequiredParams = false;
                    missingRequiredParams = missingRequiredParams + "Domain, ";
                }
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Domain, ";
            }
            if (this.pools != null && this.pools.size() > 0 && domain != null && domain.length() > 0) {
                Vector<StoragePoolInterface> poolsVector = new Vector<StoragePoolInterface>();
                StoragePoolInterface poolObj = null;
                for (int i = 0; i < this.pools.size(); ++i) {
                    poolObj = null;
                    poolObj = mgr.getItemByName((String)this.pools.get(i), domain);
                    if (poolObj == null) continue;
                    poolsVector.add(poolObj);
                }
                if (poolsVector.size() > 0) {
                    props.put("sources", poolsVector);
                } else {
                    haveRequiredParams = false;
                    missingRequiredParams = missingRequiredParams + "Pool(s), ";
                }
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Pool(s), ";
            }
            if (this.isolationPolicy != null) {
                props.put("isolationPolicy", this.isolationPolicy);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Isolation Policy, ";
            }
            if (this.resilverPriority != null) {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Creating with resilver = " + this.resilverPriority));
                props.put("resilverPriority", this.resilverPriority);
            }
            props.put("size", this.bdCapacity);
            if (this.numSnapshots > 0) {
                props.put("snamNum", new Integer(this.numSnapshots));
                props.put("snapChange", new Integer(this.snapChange));
                props.put("snapPolicy", new Integer(this.snapPolicy));
                if (this.snapPool != null && this.snapPool.length() > 0 && domain != null && domain.length() > 0) {
                    StoragePoolInterface poolObj = mgr.getItemByName(this.snapPool, domain);
                    if (poolObj != null) {
                        props.put("snapPool", poolObj);
                    } else {
                        haveRequiredParams = false;
                        missingRequiredParams = missingRequiredParams + "SnapPool, ";
                    }
                }
                if (this.snapComponent != null) {
                    props.put("snapComponent", this.snapComponent);
                }
            }
            if (!haveRequiredParams) {
                Trace.error((Object)((Object)this), (String)"finishStep, create mirror", (String)("Missing Parameters:" + missingRequiredParams));
                this.transaction.addFailedOperation(MIR_FAILURE_SUMMARY, MIR_FAILURE_SUMMARY);
                this.transaction.setSummary(MIR_FAILURE_SUMMARY);
                return false;
            }
            ManageMirrorServicesEnt1Interface mms = (ManageMirrorServicesEnt1Interface)ManageDataServicesFactory.getMirrorServicesManager((ConfigContext)context);
            mms.init(context, null, null);
            mms.create(props);
            Trace.verbose((Object)((Object)this), (String)"finishStep, create mirror", (String)("Mirrored Volume '" + name + "' created"));
            this.transaction.addSuccessfulOperation(UIUtil.getBUIString1Subst((String)MIR_SUCCESS_SUMMARY, (String)name));
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep, create mirror", (String)("ConfigMgmt Exception creating the mirrored volume " + name));
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.transaction.addFailedOperation(name, (Exception)((Object)cme));
            this.transaction.setSummary(MIR_FAILURE_SUMMARY);
            return false;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)((Object)this), (String)"finishStep, create mirror", (String)("ItemNotFound Exception creating mirror " + name));
            Trace.error((Object)((Object)this), (Throwable)infe);
            this.transaction.addFailedOperation(name, (Exception)((Object)infe));
            this.transaction.setSummary(MIR_FAILURE_SUMMARY);
            return false;
        }
        return true;
    }

    private void initializeWizard() {
        this.wizardName = "NewVolumeImpl";
        this.wizardTitle = "se6x20ui.wizards.volume.NewVolume.Title";
        this.pageClass = NewVolumeWizardData.pageClass;
        this.stepText = NewVolumeWizardData.stepText;
        this.pageTitle = NewVolumeWizardData.pageTitle;
        this.stepHelp = NewVolumeWizardData.stepHelp;
        this.stepInstruction = NewVolumeWizardData.stepInstruction;
        this.initializePages(8);
        this.mapObjects = new LinkedList();
        this.pools = new LinkedList();
        Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)"About to get number of vdisks in pool");
        this.boolPoolSelectionNeeded = this.isPoolSelectionNeeded();
        HttpSession session = RequestManager.getSession();
        session.setAttribute("PoolSelectionNeeded", (Object)String.valueOf(this.boolPoolSelectionNeeded));
        this.wizardModel.setValue("ProcessedNameDescPage", (Object)"false");
        this.wizardModel.setValue("ProcessedPoolsPage", (Object)"false");
        this.wizardModel.setValue("ProcessedCapacityPage", (Object)"false");
        this.wizardModel.setValue("ProcessedInitiatorsPage", (Object)"false");
    }

    private boolean isPoolSelectionNeeded() {
        String poolName = (String)this.wizardModel.getDefaultContextValue("WIZARD_POOL_NAME");
        String domainName = (String)this.wizardModel.getDefaultContextValue("WIZARD_DOMAIN_NAME");
        if (poolName != null && domainName != null) {
            Trace.verbose((Object)((Object)this), (String)"isPoolSelectionNeeded", (String)("POOL_SELECTION: name=" + poolName + "; Domain=" + domainName));
            this.wizardModel.setValue("PoolNameField", (Object)poolName);
            this.wizardModel.setValue("StorageDomainField", (Object)domainName);
            this.pools.clear();
            this.pools.add(poolName);
            StoragePoolInterface pool = (StoragePoolInterface)this.wizardModel.getDefaultContextValue("WIZARD_POOL_HANDLE");
            String profileName = pool.getProfileName();
            HttpSession session = RequestManager.getSession();
            if (1 == this.getProfileVirtStrategy(profileName)) {
                session.setAttribute("VirtStripe", (Object)"true");
                this.wizardModel.setValue("MirrorPoolsFilterMenu", (Object)NewVolumeNameDescPageView.FILTER_STRIPE);
                session.setAttribute("MirrorPoolFilter", (Object)NewVolumeNameDescPageView.FILTER_STRIPE);
            } else {
                session.setAttribute("VirtStripe", (Object)"false");
                this.wizardModel.setValue("MirrorPoolsFilterMenu", (Object)NewVolumeNameDescPageView.FILTER_CONCAT);
                session.setAttribute("MirrorPoolFilter", (Object)NewVolumeNameDescPageView.FILTER_CONCAT);
            }
            Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)"About to get number of vdisks in pool");
            try {
                ArrayList VDisksInPool = pool.getAssociatedVDisks();
                int numVDisks = VDisksInPool.size();
                Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)("number of VDisks in pool = " + numVDisks));
                if (numVDisks > 16) {
                    session.setAttribute("StripeAllAlert", (Object)"true");
                } else {
                    session.setAttribute("StripeAllAlert", (Object)"false");
                }
            }
            catch (ConfigMgmtException e) {
                Trace.error((Object)((Object)this), (String)"processPoolsPage", (ConfigMgmtException)e);
            }
            return false;
        }
        return true;
    }

    private boolean processPoolsPage(WizardEvent wizardEvent) {
        this.pools.clear();
        StoragePoolsSummaryView view = (StoragePoolsSummaryView)((NewVolumeSelectPoolPageView)wizardEvent.getView()).getChild("StoragePoolsSummaryView");
        CCActionTable poolsTable = (CCActionTable)view.getChild("StoragePoolsSummaryTable");
        try {
            poolsTable.restoreStateData();
            StoragePoolsSummaryModel poolsModel = (StoragePoolsSummaryModel)poolsTable.getModel();
            Integer[] selectedRows = poolsModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)("[" + selectedRows.length + "] rows were selected"));
            int i = 0;
            if (i < selectedRows.length) {
                int row = selectedRows[i];
                poolsModel.setRowIndex(row);
                String poolName = (String)poolsModel.getValue("HiddenName");
                String domainName = (String)poolsModel.getValue("HiddenDomain");
                String profileName = (String)poolsModel.getValue("HiddenProfileName");
                HttpSession session = RequestManager.getSession();
                if (1 == this.getProfileVirtStrategy(profileName)) {
                    session.setAttribute("VirtStripe", (Object)"true");
                } else {
                    session.setAttribute("VirtStripe", (Object)"false");
                }
                ManageStoragePoolsInterface mgr = ManageStoragePoolsFactory.getManager();
                mgr.init(UIUtil.getConfigContext(), null);
                StoragePoolInterface pool = mgr.getItemByName(poolName, domainName);
                if (pool != null) {
                    ArrayList VDisksInPool = pool.getAssociatedVDisks();
                    int numVDisks = VDisksInPool.size();
                    Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)("number of VDisks in pool = " + numVDisks));
                    if (numVDisks > 16) {
                        session.setAttribute("StripeAllAlert", (Object)"true");
                    } else {
                        session.setAttribute("StripeAllAlert", (Object)"false");
                    }
                }
                Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)("POOL_SELECTION: name=" + poolName + "; Domain=" + domainName));
                this.wizardModel.setValue("PoolNameField", (Object)poolName);
                this.wizardModel.setValue("StorageDomainField", (Object)domainName);
                Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)("selected row = " + selectedRows[i]));
                this.wizardModel.setValue("poolRowSelected", (Object)selectedRows[i].toString());
                this.pools.add(poolName);
            }
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)"processPoolsPage", (Throwable)e);
        }
        return true;
    }

    private boolean processPoolsMirrorPage(WizardEvent wizardEvent) {
        String poolsDisplayStr = "";
        this.pools.clear();
        String isoPolicy = (String)this.wizardModel.getValue("IsolationRadioButton");
        String isoPolicyStr = "se6x20ui.wizards.volume.NewVolumeSummaryPage.Isolation." + isoPolicy;
        this.wizardModel.setValue("IsolationPolicyField", (Object)isoPolicyStr);
        if (isoPolicy != null) {
            this.isolationPolicy = new Integer(isoPolicy);
        }
        StoragePoolsSummaryView view = (StoragePoolsSummaryView)((NewVolumeSelectPoolMirrorPageView)wizardEvent.getView()).getChild("StoragePoolsSummaryView");
        CCActionTable poolsTable = (CCActionTable)view.getChild("StoragePoolsSummaryTable");
        try {
            poolsTable.restoreStateData();
            StoragePoolsSummaryModel poolsModel = (StoragePoolsSummaryModel)poolsTable.getModel();
            Integer[] selectedRows = poolsModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)("[" + selectedRows.length + "] rows were selected"));
            int componentNumber = 1;
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int row = selectedRows[i];
                poolsModel.setRowIndex(row);
                String poolName = (String)poolsModel.getValue("HiddenName");
                String numComponents = (String)poolsModel.getValue("MirrorComponents");
                Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)("POOL_SELECTION: name=" + poolName + " , #Components=" + numComponents));
                int numComponentsFromPool = Integer.parseInt(numComponents);
                for (int c = 0; c < numComponentsFromPool; ++c) {
                    this.pools.add(poolName);
                    poolsDisplayStr = poolsDisplayStr + UIUtil.getBUIString((String)"se6x20ui.wizards.volume.NewVolumeSummaryPage.PoolsText", (String[])new String[]{String.valueOf(componentNumber++), poolName}) + "<BR>";
                }
            }
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)"processPoolsPage", (Throwable)e);
        }
        this.wizardModel.setValue("ComponentPools", (Object)this.pools);
        this.wizardModel.setValue("PoolNameField", (Object)poolsDisplayStr);
        return true;
    }

    private boolean processNameDescPage(WizardEvent wizardEvent) {
        String strName = (String)this.wizardModel.getValue("VolNameField");
        String strDesc = (String)this.wizardModel.getValue("VolDescField");
        String strVolType = (String)this.wizardModel.getValue("VolumeTypeRadioButton");
        Trace.verbose((Object)((Object)this), (String)"processNameDescPage", (String)("Name=" + strName + "; Desc=" + strDesc));
        this.wizardModel.setValue("VolNameField", (Object)strName);
        this.wizardModel.setValue("VolDescField", (Object)strDesc);
        if (this.boolPoolSelectionNeeded) {
            String strDomain = (String)this.wizardModel.getValue("DomainMenu");
            this.wizardModel.setValue("StorageDomainField", (Object)strDomain);
        }
        if (strVolType != null) {
            HttpSession session = RequestManager.getSession();
            if (strVolType.equals("M")) {
                this.isMirror = true;
                session.setAttribute("isMirror", (Object)"true");
                this.wizardModel.setValue("VolumeTypeField", (Object)"se6x20ui.wizards.volume.NewVolumeSummaryPage.VolumeType.mirror");
                String strMirPoolFilter = (String)this.wizardModel.getValue("MirrorPoolsFilterMenu");
                session.setAttribute("MirrorPoolFilter", (Object)strMirPoolFilter);
            } else {
                this.isMirror = false;
                session.setAttribute("isMirror", (Object)"false");
                this.wizardModel.setValue("VolumeTypeField", (Object)"se6x20ui.wizards.volume.NewVolumeSummaryPage.VolumeType.single");
            }
        }
        return true;
    }

    private boolean processSnapshotPage(WizardEvent wizardEvent) {
        String strSnapComponent;
        this.numSnapshots = 0;
        this.snapChange = 10;
        String strNumSnapshots = (String)this.wizardModel.getValue("SnapshotMenu");
        String strActivity = (String)this.wizardModel.getValue("ActivityMenu");
        Trace.verbose((Object)((Object)this), (String)"processSnapshotPage", (String)("SNAPSHOTS ARE: " + strNumSnapshots));
        Trace.verbose((Object)((Object)this), (String)"processSnapshotPage", (String)("Activity is: " + strActivity));
        if (strActivity != null) {
            try {
                this.numSnapshots = Integer.parseInt(strNumSnapshots);
                this.snapChange = Integer.parseInt(strActivity);
            }
            catch (NumberFormatException nfe) {
                Trace.error((Object)((Object)this), (String)"processSnapshotPage", (Throwable)nfe);
            }
        }
        String snapshotDisplayStr = "se6x20ui.wizards.volume.NewVolumeSummaryPage.NoneSnapshotText";
        if (this.numSnapshots != 0) {
            String snapSpace = Integer.toString(this.numSnapshots * this.snapChange);
            Trace.verbose((Object)((Object)this), (String)"processSnapshotPage", (String)("Snapshot space is: " + snapSpace));
            snapshotDisplayStr = UIUtil.getBUIString((String)"se6x20ui.wizards.volume.NewVolumeSummaryPage.SnapshotText", (String[])new String[]{snapSpace, strNumSnapshots, strActivity});
        }
        HttpSession session = RequestManager.getSession();
        if (this.numSnapshots == 0) {
            session.setAttribute("hasSnapReserve", (Object)"false");
        } else {
            session.setAttribute("hasSnapReserve", (Object)"true");
        }
        this.wizardModel.setValue("SnapshotSizeField", (Object)snapshotDisplayStr);
        this.snapPool = (String)this.wizardModel.getValue("AllocateFromMenu");
        Trace.verbose((Object)((Object)this), (String)"processSnapshotPage", (String)("Snap pool is: " + this.snapPool));
        this.wizardModel.setValue("SnapshotPoolField", (Object)this.snapPool);
        String strSnapPolicy = (String)this.wizardModel.getValue("PolicyMenu");
        if (strSnapPolicy != null) {
            try {
                this.snapPolicy = Integer.parseInt(strSnapPolicy);
            }
            catch (NumberFormatException nfe) {
                Trace.error((Object)((Object)this), (String)"processSnapshotPage", (Throwable)nfe);
            }
        }
        Trace.verbose((Object)((Object)this), (String)"processSnapshotPage", (String)("Snap policy is: " + this.snapPolicy));
        this.wizardModel.setValue("SnapshotPolicyField", (Object)UIUtil.getBUIString((String)("se6920.volume.snapshot.policy." + strSnapPolicy)));
        if (this.isMirror && (strSnapComponent = (String)this.wizardModel.getValue("MirrorComponentMenu")) != null) {
            Trace.verbose((Object)((Object)this), (String)"processSnapshotPage", (String)("Snap mirror component is: " + strSnapComponent));
            this.wizardModel.setValue("SnapshotComponentField", (Object)strSnapComponent);
            this.snapComponent = new Integer(strSnapComponent);
        }
        return true;
    }

    private boolean processCapacityPage(WizardEvent wizardEvent) {
        String sizeDisplayStr = "se6x20ui.wizards.volume.NewVolumeCapacityPage.MaxCapacityText";
        String capacitySelection = (String)this.wizardModel.getValue("CapacityRadioButton");
        if (this.isMirror || !capacitySelection.equals("0")) {
            String sizeval = (String)this.wizardModel.getValue("CapacityField");
            String unitStr = (String)this.wizardModel.getValue("CapacityMenu");
            if (this.isMirror) {
                String resilver = (String)this.wizardModel.getValue("ResilverMenu");
                Trace.verbose((Object)((Object)this), (String)"processCapPage", (String)("resilver selected = " + resilver));
                String resilverStr = "se6x20ui.wizards.volume.NewVolumeCapacityMirrorPage.ResilverOption." + resilver;
                this.wizardModel.setValue("ResilverField", (Object)resilverStr);
                if (resilver != null) {
                    this.resilverPriority = new Integer(resilver);
                }
            }
            if (sizeval.length() <= 0) {
                sizeval = "0";
            }
            this.bdCapacity = new BigInteger(sizeval);
            String unitDisplayStr = "";
            if (unitStr.equals("TB")) {
                this.bdCapacity = this.bdCapacity.multiply(Constants.StorageSize.ONE_TB.toBigInteger());
                unitDisplayStr = "se6x20ui.sizesuffix.TB";
            } else if (unitStr.equals("GB")) {
                this.bdCapacity = this.bdCapacity.multiply(Constants.StorageSize.ONE_GB.toBigInteger());
                unitDisplayStr = "se6x20ui.sizesuffix.GB";
            } else if (unitStr.equals("MB")) {
                this.bdCapacity = this.bdCapacity.multiply(Constants.StorageSize.ONE_MB.toBigInteger());
                unitDisplayStr = "se6x20ui.sizesuffix.MB";
            } else if (unitStr.equals("KB")) {
                this.bdCapacity = this.bdCapacity.multiply(Constants.StorageSize.ONE_KB.toBigInteger());
                unitDisplayStr = "se6x20ui.sizesuffix.KB";
            } else if (unitStr.equals("Blocks")) {
                this.bdCapacity = this.bdCapacity.multiply(Constants.StorageSize.ONE_BLOCK.toBigInteger());
                unitDisplayStr = "se6x20ui.sizesuffix.Blocks";
            }
            sizeDisplayStr = sizeval + " " + UIUtil.getBUIString((String)unitDisplayStr);
        } else {
            this.bdCapacity = new BigInteger("0");
        }
        Trace.verbose((Object)((Object)this), (String)"processCapacityPage", (String)("SIZE OF VOLUME IS : " + this.bdCapacity.toString()));
        this.wizardModel.setValue("CapacityDisplayField", (Object)sizeDisplayStr);
        return true;
    }

    private boolean processInitiatorsPage(WizardEvent wizardEvent) {
        this.mapObjects.clear();
        String initValue = "";
        MapInitiatorsView containerView = (MapInitiatorsView)((NewVolumeInitiatorsPageView)wizardEvent.getView()).getChild("MapInitiatorsView");
        CCActionTable initTable = (CCActionTable)containerView.getChild("MapInitiatorsTable");
        try {
            initTable.restoreStateData();
            MapInitiatorsModel initModel = (MapInitiatorsModel)initTable.getModel();
            Integer[] selectedRows = initModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("[" + selectedRows.length + "] rows were selected"));
            ManageInitiatorsInterface initMgr = ManageInitiatorsFactory.getManager();
            InitiatorInterface initiator = null;
            ConfigContext context = UIUtil.getConfigContext();
            try {
                initMgr.init(context, null);
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)((Object)this), (String)"processInitiatorsPage", (ConfigMgmtException)cex);
            }
            String[] selectedLuns = new String[selectedRows.length];
            String[] selectedPerms = new String[selectedRows.length];
            this.wizardModel.setValue("selectedRows", (Object)selectedRows);
            for (int i = 0; i < selectedRows.length; ++i) {
                String permStr;
                int row = selectedRows[i];
                initModel.setRowIndex(row);
                String initKey = (String)initModel.getValue("Hiddenkey");
                initiator = initMgr.getByKey(KeyBuilder.createKeyFromString((String)initKey));
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Processing selected Initiator: " + initiator.getName()));
                String lun = (String)initModel.getValue("LUN");
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Selected lun is : " + lun));
                selectedLuns[i] = lun;
                selectedPerms[i] = permStr = (String)initModel.getValue("Permission");
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Selected Permission is : " + permStr));
                HashSet<UnsignedInt16> perm = new HashSet<UnsignedInt16>();
                perm.add(ConstantsEnt.LUNMappingPermissions.READ);
                String permDisplayStr = "se6x20ui.common.Mapping.ReadOnly";
                if (permStr.equals("ReadWrite")) {
                    permDisplayStr = "se6x20ui.common.Mapping.ReadWrite";
                    perm.add(ConstantsEnt.LUNMappingPermissions.WRITE);
                }
                permDisplayStr = UIUtil.getBUIString((String)permDisplayStr);
                InitiatorVolumeMapping map = new InitiatorVolumeMapping(lun, perm, (Object)initiator);
                this.mapObjects.add(map);
                if (lun.equals("-1")) {
                    lun = UIUtil.getBUIString((String)"se6x20ui.common.Mapping.nextavailable");
                }
                String mapStr = UIUtil.getBUIString((String)"se6x20ui.wizards.volume.MapInitiator.SummaryPage.InitiatorsText", (String[])new String[]{initiator.getName(), lun, permDisplayStr});
                initValue = initValue + mapStr + "<BR>";
            }
            this.wizardModel.setValue("selectedLuns", (Object)selectedLuns);
            this.wizardModel.setValue("selectedPerms", (Object)selectedPerms);
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"processInitiatorsPage", (Throwable)ex);
        }
        if (initValue.equals("")) {
            initValue = "se6x20ui.wizards.volume.NewVolumeSummaryPage.NoneInitiatorsText";
        }
        Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)UIUtil.getEnglishBUIString((String)initValue));
        this.wizardModel.setValue("InitiatorsField", (Object)initValue);
        return true;
    }

    private int getProfileVirtStrategy(String profileName) {
        int virtStrategy = 0;
        try {
            ManageStorageProfilesInterface mgr = ManageStorageProfilesFactory.getManager();
            mgr.init(UIUtil.getConfigContext(), null);
            StorageProfileInterface profileHandle = mgr.getItemByName(profileName);
            if (profileHandle != null) {
                virtStrategy = profileHandle.getVirtualizationStrategy();
            }
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)"processPoolsPage", (Throwable)e);
        }
        return virtStrategy;
    }
}

