/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.StoragePoolsSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.StoragePoolsSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MirrorPropertiesPageView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MirrorSelectLogPoolPageView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MirrorWizardData;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageMirrorServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirroredVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpSession;

public class MirrorImpl
extends SEWizardImpl {
    public static final String MODELNAME = "MirrorWizard_ModelName";
    public static final String IMPLNAME = "MirrorWizard_ImplName";
    private static String SUCCESS_SUMMARY = "se6x20ui.wizards.volume.Mirror.VolumeAndMap";
    private static String FAILURE_SUMMARY = "se6x20ui.error.wizards.volume.Mirror.failed";
    private static String PARTIAL_SUMMARY = "se6x20ui.error.wizards.volume.Mirror.partial";
    static final String MIRROR_PROPERTIES_PAGE = "1";
    static final String MIRROR_COMPONENTS_PAGE = "2";
    static final String SELECT_LOGS_POOL_PAGE = "3";
    static final int NUM_COMPONENTS = 4;
    private boolean newMirror = false;
    private boolean all_VLV_Mirror = false;
    private StoragePoolInterface mirrorLogsPool = null;
    private StorageVolumeEnt1Interface baseVolume = null;
    private MirroredVolumeEnt1Interface baseMirror = null;
    private ArrayList knownMirrorComponentNames = null;
    private Integer isolationPolicy = null;
    private Integer resilverPriority = null;
    private ArrayList creationStrategies = null;
    private ArrayList newMirrorComponentNames = null;

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.volume.Mirror.Volume.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MirrorImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        model.setValue("wizPassPageSession", (Object)"false");
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new MirrorImpl(requestContext);
    }

    public MirrorImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        String pageId = wizardEvent.getPageId();
        if (pageId.equals(MIRROR_PROPERTIES_PAGE)) {
            this.processMirrorPropertiesPage(wizardEvent);
        } else if (pageId.equals(MIRROR_COMPONENTS_PAGE)) {
            this.processSelectMirrorComponentsPage(wizardEvent);
            this.wizardModel.setValue("ProcessedSelectComponentsPage", (Object)Boolean.TRUE.toString());
        } else if (pageId.equals(SELECT_LOGS_POOL_PAGE)) {
            this.processSelectMirrorLogsPoolPage(wizardEvent);
        }
        return true;
    }

    public String getNextPageId(String pageId) {
        Trace.methodBegin((Object)((Object)this), (String)"getNextPageId");
        int page = this.pageIdToPage(pageId);
        String nextPageId = Integer.toString(this.nextPages[page][0]);
        if (pageId.equals(MIRROR_COMPONENTS_PAGE) && !this.all_VLV_Mirror) {
            nextPageId = Integer.toString(this.nextPages[page + 1][0]);
        }
        return nextPageId;
    }

    public String[] getFutureSteps(String currentPageId) {
        return new String[0];
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        boolean retVal = false;
        HttpSession session = RequestManager.getSession();
        session.removeAttribute("KnownMirrorComponentNames");
        session.removeAttribute("CreationStrategies");
        session.removeAttribute("All_VLV_Mirror");
        ConfigContext context = UIUtil.getConfigContext();
        if (context == null) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Configcontext is empty");
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        ManageMirrorServicesEnt1Interface mms = (ManageMirrorServicesEnt1Interface)ManageDataServicesFactory.getMirrorServicesManager((ConfigContext)context);
        try {
            mms.init(context, null, null);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        retVal = this.newMirror ? this.createMirror(context, mms) : this.addToMirror(context, mms);
        if (retVal && this.newMirror) {
            String name = this.baseVolume.getName();
            MirroredVolumeEnt1Interface mirrorObj = null;
            try {
                mirrorObj = (MirroredVolumeEnt1Interface)mms.getMirroredVolumeByName(name, this.baseVolume.getStorageDomainName());
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
                this.transaction.addFailedOperation();
                this.transaction.setSummary(FAILURE_SUMMARY);
                return false;
            }
            if (null == mirrorObj) {
                Trace.error((Object)((Object)this), (String)"finishStep", (String)("Error retrieving the just created mirror " + name));
                this.transaction.addFailedOperation(name, "se6x20ui.error.systemerror");
                this.transaction.setSummary(FAILURE_SUMMARY);
            }
        }
        return true;
    }

    private boolean createMirror(ConfigContext context, ManageMirrorServicesEnt1Interface mms) {
        Properties props = new Properties();
        boolean haveRequiredParams = true;
        String missingRequiredParams = null;
        String name = this.baseVolume.getName();
        String desc = this.baseVolume.getDescription();
        String domain = this.baseVolume.getStorageDomainName();
        boolean retVal = false;
        try {
            if (name != null && name.length() > 0) {
                props.put("name", name);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Name, ";
            }
            if (desc != null && desc.length() > 0) {
                props.put("description", desc);
            }
            if (domain != null && domain.length() > 0) {
                ManageStorageDomainsInterface domainMgr = ManageStorageDomainsFactory.getManager();
                domainMgr.init(UIUtil.getConfigContext(), null);
                StorageDomainInterface domainObj = null;
                domainObj = domainMgr.getItemByName(domain);
                if (domainObj != null) {
                    props.put("domain", domainObj);
                } else {
                    haveRequiredParams = false;
                    missingRequiredParams = missingRequiredParams + "Domain, ";
                }
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Domain, ";
            }
            Vector sourcesVector = new Vector();
            sourcesVector.add(this.baseVolume);
            sourcesVector = this.getSourceObjects(sourcesVector, context);
            if (sourcesVector.size() > 0) {
                props.put("sources", sourcesVector);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Sources, ";
            }
            if (this.isolationPolicy != null) {
                props.put("isolationPolicy", this.isolationPolicy);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Isolation Policy, ";
            }
            if (this.resilverPriority != null) {
                props.put("resilverPriority", this.resilverPriority);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Resilver Priority, ";
            }
            if (this.all_VLV_Mirror) {
                if (this.mirrorLogsPool != null) {
                    Vector<StoragePoolInterface> tmpVector = new Vector<StoragePoolInterface>();
                    tmpVector.add(this.mirrorLogsPool);
                    props.put("logPools", tmpVector);
                } else {
                    haveRequiredParams = false;
                    missingRequiredParams = missingRequiredParams + "VLV Logs Pool, ";
                }
            }
            props.put("size", this.baseVolume.getCapacity());
            props.put("snamNum", new Integer("0"));
            if (!haveRequiredParams) {
                Trace.error((Object)((Object)this), (String)"finishStep, create mirror", (String)("Missing Parameters:" + missingRequiredParams));
                this.transaction.addFailedOperation("se6x20ui.error.wizards.volume.NewVolume.failed", "se6x20ui.error.wizards.volume.NewVolume.failed");
                this.transaction.setSummary(FAILURE_SUMMARY);
                return false;
            }
            mms.create(props);
            Trace.verbose((Object)((Object)this), (String)"finishStep, create mirror", (String)("Mirrored Volume '" + name + "' created"));
            this.transaction.addSuccessfulOperation(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.volume.NewVolume.mirrorVolume", (String)name));
            this.transaction.setSummary(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.volume.NewVolume.mirrorVolume", (String)name));
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep, create mirror", (String)("ConfigMgmt Exception creating the mirrored volume " + name));
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.transaction.addFailedOperation(name, (Exception)((Object)cme));
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)((Object)this), (String)"finishStep, create mirror", (String)("ItemNotFound Exception creating the storage volume " + name));
            Trace.error((Object)((Object)this), (Throwable)infe);
            this.transaction.addFailedOperation(name, (Exception)((Object)infe));
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        return true;
    }

    private boolean addToMirror(ConfigContext context, ManageMirrorServicesEnt1Interface mms) {
        Properties props = new Properties();
        boolean haveRequiredParams = true;
        String missingRequiredParams = null;
        String name = this.baseMirror.getName();
        String domain = this.baseMirror.getStorageDomainName();
        boolean retVal = false;
        try {
            Vector sourcesVector = new Vector();
            sourcesVector = this.getSourceObjects(sourcesVector, context);
            if (sourcesVector.size() > 0) {
                props.put("sources", sourcesVector);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Sources, ";
            }
            if (this.isolationPolicy != null) {
                props.put("isolationPolicy", this.isolationPolicy);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Isolation Policy, ";
            }
            if (this.resilverPriority != null) {
                props.put("resilverPriority", this.resilverPriority);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Resilver Priority, ";
            }
            props.put("snamNum", new Integer("0"));
            if (!haveRequiredParams) {
                Trace.error((Object)((Object)this), (String)"finishStep, create mirror", (String)("Missing Parameters:" + missingRequiredParams));
                this.transaction.addFailedOperation("se6x20ui.error.wizards.volume.NewVolume.failed", "se6x20ui.error.wizards.volume.NewVolume.failed");
                this.transaction.setSummary(FAILURE_SUMMARY);
                return false;
            }
            mms.addComponent((Object)this.baseMirror.getKey(), props);
            Trace.verbose((Object)((Object)this), (String)"finishStep, create mirror", (String)("Mirrored Volume '" + name + "' created"));
            this.transaction.addSuccessfulOperation(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.volume.NewVolume.addToMirror", (String)name));
            this.transaction.setSummary(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.volume.NewVolume.addToMirror", (String)name));
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep, create mirror", (String)("ConfigMgmt Exception creating the mirrored volume " + name));
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.transaction.addFailedOperation(name, (Exception)((Object)cme));
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)((Object)this), (String)"finishStep, create mirror", (String)("ItemNotFound Exception creating the storage volume " + name));
            Trace.error((Object)((Object)this), (Throwable)infe);
            this.transaction.addFailedOperation(name, (Exception)((Object)infe));
            this.transaction.setSummary(FAILURE_SUMMARY);
            return false;
        }
        return true;
    }

    private Vector getSourceObjects(Vector sourcesVector, ConfigContext context) throws ConfigMgmtException, ItemNotFoundException {
        String domain = (String)this.wizardModel.getValue("DOMAIN_NAME");
        ManageStoragePoolsInterface poolsMgr = ManageStoragePoolsFactory.getManager();
        poolsMgr.init(context, null);
        ManageStorageVolumesInterface volsMgr = ManageStorageVolumesFactory.getManager();
        volsMgr.init(context, null);
        if (domain != null && domain.length() > 0) {
            String tmpCreationStrategy = null;
            String tmpComponentName = null;
            for (int i = 0; i < this.creationStrategies.size(); ++i) {
                tmpCreationStrategy = (String)this.creationStrategies.get(i);
                tmpComponentName = (String)this.newMirrorComponentNames.get(i);
                if (tmpCreationStrategy.equals("se6x20ui.wizards.volume.MirrorPropertiesPage.ComponentMenuOption.Pool")) {
                    StoragePoolInterface poolObj = null;
                    poolObj = poolsMgr.getItemByName(tmpComponentName, domain);
                    if (poolObj == null) continue;
                    sourcesVector.add(poolObj);
                    continue;
                }
                StorageVolumeInterface volObj = null;
                volObj = volsMgr.getItemByName(tmpComponentName);
                if (volObj == null) continue;
                sourcesVector.add(volObj);
            }
        }
        return sourcesVector;
    }

    private void initializeWizard() {
        this.wizardName = "MirrorImpl";
        this.pageClass = MirrorWizardData.pageClass;
        this.stepText = MirrorWizardData.stepText;
        this.pageTitle = MirrorWizardData.pageTitle;
        this.stepHelp = MirrorWizardData.stepHelp;
        this.stepInstruction = MirrorWizardData.stepInstruction;
        this.initializePages(4);
        this.knownMirrorComponentNames = new ArrayList();
        this.creationStrategies = new ArrayList();
        this.newMirrorComponentNames = new ArrayList();
        String domain = null;
        String mirrorName = null;
        HttpSession session = RequestManager.getSession();
        String mirrorOp = (String)this.wizardModel.getDefaultContextValue("MIRROR_OP");
        if (mirrorOp.equals("MIRROR_EXISTING")) {
            this.newMirror = true;
            this.wizardTitle = "se6x20ui.wizards.volume.Mirror.Volume.Title";
            this.baseVolume = (StorageVolumeEnt1Interface)this.wizardModel.getDefaultContextValue("WIZARD_VOLUME_HANDLE");
            mirrorName = this.baseVolume.getName();
            this.knownMirrorComponentNames.add(this.baseVolume.getName());
            domain = this.baseVolume.getStorageDomainName();
        } else {
            this.newMirror = false;
            this.wizardTitle = "se6x20ui.wizards.volume.Mirror.Add.Title";
            this.baseMirror = (MirroredVolumeEnt1Interface)this.wizardModel.getDefaultContextValue("WIZARD_VOLUME_HANDLE");
            mirrorName = this.baseMirror.getName();
            domain = this.baseMirror.getStorageDomainName();
            ArrayList knownComponents = null;
            try {
                this.isolationPolicy = new Integer(this.baseMirror.getIsolationPolicy());
                this.resilverPriority = new Integer(this.baseMirror.getResilverPriority());
                knownComponents = this.baseMirror.getAssociatedComponents();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)((Object)this), (String)"initializeWizard", (String)"Error getting mirror components");
            }
            if (knownComponents != null) {
                MirrorComponentEnt1Interface mirrorComponent = null;
                for (int i = 0; i < knownComponents.size(); ++i) {
                    mirrorComponent = (MirrorComponentEnt1Interface)knownComponents.get(i);
                    if (mirrorComponent != null) {
                        this.knownMirrorComponentNames.add(mirrorComponent.getName());
                        continue;
                    }
                    Trace.error((Object)((Object)this), (String)"initializeWizard", (String)"Error getting mirror component");
                }
            }
        }
        session.setAttribute("KnownMirrorComponentNames", (Object)this.knownMirrorComponentNames);
        this.wizardModel.setValue("KnownMirrorComponentNames", (Object)this.knownMirrorComponentNames);
        this.wizardModel.setValue("isNewMirror", (Object)new Boolean(this.newMirror));
        if (mirrorName != null) {
            this.wizardModel.setValue("MirrorNameField", (Object)mirrorName);
        }
        if (domain != null) {
            this.wizardModel.setValue("DOMAIN_NAME", (Object)domain);
        }
        if (this.isolationPolicy != null) {
            this.wizardModel.setValue("IsolationPolicy", (Object)this.isolationPolicy);
        }
        if (this.resilverPriority != null) {
            this.wizardModel.setValue("ResilverPriority", (Object)this.resilverPriority);
        }
        this.wizardModel.setValue("ProcessedSelectComponentsPage", (Object)Boolean.FALSE.toString());
    }

    private boolean processMirrorPropertiesPage(WizardEvent wizardEvent) {
        HttpSession session = RequestManager.getSession();
        String resilver = (String)this.wizardModel.getValue("ResilverMenu");
        String resilverStr = "";
        if (resilver.equals(MirrorPropertiesPageView.RESILVER_HIGH)) {
            resilverStr = "se6x20ui.wizards.volume.MirrorPropertiesPage.ResilverOption.High";
        } else if (resilver.equals(MirrorPropertiesPageView.RESILVER_MED)) {
            resilverStr = "se6x20ui.wizards.volume.MirrorPropertiesPage.ResilverOption.Medium";
        } else if (resilver.equals(MirrorPropertiesPageView.RESILVER_LOW)) {
            resilverStr = "se6x20ui.wizards.volume.MirrorPropertiesPage.ResilverOption.Low";
        }
        this.wizardModel.setValue("ResilverField", (Object)resilverStr);
        this.resilverPriority = new Integer(resilver);
        this.creationStrategies.clear();
        String tmpCreateStrategy = "";
        String tmpChild = "";
        this.all_VLV_Mirror = true;
        for (int i = 2; i <= 4; ++i) {
            tmpChild = "Strategy" + i + "Menu";
            tmpCreateStrategy = (String)this.wizardModel.getValue(tmpChild);
            if (tmpCreateStrategy == null || tmpCreateStrategy.equals("se6x20ui.wizards.volume.MirrorPropertiesPage.ComponentMenuOption.Select")) continue;
            this.creationStrategies.add(tmpCreateStrategy);
            if (tmpCreateStrategy.equals("se6x20ui.wizards.volume.MirrorPropertiesPage.ComponentMenuOption.LegacyVolume")) continue;
            this.all_VLV_Mirror = false;
        }
        if (!this.newMirror || this.newMirror && !this.baseVolume.getType().equals("Legacy")) {
            this.all_VLV_Mirror = false;
        }
        session.setAttribute("All_VLV_Mirror", (Object)new Boolean(this.all_VLV_Mirror));
        session.setAttribute("CreationStrategies", (Object)this.creationStrategies);
        this.wizardModel.setValue("CreationStrategies", (Object)this.creationStrategies);
        String strMirPoolFilter = (String)this.wizardModel.getValue("MirrorPoolsFilterMenu");
        this.wizardModel.setValue("MirrorPoolsFilterMenu", (Object)strMirPoolFilter);
        return true;
    }

    private boolean processSelectMirrorComponentsPage(WizardEvent wizardEvent) {
        HttpSession session = RequestManager.getSession();
        String isoPolicy = (String)this.wizardModel.getValue("IsolationRadioButton");
        String isoPolicyStr = "se6x20ui.wizards.volume.MirrorSummaryPage.Isolation." + isoPolicy;
        this.wizardModel.setValue("IsolationField", (Object)isoPolicyStr);
        if (isoPolicy != null) {
            this.isolationPolicy = new Integer(isoPolicy);
        }
        this.newMirrorComponentNames.clear();
        String tmpComponentName = "";
        String tmpChild = "";
        boolean StrategyCnt = false;
        int rmIndex = 0;
        for (int i = 2; i <= 4; ++i) {
            tmpChild = "ComponentMenu_" + i;
            tmpComponentName = (String)this.wizardModel.getValue(tmpChild);
            if (tmpComponentName == null) continue;
            Trace.verbose((Object)((Object)this), (String)"processSelectMirrorComponentsPage", (String)("tmpComponentName = " + tmpComponentName));
            if (tmpComponentName.equals("select")) {
                rmIndex = i - this.knownMirrorComponentNames.size() - 1;
                if (rmIndex <= this.creationStrategies.size()) continue;
                this.creationStrategies.remove(rmIndex);
                continue;
            }
            int vertBar = tmpComponentName.indexOf("|");
            if (vertBar != -1) {
                tmpComponentName = tmpComponentName.substring(0, vertBar);
            }
            this.newMirrorComponentNames.add(tmpComponentName);
        }
        this.prepareSummaryPage();
        return true;
    }

    private boolean processSelectMirrorLogsPoolPage(WizardEvent wizardEvent) {
        StoragePoolsSummaryView view = (StoragePoolsSummaryView)((MirrorSelectLogPoolPageView)wizardEvent.getView()).getChild("StoragePoolsSummaryView");
        CCActionTable poolsTable = (CCActionTable)view.getChild("StoragePoolsSummaryTable");
        try {
            poolsTable.restoreStateData();
            StoragePoolsSummaryModel poolsModel = (StoragePoolsSummaryModel)poolsTable.getModel();
            Integer[] selectedRows = poolsModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)("[" + selectedRows.length + "] rows were selected"));
            int i = 0;
            if (i < selectedRows.length) {
                int row = selectedRows[i];
                poolsModel.setRowIndex(row);
                String poolName = (String)poolsModel.getValue("HiddenName");
                String domainName = (String)poolsModel.getValue("HiddenDomain");
                ManageStoragePoolsInterface mgr = ManageStoragePoolsFactory.getManager();
                mgr.init(UIUtil.getConfigContext(), null);
                this.mirrorLogsPool = mgr.getItemByName(poolName, domainName);
                Trace.verbose((Object)((Object)this), (String)"processSelectMirrorLogsPoolPage", (String)("POOL_SELECTION: name=" + poolName + "; Domain=" + domainName));
                this.wizardModel.setValue("MirrorLogsPoolField", (Object)poolName);
            }
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)"processSelectMirrorLogsPoolPage", (Throwable)e);
        }
        return true;
    }

    private void prepareSummaryPage() {
        int i;
        String tmpSummaryChild = "";
        String tmpSummaryValue = "";
        String componentValueLabel = "se6x20ui.wizards.volume.MirrorSummaryPage.ComponentValue";
        String knownComponentCreationStrategy = UIUtil.getBUIString((String)"se6x20ui.wizards.volume.MirrorPropertiesPage.ComponentMenuOption.Volume");
        String tmpComponentCreationStrategy = "";
        for (i = 1; i <= this.knownMirrorComponentNames.size(); ++i) {
            tmpSummaryChild = "MirrorComponentField_" + i;
            tmpSummaryValue = UIUtil.getBUIString2Subst((String)componentValueLabel, (String)knownComponentCreationStrategy, (String)((String)this.knownMirrorComponentNames.get(i - 1)));
            this.wizardModel.setValue(tmpSummaryChild, (Object)tmpSummaryValue);
        }
        ArrayList overwriteComponents = new ArrayList();
        String strategy = "";
        for (int j = 0; j < this.creationStrategies.size(); ++j) {
            tmpSummaryChild = "MirrorComponentField_" + (i + j);
            strategy = (String)this.creationStrategies.get(j);
            tmpComponentCreationStrategy = UIUtil.getBUIString((String)strategy);
            tmpSummaryValue = UIUtil.getBUIString2Subst((String)componentValueLabel, (String)tmpComponentCreationStrategy, (String)((String)this.newMirrorComponentNames.get(j)));
            tmpSummaryValue = tmpSummaryValue + " " + UIUtil.getBUIString((String)"se6x20ui.wizards.volume.MirrorSummaryPage.NewComponent");
            this.wizardModel.setValue(tmpSummaryChild, (Object)tmpSummaryValue);
            if (!strategy.equals("se6x20ui.wizards.volume.MirrorPropertiesPage.ComponentMenuOption.Volume") && !strategy.equals("se6x20ui.wizards.volume.MirrorPropertiesPage.ComponentMenuOption.LegacyVolume")) continue;
            overwriteComponents.add(this.newMirrorComponentNames.get(j));
        }
        this.wizardModel.setValue("overwriteComponents", overwriteComponents);
        for (int k = i + j; k <= 4; ++k) {
            tmpSummaryChild = "MirrorComponentField_" + k;
            this.wizardModel.setValue(tmpSummaryChild, (Object)"se6x20ui.wizards.volume.MirrorSummaryPage.ComponentNone");
        }
    }
}

