/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MapInitiatorsData;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public final class MapInitiatorsModel
extends CCActionTableModel {
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_LUN = "LUN";
    public static final String CHILD_PERMISSION = "Permission";
    public static final String CHILD_DOMAIN = "Domain";
    public static final String CHILD_HIDDEN_KEY = "Hiddenkey";
    private Hashtable availableLUNsTable = null;
    Integer[] rowsSel = null;
    String[] lunsSel = null;
    String[] permsSel = null;
    public static final String DEFAULT_XML = "/jsp/wizards/volume/MapInitiatorsTable.xml";

    public MapInitiatorsModel() {
        this(DEFAULT_XML);
    }

    public MapInitiatorsModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initializeHeaders();
        this.availableLUNsTable = new Hashtable();
    }

    private void initializeHeaders() {
        this.setActionValue("ColName", "se6x20ui.wizards.volume.MapInitiatorPage1.ColInitiatorName");
        this.setActionValue("ColLUN", "se6x20ui.wizards.volume.MapInitiatorPage1.ColLUN");
        this.setActionValue("ColPermission", "se6x20ui.wizards.volume.MapInitiatorPage1.ColPermission");
        this.setActionValue("ColDomain", "se6x20ui.wizards.volume.MapInitiatorPage1.ColDomain");
    }

    public ArrayList getAvailableLUNs(String key) {
        return (ArrayList)this.availableLUNsTable.get(key);
    }

    public Integer[] getUserSelectedRows() {
        return this.rowsSel;
    }

    public String[] getSelectedLuns() {
        return this.lunsSel;
    }

    public String[] getSelectedPerms() {
        return this.permsSel;
    }

    public void populateData(ContextFilter filter, Integer[] rows, String[] luns, String[] perms) throws ConfigMgmtException, ItemNotFoundException {
        this.rowsSel = rows;
        this.lunsSel = luns;
        this.permsSel = perms;
        this.populateData(filter);
    }

    public void populateData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        this.clear();
        MapInitiatorsData data = new MapInitiatorsData();
        Trace.verbose((Object)((Object)this), (String)"populateData", (String)"created empty MapInitiatorsData class");
        try {
            ArrayList initiatorList = data.getData(filter);
            Iterator it = initiatorList.iterator();
            while (it.hasNext()) {
                this.appendRow();
                this.setRowSelected(false);
                InitiatorInterface initiator = (InitiatorInterface)it.next();
                ArrayList lunArray = initiator.getAllLUNs();
                this.setValue(CHILD_NAME, initiator.getName());
                this.setValue(CHILD_LUN, "-1");
                if (this.rowsSel != null && this.permsSel != null) {
                    for (int i = 0; i < this.rowsSel.length; ++i) {
                        if (this.rowsSel[i].intValue() == this.getRowIndex()) {
                            if (i < this.permsSel.length) {
                                this.setValue(CHILD_PERMISSION, this.permsSel[i]);
                                break;
                            }
                            this.setValue(CHILD_PERMISSION, "ReadWrite");
                            continue;
                        }
                        this.setValue(CHILD_PERMISSION, "ReadWrite");
                    }
                } else {
                    this.setValue(CHILD_PERMISSION, "ReadWrite");
                }
                this.setValue(CHILD_DOMAIN, initiator.getStorageDomain());
                this.setValue(CHILD_HIDDEN_KEY, KeyBuilder.createStringFromKey((Collection)initiator.getKey()));
                String index = Integer.toString(this.getRowIndex());
                this.availableLUNsTable.put(index, lunArray);
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)"populateData", (String)"Error populating MapInitiatorsData class.");
            throw cex;
        }
    }
}

