/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;

public final class MapInitiatorsData {
    public ArrayList getData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        ArrayList initiatorList = null;
        ManageInitiatorsInterface mngInitiators = ManageInitiatorsFactory.getManager();
        ConfigContext cfgctx = UIUtil.getConfigContext();
        try {
            mngInitiators.init(cfgctx, null);
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"getData", (String)"Error getting Initiators.");
            throw cex;
        }
        if (filter == null) {
            try {
                initiatorList = mngInitiators.getItemsBySystem();
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)this, (String)"getData", (String)"Error getting Initiators.");
                throw cex;
            }
        }
        if (filter.getType() == 1) {
            try {
                String domainName = (String)filter.getValue("DOMAIN_NAME");
                if (domainName == null) {
                    Trace.verbose((Object)this, (String)"getData", (String)"Getting Initiators, filtered to system (No Domain)");
                    initiatorList = mngInitiators.getItemsBySystem();
                }
                initiatorList = mngInitiators.getItemsByStorageDomain(domainName);
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)this, (String)"getData", (String)"Error getting Initiators.");
                throw cex;
            }
        } else if (filter.getType() == 12) {
            try {
                String domainName = (String)filter.getValue("DOMAIN_NAME");
                if (domainName == null) {
                    Trace.verbose((Object)this, (String)"getData", (String)"Getting Initiators, filtered to system (No Domain)");
                    initiatorList = mngInitiators.getItemsBySystem();
                } else {
                    initiatorList = mngInitiators.getItemsByStorageDomain(domainName);
                }
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)this, (String)"getData", (String)"Error getting Initiators.");
                throw cex;
            }
            StorageVolumeInterface volume = (StorageVolumeInterface)filter.getValue("VOLUME_HANDLE");
            InitiatorInterface initiator = null;
            InitiatorVolumeMappingInterface mapIF = null;
            ArrayList mappedInitList = null;
            try {
                mappedInitList = volume.getInitiatorMappings();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, (String)"getData", (String)"Error getting list of mapped initiators");
                Trace.error((Object)this, (String)"getData", (ConfigMgmtException)cme);
            }
            ArrayList<String> listWwn = new ArrayList<String>(mappedInitList.size());
            Iterator itMappedInit = mappedInitList.iterator();
            while (itMappedInit.hasNext()) {
                mapIF = (InitiatorVolumeMappingInterface)itMappedInit.next();
                initiator = (InitiatorInterface)mapIF.getObject();
                if (null == initiator) continue;
                listWwn.add(initiator.getWWN());
            }
            Iterator it = initiatorList.iterator();
            while (it.hasNext()) {
                initiator = (InitiatorInterface)it.next();
                if (listWwn.indexOf(initiator.getWWN()) == -1) continue;
                it.remove();
            }
        } else {
            try {
                initiatorList = mngInitiators.getItemsBySystem();
            }
            catch (ConfigMgmtException cex) {
                Trace.verbose((Object)this, (String)"getData", (String)"Error getting Initiators.");
                throw cex;
            }
        }
        Trace.verbose((Object)this, (String)"getData", (String)("Returning Initiators list, size: " + initiatorList.size()));
        return initiatorList;
    }
}

