/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEAction;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionOperands;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionParameters;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MapInitiatorPage1View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MapInitiatorWizardData;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MapInitiatorsModel;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MapInitiatorsView;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.InitiatorVolumeMapping;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.HashSet;
import java.util.LinkedList;
import javax.servlet.http.HttpSession;
import javax.wbem.cim.UnsignedInt16;

public class MapInitiatorImpl
extends SEWizardImpl {
    public static final String MODELNAME = "MapWizard_ModelName";
    public static final String IMPLNAME = "MapWizard_ImplName";
    private static final String SUCCESS_SUMMARY = "se6x20ui.wizards.volume.MapInitiator.success";
    private static final String FAILURE_SUMMARY = "se6x20ui.error.wizards.volume.MapInitiator.failed";
    private static final String PARTIAL_SUMMARY = "se6x20ui.error.wizards.volume.MapInitiator.partial";
    private static final String INITIATORS_PAGE = "1";
    private LinkedList mapObjects = null;

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.volume.MapInitiator.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MapInitiatorImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        model.setValue("wizPassPageSession", (Object)"false");
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new MapInitiatorImpl(requestContext);
    }

    public MapInitiatorImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        if (wizardEvent.getPageId().equals(INITIATORS_PAGE)) {
            this.processInitiatorsPage(wizardEvent);
        }
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        HttpSession session = RequestManager.getSession();
        session.removeAttribute("showPI");
        StorageVolumeInterface volume = (StorageVolumeInterface)this.wizardModel.getDefaultContextValue("WIZARD_VOLUME_HANDLE");
        if (volume == null) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"The volume reference cannot be obtained.");
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation();
            return true;
        }
        LinkedList<StorageVolumeInterface> volumesList = new LinkedList<StorageVolumeInterface>();
        if (volumesList == null) {
            this.transaction.addFailedOperation();
            this.transaction.setSummary(UIUtil.getBUIString((String)"se6x20ui.error.error"));
            return true;
        }
        volumesList.add(volume);
        SEActionOperands actionOperands = new SEActionOperands();
        if (actionOperands == null) {
            this.transaction.addFailedOperation();
            this.transaction.setSummary(UIUtil.getBUIString((String)"se6x20ui.error.error"));
            return true;
        }
        actionOperands.add(volumesList, this.mapObjects, UIUtil.getBUIString((String)"se6920.action.mapping.fromtoseperator"));
        int nOps = actionOperands.getSize();
        int actionType = 3;
        SEActionParameters actionParams = new SEActionParameters(actionType);
        if (actionParams != null) {
            int opThreshold = UIUtil.getInitParamInt((String)"VOLUME_MAP_THRESHOLD");
            boolean requestAsync = opThreshold < 0 ? false : nOps >= opThreshold;
            ConfigContext context = UIUtil.getConfigContext();
            SEAction action = new SEAction(context, actionOperands, actionParams, requestAsync);
            if (requestAsync && !action.isAsync()) {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"failed job initiation");
                this.transaction.addFailedOperation();
                this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.notinitiated"));
            } else {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Successful job initiation, starting action");
                action.execute();
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Back from action initiation");
                if (requestAsync) {
                    String jobID = action.getJobID();
                    if (jobID == null) {
                        jobID = UIUtil.getBUIString((String)"se6920.action.jobunknown");
                    }
                    String jobInfo = UIUtil.getBUIString1Subst((String)"se6920.action.jobinitiated", (String)jobID);
                    Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Successful job initiation, job is:" + jobID));
                    this.transaction.addSuccessfulOperation("");
                    this.transaction.setSummary(jobInfo);
                    this.transaction.setSummaryIsJobRelated();
                } else {
                    this.transaction = action.getTransaction();
                    this.wizardModel.setDefaultContextValue("WIZARD_TRANSACTION", (Object)this.transaction);
                    this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
                }
            }
        } else {
            this.transaction.addFailedOperation();
            this.transaction.setSummary(UIUtil.getBUIString((String)"se6x20ui.error.error"));
        }
        return true;
    }

    private void initializeWizard() {
        this.wizardName = "MapInitiatorImpl";
        this.pageClass = MapInitiatorWizardData.pageClass;
        this.stepText = MapInitiatorWizardData.stepText;
        this.pageTitle = MapInitiatorWizardData.pageTitle;
        this.stepHelp = MapInitiatorWizardData.stepHelp;
        this.stepInstruction = MapInitiatorWizardData.stepInstruction;
        this.initializePages(2);
        this.mapObjects = new LinkedList();
        StorageVolumeEnt1Interface volume = (StorageVolumeEnt1Interface)this.wizardModel.getDefaultContextValue("WIZARD_VOLUME_HANDLE");
        String volName = volume.getName();
        this.wizardTitle = volume.isMirrorComponent() ? UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.volume.MapInitiator.TitleComponent", (String)volName) : (volume.getRedundancyType() == 1 ? UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.volume.MapInitiator.TitleMirror", (String)volName) : (volume.isSnapshot() ? UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.volume.MapInitiator.TitleSnapshot", (String)volName) : UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.volume.MapInitiator.TitleVolume", (String)volName)));
    }

    private boolean processInitiatorsPage(WizardEvent wizardEvent) {
        this.mapObjects.clear();
        String initValue = "";
        MapInitiatorsView containerView = (MapInitiatorsView)((MapInitiatorPage1View)wizardEvent.getView()).getChild("MapInitiatorsView");
        CCActionTable initTable = (CCActionTable)containerView.getChild("MapInitiatorsTable");
        try {
            initTable.restoreStateData();
            MapInitiatorsModel initModel = (MapInitiatorsModel)initTable.getModel();
            Integer[] selectedRows = initModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("[" + selectedRows.length + "] rows were selected"));
            ManageInitiatorsInterface initMgr = ManageInitiatorsFactory.getManager();
            InitiatorInterface initiator = null;
            ConfigContext context = UIUtil.getConfigContext();
            try {
                initMgr.init(context, null);
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)((Object)this), (String)"processInitiatorsPage", (ConfigMgmtException)cex);
            }
            String[] selectedLuns = new String[selectedRows.length];
            String[] selectedPerms = new String[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                String permVal;
                int row = selectedRows[i];
                initModel.setRowIndex(row);
                String initKey = (String)initModel.getValue("Hiddenkey");
                initiator = initMgr.getByKey(KeyBuilder.createKeyFromString((String)initKey));
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Processing selected Initiator: " + initiator.getName()));
                String lun = (String)initModel.getValue("LUN");
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Selected lun is : " + lun));
                selectedLuns[i] = lun;
                selectedPerms[i] = permVal = (String)initModel.getValue("Permission");
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Selected Permission is : " + permVal));
                HashSet<UnsignedInt16> perm = new HashSet<UnsignedInt16>();
                perm.add(ConstantsEnt.LUNMappingPermissions.READ);
                String permDisplayStr = "se6x20ui.common.Mapping.ReadOnly";
                if (permVal.equals("ReadWrite")) {
                    permDisplayStr = "se6x20ui.common.Mapping.ReadWrite";
                    perm.add(ConstantsEnt.LUNMappingPermissions.WRITE);
                }
                InitiatorVolumeMapping map = new InitiatorVolumeMapping(lun, perm, (Object)initiator);
                permDisplayStr = UIUtil.getBUIString((String)permDisplayStr);
                if (lun.equals("-1")) {
                    lun = UIUtil.getBUIString((String)"se6x20ui.common.Mapping.nextavailable");
                }
                this.mapObjects.add(map);
                String mapStr = UIUtil.getBUIString((String)"se6x20ui.wizards.volume.MapInitiator.SummaryPage.InitiatorsText", (String[])new String[]{initiator.getName(), lun, permDisplayStr});
                initValue = initValue + mapStr + "<BR>";
            }
            this.wizardModel.setValue("selectedRows", (Object)selectedRows);
            this.wizardModel.setValue("selectedLuns", (Object)selectedLuns);
            this.wizardModel.setValue("selectedPerms", (Object)selectedPerms);
            HttpSession session = RequestManager.getSession();
            if (selectedRows.length == 1) {
                session.setAttribute("showPI", (Object)"true");
            } else {
                session.setAttribute("showPI", (Object)"false");
            }
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"processInitiatorsPage", (Throwable)ex);
        }
        if (initValue.equals("")) {
            initValue = "se6x20ui.wizards.volume.MapInitiator.SummaryPage.NoneInitiatorsText";
        }
        Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)UIUtil.getEnglishBUIString((String)initValue));
        this.wizardModel.setValue("InitiatorsField", (Object)initValue);
        return true;
    }
}

