/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEAction;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionOperands;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionParameters;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.CreateSnapshotPage3View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.CreateSnapshotWizardData;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MapInitiatorsModel;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.MapInitiatorsView;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageMirrorServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageSnapShotServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirroredVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.InitiatorVolumeMapping;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.HashSet;
import java.util.LinkedList;
import javax.servlet.http.HttpSession;
import javax.wbem.cim.UnsignedInt16;

public class CreateSnapshotImpl
extends SEWizardImpl {
    public static final String MODELNAME = "SnapshotWizard_ModelName";
    public static final String IMPLNAME = "SnapshotWizard_ImplName";
    private static final String SUCCESS_SUMMARY = "se6x20ui.wizards.volume.CreateSnapshot.success";
    private static final String FAILURE_SUMMARY = "se6x20ui.error.wizards.volume.CreateSnapshot.failed";
    private static final String PARTIAL_SUMMARY = "se6x20ui.error.wizards.volume.CreateSnapshot.partial";
    private static final String NAME_PAGE = "1";
    private static final String SNAPSHOT_PAGE = "2";
    private static final String INITIATORS_PAGE = "3";
    private StorageVolumeInterface volumeHandle = null;
    private LinkedList mapObjects = null;
    private int numSnapshots = 0;
    private int snapChange = 10;
    private int snapPolicy = 0;
    private String snapPoolName = null;
    private String snapComponentName = null;
    private boolean isMirror = false;
    private Boolean bCreateReserve;
    private Boolean bChangeReserve;
    private Integer nCurSnaps;
    private Integer nCurActivity;

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.volume.CreateSnapshot.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.volume.CreateSnapshotImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        model.setValue("wizPassPageSession", (Object)"false");
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new CreateSnapshotImpl(requestContext);
    }

    public CreateSnapshotImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        if (wizardEvent.getPageId().equals(NAME_PAGE)) {
            this.processNamePage(wizardEvent);
        }
        if (wizardEvent.getPageId().equals(INITIATORS_PAGE)) {
            this.processInitiatorsPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(SNAPSHOT_PAGE)) {
            this.processSnapshotPage(wizardEvent);
        }
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"finishStep");
        MirroredVolumeEnt1Interface mirror = null;
        StorageVolumeInterface vol = (StorageVolumeInterface)this.wizardModel.getDefaultContextValue("WIZARD_VOLUME_HANDLE");
        if (vol == null) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"The volume reference cannot be obtained.");
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Creating snapshot for Volume: " + vol.getName()));
        String snapshotName = (String)this.wizardModel.getValue("SnapshotNameField");
        String snapshotDescription = (String)this.wizardModel.getValue("SnapshotDescField");
        if (snapshotName.trim().length() <= 0) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"The snapshot name is empty.");
            this.transaction.addFailedOperation("se6x20ui.wizards.volume.CreateSnapshot.snapshot", "se6x20ui.error.wizards.volume.CreateSnapshot.noName");
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        ManageStorageVolumesInterface manageSVIF = ManageStorageVolumesFactory.getManager();
        ConfigContext context = UIUtil.getConfigContext();
        try {
            manageSVIF.init(context, null);
        }
        catch (ConfigMgmtException cme) {
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        try {
            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Prevalidating description");
            manageSVIF.validateDescription(snapshotDescription);
            MethodCallStatus mcs = null;
            ManageSnapShotServicesEnt1Interface msss = (ManageSnapShotServicesEnt1Interface)ManageDataServicesFactory.getSnapShotServicesManager();
            msss.init(context, null, null);
            if (this.bCreateReserve.booleanValue()) {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Create snap reserve first...");
                ManageStoragePoolsInterface mgr = ManageStoragePoolsFactory.getManager();
                mgr.init(context, null);
                StoragePool snapPool = (StoragePool)mgr.getItemByName(this.snapPoolName, vol.getStorageDomainName());
                if (this.isMirror) {
                    mirror = (MirroredVolumeEnt1Interface)vol;
                    if (this.snapComponentName != null) {
                        MirrorComponentEnt1Interface snapComponent = null;
                        ManageMirrorServicesEnt1Interface mms = (ManageMirrorServicesEnt1Interface)ManageDataServicesFactory.getMirrorServicesManager((ConfigContext)context);
                        try {
                            mms.init(context, null, null);
                            snapComponent = (MirrorComponentEnt1Interface)mms.getMirrorComponentByName(this.snapComponentName, mirror.getStorageDomainName());
                            mirror.setSnapshotComponent((Object)snapComponent.getKey());
                        }
                        catch (ConfigMgmtException cex) {
                            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cex);
                            this.transaction.addFailedOperation();
                            this.transaction.setSummary(FAILURE_SUMMARY);
                        }
                    }
                }
                mcs = this.isMirror ? msss.createSnapshot((StorageVolume)mirror, snapPool, snapshotName, snapshotDescription, this.numSnapshots, this.snapChange, this.snapPolicy) : msss.createSnapshot((StorageVolume)vol, snapPool, snapshotName, snapshotDescription, this.numSnapshots, this.snapChange, this.snapPolicy);
            } else if (this.bChangeReserve.booleanValue()) {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Calling createSnapshot with Name:" + snapshotName + ", Desc:" + snapshotDescription + ", Number:" + this.numSnapshots + ", Activity:" + this.snapChange));
                mcs = msss.createSnapshot((StorageVolume)vol, snapshotName, snapshotDescription, this.numSnapshots, this.snapChange);
            } else {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Just take snapshot...");
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Calling createSnapshot with Name:" + snapshotName + ", Desc:" + snapshotDescription));
                mcs = msss.createSnapshot((StorageVolume)vol, snapshotName, snapshotDescription);
            }
            if (UIUtil.isMCSSuccess((MethodCallStatus)mcs)) {
                StorageVolumeInterface snapshotVol = manageSVIF.getItemByName(snapshotName);
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("The snapshot " + snapshotName + " was created successfully."));
                this.transaction.addSuccessfulOperation(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.volume.CreateSnapshot.specificSuccess", (String)snapshotName));
                if (this.mapObjects.size() > 0) {
                    Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Mapping snapshot...");
                    LinkedList<StorageVolumeInterface> volumesList = new LinkedList<StorageVolumeInterface>();
                    if (volumesList == null) {
                        this.transaction.addFailedOperation();
                        this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.snapshotcreated.mapsystemerror"));
                        return true;
                    }
                    volumesList.add(snapshotVol);
                    SEActionOperands actionOperands = new SEActionOperands();
                    if (actionOperands == null) {
                        this.transaction.addFailedOperation();
                        this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.snapshotcreated.mapsystemerror"));
                        return true;
                    }
                    actionOperands.add(volumesList, this.mapObjects, UIUtil.getBUIString((String)"se6920.action.mapping.fromtoseperator"));
                    int nOps = actionOperands.getSize();
                    int actionType = 13;
                    SEActionParameters actionParams = new SEActionParameters(actionType);
                    if (actionParams != null) {
                        int opThreshold = UIUtil.getInitParamInt((String)"SNAPSHOT_MAP_THRESHOLD");
                        boolean requestAsync = opThreshold < 0 ? false : nOps >= opThreshold;
                        SEAction action = new SEAction(context, actionOperands, actionParams, requestAsync);
                        if (requestAsync && !action.isAsync()) {
                            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"failed job initiation");
                            this.transaction.addFailedOperation();
                            this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.snapshotcreated.mapjobnotinitiated"));
                        } else {
                            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Successful job initiation, starting action");
                            action.execute();
                            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Back from action initiation");
                            if (requestAsync) {
                                String jobID = action.getJobID();
                                if (jobID == null) {
                                    jobID = UIUtil.getBUIString((String)"se6920.action.jobunknown");
                                }
                                String jobInfo = UIUtil.getBUIString1Subst((String)"se6920.action.snapshotcreated.mapjobinitiated", (String)jobID);
                                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Snapshot created, successful job initiation for mapping, job is:" + jobID));
                                this.transaction.addSuccessfulOperation("");
                                this.transaction.setSummary(jobInfo);
                                this.transaction.setSummaryIsJobRelated();
                            } else {
                                this.transaction = action.getTransaction();
                                this.wizardModel.setDefaultContextValue("WIZARD_TRANSACTION", (Object)this.transaction);
                                this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, PARTIAL_SUMMARY);
                            }
                        }
                    } else {
                        this.transaction.addFailedOperation();
                        this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.snapshotcreated.mapsystemerror"));
                    }
                } else {
                    Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"No mapping requested");
                    this.transaction.setSummary(SUCCESS_SUMMARY);
                }
            } else {
                Trace.error((Object)((Object)this), (String)"finishStep", (String)"Error creating snapshot.");
                Trace.error((Object)((Object)this), (String)"finishStep", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
                this.transaction.addFailedOperation(snapshotName, "error.cim." + mcs.getReturnCode());
                this.transaction.setSummary(FAILURE_SUMMARY);
            }
        }
        catch (BadParameterException bpe) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"BadParameter exception creating snapshot.");
            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)((Object)bpe));
            this.transaction.addFailedOperation(snapshotName, (Exception)((Object)bpe));
            this.transaction.setSummary(FAILURE_SUMMARY);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"ItemNotFoundException exception creating snapshot.");
            Trace.error((Object)((Object)this), (String)"finishStep", (Throwable)infe);
            this.transaction.addFailedOperation(snapshotName, (Exception)((Object)infe));
            this.transaction.setSummary(FAILURE_SUMMARY);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"ConfigMgmt exception creating snapshot.");
            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
            this.transaction.addFailedOperation(snapshotName, (Exception)((Object)cme));
            this.transaction.setSummary(FAILURE_SUMMARY);
        }
        HttpSession session = RequestManager.getSession();
        session.removeAttribute("showPI");
        return true;
    }

    private void initializeWizard() {
        this.wizardName = "CreateSnapshotImpl";
        this.wizardTitle = "se6x20ui.wizards.volume.CreateSnapshot.Title";
        this.pageClass = CreateSnapshotWizardData.pageClass;
        this.stepText = CreateSnapshotWizardData.stepText;
        this.pageTitle = CreateSnapshotWizardData.pageTitle;
        this.stepHelp = CreateSnapshotWizardData.stepHelp;
        this.stepInstruction = CreateSnapshotWizardData.stepInstruction;
        this.initializePages(4);
        this.mapObjects = new LinkedList();
        this.volumeHandle = (StorageVolumeInterface)this.wizardModel.getDefaultContextValue("WIZARD_VOLUME_HANDLE");
    }

    private boolean isPoolModifiable() {
        try {
            if (this.volumeHandle != null) {
                int numSnap = this.volumeHandle.getNumberOfSnapshots();
                Trace.verbose((Object)((Object)this), (String)"isPoolModifiable", (String)("number of snapshots = " + Integer.toString(numSnap)));
                if (numSnap > 0) {
                    Trace.verbose((Object)((Object)this), (String)"isPoolModifiable", (String)"Snapshot exists, so cannot modify PoolSize");
                    this.wizardModel.setValue("SnapshotSpaceField", (Object)UIUtil.getBUIString((String)"se6x20ui.wizards.volume.CreateSnapshotSummaryPage.SnapshotSpaceNoChange"));
                    return false;
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"isPoolModifiable", (String)"ConfigMgmtException exception while retrieving number of snapshot.");
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
        }
        return true;
    }

    private boolean processNamePage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processNamePage");
        this.volumeHandle = (StorageVolumeInterface)this.wizardModel.getDefaultContextValue("WIZARD_VOLUME_HANDLE");
        int poolSize = this.volumeHandle.getSnapshotPoolSize();
        int redundancyType = this.volumeHandle.getRedundancyType();
        Trace.verbose((Object)((Object)this), (String)"processNamePage", (String)("Pool Size: " + poolSize));
        Trace.verbose((Object)((Object)this), (String)"processNamePage", (String)("Redundancy Type: " + redundancyType));
        HttpSession session = RequestManager.getSession();
        if (redundancyType == 1) {
            session.setAttribute("isMirror", (Object)"true");
            this.isMirror = true;
        } else {
            session.setAttribute("isMirror", (Object)"false");
            this.isMirror = false;
        }
        this.wizardModel.setValue("IsMirror", (Object)new Boolean(this.isMirror));
        if (poolSize == 0) {
            session.setAttribute("hasReserve", (Object)"false");
        } else {
            session.setAttribute("hasReserve", (Object)"true");
        }
        return true;
    }

    private boolean processInitiatorsPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processInitiatorsPage");
        HttpSession session = RequestManager.getSession();
        if (!this.bCreateReserve.booleanValue()) {
            session.setAttribute("createReserve", (Object)"false");
        } else {
            session.setAttribute("createReserve", (Object)"true");
        }
        this.mapObjects.clear();
        String initValue = "";
        MapInitiatorsView containerView = (MapInitiatorsView)((CreateSnapshotPage3View)wizardEvent.getView()).getChild("MapInitiatorsView");
        CCActionTable initTable = (CCActionTable)containerView.getChild("MapInitiatorsTable");
        try {
            initTable.restoreStateData();
            MapInitiatorsModel initModel = (MapInitiatorsModel)initTable.getModel();
            Integer[] selectedRows = initModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("[" + selectedRows.length + "] rows were selected"));
            if (selectedRows.length <= 0) {
                initValue = "se6x20ui.wizards.volume.CreateSnapshotSummaryPage.NoneInitiatorsText";
                this.wizardModel.setValue("InitiatorsField", (Object)initValue);
                return true;
            }
            ManageInitiatorsInterface initMgr = ManageInitiatorsFactory.getManager();
            InitiatorInterface initiator = null;
            ConfigContext context = UIUtil.getConfigContext();
            try {
                initMgr.init(context, null);
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)((Object)this), (String)"processInitiatorsPage", (ConfigMgmtException)cex);
            }
            String[] selectedLuns = new String[selectedRows.length];
            String[] selectedPerms = new String[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                String permStr;
                int row = selectedRows[i];
                initModel.setRowIndex(row);
                String initKey = (String)initModel.getValue("Hiddenkey");
                initiator = initMgr.getByKey(KeyBuilder.createKeyFromString((String)initKey));
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Processing selected Initiator: " + initiator.getName()));
                String lun = (String)initModel.getValue("LUN");
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Selected lun is : " + lun));
                selectedLuns[i] = lun;
                selectedPerms[i] = permStr = (String)initModel.getValue("Permission");
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Selected Permission is : " + permStr));
                HashSet<UnsignedInt16> perm = new HashSet<UnsignedInt16>();
                perm.add(ConstantsEnt.LUNMappingPermissions.READ);
                String permDisplayStr = "se6x20ui.common.Mapping.ReadOnly";
                if (permStr.equals("ReadWrite")) {
                    permDisplayStr = "se6x20ui.common.Mapping.ReadWrite";
                    perm.add(ConstantsEnt.LUNMappingPermissions.WRITE);
                }
                permDisplayStr = UIUtil.getBUIString((String)permDisplayStr);
                InitiatorVolumeMapping map = new InitiatorVolumeMapping(lun, perm, (Object)initiator);
                this.mapObjects.add(map);
                if (lun.equals("-1")) {
                    lun = UIUtil.getBUIString((String)"se6x20ui.common.Mapping.nextavailable");
                }
                String mapStr = UIUtil.getBUIString((String)"se6x20ui.wizards.volume.MapInitiator.SummaryPage.InitiatorsText", (String[])new String[]{initiator.getName(), lun, permDisplayStr});
                initValue = initValue + mapStr + "<BR>";
            }
            this.wizardModel.setValue("selectedRows", (Object)selectedRows);
            this.wizardModel.setValue("selectedLuns", (Object)selectedLuns);
            this.wizardModel.setValue("selectedPerms", (Object)selectedPerms);
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"processInitiatorsPage", (Throwable)ex);
        }
        if (initValue.trim().length() <= 0) {
            initValue = "se6x20ui.wizards.volume.CreateSnapshotSummaryPage.NoneInitiatorsText";
        }
        Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)UIUtil.getEnglishBUIString((String)initValue));
        this.wizardModel.setValue("InitiatorsField", (Object)initValue);
        return true;
    }

    private boolean processSnapshotPage(WizardEvent wizardEvent) {
        String snapshotDisplayStr;
        Trace.methodBegin((Object)((Object)this), (String)"processSnapshotPage");
        HttpSession session = RequestManager.getSession();
        session.setAttribute("showPI", (Object)"false");
        this.bCreateReserve = (Boolean)this.wizardModel.getValue("SnapshotCreateReserve");
        this.nCurSnaps = (Integer)this.wizardModel.getValue("SnapshotN");
        this.nCurActivity = (Integer)this.wizardModel.getValue("SnapshotM");
        String strNumSnapshots = (String)this.wizardModel.getValue("SnapshotNumberMenu");
        String strActivity = (String)this.wizardModel.getValue("SnapshotActivityMenu");
        String strPolicy = (String)this.wizardModel.getValue("SnapshotPolicyMenu");
        Trace.verbose((Object)((Object)this), (String)"processSnapshotPage", (String)("Create reserve : " + this.bCreateReserve.toString()));
        Trace.verbose((Object)((Object)this), (String)"processSnapshotPage", (String)("Number of Snapshots are : " + strNumSnapshots));
        Trace.verbose((Object)((Object)this), (String)"processSnapshotPage", (String)("Selected Activity is    : " + strActivity));
        try {
            this.numSnapshots = Integer.parseInt(strNumSnapshots);
            this.snapChange = Integer.parseInt(strActivity);
            this.snapPolicy = Integer.parseInt(strPolicy);
        }
        catch (NumberFormatException nfe) {
            Trace.error((Object)((Object)this), (String)"processSnapshotPage", (Throwable)nfe);
        }
        if (!this.bCreateReserve.booleanValue()) {
            if (this.numSnapshots == this.nCurSnaps && this.snapChange == this.nCurActivity) {
                this.bChangeReserve = Boolean.FALSE;
                snapshotDisplayStr = this.numSnapshots == 1 ? "se6x20ui.wizards.volume.CreateSnapshotSummaryPage.Nochange1SnapshotText" : "se6x20ui.wizards.volume.CreateSnapshotSummaryPage.NochangeNSnapshotText";
            } else {
                this.bChangeReserve = Boolean.TRUE;
                snapshotDisplayStr = this.numSnapshots == 1 ? "se6x20ui.wizards.volume.CreateSnapshotSummaryPage.Change1SnapshotText" : "se6x20ui.wizards.volume.CreateSnapshotSummaryPage.ChangeNSnapshotText";
                session.setAttribute("showPI", (Object)"true");
            }
        } else {
            snapshotDisplayStr = this.numSnapshots == 1 ? "se6x20ui.wizards.volume.CreateSnapshotSummaryPage.Create1SnapshotText" : "se6x20ui.wizards.volume.CreateSnapshotSummaryPage.CreateNSnapshotText";
            session.setAttribute("showPI", (Object)"true");
            this.snapPoolName = (String)this.wizardModel.getValue("SnapshotPoolNameMenu");
            this.wizardModel.setValue("SnapshotPoolField", (Object)this.snapPoolName);
            if (this.isMirror) {
                this.snapComponentName = (String)this.wizardModel.getValue("SnapshotMirrorComponentMenu");
                this.wizardModel.setValue("SnapshotComponentField", (Object)this.snapComponentName);
            }
        }
        String snapSpace = Integer.toString(this.numSnapshots * this.snapChange);
        Trace.verbose((Object)((Object)this), (String)"processSnapshotPage", (String)("Snapshot space is : " + snapSpace));
        snapshotDisplayStr = UIUtil.getBUIString((String)snapshotDisplayStr, (String[])new String[]{strNumSnapshots, strActivity});
        this.wizardModel.setValue("SnapshotSpaceField", (Object)snapshotDisplayStr);
        return true;
    }

    private void createInitiatorsMapping(StorageVolumeInterface vol) {
        Trace.methodBegin((Object)((Object)this), (String)"createInitiatorsMapping");
        try {
            for (int i = 0; i < this.mapObjects.size(); ++i) {
                vol.createMapping((InitiatorVolumeMappingInterface)this.mapObjects.get(i));
            }
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)"createInitiatorsMapping", (Throwable)e);
        }
    }
}

