/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.svsd;

import com.iplanet.jato.RequestContext;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.InitiatorsSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.InitiatorsSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.svsd.CreateSVSDPage2View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.svsd.CreateSVSDWizardData;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.Collection;
import java.util.LinkedList;

public class CreateSVSDImpl
extends SEWizardImpl {
    public static final String MODELNAME = "CreateSVSDWizard_ModelName";
    public static final String IMPLNAME = "CreateSVSDWizard_ImplName";
    static final String INITIATORS_PAGE = "2";
    private LinkedList initList = null;
    private static final String SUCCESS_SUMMARY = "se6x20ui.wizards.svsd.createSVSD.success";
    private static final String FAILURE_SUMMARY = "se6x20ui.error.wizards.svsd.createSVSD.failed";
    private static final String PARTIAL_SUMMARY = "se6x20ui.error.wizards.svsd.createSVSD.partial";

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.svsd.createSVSD.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.svsd.CreateSVSDImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new CreateSVSDImpl(requestContext);
    }

    public CreateSVSDImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        if (wizardEvent.getPageId().equals(INITIATORS_PAGE)) {
            this.processInitiatorsPage(wizardEvent);
        }
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        String name = (String)this.wizardModel.getValue("SVSDNameField");
        String desc = (String)this.wizardModel.getValue("SVSDDescField");
        if (name.length() <= 0) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Storage Domain Name is empty.");
            this.transaction.addFailedOperation("se6x20ui.wizards.svsd.createSVSD.Name", "se6x20ui.error.wizards.svsd.createSVSD.noName");
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        ConfigContext context = UIUtil.getConfigContext();
        if (context == null) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Session Context is invalid.");
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        ManageStorageDomainsInterface svsdMgr = ManageStorageDomainsFactory.getManager();
        try {
            svsdMgr.init(context, null);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        MethodCallStatus mcs = null;
        try {
            mcs = svsdMgr.create(name, desc);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
            this.transaction.addFailedOperation(name, (Exception)((Object)cme));
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        if (!UIUtil.isMCSSuccess((MethodCallStatus)mcs)) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Storage Domain creation failed with error.");
            Trace.error((Object)((Object)this), (String)"finishStep", (String)UIUtil.getEnglishBUIString((String)("cim.error." + mcs.getReturnCode())));
            this.transaction.addFailedOperation(name, "error.cim." + mcs.getReturnCode());
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        this.transaction.addSuccessfulOperation(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.svsd.createSVSD.specificsuccess", (String)name));
        Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("The storage domain " + name + " was created successfully."));
        if (this.initList.size() > 0) {
            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Created Domain. Adding initiators...");
            try {
                StorageDomainInterface domain = svsdMgr.getItemByName(name);
                domain.addInitiators((Collection)this.initList);
            }
            catch (ConfigMgmtException cme) {
                this.transaction.addFailedOperation(name, (Exception)((Object)cme));
                Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
            }
            catch (ItemNotFoundException infe) {
                this.transaction.addFailedOperation(name, (Exception)((Object)infe));
                Trace.error((Object)((Object)this), (String)"finishStep", (Throwable)infe);
            }
        }
        this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
        return true;
    }

    private void initializeWizard() {
        this.wizardName = "CreateSVSDImpl";
        this.wizardTitle = "se6x20ui.wizards.svsd.createSVSD.Title";
        this.pageClass = CreateSVSDWizardData.pageClass;
        this.stepText = CreateSVSDWizardData.stepText;
        this.pageTitle = CreateSVSDWizardData.pageTitle;
        this.stepHelp = CreateSVSDWizardData.stepHelp;
        this.stepInstruction = CreateSVSDWizardData.stepInstruction;
        this.initializePages(3);
        this.initList = new LinkedList();
    }

    private boolean processInitiatorsPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processInitiatorsPage");
        this.initList.clear();
        String initValue = "";
        InitiatorsSummaryView containerView = (InitiatorsSummaryView)((CreateSVSDPage2View)wizardEvent.getView()).getChild("InitiatorsSummaryView");
        CCActionTable initTable = (CCActionTable)containerView.getChild("InitiatorsSummaryTable");
        try {
            initTable.restoreStateData();
            InitiatorsSummaryModel initModel = (InitiatorsSummaryModel)initTable.getModel();
            Integer[] selectedRows = initModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("[" + selectedRows.length + "] rows were selected"));
            if (selectedRows.length <= 0) {
                initValue = "se6x20ui.wizards.svsd.createSVSDSummaryPage.NoneInitiatorsText";
                this.wizardModel.setValue("InitiatorsField", (Object)initValue);
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)"setting the initiator selection to NONE");
                return true;
            }
            ManageInitiatorsInterface initMgr = ManageInitiatorsFactory.getManager();
            InitiatorInterface initiator = null;
            String initName = null;
            ConfigContext context = UIUtil.getConfigContext();
            try {
                initMgr.init(context, null);
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)((Object)this), (String)"processInitiatorsPage", (ConfigMgmtException)cex);
            }
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                initModel.setRowIndex(row);
                initName = (String)initModel.getValue("HiddenName");
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Processing selected Initiator: " + initName));
                String initKey = (String)initModel.getValue("HiddenKey");
                Collection key = KeyBuilder.createKeyFromString((String)initKey);
                initiator = initMgr.getByKey(key);
                Trace.verbose((Object)((Object)this), (String)"processInitiatorsPage", (String)("Processing selected Initiator: " + initiator.getName()));
                this.initList.add(initiator);
                initValue = initValue + initiator.getName() + "<BR>";
                Trace.verbose((Object)((Object)this), (String)"processInitiatorPage", (String)("InitValue: " + initValue));
            }
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"processInitiatorsPage", (Throwable)ex);
        }
        if (initValue.trim().length() <= 0) {
            initValue = "se6x20ui.wizards.volume.CreateSnapshotSummaryPage.NoneInitiatorsText";
        }
        this.wizardModel.setValue("InitiatorsField", (Object)initValue);
        return true;
    }
}

