/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.replication;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.StoragePoolsSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.StoragePoolsSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.replication.CreateRepSetPage3View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.replication.CreateRepSetPage4View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.replication.CreateRepSetPage5View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.replication.CreateRepSetPage8View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.replication.CreateRepSetWizardData;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationGroupEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationParametersEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Properties;
import javax.servlet.http.HttpSession;

public class CreateRepSetImpl
extends SEWizardImpl {
    public static final String MODELNAME = "CreateRepSetWizard_ModelName";
    public static final String IMPLNAME = "CreateRepSetWizard_ImplName";
    private static String SUCCESS_SUMMARY = "se6x20ui.wizards.replication.CreateRepSet.success";
    private static String FAILURE_SUMMARY = "se6x20ui.error.wizards.replication.CreateRepSet.failed";
    private static String MISSING_SUMMARY = "Create Replication Set Failed, Missing: ";
    static final String REMOTE_VOL_PAGE = "1";
    static final String REP_GRP_DECISION_PAGE = "2";
    static final String REP_PROPERTIES_PAGE = "3";
    static final String ASYNCQ_PROPS_PAGE = "4";
    static final String ASYNCQ_SELECT_PAGE = "5";
    static final String BITMAP_SELECT_PAGE = "6";
    private StorageVolumeInterface m_LocalVolume = null;
    private String m_RepPeer = null;
    private String m_RepGrpDecision = "1";
    private String m_RepGrpNewName = null;
    private String m_RepGrpNewDesc = null;
    private ReplicationGroupEnt1Interface m_RepGrpUse = null;
    private String m_RepGrpUseName = null;
    private String m_role = null;
    private String m_mode = null;
    private String m_priority = null;
    private boolean m_snapBeforeSync = false;
    private boolean m_snapWithPrimary = false;
    private boolean m_autoSynchronize = false;
    private BigInteger m_q_size = BigInteger.ZERO;
    private String m_q_blocksPending = null;
    private String m_q_writesWaiting = null;
    private String m_q_fullAction = null;
    private String m_q_domain = null;
    private String m_q_pool = null;
    private String m_RemoteVolume = null;
    private String m_bitmap_domain = null;
    private String m_bitmap_pool = null;

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.replication.CreateRepSet.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.replication.CreateRepSetImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        model.setValue("wizPassPageSession", (Object)"false");
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new CreateRepSetImpl(requestContext);
    }

    public CreateRepSetImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public String getNextPageId(String pageId) {
        Trace.methodBegin((Object)((Object)this), (String)"getNextPageId");
        int page = this.pageIdToPage(pageId);
        String nextPageId = Integer.toString(this.nextPages[page][0]);
        if (pageId.equals(REP_PROPERTIES_PAGE)) {
            if (this.m_mode.equals(CreateRepSetPage3View.MODE_SYNC)) {
                nextPageId = Integer.toString(this.nextPages[page + 2][0]);
            }
        } else if (pageId.equals(REP_GRP_DECISION_PAGE) && this.m_RepGrpUseName != null) {
            nextPageId = Integer.toString(this.nextPages[page + 3][0]);
        }
        return nextPageId;
    }

    public String[] getFutureSteps(String currentPageId) {
        return new String[0];
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        if (wizardEvent.getPageId().equals(REP_GRP_DECISION_PAGE)) {
            this.processRepGroupDecisionPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(REP_PROPERTIES_PAGE)) {
            this.processRepPropertiesPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(ASYNCQ_PROPS_PAGE)) {
            this.processAsyncQueuePropsPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(ASYNCQ_SELECT_PAGE)) {
            this.processAsyncQueueSelectPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(REMOTE_VOL_PAGE)) {
            this.processRemoteVolumePage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(BITMAP_SELECT_PAGE)) {
            this.processBitmapSelectPage(wizardEvent);
        }
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        int queueAction;
        int timeCount;
        BigInteger blockCount;
        int priority;
        int syncMode;
        int role;
        ManageReplicationServicesEnt1Interface repMgr;
        ReplicationParametersEnt1Interface replicationParams;
        String missingRequiredParams;
        boolean haveRequiredParams;
        Properties props;
        block45: {
            Trace.methodBegin((Object)((Object)this), (String)"finishStep");
            props = new Properties();
            haveRequiredParams = true;
            missingRequiredParams = "";
            Object replicationGroup = null;
            replicationParams = null;
            StoragePoolInterface pool = null;
            HttpSession session = RequestManager.getSession();
            ConfigContext context = (ConfigContext)session.getAttribute("ConfigContext");
            repMgr = (ManageReplicationServicesEnt1Interface)ManageDataServicesFactory.getReplicationServicesManager();
            ManageStoragePoolsInterface mgr = ManageStoragePoolsFactory.getManager();
            try {
                repMgr.init(context, null, null);
                mgr.init(context, null);
            }
            catch (ConfigMgmtException cex) {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Error getting factory services");
            }
            if (this.m_LocalVolume != null) {
                props.put("LOCALVOLUME", this.m_LocalVolume);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Local Volume, ";
            }
            if (this.m_RepPeer != null) {
                props.put("REMOTEPEERWWN", this.m_RepPeer);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Remote Peer WWN, ";
            }
            if (this.m_RemoteVolume != null) {
                props.put("REMOVEVOLUMEWWN", this.m_RemoteVolume);
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Remote Volume WWN, ";
            }
            if (this.m_bitmap_pool != null && this.m_bitmap_domain != null) {
                try {
                    pool = mgr.getItemByName(this.m_bitmap_pool, this.m_bitmap_domain);
                    if (pool != null) {
                        props.put("BITMAPPOOL", pool);
                    }
                    pool = null;
                }
                catch (ConfigMgmtException cex) {
                    Trace.error((Object)((Object)this), (String)"finishStep, bitmap storage pool", (ConfigMgmtException)cex);
                }
                catch (ItemNotFoundException infe) {
                    Trace.error((Object)((Object)this), (String)"finishStep, bitmap storage pool", (Throwable)infe);
                }
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Bitmap Storage Pool, ";
            }
            if (this.m_RepGrpDecision.equals(REP_GRP_DECISION_PAGE)) {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Set for use existing Consistency Group, Name: " + this.m_RepGrpUseName));
                props.put("REPLICATIONGROUP", this.m_RepGrpUse);
            } else if (this.m_RepGrpDecision.equals(REP_PROPERTIES_PAGE)) {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Set for new Consistency Group, Name: " + this.m_RepGrpNewName + ", description: " + this.m_RepGrpNewDesc));
                props.put("GROUPNAME", this.m_RepGrpNewName);
                props.put("GROUPDESCRIPTION", this.m_RepGrpNewDesc);
            }
            role = 0;
            syncMode = 0;
            priority = 128;
            blockCount = new BigInteger("0");
            timeCount = 0;
            queueAction = 1;
            if (this.m_role != null) {
                if (this.m_role.equals(CreateRepSetPage3View.ROLE_PRIMARY)) {
                    role = 1;
                } else if (this.m_role.equals(CreateRepSetPage3View.ROLE_SECONDARY)) {
                    role = 2;
                }
            }
            if (this.m_role == null || role == 0) {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Role, ";
            }
            if (this.m_mode != null) {
                if (this.m_mode.equals(CreateRepSetPage3View.MODE_ASYNC)) {
                    syncMode = 2;
                } else if (this.m_mode.equals(CreateRepSetPage3View.MODE_SYNC)) {
                    syncMode = 3;
                }
            } else {
                haveRequiredParams = false;
                missingRequiredParams = missingRequiredParams + "Mode, ";
            }
            if (this.m_priority != null) {
                try {
                    priority = Integer.parseInt(this.m_priority);
                }
                catch (NumberFormatException nfe) {
                    Trace.error((Object)((Object)this), (String)"finishStep", (String)("Non-integer priority, using default: " + priority));
                }
            }
            if (this.m_mode != null && this.m_mode.equals(CreateRepSetPage3View.MODE_ASYNC)) {
                if (this.m_q_blocksPending != null && this.m_q_writesWaiting != null && this.m_q_fullAction != null) {
                    try {
                        blockCount = new BigInteger(this.m_q_blocksPending);
                        timeCount = Integer.parseInt(this.m_q_writesWaiting);
                        if (this.m_q_fullAction.equals(CreateRepSetPage4View.QUEUE_FULL_BLOCK)) {
                            queueAction = 1;
                        } else if (this.m_q_fullAction.equals(CreateRepSetPage4View.QUEUE_FULL_SCORE)) {
                            queueAction = 2;
                        }
                        if (this.m_q_pool == null) break block45;
                        pool = mgr.getItemByName(this.m_q_pool, this.m_q_domain);
                        if (pool != null) {
                            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Setting ASYNC_QUEUE to instance of pool named: " + this.m_q_pool));
                            props.put("ASYNCQUEUE", pool);
                            break block45;
                        }
                        Trace.error((Object)((Object)this), (String)"finishStep", (String)("Didn't get instance of pool named: " + this.m_q_pool));
                        haveRequiredParams = false;
                        missingRequiredParams = missingRequiredParams + "Async Queue Pool, ";
                    }
                    catch (NumberFormatException nfe) {
                        Trace.error((Object)((Object)this), (String)"finishStep, Async Queue Properties", (Throwable)nfe);
                    }
                    catch (ConfigMgmtException cex) {
                        Trace.error((Object)((Object)this), (String)"finishStep, Async Queue Storage Pool", (ConfigMgmtException)cex);
                    }
                    catch (ItemNotFoundException infe) {
                        Trace.error((Object)((Object)this), (String)"finishStep, Async Queue Storage Pool", (Throwable)infe);
                    }
                } else {
                    haveRequiredParams = false;
                    missingRequiredParams = missingRequiredParams + "Async Queue Properties, ";
                }
            }
        }
        if (haveRequiredParams) {
            replicationParams = repMgr.createReplicationParameters(role, syncMode, this.m_autoSynchronize, this.m_snapBeforeSync, this.m_snapWithPrimary, priority, 0, blockCount, timeCount, this.m_q_size, queueAction);
            props.put("REPLICATIONPARAMS", replicationParams);
            try {
                repMgr.create(props);
                this.transaction.setSummary(SUCCESS_SUMMARY);
                this.transaction.addSuccessfulOperation(SUCCESS_SUMMARY);
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)SUCCESS_SUMMARY);
            }
            catch (ConfigMgmtException cex) {
                this.transaction.setSummary(FAILURE_SUMMARY);
                this.transaction.addFailedOperation(this.m_LocalVolume.getName(), (Exception)((Object)cex));
                Trace.error((Object)((Object)this), (String)"finishStep", (String)"Error Creating Replication Set");
                Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cex);
            }
        } else {
            this.transaction.setSummary(MISSING_SUMMARY + missingRequiredParams);
            this.transaction.addFailedOperation();
            Trace.error((Object)((Object)this), (String)"finishStep", (String)("Error Creating Replication Set due to missing fields: " + missingRequiredParams));
        }
        return true;
    }

    private void initializeWizard() {
        this.wizardName = "CreateRepSetImpl";
        this.wizardTitle = "se6x20ui.wizards.replication.CreateRepSet.Title";
        this.pageClass = CreateRepSetWizardData.pageClass;
        this.stepText = CreateRepSetWizardData.stepText;
        this.pageTitle = CreateRepSetWizardData.pageTitle;
        this.stepHelp = CreateRepSetWizardData.stepHelp;
        this.stepInstruction = CreateRepSetWizardData.stepInstruction;
        this.initializePages(7);
        this.m_LocalVolume = (StorageVolumeInterface)this.wizardModel.getDefaultContextValue("WIZARD_VOLUME_HANDLE");
        this.wizardModel.setValue("LocalVolumeField", (Object)this.m_LocalVolume.getName());
        this.wizardModel.setValue("DOMAIN_NAME", (Object)this.m_LocalVolume.getStorageDomainName());
        int snapPoolSize = this.m_LocalVolume.getSnapshotPoolSize();
        this.wizardModel.setValue("volumeHasSnapPool", (Object)(snapPoolSize == 0 ? "false" : "true"));
    }

    private boolean processRemoteVolumePage(WizardEvent wizardEvent) {
        this.m_RepPeer = (String)this.wizardModel.getValue("RepPeerWWNField");
        this.m_RepPeer = this.m_RepPeer.trim();
        Trace.verbose((Object)((Object)this), (String)"processRemoteVolumePage", (String)("Replication Peer is: " + this.m_RepPeer));
        this.wizardModel.setValue("RepPeerWWNField", (Object)this.m_RepPeer);
        this.m_RemoteVolume = (String)this.wizardModel.getValue("RemoteVolumeWWNField");
        this.m_RemoteVolume = this.m_RemoteVolume.trim();
        Trace.verbose((Object)((Object)this), (String)"processRemoteVolumePage", (String)("Remote Volume is: " + this.m_RemoteVolume));
        this.wizardModel.setValue("RemoteVolumeWWNField", (Object)this.m_RemoteVolume);
        return true;
    }

    private boolean processRepGroupDecisionPage(WizardEvent wizardEvent) {
        String newGroup;
        String selGroup;
        Trace.methodBegin((Object)((Object)this), (String)"processRepGroupDecisionPage");
        Trace.verbose((Object)((Object)this), (String)"processRepGroupDecisionPage", (String)("Enter w/group selected: " + this.m_RepGrpDecision));
        this.m_RepGrpUse = null;
        this.m_RepGrpUseName = null;
        String RepGroupLabel = null;
        int nSel = 0;
        String[] selItem = new String[3];
        String noGroup = (String)this.wizardModel.getValue("NoRepGroup");
        if (noGroup != null) {
            selItem[nSel++] = noGroup;
        }
        if ((selGroup = (String)this.wizardModel.getValue("SelectRepGroup")) != null && !selGroup.equals("")) {
            selItem[nSel++] = selGroup;
        }
        if ((newGroup = (String)this.wizardModel.getValue("CreateRepGroup")) != null) {
            selItem[nSel++] = newGroup;
        }
        Trace.verbose((Object)((Object)this), (String)"processRepGroupDecisionPage", (String)("nSel: " + nSel));
        Trace.verbose((Object)((Object)this), (String)"processRepGroupDecisionPage", (String)("noGroup: " + noGroup + ",selGroup: " + selGroup + ", newGroup :" + newGroup));
        this.wizardModel.setValue("NoRepGroup", null);
        this.wizardModel.setValue("SelectRepGroup", null);
        this.wizardModel.setValue("CreateRepGroup", null);
        if (nSel == 1) {
            this.m_RepGrpDecision = selItem[0];
        } else if (nSel == 2) {
            this.m_RepGrpDecision = this.m_RepGrpDecision.equals(selItem[0]) ? selItem[1] : selItem[0];
        } else {
            Trace.error((Object)((Object)this), (String)"processRepGroupDecisionPage", (String)"ERROR, Defaulting to no group");
            this.m_RepGrpDecision = REMOTE_VOL_PAGE;
        }
        Trace.verbose((Object)((Object)this), (String)"processRepGroupDecisionPage", (String)("Exit w/group selected: " + this.m_RepGrpDecision));
        this.wizardModel.setValue("RepGroupDecision", (Object)this.m_RepGrpDecision);
        if (REP_PROPERTIES_PAGE.equals(this.m_RepGrpDecision)) {
            this.m_RepGrpNewName = (String)this.wizardModel.getValue("GroupNameField");
            this.m_RepGrpNewDesc = (String)this.wizardModel.getValue("GroupDescriptionField");
            RepGroupLabel = UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.RepGroup.Create", (String)this.m_RepGrpNewName);
        } else if (REP_GRP_DECISION_PAGE.equals(this.m_RepGrpDecision)) {
            String strRepGrpKey = (String)this.wizardModel.getValue("SelGroupNameField");
            Collection repGrpKey = KeyBuilder.createKeyFromString((String)strRepGrpKey);
            try {
                ConfigContext context = UIUtil.getConfigContext();
                ManageReplicationServicesEnt1Interface repMgr = (ManageReplicationServicesEnt1Interface)ManageDataServicesFactory.getReplicationServicesManager();
                repMgr.init(context, null, null);
                this.m_RepGrpUse = repMgr.getReplicationGroupByKey(repGrpKey);
                this.m_RepGrpUseName = this.m_RepGrpUse.getName();
                RepGroupLabel = UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.RepGroup.Select", (String)this.m_RepGrpUseName);
                ReplicationParametersEnt1Interface params = this.m_RepGrpUse.getReplicationParameters();
                int role = params.getRole();
                if (role == 1) {
                    this.m_role = CreateRepSetPage3View.ROLE_PRIMARY;
                    this.wizardModel.setValue("RoleField", (Object)"se6x20ui.replication.role.Primary");
                } else if (role == 2) {
                    this.m_role = CreateRepSetPage3View.ROLE_SECONDARY;
                    this.wizardModel.setValue("RoleField", (Object)"se6x20ui.replication.role.Secondary");
                } else {
                    this.m_role = null;
                }
                int mode = params.getSyncMode();
                HttpSession session = RequestManager.getSession();
                if (mode == 2) {
                    this.m_mode = CreateRepSetPage3View.MODE_ASYNC;
                    this.wizardModel.setValue("ModeField", (Object)"se6x20ui.replication.mode.Asynchronous");
                    session.setAttribute("AsynchronousReplication", (Object)"true");
                } else if (mode == 3) {
                    this.m_mode = CreateRepSetPage3View.MODE_SYNC;
                    this.wizardModel.setValue("ModeField", (Object)"se6x20ui.replication.mode.Synchronous");
                    session.setAttribute("AsynchronousReplication", (Object)"false");
                } else {
                    this.m_mode = null;
                }
                this.m_autoSynchronize = params.isAutoSync();
                if (this.m_autoSynchronize) {
                    this.wizardModel.setValue("AutoSyncField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.Yes");
                } else {
                    this.wizardModel.setValue("AutoSyncField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.No");
                }
                this.m_snapBeforeSync = params.isSnapBeforeSync();
                if (this.m_snapBeforeSync) {
                    this.wizardModel.setValue("SnapBeforeSyncField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.Yes");
                } else {
                    this.wizardModel.setValue("SnapBeforeSyncField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.No");
                }
                this.m_snapWithPrimary = params.isSnapWithPrimary();
                if (this.m_snapWithPrimary) {
                    this.wizardModel.setValue("SnapWithPrimaryField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.Yes");
                } else {
                    this.wizardModel.setValue("SnapWithPrimaryField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.No");
                }
                BigInteger asyncQBlockCount = params.getAsyncQBlockCount();
                this.m_q_blocksPending = asyncQBlockCount.toString();
                int asyncQTimeCount = params.getAsyncQTimeCount();
                this.m_q_writesWaiting = Integer.toString(asyncQTimeCount);
                int asyncQAction = params.getAsyncQAction();
                if (asyncQAction == 1) {
                    this.m_q_fullAction = CreateRepSetPage4View.QUEUE_FULL_BLOCK;
                } else if (asyncQAction == 2) {
                    this.m_q_fullAction = CreateRepSetPage4View.QUEUE_FULL_SCORE;
                }
                this.m_q_pool = null;
                this.m_q_domain = null;
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)((Object)this), (String)"processRepGroupDecisionPage", (String)"Error getting selected replication group information, reverting to NONE");
                Trace.error((Object)((Object)this), (String)"processRepGroupDecisionPage", (ConfigMgmtException)cex);
                this.m_RepGrpUse = null;
                this.m_RepGrpUseName = null;
                RepGroupLabel = UIUtil.getBUIString((String)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.RepGroup.None");
            }
        } else {
            RepGroupLabel = UIUtil.getBUIString((String)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.RepGroup.None");
        }
        this.wizardModel.setValue("RepGroupField", (Object)RepGroupLabel);
        return true;
    }

    private boolean processRepPropertiesPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processRepPropertiesPage");
        String role = null;
        String mode = null;
        String priority = null;
        String snapBeforeSync = null;
        String snapWithPrimary = null;
        String autoSynchronize = null;
        HttpSession session = RequestManager.getSession();
        role = (String)this.wizardModel.getValue("RoleValue");
        mode = (String)this.wizardModel.getValue("ModeValue");
        priority = (String)this.wizardModel.getValue("PriorityValue");
        snapBeforeSync = (String)this.wizardModel.getValue("SnapBeforeSyncValue");
        snapWithPrimary = (String)this.wizardModel.getValue("SnapWithPrimaryValue");
        autoSynchronize = (String)this.wizardModel.getValue("AutoSyncValue");
        if (role != null) {
            this.m_role = role;
            this.wizardModel.setValue("Role", (Object)this.m_role);
            if (role.equals(CreateRepSetPage3View.ROLE_PRIMARY)) {
                this.wizardModel.setValue("RoleField", (Object)"se6x20ui.replication.role.Primary");
            } else if (role.equals(CreateRepSetPage3View.ROLE_SECONDARY)) {
                this.wizardModel.setValue("RoleField", (Object)"se6x20ui.replication.role.Secondary");
            }
        }
        if (mode != null) {
            this.m_mode = mode;
            this.wizardModel.setValue("Mode", (Object)this.m_mode);
            if (mode.equals(CreateRepSetPage3View.MODE_ASYNC)) {
                this.wizardModel.setValue("ModeField", (Object)"se6x20ui.replication.mode.Asynchronous");
                session.setAttribute("AsynchronousReplication", (Object)"true");
            } else if (mode.equals(CreateRepSetPage3View.MODE_SYNC)) {
                this.wizardModel.setValue("ModeField", (Object)"se6x20ui.replication.mode.Synchronous");
                session.setAttribute("AsynchronousReplication", (Object)"false");
            }
        }
        if (priority != null) {
            this.m_priority = priority;
            this.wizardModel.setValue("Priority", (Object)this.m_priority);
            this.wizardModel.setValue("PriorityField", (Object)("se6920ui.reports.repSets.priority." + priority));
        }
        if (snapBeforeSync != null) {
            boolean bl = this.m_snapBeforeSync = snapBeforeSync.equals("true");
            if (this.m_snapBeforeSync) {
                this.wizardModel.setValue("SnapBeforeSyncField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.Yes");
            } else {
                this.wizardModel.setValue("SnapBeforeSyncField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.No");
            }
        }
        if (snapWithPrimary != null) {
            boolean bl = this.m_snapWithPrimary = snapWithPrimary.equals("true");
            if (this.m_snapWithPrimary) {
                this.wizardModel.setValue("SnapWithPrimaryField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.Yes");
            } else {
                this.wizardModel.setValue("SnapWithPrimaryField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.No");
            }
        }
        if (autoSynchronize != null) {
            boolean bl = this.m_autoSynchronize = autoSynchronize.equals("true");
            if (this.m_autoSynchronize) {
                this.wizardModel.setValue("AutoSyncField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.Yes");
            } else {
                this.wizardModel.setValue("AutoSyncField", (Object)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.No");
            }
        }
        return true;
    }

    private boolean processAsyncQueuePropsPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processRepPropertiesPage");
        String q_blocksPending = null;
        String q_writesWaiting = null;
        String q_fullAction = null;
        String q_sizeNum = null;
        String q_sizeUnitMx = null;
        q_blocksPending = (String)this.wizardModel.getValue("BlocksPendingField");
        q_writesWaiting = (String)this.wizardModel.getValue("WritesWaitingField");
        q_fullAction = (String)this.wizardModel.getValue("QueueFullValue");
        q_sizeNum = (String)this.wizardModel.getValue("AsyncQSizeField");
        q_sizeUnitMx = (String)this.wizardModel.getValue("AsyncQSizeMenu");
        if (q_blocksPending != null) {
            this.m_q_blocksPending = q_blocksPending;
            this.wizardModel.setValue("QBlocksPending", (Object)this.m_q_blocksPending);
            this.wizardModel.setValue("QFullBlocksField", (Object)UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.QFullBlocksValue", (String)this.m_q_blocksPending));
        }
        if (q_writesWaiting != null) {
            this.m_q_writesWaiting = q_writesWaiting;
            this.wizardModel.setValue("QWritesWaiting", (Object)this.m_q_writesWaiting);
            this.wizardModel.setValue("QFullSecondsField", (Object)UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.replication.CreateRepSetSummaryPage.QFullSecondsValue", (String)this.m_q_writesWaiting));
        }
        if (q_fullAction != null) {
            this.m_q_fullAction = q_fullAction;
            this.wizardModel.setValue("QFullAction", (Object)this.m_q_fullAction);
            this.wizardModel.setValue("QFullPolicy", (Object)("se6920ui.reports.repSets.asyncQfullAction." + this.m_q_fullAction));
        }
        if (q_sizeNum != null && q_sizeUnitMx != null) {
            try {
                this.wizardModel.setValue("QSizeNum", (Object)q_sizeNum);
                this.wizardModel.setValue("QSizeUnitMx", (Object)q_sizeUnitMx);
                this.m_q_size = UIUtil.getUISizeEditValue((String)q_sizeNum, (String)q_sizeUnitMx);
                this.wizardModel.setValue("SizeField", (Object)(q_sizeNum + " " + UIUtil.getMultiplierSuffix((String)q_sizeUnitMx)));
            }
            catch (NumberFormatException nfe) {
                Trace.error((Object)((Object)this), (String)"processAsyncQueuePropsPage", (String)"Error parsing async Q size, reverting to default");
                this.m_q_size = BigInteger.ZERO;
            }
        }
        return true;
    }

    private boolean processAsyncQueueSelectPage(WizardEvent wizardEvent) {
        StoragePoolsSummaryView view = (StoragePoolsSummaryView)((CreateRepSetPage5View)wizardEvent.getView()).getChild("StoragePoolsSummaryView");
        CCActionTable poolsTable = (CCActionTable)view.getChild("StoragePoolsSummaryTable");
        try {
            poolsTable.restoreStateData();
            StoragePoolsSummaryModel poolsModel = (StoragePoolsSummaryModel)poolsTable.getModel();
            Integer[] selectedRows = poolsModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processAsyncQueueSelectPage", (String)("[" + selectedRows.length + "] rows were selected"));
            int i = 0;
            if (i < selectedRows.length) {
                int row = selectedRows[i];
                poolsModel.setRowIndex(row);
                this.m_q_pool = (String)poolsModel.getValue("HiddenName");
                this.m_q_domain = (String)poolsModel.getValue("HiddenDomain");
                Trace.verbose((Object)((Object)this), (String)"processAsyncQueueSelectPage", (String)("POOL_SELECTION: name=" + this.m_q_pool + "; Domain=" + this.m_q_domain));
                this.wizardModel.setValue("AsyncQPoolField", (Object)this.m_q_pool);
            }
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)"processAsyncQueueSelectPage", (Throwable)e);
        }
        return true;
    }

    private boolean processBitmapSelectPage(WizardEvent wizardEvent) {
        StoragePoolsSummaryView view = (StoragePoolsSummaryView)((CreateRepSetPage8View)wizardEvent.getView()).getChild("StoragePoolsSummaryView");
        CCActionTable poolsTable = (CCActionTable)view.getChild("StoragePoolsSummaryTable");
        try {
            poolsTable.restoreStateData();
            StoragePoolsSummaryModel poolsModel = (StoragePoolsSummaryModel)poolsTable.getModel();
            Integer[] selectedRows = poolsModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processBitmapSelectPage", (String)("[" + selectedRows.length + "] rows were selected"));
            int i = 0;
            if (i < selectedRows.length) {
                int row = selectedRows[i];
                poolsModel.setRowIndex(row);
                this.m_bitmap_pool = (String)poolsModel.getValue("HiddenName");
                this.m_bitmap_domain = (String)poolsModel.getValue("HiddenDomain");
                Trace.verbose((Object)((Object)this), (String)"Bitmap", (String)("POOL_SELECTION: name=" + this.m_bitmap_pool + "; Domain=" + this.m_bitmap_domain));
                this.wizardModel.setValue("BitmapPoolField", (Object)this.m_bitmap_pool);
            }
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)"processAsyncQueueSelectPage", (Throwable)e);
        }
        return true;
    }
}

