/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.profile;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.profile.CreateProfileWizardData;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageProfileParameters;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class CreateProfileImpl
extends SEWizardImpl {
    public static final String MODELNAME = "CreateProfileWizard_ModelName";
    public static final String IMPLNAME = "CreateProfileWizard_ImplName";
    private static final String NAME_PAGE = "1";
    private static final String BACKEND_PAGE = "2";
    private static final String FRONTEND_PAGE = "3";
    private static final String SUCCESS_SUMMARY = "se6x20ui.wizards.profile.CreateProfile.success";
    private static final String FAILURE_SUMMARY = "se6x20ui.error.wizards.profile.CreateProfile.failed";
    private static final String PARTIAL_SUMMARY = "se6920ui.error.wizards.profile.CreateProfile.partial";

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.profile.CreateProfile.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.profile.CreateProfileImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new CreateProfileImpl(requestContext);
    }

    public CreateProfileImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        if (wizardEvent.getPageId().equals(NAME_PAGE)) {
            this.wizardModel.setValue("ProcessedNamePage", (Object)"true");
        }
        if (wizardEvent.getPageId().equals(BACKEND_PAGE)) {
            this.processBackendPage(wizardEvent);
            this.wizardModel.setValue("ProcessedBackendPage", (Object)"true");
        }
        if (wizardEvent.getPageId().equals(FRONTEND_PAGE)) {
            this.processFrontendPage(wizardEvent);
            this.wizardModel.setValue("ProcessedFrontendPage", (Object)"true");
        }
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        try {
            RequestContext rq = RequestManager.getRequestContext();
            HttpServletRequest httprq = rq.getRequest();
            HttpSession session = httprq.getSession();
            ConfigContext context = (ConfigContext)session.getAttribute("ConfigContext");
            if (context == null) {
                Trace.error((Object)((Object)this), (String)"finishStep", (String)"Context is null");
                this.transaction.setSummary(FAILURE_SUMMARY);
                this.transaction.addFailedOperation();
                return true;
            }
            ManageStorageProfilesInterface profilesMgr = ManageStorageProfilesFactory.getManager();
            profilesMgr.init(context, null);
            String name = (String)this.wizardModel.getValue("ProfileNameField");
            String description = (String)this.wizardModel.getValue("ProfileDescField");
            int raidLevel = Integer.parseInt((String)this.wizardModel.getValue("RaidLevelMenu"));
            int segmentSize = Integer.parseInt((String)this.wizardModel.getValue("SegSizeMenu"));
            boolean hotSpare = ((String)this.wizardModel.getValue("HotSpareCheckBox")).equals("true");
            boolean readAhead = ((String)this.wizardModel.getValue("ReadAheadCheckBox")).equals("true");
            int numDisks = Integer.parseInt((String)this.wizardModel.getValue("NumDrivesMenu"));
            int arrayType = Integer.parseInt((String)this.wizardModel.getValue("ArrayTypeMenu"));
            int virtType = Integer.parseInt((String)this.wizardModel.getValue("VirtStrategyMenu"));
            int stripeSize = Integer.parseInt((String)this.wizardModel.getValue("StripeSizeMenu"));
            StorageProfileParameters params = new StorageProfileParameters();
            params.setName(name);
            params.setDescription(description);
            params.setReadAhead(readAhead);
            params.setHotSpare(hotSpare);
            params.setRaidLevel(raidLevel);
            params.setSegmentSize(segmentSize);
            params.setArrayType(arrayType);
            params.setNumDisks(numDisks);
            params.setVirtType(virtType);
            params.setStripeSize(stripeSize);
            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Calling createStorageProfile with name=" + name + " description=" + description + " raidLevel=" + raidLevel + " segSize=" + segmentSize + " hotSpare=" + hotSpare + " readAhead=" + readAhead + " numDrives=" + numDisks + " arrayType=" + arrayType + " virtType=" + virtType + " stripeSize=" + stripeSize));
            MethodCallStatus mcs = profilesMgr.createStorageProfile(params);
            if (UIUtil.isMCSSuccess((MethodCallStatus)mcs)) {
                this.transaction.addSuccessfulOperation(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.profile.CreateProfile.specificsuccess", (String)name));
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("The storage profile " + name + " was created successfully."));
            } else {
                Trace.error((Object)((Object)this), (String)"finishStep", (String)"Storage profile creation failed.");
                Trace.error((Object)((Object)this), (String)"finishStep", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
                this.transaction.addFailedOperation(name, "error.cim." + mcs.getReturnCode());
            }
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"finishStep", (Throwable)ex);
            this.transaction.addFailedOperation("se6x20ui.wizards.profile.CreateProfile.name", ex);
        }
        this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
        return true;
    }

    private void initializeWizard() {
        this.wizardName = "CreateProfileImpl";
        this.wizardTitle = "se6x20ui.wizards.profile.CreateProfile.Title";
        this.pageClass = CreateProfileWizardData.pageClass;
        this.stepText = CreateProfileWizardData.stepText;
        this.pageTitle = CreateProfileWizardData.pageTitle;
        this.stepHelp = CreateProfileWizardData.stepHelp;
        this.stepInstruction = CreateProfileWizardData.stepInstruction;
        this.initializePages(4);
        this.wizardModel.setValue("ProcessedNamePage", (Object)"false");
        this.wizardModel.setValue("ProcessedBackendPage", (Object)"false");
        this.wizardModel.setValue("ProcessedFrontendPage", (Object)"false");
    }

    private boolean processBackendPage(WizardEvent wizardEvent) {
        String raidLevel = (String)this.wizardModel.getValue("RaidLevelMenu");
        this.wizardModel.setValue("RaidLevelField", (Object)("se6920.profile.raidlevel." + raidLevel));
        String segSize = (String)this.wizardModel.getValue("SegSizeMenu");
        this.wizardModel.setValue("SegSizeField", (Object)("se6920.profile.segmentsize." + segSize));
        String hotSpare = (String)this.wizardModel.getValue("HotSpareCheckBox");
        this.wizardModel.setValue("HotSpareField", (Object)("se6920.profile.dedicatedspare." + hotSpare));
        String readAhead = (String)this.wizardModel.getValue("ReadAheadCheckBox");
        this.wizardModel.setValue("ReadAheadField", (Object)("se6920.profile.readahead." + readAhead));
        String numDrives = (String)this.wizardModel.getValue("NumDrivesMenu");
        this.wizardModel.setValue("NumDrivesField", (Object)("se6920.profile.numberofdrives." + numDrives));
        String arrayType = (String)this.wizardModel.getValue("ArrayTypeMenu");
        this.wizardModel.setValue("ArrayTypeField", (Object)("se6920.profile.arraytype." + arrayType));
        return true;
    }

    private boolean processFrontendPage(WizardEvent wizardEvent) {
        String virtType = (String)this.wizardModel.getValue("VirtStrategyMenu");
        this.wizardModel.setValue("VirtStrategyField", (Object)("se6920.profile.virtstrategy." + virtType));
        String stripeSize = (String)this.wizardModel.getValue("StripeSizeMenu");
        if (Integer.parseInt(virtType) == 0) {
            stripeSize = Integer.toString(-1);
        }
        this.wizardModel.setValue("StripeSizeField", (Object)("se6920.profile.stripesize." + stripeSize));
        return true;
    }
}

